/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.OAuth2Config;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.OAuth2ExceptionKt;
import no.nav.security.mock.oauth2.debugger.DebuggerRequestHandler;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.grant.AuthorizationCodeHandler;
import no.nav.security.mock.oauth2.grant.ClientCredentialsGrantHandler;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import no.nav.security.mock.oauth2.grant.JwtBearerGrantHandler;
import no.nav.security.mock.oauth2.grant.RefreshTokenGrantHandler;
import no.nav.security.mock.oauth2.grant.RefreshTokenManager;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrantHandler;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrantKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequestHandler$WhenMappings;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequestHandlerKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import no.nav.security.mock.oauth2.http.OAuth2TokenResponse;
import no.nav.security.mock.oauth2.login.LoginRequestHandler;
import no.nav.security.mock.oauth2.token.DefaultOAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lno/nav/security/mock/oauth2/http/OAuth2HttpRequestHandler;", "", "config", "Lno/nav/security/mock/oauth2/OAuth2Config;", "(Lno/nav/security/mock/oauth2/OAuth2Config;)V", "debuggerRequestHandler", "Lno/nav/security/mock/oauth2/debugger/DebuggerRequestHandler;", "grantHandlers", "", "Lcom/nimbusds/oauth2/sdk/GrantType;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "loginRequestHandler", "Lno/nav/security/mock/oauth2/login/LoginRequestHandler;", "refreshTokenManager", "Lno/nav/security/mock/oauth2/grant/RefreshTokenManager;", "tokenCallbackQueue", "Ljava/util/concurrent/BlockingQueue;", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "enqueueTokenCallback", "", "oAuth2TokenCallback", "handleAuthenticationRequest", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "handleEndSessionRequest", "handleException", "error", "", "handleJwksRequest", "handleRequest", "handleTokenRequest", "tokenCallbackFromQueueOrDefault", "issuerId", "", "mock-oauth2-server"})
public final class OAuth2HttpRequestHandler {
    private final LoginRequestHandler loginRequestHandler;
    private final DebuggerRequestHandler debuggerRequestHandler;
    private final BlockingQueue<OAuth2TokenCallback> tokenCallbackQueue;
    private final RefreshTokenManager refreshTokenManager;
    private final Map<GrantType, GrantHandler> grantHandlers;
    private final OAuth2Config config;

    @NotNull
    public final OAuth2HttpResponse handleRequest(@NotNull OAuth2HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = this;
        boolean bl = false;
        try {
            OAuth2HttpResponse oAuth2HttpResponse;
            Result.Companion companion = Result.Companion;
            OAuth2HttpRequestHandler $this$runCatching = object;
            boolean bl2 = false;
            OAuth2HttpRequestHandlerKt.access$getLog$p().debug("received request on url=" + request.getUrl() + " with headers=" + request.getHeaders());
            switch (OAuth2HttpRequestHandler$WhenMappings.$EnumSwitchMapping$0[request.type().ordinal()]) {
                case 1: {
                    OAuth2HttpResponse oAuth2HttpResponse2 = OAuth2HttpResponseKt.json(request.toWellKnown());
                    boolean bl3 = false;
                    boolean bl4 = false;
                    OAuth2HttpResponse it = oAuth2HttpResponse2;
                    boolean bl5 = false;
                    OAuth2HttpRequestHandlerKt.access$getLog$p().debug("returning well-known json data for url=" + request.getUrl());
                    oAuth2HttpResponse = oAuth2HttpResponse2;
                    break;
                }
                case 2: {
                    oAuth2HttpResponse = $this$runCatching.handleAuthenticationRequest(request);
                    break;
                }
                case 3: {
                    oAuth2HttpResponse = $this$runCatching.handleTokenRequest(request);
                    break;
                }
                case 4: {
                    oAuth2HttpResponse = $this$runCatching.handleEndSessionRequest(request);
                    break;
                }
                case 5: {
                    oAuth2HttpResponse = $this$runCatching.handleJwksRequest(request);
                    break;
                }
                case 6: {
                    OAuth2HttpResponse oAuth2HttpResponse3 = $this$runCatching.debuggerRequestHandler.handleDebuggerForm(request);
                    boolean bl6 = false;
                    boolean bl7 = false;
                    OAuth2HttpResponse it = oAuth2HttpResponse3;
                    boolean bl8 = false;
                    OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle debugger request");
                    oAuth2HttpResponse = oAuth2HttpResponse3;
                    break;
                }
                case 7: {
                    OAuth2HttpResponse oAuth2HttpResponse4 = $this$runCatching.debuggerRequestHandler.handleDebuggerCallback(request);
                    boolean bl9 = false;
                    boolean bl10 = false;
                    OAuth2HttpResponse it = oAuth2HttpResponse4;
                    boolean bl11 = false;
                    OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle debugger callback request");
                    oAuth2HttpResponse = oAuth2HttpResponse4;
                    break;
                }
                case 8: {
                    oAuth2HttpResponse = new OAuth2HttpResponse(null, 200, null, 5, null);
                    break;
                }
                default: {
                    OAuth2HttpResponse oAuth2HttpResponse5 = OAuth2HttpResponseKt.notFound();
                    boolean bl12 = false;
                    boolean bl13 = false;
                    OAuth2HttpResponse it = oAuth2HttpResponse5;
                    boolean bl14 = false;
                    OAuth2HttpRequestHandlerKt.access$getLog$p().error("path '" + request.getUrl() + "' not found");
                    oAuth2HttpResponse = oAuth2HttpResponse5;
                }
            }
            return oAuth2HttpResponse;
        }
        catch (Throwable $this$runCatching) {
            OAuth2HttpResponse oAuth2HttpResponse;
            Object object2;
            Result.Companion bl2 = Result.Companion;
            boolean bl15 = false;
            object = object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
            bl = false;
            boolean bl16 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) {
                Void result = (Void)object;
                boolean bl17 = false;
                oAuth2HttpResponse = (OAuth2HttpResponse)((Object)result);
            } else {
                Throwable error = throwable;
                boolean bl18 = false;
                oAuth2HttpResponse = this.handleException(error);
            }
            return oAuth2HttpResponse;
        }
    }

    public final boolean enqueueTokenCallback(@NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        return this.tokenCallbackQueue.add(oAuth2TokenCallback);
    }

    private final OAuth2HttpResponse handleJwksRequest(OAuth2HttpRequest request) {
        OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle jwks request on url=" + request.getUrl());
        String issuerId = HttpUrlExtensionsKt.issuerId(request.getUrl());
        JWKSet jwkSet = this.config.getTokenProvider().publicJwkSet(issuerId);
        Map map = jwkSet.toJSONObject();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"jwkSet.toJSONObject()");
        return OAuth2HttpResponseKt.json(map);
    }

    private final OAuth2HttpResponse handleEndSessionRequest(OAuth2HttpRequest request) {
        Object object;
        block3: {
            block2: {
                OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle end session request " + request);
                String postLogoutRedirectUri = request.getUrl().queryParameter("post_logout_redirect_uri");
                object = postLogoutRedirectUri;
                if (object == null) break block2;
                String string = object;
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                object = OAuth2HttpResponseKt.redirect$default(postLogoutRedirectUri, null, 2, null);
                if (object != null) break block3;
            }
            object = OAuth2HttpResponseKt.html("logged out");
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private final OAuth2HttpResponse handleAuthenticationRequest(OAuth2HttpRequest request) {
        block5: {
            OAuth2HttpRequestHandlerKt.access$getLog$p().debug("received call to authorization endpoint");
            authRequest = request.asAuthenticationRequest();
            v0 = this.grantHandlers.get(GrantType.AUTHORIZATION_CODE);
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type no.nav.security.mock.oauth2.grant.AuthorizationCodeHandler");
            }
            authorizationCodeHandler = (AuthorizationCodeHandler)v0;
            var4_4 = request.getMethod();
            switch (var4_4.hashCode()) {
                case 2461856: {
                    if (!var4_4.equals("POST")) ** break;
                    break;
                }
                case 70454: {
                    if (!var4_4.equals("GET")) ** break;
                    v1 = this.config.getInteractiveLogin() || NimbusExtensionsKt.isPrompt(authRequest) ? OAuth2HttpResponseKt.html(this.loginRequestHandler.loginHtml(request)) : OAuth2HttpResponseKt.authenticationSuccess(AuthorizationCodeHandler.authorizationCodeResponse$default(authorizationCodeHandler, authRequest, null, 2, null));
                    break block5;
                }
            }
            login = this.loginRequestHandler.loginSubmit(request);
            v1 = OAuth2HttpResponseKt.authenticationSuccess(authorizationCodeHandler.authorizationCodeResponse(authRequest, login));
            break block5;
            v2 = OAuth2ExceptionKt.invalidRequest("Unsupported request method " + request.getMethod());
            throw new KotlinNothingValueException();
        }
        return v1;
    }

    private final OAuth2HttpResponse handleTokenRequest(OAuth2HttpRequest request) {
        OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle token request " + request);
        GrantType grantType = request.grantType();
        OAuth2TokenCallback tokenCallback = this.tokenCallbackFromQueueOrDefault(HttpUrlExtensionsKt.issuerId(request.getUrl()));
        GrantHandler grantHandler = this.grantHandlers.get(grantType);
        if (grantHandler == null) {
            Void void_ = OAuth2ExceptionKt.invalidGrant(grantType);
            throw new KotlinNothingValueException();
        }
        GrantHandler grantHandler2 = grantHandler;
        OAuth2TokenResponse tokenResponse = grantHandler2.tokenResponse(request, HttpUrlExtensionsKt.toIssuerUrl(request.getUrl()), tokenCallback);
        return OAuth2HttpResponseKt.json(tokenResponse);
    }

    private final OAuth2TokenCallback tokenCallbackFromQueueOrDefault(String issuerId) {
        OAuth2TokenCallback oAuth2TokenCallback;
        String string = issuerId;
        OAuth2TokenCallback oAuth2TokenCallback2 = (OAuth2TokenCallback)this.tokenCallbackQueue.peek();
        if (Intrinsics.areEqual((Object)string, (Object)(oAuth2TokenCallback2 != null ? oAuth2TokenCallback2.issuerId() : null))) {
            OAuth2TokenCallback oAuth2TokenCallback3 = this.tokenCallbackQueue.take();
            Intrinsics.checkNotNullExpressionValue((Object)oAuth2TokenCallback3, (String)"tokenCallbackQueue.take()");
            oAuth2TokenCallback = oAuth2TokenCallback3;
        } else {
            Object v3;
            block4: {
                Iterable $this$firstOrNull$iv = this.config.getTokenCallbacks();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    OAuth2TokenCallback it = (OAuth2TokenCallback)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.issuerId(), (Object)issuerId)) continue;
                    v3 = element$iv;
                    break block4;
                }
                v3 = null;
            }
            if ((oAuth2TokenCallback = (OAuth2TokenCallback)v3) == null) {
                oAuth2TokenCallback = new DefaultOAuth2TokenCallback(issuerId, null, null, null, 0L, 30, null);
            }
        }
        return oAuth2TokenCallback;
    }

    private final OAuth2HttpResponse handleException(Throwable error) {
        ErrorObject errorObject;
        Object object;
        OAuth2HttpRequestHandlerKt.access$getLog$p().error("received exception when handling request.", error);
        String msg = URLEncoder.encode(error.getMessage(), Charset.forName("UTF-8"));
        Throwable throwable = error;
        if (throwable instanceof OAuth2Exception) {
            object = ((OAuth2Exception)error).getErrorObject();
        } else if (throwable instanceof ParseException) {
            object = ((ParseException)error).getErrorObject();
            if (object == null) {
                object = OAuth2Error.INVALID_REQUEST.setDescription("failed to parse request: " + msg);
            }
        } else {
            object = errorObject = throwable instanceof GeneralException ? ((GeneralException)error).getErrorObject() : null;
        }
        if (object == null) {
            ErrorObject errorObject2 = OAuth2Error.SERVER_ERROR.setDescription("unexpected exception with message: " + msg);
            errorObject = errorObject2;
            Intrinsics.checkNotNullExpressionValue((Object)errorObject2, (String)"OAuth2Error.SERVER_ERROR\u2026tion with message: $msg\")");
        }
        ErrorObject errorObject3 = errorObject;
        return OAuth2HttpResponseKt.oauth2Error(errorObject3);
    }

    public OAuth2HttpRequestHandler(@NotNull OAuth2Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.loginRequestHandler = new LoginRequestHandler(OAuth2HttpResponseKt.getTemplateMapper());
        this.debuggerRequestHandler = new DebuggerRequestHandler(OAuth2HttpResponseKt.getTemplateMapper());
        this.tokenCallbackQueue = new LinkedBlockingQueue();
        this.refreshTokenManager = new RefreshTokenManager(null, 1, null);
        this.grantHandlers = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)GrantType.AUTHORIZATION_CODE, (Object)new AuthorizationCodeHandler(this.config.getTokenProvider(), this.refreshTokenManager)), TuplesKt.to((Object)GrantType.CLIENT_CREDENTIALS, (Object)new ClientCredentialsGrantHandler(this.config.getTokenProvider())), TuplesKt.to((Object)GrantType.JWT_BEARER, (Object)new JwtBearerGrantHandler(this.config.getTokenProvider())), TuplesKt.to((Object)TokenExchangeGrantKt.getTOKEN_EXCHANGE(), (Object)new TokenExchangeGrantHandler(this.config.getTokenProvider())), TuplesKt.to((Object)GrantType.REFRESH_TOKEN, (Object)new RefreshTokenGrantHandler(this.config.getTokenProvider(), this.refreshTokenManager))});
    }
}

