/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpRouterKt;
import no.nav.security.mock.oauth2.http.Route;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n\u001a&\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n\u001a&\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n\u001a4\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0007\u001a4\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\"\u0010\u0010\"\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a8\u0006\u0011"}, d2={"log", "Lmu/KLogger;", "get", "Lno/nav/security/mock/oauth2/http/Route;", "path", "", "requestHandler", "Lkotlin/Function1;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "Lno/nav/security/mock/oauth2/http/RequestHandler;", "post", "put", "route", "method", "routeFromPathAndMethod", "RequestHandler", "mock-oauth2-server"})
public final class OAuth2HttpRouterKt {
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);

    @JvmOverloads
    @NotNull
    public static final Route route(@NotNull String path, @Nullable String method, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        return OAuth2HttpRouterKt.routeFromPathAndMethod(path, method, requestHandler);
    }

    public static /* synthetic */ Route route$default(String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return OAuth2HttpRouterKt.route(string, string2, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)function1);
    }

    @JvmOverloads
    @NotNull
    public static final Route route(@NotNull String path, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        return OAuth2HttpRouterKt.route$default(path, null, requestHandler, 2, null);
    }

    @NotNull
    public static final Route put(@NotNull String path, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        return OAuth2HttpRouterKt.routeFromPathAndMethod(path, "PUT", requestHandler);
    }

    @NotNull
    public static final Route post(@NotNull String path, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        return OAuth2HttpRouterKt.routeFromPathAndMethod(path, "POST", requestHandler);
    }

    @NotNull
    public static final Route get(@NotNull String path, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        return OAuth2HttpRouterKt.routeFromPathAndMethod(path, "GET", requestHandler);
    }

    private static final Route routeFromPathAndMethod(String path, String method, Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        return new Route(path, method, requestHandler){
            final /* synthetic */ String $path;
            final /* synthetic */ String $method;
            final /* synthetic */ Function1 $requestHandler;

            public boolean match(@NotNull OAuth2HttpRequest request) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                if (HttpUrlExtensionsKt.endsWith(request.getUrl(), this.$path)) {
                    String string = this.$method;
                    if (string != null) {
                        String string2 = string;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        String it = string2;
                        boolean bl4 = false;
                        bl = Intrinsics.areEqual((Object)it, (Object)request.getMethod());
                    } else {
                        bl = true;
                    }
                } else {
                    bl = false;
                }
                return bl;
            }

            @NotNull
            public OAuth2HttpResponse invoke(@NotNull OAuth2HttpRequest request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                return (OAuth2HttpResponse)this.$requestHandler.invoke((Object)request);
            }
            {
                this.$path = $captured_local_variable$0;
                this.$method = $captured_local_variable$1;
                this.$requestHandler = $captured_local_variable$2;
            }
        };
    }

    static /* synthetic */ Route routeFromPathAndMethod$default(String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return OAuth2HttpRouterKt.routeFromPathAndMethod(string, string2, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)function1);
    }

    public static final /* synthetic */ KLogger access$getLog$p() {
        return log;
    }
}

