/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.token;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.TokenRequest;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005JV\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J&\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eJ*\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005J0\u0010\u001d\u001a\u00020\b2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u0005H\u0007J\u0012\u0010!\u001a\u00020\"2\b\b\u0002\u0010 \u001a\u00020\u0005H\u0007J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0005H\u0002J\"\u0010$\u001a\u00020%*\u00020%2\u0014\b\u0002\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0017H\u0002J\u0014\u0010&\u001a\u00020\b*\u00020\u00112\u0006\u0010 \u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "", "()V", "signingKeys", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/nimbusds/jose/jwk/RSAKey;", "accessToken", "Lcom/nimbusds/jwt/SignedJWT;", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "issuerUrl", "Lokhttp3/HttpUrl;", "oAuth2TokenCallback", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "nonce", "defaultClaims", "Lcom/nimbusds/jwt/JWTClaimsSet;", "kotlin.jvm.PlatformType", "subject", "audience", "", "additionalClaims", "", "expiry", "", "exchangeAccessToken", "claimsSet", "idToken", "jwt", "claims", "Ljava/time/Duration;", "issuerId", "publicJwkSet", "Lcom/nimbusds/jose/jwk/JWKSet;", "rsaKey", "addClaims", "Lcom/nimbusds/jwt/JWTClaimsSet$Builder;", "sign", "Companion", "mock-oauth2-server"})
public final class OAuth2TokenProvider {
    private final ConcurrentHashMap<String, RSAKey> signingKeys = new ConcurrentHashMap();
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmOverloads
    @NotNull
    public final JWKSet publicJwkSet(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        JWKSet jWKSet = new JWKSet((JWK)this.rsaKey(issuerId)).toPublicJWKSet();
        Intrinsics.checkNotNullExpressionValue((Object)jWKSet, (String)"JWKSet(rsaKey(issuerId)).toPublicJWKSet()");
        return jWKSet;
    }

    public static /* synthetic */ JWKSet publicJwkSet$default(OAuth2TokenProvider oAuth2TokenProvider, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "default";
        }
        return oAuth2TokenProvider.publicJwkSet(string);
    }

    @JvmOverloads
    @NotNull
    public final JWKSet publicJwkSet() {
        return OAuth2TokenProvider.publicJwkSet$default(this, null, 1, null);
    }

    @NotNull
    public final SignedJWT idToken(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback, @Nullable String nonce) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        JWTClaimsSet jWTClaimsSet = this.defaultClaims(issuerUrl, oAuth2TokenCallback.subject(tokenRequest), CollectionsKt.listOf((Object)NimbusExtensionsKt.clientIdAsString(tokenRequest)), nonce, oAuth2TokenCallback.addClaims(tokenRequest), oAuth2TokenCallback.tokenExpiry());
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"defaultClaims(\n        i\u2026lback.tokenExpiry()\n    )");
        return this.sign(jWTClaimsSet, HttpUrlExtensionsKt.issuerId(issuerUrl));
    }

    public static /* synthetic */ SignedJWT idToken$default(OAuth2TokenProvider oAuth2TokenProvider, TokenRequest tokenRequest, HttpUrl httpUrl, OAuth2TokenCallback oAuth2TokenCallback, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return oAuth2TokenProvider.idToken(tokenRequest, httpUrl, oAuth2TokenCallback, string);
    }

    @NotNull
    public final SignedJWT accessToken(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback, @Nullable String nonce) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        JWTClaimsSet jWTClaimsSet = this.defaultClaims(issuerUrl, oAuth2TokenCallback.subject(tokenRequest), oAuth2TokenCallback.audience(tokenRequest), nonce, oAuth2TokenCallback.addClaims(tokenRequest), oAuth2TokenCallback.tokenExpiry());
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"defaultClaims(\n        i\u2026lback.tokenExpiry()\n    )");
        return this.sign(jWTClaimsSet, HttpUrlExtensionsKt.issuerId(issuerUrl));
    }

    public static /* synthetic */ SignedJWT accessToken$default(OAuth2TokenProvider oAuth2TokenProvider, TokenRequest tokenRequest, HttpUrl httpUrl, OAuth2TokenCallback oAuth2TokenCallback, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return oAuth2TokenProvider.accessToken(tokenRequest, httpUrl, oAuth2TokenCallback, string);
    }

    @NotNull
    public final SignedJWT exchangeAccessToken(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @NotNull JWTClaimsSet claimsSet, @NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)claimsSet, (String)"claimsSet");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        Instant instant = Instant.now();
        boolean bl = false;
        boolean bl2 = false;
        Instant now = instant;
        boolean bl3 = false;
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder(claimsSet).issuer(issuerUrl.toString()).expirationTime(Date.from(now.plusSeconds(oAuth2TokenCallback.tokenExpiry()))).notBeforeTime(Date.from(now)).issueTime(Date.from(now)).jwtID(UUID.randomUUID().toString()).audience(oAuth2TokenCallback.audience(tokenRequest));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"JWTClaimsSet.Builder(cla\u2026k.audience(tokenRequest))");
        JWTClaimsSet jWTClaimsSet = this.addClaims(builder, oAuth2TokenCallback.addClaims(tokenRequest)).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"JWTClaimsSet.Builder(cla\u2026st))\n            .build()");
        return this.sign(jWTClaimsSet, HttpUrlExtensionsKt.issuerId(issuerUrl));
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final SignedJWT jwt(@NotNull Map<String, ? extends Object> claims, @NotNull Duration expiry, @NotNull String issuerId) {
        JWTClaimsSet jWTClaimsSet;
        void builder;
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        JWTClaimsSet.Builder builder2 = new JWTClaimsSet.Builder();
        boolean bl = false;
        boolean bl2 = false;
        JWTClaimsSet.Builder builder3 = builder2;
        OAuth2TokenProvider oAuth2TokenProvider = this;
        boolean bl3 = false;
        Instant now = Instant.now();
        builder.issueTime(Date.from(now)).notBeforeTime(Date.from(now)).expirationTime(Date.from(now.plusSeconds(expiry.toSeconds())));
        this.addClaims((JWTClaimsSet.Builder)builder, claims);
        JWTClaimsSet jWTClaimsSet2 = jWTClaimsSet = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet2, (String)"JWTClaimsSet.Builder().l\u2026builder.build()\n        }");
        return oAuth2TokenProvider.sign(jWTClaimsSet2, issuerId);
    }

    public static /* synthetic */ SignedJWT jwt$default(OAuth2TokenProvider oAuth2TokenProvider, Map map, Duration duration, String string, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofHours(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.ofHours(1)");
            duration = duration2;
        }
        if ((n & 4) != 0) {
            string = "default";
        }
        return oAuth2TokenProvider.jwt(map, duration, string);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT jwt(@NotNull Map<String, ? extends Object> claims, @NotNull Duration expiry) {
        return OAuth2TokenProvider.jwt$default(this, claims, expiry, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT jwt(@NotNull Map<String, ? extends Object> claims) {
        return OAuth2TokenProvider.jwt$default(this, claims, null, null, 6, null);
    }

    private final RSAKey rsaKey(String issuerId) {
        RSAKey rSAKey = this.signingKeys.computeIfAbsent(issuerId, new Function<String, RSAKey>(issuerId){
            final /* synthetic */ String $issuerId;

            @NotNull
            public final RSAKey apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return no.nav.security.mock.oauth2.token.OAuth2TokenProvider$Companion.access$generateRSAKey(OAuth2TokenProvider.Companion, this.$issuerId);
            }
            {
                this.$issuerId = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)rSAKey, (String)"signingKeys.computeIfAbs\u2026enerateRSAKey(issuerId) }");
        return rSAKey;
    }

    private final SignedJWT sign(JWTClaimsSet $this$sign, String issuerId) {
        RSAKey key = this.rsaKey(issuerId);
        SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(key.getKeyID()).type(JOSEObjectType.JWT).build(), $this$sign);
        boolean bl = false;
        boolean bl2 = false;
        SignedJWT $this$apply = signedJWT;
        boolean bl3 = false;
        $this$apply.sign((JWSSigner)new RSASSASigner(key.toPrivateKey()));
        return signedJWT;
    }

    private final JWTClaimsSet.Builder addClaims(JWTClaimsSet.Builder $this$addClaims, Map<String, ? extends Object> claims) {
        JWTClaimsSet.Builder builder = $this$addClaims;
        boolean bl = false;
        boolean bl2 = false;
        JWTClaimsSet.Builder $this$apply = builder;
        boolean bl3 = false;
        Map<String, ? extends Object> $this$forEach$iv = claims;
        boolean $i$f$forEach = false;
        Map<String, ? extends Object> map = $this$forEach$iv;
        boolean bl4 = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> it = element$iv = iterator.next();
            boolean bl5 = false;
            $this$apply.claim(it.getKey(), it.getValue());
        }
        return builder;
    }

    static /* synthetic */ JWTClaimsSet.Builder addClaims$default(OAuth2TokenProvider oAuth2TokenProvider, JWTClaimsSet.Builder builder, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        return oAuth2TokenProvider.addClaims(builder, map);
    }

    private final JWTClaimsSet defaultClaims(HttpUrl issuerUrl, String subject, List<String> audience, String nonce, Map<String, ? extends Object> additionalClaims, long expiry) {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        boolean bl = false;
        boolean bl2 = false;
        JWTClaimsSet.Builder builder2 = builder;
        boolean bl3 = false;
        Instant now = Instant.now();
        builder2.subject(subject).audience(audience).issuer(issuerUrl.toString()).issueTime(Date.from(now)).notBeforeTime(Date.from(now)).expirationTime(Date.from(now.plusSeconds(expiry))).jwtID(UUID.randomUUID().toString());
        String string = nonce;
        if (string != null) {
            String string2 = string;
            boolean bl4 = false;
            boolean bl5 = false;
            String it = string2;
            boolean bl6 = false;
            builder2.claim("nonce", (Object)it);
        }
        this.addClaims(builder2, additionalClaims);
        return builder2.build();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider$Companion;", "", "()V", "generateRSAKey", "Lcom/nimbusds/jose/jwk/RSAKey;", "keyId", "", "mock-oauth2-server"})
    public static final class Companion {
        private final RSAKey generateRSAKey(String keyId) {
            Object object = KeyPairGenerator.getInstance("RSA");
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            ((KeyPairGenerator)it).initialize(2048);
            object = ((KeyPairGenerator)it).generateKeyPair();
            bl = false;
            bl2 = false;
            it = object;
            boolean bl4 = false;
            Object object2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it");
            PublicKey publicKey = ((KeyPair)object2).getPublic();
            if (publicKey == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
            }
            PrivateKey privateKey = ((KeyPair)it).getPrivate();
            if (privateKey == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPrivateKey");
            }
            RSAKey rSAKey = new RSAKey.Builder((RSAPublicKey)publicKey).privateKey((RSAPrivateKey)privateKey).keyUse(KeyUse.SIGNATURE).keyID(keyId).build();
            Intrinsics.checkNotNullExpressionValue((Object)rSAKey, (String)"KeyPairGenerator.getInst\u2026   .build()\n            }");
            return rSAKey;
        }

        private Companion() {
        }

        public static final /* synthetic */ RSAKey access$generateRSAKey(Companion $this, String keyId) {
            return $this.generateRSAKey(keyId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

