/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.debugger;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.debugger.ClientAuthMethod;
import no.nav.security.mock.oauth2.debugger.ClientAuthentication;
import no.nav.security.mock.oauth2.debugger.DebuggerRequestHandler;
import no.nav.security.mock.oauth2.debugger.DebuggerRequestHandlerKt;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import no.nav.security.mock.oauth2.templates.TemplateMapper;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lno/nav/security/mock/oauth2/debugger/DebuggerRequestHandler;", "", "templateMapper", "Lno/nav/security/mock/oauth2/templates/TemplateMapper;", "(Lno/nav/security/mock/oauth2/templates/TemplateMapper;)V", "encryptionKey", "Ljavax/crypto/SecretKey;", "getDecryptedSessionCookie", "", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "handleDebuggerCallback", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "handleDebuggerForm", "Companion", "mock-oauth2-server"})
public final class DebuggerRequestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TemplateMapper templateMapper;
    @NotNull
    private final SecretKey encryptionKey;
    @NotNull
    public static final String DEBUGGER_SESSION_COOKIE = "debugger-session";

    /*
     * WARNING - void declaration
     */
    public DebuggerRequestHandler(@NotNull TemplateMapper templateMapper2) {
        void $this$encryptionKey_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)templateMapper2, (String)"templateMapper");
        this.templateMapper = templateMapper2;
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        boolean bl = false;
        boolean bl2 = false;
        KeyGenerator keyGenerator2 = keyGenerator;
        DebuggerRequestHandler debuggerRequestHandler = this;
        boolean bl3 = false;
        $this$encryptionKey_u24lambda_u2d0.init(128);
        Unit unit = Unit.INSTANCE;
        SecretKey secretKey = keyGenerator.generateKey();
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"getInstance(\"AES\")\n     \u2026init(128) }.generateKey()");
        debuggerRequestHandler.encryptionKey = secretKey;
    }

    @NotNull
    public final OAuth2HttpResponse handleDebuggerForm(@NotNull OAuth2HttpRequest request) {
        OAuth2HttpResponse oAuth2HttpResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = request.getMethod();
        if (Intrinsics.areEqual((Object)string, (Object)"GET")) {
            DebuggerRequestHandlerKt.access$getLog$p().debug("handling GET request, return html form");
            oAuth2HttpResponse = OAuth2HttpResponseKt.html(this.templateMapper.debuggerFormHtml(DebuggerRequestHandlerKt.access$debuggerAuthorizationRequest(HttpUrlExtensionsKt.toAuthorizationEndpointUrl(request.getUrl()), HttpUrlExtensionsKt.toDebuggerCallbackUrl(request.getUrl())), ClientAuthMethod.CLIENT_SECRET_BASIC.name()));
        } else if (Intrinsics.areEqual((Object)string, (Object)"POST")) {
            DebuggerRequestHandlerKt.access$getLog$p().debug("handling POST request, return redirect");
            String string2 = request.getFormParameters().get("authorize_url");
            if (string2 == null) {
                String string3 = "authorize_url is missing";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            String authorizeUrl = string2;
            String[] stringArray = new String[]{"authorize_url", "token_url", "client_secret", "client_auth_method"};
            HttpUrl httpUrl = HttpUrlExtensionsKt.removeAllEncodedQueryParams(HttpUrl.Companion.get(authorizeUrl).newBuilder().encodedQuery(request.getFormParameters().getParameterString()), stringArray).build();
            DebuggerRequestHandlerKt.access$getLog$p().debug("attempting to redirect to " + httpUrl + ", setting received params in encrypted cookie");
            String[] stringArray2 = OAuth2HttpResponseKt.getObjectMapper().writeValueAsString(request.getFormParameters().getMap());
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"objectMapper.writeValueA\u2026quest.formParameters.map)");
            String cookieValue = DebuggerRequestHandlerKt.access$encrypt((String)stringArray2, this.encryptionKey);
            stringArray2 = new String[]{"Set-Cookie", "debugger-session=" + cookieValue + "; HttpOnly;"};
            oAuth2HttpResponse = OAuth2HttpResponseKt.redirect(httpUrl.toString(), Headers.Companion.of(stringArray2));
        } else {
            throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "Unsupported request method " + request.getMethod());
        }
        return oAuth2HttpResponse;
    }

    @NotNull
    public final OAuth2HttpResponse handleDebuggerCallback(@NotNull OAuth2HttpRequest request) {
        Headers headers;
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        DebuggerRequestHandlerKt.access$getLog$p().debug("handling " + request.getMethod() + " request to debugger callback");
        String string2 = this.getDecryptedSessionCookie(request);
        if (string2 == null) {
            Object object = new String[]{"Content-Type", "text/html"};
            Headers headers2 = Headers.Companion.of(object);
            object = "<p>Expired session, please try again using the debugger form - <a href='" + HttpUrlExtensionsKt.toDebuggerUrl(request.getUrl()) + "'>" + HttpUrlExtensionsKt.toDebuggerUrl(request.getUrl()) + "</></p>";
            return new OAuth2HttpResponse(headers2, 500, (String)object);
        }
        String decryptedSessionCookie = string2;
        ObjectMapper $this$readValue$iv = OAuth2HttpResponseKt.getObjectMapper();
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef22 = false;
        Map sessionParameters = (Map)$this$readValue$iv.readValue(decryptedSessionCookie, (TypeReference)new TypeReference<Map<String, String>>(){});
        String $i$f$jacksonTypeRef22 = (String)sessionParameters.get("token_url");
        HttpUrl httpUrl = $i$f$readValue = $i$f$jacksonTypeRef22 == null ? null : HttpUrl.Companion.get($i$f$jacksonTypeRef22);
        if ($i$f$readValue == null) {
            throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "missing token_url initial call");
        }
        HttpUrl tokenUrl = $i$f$readValue;
        $i$f$jacksonTypeRef22 = request.getUrl().queryParameter("code");
        if ($i$f$jacksonTypeRef22 == null) {
            String string3 = request.getFormParameters().get("code");
            if (string3 == null) {
                throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "no code parameter present");
            }
            string = string3;
        } else {
            string = $i$f$jacksonTypeRef22;
        }
        String code = string;
        ClientAuthentication clientAuthentication = ClientAuthentication.Companion.fromMap(sessionParameters);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"grant_type", (Object)"authorization_code"), TuplesKt.to((Object)"code", (Object)code), TuplesKt.to((Object)"scope", (Object)DebuggerRequestHandlerKt.access$urlEncode(sessionParameters, "scope")), TuplesKt.to((Object)"redirect_uri", (Object)DebuggerRequestHandlerKt.access$urlEncode(sessionParameters, "redirect_uri"))};
        String formBodyString = DebuggerRequestHandlerKt.access$toKeyValueString(MapsKt.mapOf((Pair[])pairArray), "&");
        ClientAuthMethod clientAuthMethod = clientAuthentication.getClientAuthMethod();
        int n = WhenMappings.$EnumSwitchMapping$0[clientAuthMethod.ordinal()];
        String body = n == 1 ? formBodyString + "&" + clientAuthentication.form() : formBodyString;
        ClientAuthMethod clientAuthMethod2 = clientAuthentication.getClientAuthMethod();
        int n2 = WhenMappings.$EnumSwitchMapping$0[clientAuthMethod2.ordinal()];
        if (n2 == 2) {
            String[] stringArray = new String[]{"Authorization", clientAuthentication.basic()};
            headers = Headers.Companion.of(stringArray);
        } else {
            headers = Headers.Companion.of(new String[0]);
        }
        Headers headers3 = headers;
        ResponseBody responseBody = DebuggerRequestHandlerKt.access$getClient$p().newCall(new Request.Builder().headers(headers3).url(tokenUrl).post(RequestBody.Companion.create(body, MediaType.Companion.get("application/x-www-form-urlencoded"))).build()).execute().body();
        Intrinsics.checkNotNull((Object)responseBody);
        String tokenResponse = responseBody.string();
        String formattedTokenRequest2 = "POST " + tokenUrl.encodedPath() + " HTTP/1.1\nHost: " + Util.toHostHeader((HttpUrl)tokenUrl, (boolean)true) + "\nContent-Type: application/x-www-form-urlencoded\n" + CollectionsKt.joinToString$default((Iterable)((Iterable)headers3), (CharSequence)"\n", null, null, (int)0, null, (Function1)handleDebuggerCallback.formattedTokenRequest.1.INSTANCE, (int)30, null) + "\n\n" + body;
        return OAuth2HttpResponseKt.html(this.templateMapper.debuggerCallbackHtml(formattedTokenRequest2, tokenResponse));
    }

    private final String getDecryptedSessionCookie(OAuth2HttpRequest request) {
        String string;
        Object object;
        DebuggerRequestHandler debuggerRequestHandler = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            DebuggerRequestHandler $this$getDecryptedSessionCookie_u24lambda_u2d1 = debuggerRequestHandler;
            boolean bl2 = false;
            String string2 = request.getCookies().get(DEBUGGER_SESSION_COOKIE);
            $this$getDecryptedSessionCookie_u24lambda_u2d1 = string2 == null ? null : DebuggerRequestHandlerKt.access$decrypt(string2, $this$getDecryptedSessionCookie_u24lambda_u2d1.encryptionKey);
            bl2 = false;
            object = Result.constructor-impl((Object)$this$getDecryptedSessionCookie_u24lambda_u2d1);
        }
        catch (Throwable $this$getDecryptedSessionCookie_u24lambda_u2d1) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$getDecryptedSessionCookie_u24lambda_u2d1));
        }
        debuggerRequestHandler = object;
        bl = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)debuggerRequestHandler);
        if (throwable == null) {
            String result = (String)((Object)debuggerRequestHandler);
            boolean bl5 = false;
            string = result;
        } else {
            Throwable error = throwable;
            boolean bl6 = false;
            DebuggerRequestHandlerKt.access$getLog$p().error("received exception when decrypting cookie", error);
            string = null;
        }
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lno/nav/security/mock/oauth2/debugger/DebuggerRequestHandler$Companion;", "", "()V", "DEBUGGER_SESSION_COOKIE", "", "mock-oauth2-server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClientAuthMethod.values().length];
            nArray[ClientAuthMethod.CLIENT_SECRET_POST.ordinal()] = 1;
            nArray[ClientAuthMethod.CLIENT_SECRET_BASIC.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

