/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import no.nav.security.mock.oauth2.OAuth2ExceptionKt;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.extensions.StringKt;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrant;
import no.nav.security.mock.oauth2.http.RequestType;
import no.nav.security.mock.oauth2.http.WellKnown;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u00015B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J3\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010*\u001a\u00020+J\t\u0010,\u001a\u00020-H\u00d6\u0001J\r\u0010.\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b/J\t\u00100\u001a\u00020\u0005H\u00d6\u0001J\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u000204R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\u00a8\u00066"}, d2={"Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "", "headers", "Lokhttp3/Headers;", "method", "", "originalUrl", "Lokhttp3/HttpUrl;", "body", "(Lokhttp3/Headers;Ljava/lang/String;Lokhttp3/HttpUrl;Ljava/lang/String;)V", "getBody", "()Ljava/lang/String;", "cookies", "", "getCookies", "()Ljava/util/Map;", "formParameters", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest$Parameters;", "getFormParameters", "()Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest$Parameters;", "getHeaders", "()Lokhttp3/Headers;", "getMethod", "getOriginalUrl", "()Lokhttp3/HttpUrl;", "url", "getUrl", "asAuthenticationRequest", "Lcom/nimbusds/openid/connect/sdk/AuthenticationRequest;", "asNimbusHTTPRequest", "Lcom/nimbusds/oauth2/sdk/http/HTTPRequest;", "asNimbusTokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "asTokenExchangeRequest", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "grantType", "Lcom/nimbusds/oauth2/sdk/GrantType;", "hashCode", "", "proxyAwareUrl", "proxyAwareUrl$mock_oauth2_server", "toString", "toWellKnown", "Lno/nav/security/mock/oauth2/http/WellKnown;", "type", "Lno/nav/security/mock/oauth2/http/RequestType;", "Parameters", "mock-oauth2-server"})
public final class OAuth2HttpRequest {
    @NotNull
    private final Headers headers;
    @NotNull
    private final String method;
    @NotNull
    private final HttpUrl originalUrl;
    @Nullable
    private final String body;
    @NotNull
    private final Parameters formParameters;
    @NotNull
    private final Map<String, String> cookies;

    public OAuth2HttpRequest(@NotNull Headers headers, @NotNull String method, @NotNull HttpUrl originalUrl, @Nullable String body) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)originalUrl, (String)"originalUrl");
        this.headers = headers;
        this.method = method;
        this.originalUrl = originalUrl;
        this.body = body;
        this.formParameters = new Parameters(this.body);
        String string = this.headers.get("Cookie");
        Map<String, String> map = string == null ? null : StringKt.keyValuesToMap(string, ";");
        this.cookies = map == null ? MapsKt.emptyMap() : map;
    }

    public /* synthetic */ OAuth2HttpRequest(Headers headers, String string, HttpUrl httpUrl, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(headers, string, httpUrl, string2);
    }

    @NotNull
    public final Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public final HttpUrl getOriginalUrl() {
        return this.originalUrl;
    }

    @Nullable
    public final String getBody() {
        return this.body;
    }

    @NotNull
    public final HttpUrl getUrl() {
        return this.proxyAwareUrl$mock_oauth2_server();
    }

    @NotNull
    public final Parameters getFormParameters() {
        return this.formParameters;
    }

    @NotNull
    public final Map<String, String> getCookies() {
        return this.cookies;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TokenRequest asTokenExchangeRequest() {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        HTTPRequest httpRequest = this.asNimbusHTTPRequest();
        PrivateKeyJWT clientAuthentication = NimbusExtensionsKt.requirePrivateKeyJwt(NimbusExtensionsKt.clientAuthentication(httpRequest), this.getUrl().toString(), 120L);
        TokenExchangeGrant tokenExchangeGrant = TokenExchangeGrant.Companion.parse(this.formParameters.getMap());
        Map<String, String> map2 = this.formParameters.getMap();
        List list = CollectionsKt.emptyList();
        Scope scope = null;
        AuthorizationGrant authorizationGrant = tokenExchangeGrant;
        ClientAuthentication clientAuthentication2 = (ClientAuthentication)clientAuthentication;
        URI uRI = this.getUrl().uri();
        boolean $i$f$mapValues = false;
        void var6_11 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map3;
            boolean bl2 = false;
            Object[] objectArray = new String[]{(String)it.getValue()};
            List list2 = CollectionsKt.mutableListOf((Object[])objectArray);
            map.put(k2, list2);
        }
        Map map4 = map = destination$iv$iv;
        List list3 = list;
        Scope scope2 = scope;
        AuthorizationGrant authorizationGrant2 = authorizationGrant;
        ClientAuthentication clientAuthentication3 = clientAuthentication2;
        URI uRI2 = uRI;
        return new TokenRequest(uRI2, clientAuthentication3, authorizationGrant2, scope2, list3, map4);
    }

    @NotNull
    public final HTTPRequest asNimbusHTTPRequest() {
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.valueOf((String)this.method), this.getUrl().url());
        boolean bl = false;
        boolean bl2 = false;
        HTTPRequest $this$asNimbusHTTPRequest_u24lambda_u2d2 = hTTPRequest;
        boolean bl3 = false;
        Iterable $this$forEach$iv = (Iterable)this.getHeaders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair header = (Pair)element$iv;
            boolean bl4 = false;
            String[] stringArray = new String[]{(String)header.getSecond()};
            $this$asNimbusHTTPRequest_u24lambda_u2d2.setHeader((String)header.getFirst(), stringArray);
        }
        $this$asNimbusHTTPRequest_u24lambda_u2d2.setQuery(this.getBody());
        return hTTPRequest;
    }

    @NotNull
    public final TokenRequest asNimbusTokenRequest() {
        TokenRequest tokenRequest = TokenRequest.parse((HTTPRequest)this.asNimbusHTTPRequest());
        Intrinsics.checkNotNullExpressionValue((Object)tokenRequest, (String)"parse(\n            this.\u2026usHTTPRequest()\n        )");
        return tokenRequest;
    }

    @NotNull
    public final AuthenticationRequest asAuthenticationRequest() {
        AuthenticationRequest authenticationRequest = AuthenticationRequest.parse((URI)this.getUrl().uri());
        Intrinsics.checkNotNullExpressionValue((Object)authenticationRequest, (String)"parse(this.url.toUri())");
        return authenticationRequest;
    }

    @NotNull
    public final RequestType type() {
        return HttpUrlExtensionsKt.isWellKnownUrl(this.getUrl()) ? RequestType.WELL_KNOWN : (HttpUrlExtensionsKt.isAuthorizationEndpointUrl(this.getUrl()) ? RequestType.AUTHORIZATION : (HttpUrlExtensionsKt.isTokenEndpointUrl(this.getUrl()) ? RequestType.TOKEN : (HttpUrlExtensionsKt.isEndSessionEndpointUrl(this.getUrl()) ? RequestType.END_SESSION : (HttpUrlExtensionsKt.isJwksUrl(this.getUrl()) ? RequestType.JWKS : (HttpUrlExtensionsKt.isDebuggerUrl(this.getUrl()) ? RequestType.DEBUGGER : (HttpUrlExtensionsKt.isDebuggerCallbackUrl(this.getUrl()) ? RequestType.DEBUGGER_CALLBACK : (Intrinsics.areEqual((Object)this.getUrl().encodedPath(), (Object)"/favicon.ico") ? RequestType.FAVICON : (Intrinsics.areEqual((Object)this.method, (Object)"OPTIONS") ? RequestType.PREFLIGHT : RequestType.UNKNOWN))))))));
    }

    @NotNull
    public final GrantType grantType() {
        GrantType grantType;
        String string = this.formParameters.getMap().get("grant_type");
        if (string == null) {
            grantType = null;
        } else {
            CharSequence charSequence;
            CharSequence charSequence2 = string;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl2 = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            String string2 = (String)charSequence;
            if (string2 == null) {
                grantType = null;
            } else {
                charSequence2 = string2;
                bl = false;
                boolean bl3 = false;
                CharSequence it = charSequence2;
                boolean bl4 = false;
                grantType = new GrantType((String)it);
            }
        }
        GrantType grantType2 = grantType;
        if (grantType2 == null) {
            OAuth2ExceptionKt.missingParameter("grant_type");
            throw new KotlinNothingValueException();
        }
        return grantType2;
    }

    @NotNull
    public final WellKnown toWellKnown() {
        String string = HttpUrlExtensionsKt.toIssuerUrl(this.proxyAwareUrl$mock_oauth2_server()).toString();
        String string2 = HttpUrlExtensionsKt.toAuthorizationEndpointUrl(this.proxyAwareUrl$mock_oauth2_server()).toString();
        String string3 = HttpUrlExtensionsKt.toTokenEndpointUrl(this.proxyAwareUrl$mock_oauth2_server()).toString();
        String string4 = HttpUrlExtensionsKt.toEndSessionEndpointUrl(this.proxyAwareUrl$mock_oauth2_server()).toString();
        String string5 = HttpUrlExtensionsKt.toJwksUrl(this.proxyAwareUrl$mock_oauth2_server()).toString();
        return new WellKnown(string, string2, string4, string3, string5, null, null, null, 224, null);
    }

    @NotNull
    public final HttpUrl proxyAwareUrl$mock_oauth2_server() {
        HttpUrl httpUrl;
        String hostheader = this.headers.get("host");
        String proto = this.headers.get("x-forwarded-proto");
        String port = this.headers.get("x-forwarded-port");
        if (hostheader != null && proto != null) {
            HttpUrl.Builder builder = new HttpUrl.Builder().scheme(proto).host(hostheader);
            boolean bl = false;
            boolean bl2 = false;
            HttpUrl.Builder $this$proxyAwareUrl_u24lambda_u2d6 = builder;
            boolean bl3 = false;
            String string = port;
            if (string != null) {
                int n;
                String string2 = string;
                boolean bl4 = false;
                int n2 = n = Integer.parseInt(string2);
                bl4 = false;
                boolean bl5 = false;
                int it = n2;
                boolean bl6 = false;
                $this$proxyAwareUrl_u24lambda_u2d6.port(it);
            }
            httpUrl = builder.encodedPath(this.originalUrl.encodedPath()).query(this.originalUrl.query()).build();
        } else {
            httpUrl = this.originalUrl;
        }
        return httpUrl;
    }

    @NotNull
    public final Headers component1() {
        return this.headers;
    }

    @NotNull
    public final String component2() {
        return this.method;
    }

    @NotNull
    public final HttpUrl component3() {
        return this.originalUrl;
    }

    @Nullable
    public final String component4() {
        return this.body;
    }

    @NotNull
    public final OAuth2HttpRequest copy(@NotNull Headers headers, @NotNull String method, @NotNull HttpUrl originalUrl, @Nullable String body) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)originalUrl, (String)"originalUrl");
        return new OAuth2HttpRequest(headers, method, originalUrl, body);
    }

    public static /* synthetic */ OAuth2HttpRequest copy$default(OAuth2HttpRequest oAuth2HttpRequest, Headers headers, String string, HttpUrl httpUrl, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            headers = oAuth2HttpRequest.headers;
        }
        if ((n & 2) != 0) {
            string = oAuth2HttpRequest.method;
        }
        if ((n & 4) != 0) {
            httpUrl = oAuth2HttpRequest.originalUrl;
        }
        if ((n & 8) != 0) {
            string2 = oAuth2HttpRequest.body;
        }
        return oAuth2HttpRequest.copy(headers, string, httpUrl, string2);
    }

    @NotNull
    public String toString() {
        return "OAuth2HttpRequest(headers=" + this.headers + ", method=" + this.method + ", originalUrl=" + this.originalUrl + ", body=" + this.body + ")";
    }

    public int hashCode() {
        int result = this.headers.hashCode();
        result = result * 31 + this.method.hashCode();
        result = result * 31 + this.originalUrl.hashCode();
        result = result * 31 + (this.body == null ? 0 : this.body.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OAuth2HttpRequest)) {
            return false;
        }
        OAuth2HttpRequest oAuth2HttpRequest = (OAuth2HttpRequest)other;
        if (!Intrinsics.areEqual((Object)this.headers, (Object)oAuth2HttpRequest.headers)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.method, (Object)oAuth2HttpRequest.method)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.originalUrl, (Object)oAuth2HttpRequest.originalUrl)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.body, (Object)oAuth2HttpRequest.body);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest$Parameters;", "", "parameterString", "", "(Ljava/lang/String;)V", "map", "", "getMap", "()Ljava/util/Map;", "getParameterString", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "get", "name", "hashCode", "", "toString", "mock-oauth2-server"})
    public static final class Parameters {
        @Nullable
        private final String parameterString;
        @NotNull
        private final Map<String, String> map;

        public Parameters(@Nullable String parameterString) {
            String string = this.parameterString = parameterString;
            Map<String, String> map = string == null ? null : StringKt.keyValuesToMap(string, "&");
            this.map = map == null ? MapsKt.emptyMap() : map;
        }

        @Nullable
        public final String getParameterString() {
            return this.parameterString;
        }

        @NotNull
        public final Map<String, String> getMap() {
            return this.map;
        }

        @Nullable
        public final String get(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.map.get(name);
        }

        @Nullable
        public final String component1() {
            return this.parameterString;
        }

        @NotNull
        public final Parameters copy(@Nullable String parameterString) {
            return new Parameters(parameterString);
        }

        public static /* synthetic */ Parameters copy$default(Parameters parameters, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = parameters.parameterString;
            }
            return parameters.copy(string);
        }

        @NotNull
        public String toString() {
            return "Parameters(parameterString=" + this.parameterString + ")";
        }

        public int hashCode() {
            return this.parameterString == null ? 0 : this.parameterString.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Parameters)) {
                return false;
            }
            Parameters parameters = (Parameters)other;
            return Intrinsics.areEqual((Object)this.parameterString, (Object)parameters.parameterString);
        }
    }
}

