/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.OAuth2Config;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.OAuth2ExceptionKt;
import no.nav.security.mock.oauth2.debugger.DebuggerRequestHandler;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.grant.AuthorizationCodeHandler;
import no.nav.security.mock.oauth2.grant.ClientCredentialsGrantHandler;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import no.nav.security.mock.oauth2.grant.JwtBearerGrantHandler;
import no.nav.security.mock.oauth2.grant.RefreshTokenGrantHandler;
import no.nav.security.mock.oauth2.grant.RefreshTokenManager;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrantHandler;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrantKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequestHandlerKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import no.nav.security.mock.oauth2.http.OAuth2TokenResponse;
import no.nav.security.mock.oauth2.http.RequestType;
import no.nav.security.mock.oauth2.login.Login;
import no.nav.security.mock.oauth2.login.LoginRequestHandler;
import no.nav.security.mock.oauth2.token.DefaultOAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lno/nav/security/mock/oauth2/http/OAuth2HttpRequestHandler;", "", "config", "Lno/nav/security/mock/oauth2/OAuth2Config;", "(Lno/nav/security/mock/oauth2/OAuth2Config;)V", "debuggerRequestHandler", "Lno/nav/security/mock/oauth2/debugger/DebuggerRequestHandler;", "grantHandlers", "", "Lcom/nimbusds/oauth2/sdk/GrantType;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "loginRequestHandler", "Lno/nav/security/mock/oauth2/login/LoginRequestHandler;", "refreshTokenManager", "Lno/nav/security/mock/oauth2/grant/RefreshTokenManager;", "tokenCallbackQueue", "Ljava/util/concurrent/BlockingQueue;", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "enqueueTokenCallback", "", "oAuth2TokenCallback", "handleAuthenticationRequest", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "handleEndSessionRequest", "handleException", "error", "", "handleJwksRequest", "handleRequest", "handleTokenRequest", "tokenCallbackFromQueueOrDefault", "issuerId", "", "mock-oauth2-server"})
public final class OAuth2HttpRequestHandler {
    @NotNull
    private final OAuth2Config config;
    @NotNull
    private final LoginRequestHandler loginRequestHandler;
    @NotNull
    private final DebuggerRequestHandler debuggerRequestHandler;
    @NotNull
    private final BlockingQueue<OAuth2TokenCallback> tokenCallbackQueue;
    @NotNull
    private final RefreshTokenManager refreshTokenManager;
    @NotNull
    private final Map<GrantType, GrantHandler> grantHandlers;

    public OAuth2HttpRequestHandler(@NotNull OAuth2Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.loginRequestHandler = new LoginRequestHandler(OAuth2HttpResponseKt.getTemplateMapper());
        this.debuggerRequestHandler = new DebuggerRequestHandler(OAuth2HttpResponseKt.getTemplateMapper());
        this.tokenCallbackQueue = new LinkedBlockingQueue();
        this.refreshTokenManager = new RefreshTokenManager(null, 1, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)GrantType.AUTHORIZATION_CODE, (Object)new AuthorizationCodeHandler(this.config.getTokenProvider(), this.refreshTokenManager)), TuplesKt.to((Object)GrantType.CLIENT_CREDENTIALS, (Object)new ClientCredentialsGrantHandler(this.config.getTokenProvider())), TuplesKt.to((Object)GrantType.JWT_BEARER, (Object)new JwtBearerGrantHandler(this.config.getTokenProvider())), TuplesKt.to((Object)TokenExchangeGrantKt.getTOKEN_EXCHANGE(), (Object)new TokenExchangeGrantHandler(this.config.getTokenProvider())), TuplesKt.to((Object)GrantType.REFRESH_TOKEN, (Object)new RefreshTokenGrantHandler(this.config.getTokenProvider(), this.refreshTokenManager))};
        this.grantHandlers = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final OAuth2HttpResponse handleRequest(@NotNull OAuth2HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = this;
        boolean bl = false;
        try {
            OAuth2HttpResponse oAuth2HttpResponse;
            Result.Companion companion = Result.Companion;
            OAuth2HttpRequestHandler $this$handleRequest_u24lambda_u2d4 = object;
            boolean bl2 = false;
            OAuth2HttpRequestHandlerKt.access$getLog$p().debug("received request on url=" + request.getUrl() + " with headers=" + request.getHeaders());
            RequestType requestType = request.type();
            int n = WhenMappings.$EnumSwitchMapping$0[requestType.ordinal()];
            switch (n) {
                case 1: {
                    OAuth2HttpResponse oAuth2HttpResponse2 = OAuth2HttpResponseKt.json(request.toWellKnown());
                    boolean bl3 = false;
                    boolean bl4 = false;
                    OAuth2HttpResponse it = oAuth2HttpResponse2;
                    boolean bl5 = false;
                    OAuth2HttpRequestHandlerKt.access$getLog$p().debug("returning well-known json data for url=" + request.getUrl());
                    oAuth2HttpResponse = oAuth2HttpResponse2;
                    break;
                }
                case 2: {
                    oAuth2HttpResponse = $this$handleRequest_u24lambda_u2d4.handleAuthenticationRequest(request);
                    break;
                }
                case 3: {
                    oAuth2HttpResponse = $this$handleRequest_u24lambda_u2d4.handleTokenRequest(request);
                    break;
                }
                case 4: {
                    oAuth2HttpResponse = $this$handleRequest_u24lambda_u2d4.handleEndSessionRequest(request);
                    break;
                }
                case 5: {
                    oAuth2HttpResponse = $this$handleRequest_u24lambda_u2d4.handleJwksRequest(request);
                    break;
                }
                case 6: {
                    OAuth2HttpResponse oAuth2HttpResponse3 = $this$handleRequest_u24lambda_u2d4.debuggerRequestHandler.handleDebuggerForm(request);
                    boolean bl6 = false;
                    boolean bl7 = false;
                    OAuth2HttpResponse it = oAuth2HttpResponse3;
                    boolean bl8 = false;
                    OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle debugger request");
                    oAuth2HttpResponse = oAuth2HttpResponse3;
                    break;
                }
                case 7: {
                    OAuth2HttpResponse oAuth2HttpResponse4 = $this$handleRequest_u24lambda_u2d4.debuggerRequestHandler.handleDebuggerCallback(request);
                    boolean bl9 = false;
                    boolean bl10 = false;
                    OAuth2HttpResponse it = oAuth2HttpResponse4;
                    boolean bl11 = false;
                    OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle debugger callback request");
                    oAuth2HttpResponse = oAuth2HttpResponse4;
                    break;
                }
                case 8: {
                    oAuth2HttpResponse = new OAuth2HttpResponse(null, 200, null, 5, null);
                    break;
                }
                case 9: {
                    String[] stringArray = new String[6];
                    String string = HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ACCESS_CONTROL_ALLOW_ORIGIN.toString()");
                    stringArray[0] = string;
                    stringArray[1] = "*";
                    string = HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ACCESS_CONTROL_ALLOW_METHODS.toString()");
                    stringArray[2] = string;
                    stringArray[3] = "*";
                    string = HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ACCESS_CONTROL_ALLOW_HEADERS.toString()");
                    stringArray[4] = string;
                    stringArray[5] = "*";
                    Headers headers = Headers.Companion.of(stringArray);
                    oAuth2HttpResponse = new OAuth2HttpResponse(headers, 200, null, 4, null);
                    break;
                }
                default: {
                    OAuth2HttpResponse oAuth2HttpResponse5 = OAuth2HttpResponseKt.notFound();
                    boolean bl12 = false;
                    boolean bl13 = false;
                    OAuth2HttpResponse it = oAuth2HttpResponse5;
                    boolean bl14 = false;
                    OAuth2HttpRequestHandlerKt.access$getLog$p().error("path '" + request.getUrl() + "' not found");
                    oAuth2HttpResponse = oAuth2HttpResponse5;
                }
            }
            return oAuth2HttpResponse;
        }
        catch (Throwable $this$handleRequest_u24lambda_u2d4) {
            OAuth2HttpResponse oAuth2HttpResponse;
            Object object2;
            Result.Companion bl2 = Result.Companion;
            boolean bl15 = false;
            object = object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$handleRequest_u24lambda_u2d4));
            bl = false;
            boolean bl16 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) {
                Void result = (Void)object;
                boolean bl17 = false;
                oAuth2HttpResponse = (OAuth2HttpResponse)((Object)result);
            } else {
                Throwable error = throwable;
                boolean bl18 = false;
                oAuth2HttpResponse = this.handleException(error);
            }
            return oAuth2HttpResponse;
        }
    }

    public final boolean enqueueTokenCallback(@NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        return this.tokenCallbackQueue.add(oAuth2TokenCallback);
    }

    private final OAuth2HttpResponse handleJwksRequest(OAuth2HttpRequest request) {
        OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle jwks request on url=" + request.getUrl());
        String issuerId = HttpUrlExtensionsKt.issuerId(request.getUrl());
        JWKSet jwkSet = this.config.getTokenProvider().publicJwkSet(issuerId);
        Map map = jwkSet.toJSONObject();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"jwkSet.toJSONObject()");
        return OAuth2HttpResponseKt.json(map);
    }

    private final OAuth2HttpResponse handleEndSessionRequest(OAuth2HttpRequest request) {
        OAuth2HttpResponse oAuth2HttpResponse;
        String postLogoutRedirectUri;
        OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle end session request " + request);
        String string = postLogoutRedirectUri = request.getUrl().queryParameter("post_logout_redirect_uri");
        if (string == null) {
            oAuth2HttpResponse = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            oAuth2HttpResponse = OAuth2HttpResponseKt.redirect$default(postLogoutRedirectUri, null, 2, null);
        }
        OAuth2HttpResponse oAuth2HttpResponse2 = oAuth2HttpResponse;
        return oAuth2HttpResponse2 == null ? OAuth2HttpResponseKt.html("logged out") : oAuth2HttpResponse2;
    }

    private final OAuth2HttpResponse handleAuthenticationRequest(OAuth2HttpRequest request) {
        OAuth2HttpResponse oAuth2HttpResponse;
        OAuth2HttpRequestHandlerKt.access$getLog$p().debug("received call to authorization endpoint");
        AuthenticationRequest authRequest = request.asAuthenticationRequest();
        Object object = this.grantHandlers.get(GrantType.AUTHORIZATION_CODE);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type no.nav.security.mock.oauth2.grant.AuthorizationCodeHandler");
        }
        AuthorizationCodeHandler authorizationCodeHandler = (AuthorizationCodeHandler)object;
        object = request.getMethod();
        if (Intrinsics.areEqual((Object)object, (Object)"GET")) {
            oAuth2HttpResponse = this.config.getInteractiveLogin() || NimbusExtensionsKt.isPrompt(authRequest) ? OAuth2HttpResponseKt.html(this.loginRequestHandler.loginHtml(request, this.config)) : OAuth2HttpResponseKt.authenticationSuccess(AuthorizationCodeHandler.authorizationCodeResponse$default(authorizationCodeHandler, authRequest, null, 2, null));
        } else if (Intrinsics.areEqual((Object)object, (Object)"POST")) {
            Login login = this.loginRequestHandler.loginSubmit(request);
            oAuth2HttpResponse = OAuth2HttpResponseKt.authenticationSuccess(authorizationCodeHandler.authorizationCodeResponse(authRequest, login));
        } else {
            OAuth2ExceptionKt.invalidRequest("Unsupported request method " + request.getMethod());
            throw new KotlinNothingValueException();
        }
        return oAuth2HttpResponse;
    }

    private final OAuth2HttpResponse handleTokenRequest(OAuth2HttpRequest request) {
        OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle token request " + request);
        GrantType grantType = request.grantType();
        OAuth2TokenCallback tokenCallback = this.tokenCallbackFromQueueOrDefault(HttpUrlExtensionsKt.issuerId(request.getUrl()));
        GrantHandler grantHandler = this.grantHandlers.get(grantType);
        if (grantHandler == null) {
            OAuth2ExceptionKt.invalidGrant(grantType);
            throw new KotlinNothingValueException();
        }
        GrantHandler grantHandler2 = grantHandler;
        OAuth2TokenResponse tokenResponse = grantHandler2.tokenResponse(request, HttpUrlExtensionsKt.toIssuerUrl(request.getUrl()), tokenCallback);
        return OAuth2HttpResponseKt.json(tokenResponse);
    }

    private final OAuth2TokenCallback tokenCallbackFromQueueOrDefault(String issuerId) {
        OAuth2TokenCallback oAuth2TokenCallback;
        String string = issuerId;
        OAuth2TokenCallback oAuth2TokenCallback2 = (OAuth2TokenCallback)this.tokenCallbackQueue.peek();
        if (Intrinsics.areEqual((Object)string, (Object)(oAuth2TokenCallback2 == null ? null : oAuth2TokenCallback2.issuerId()))) {
            oAuth2TokenCallback2 = this.tokenCallbackQueue.take();
            Intrinsics.checkNotNullExpressionValue((Object)oAuth2TokenCallback2, (String)"tokenCallbackQueue.take()");
            oAuth2TokenCallback = oAuth2TokenCallback2;
        } else {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = this.config.getTokenCallbacks();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    OAuth2TokenCallback it = (OAuth2TokenCallback)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.issuerId(), (Object)issuerId)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            oAuth2TokenCallback2 = v1;
            oAuth2TokenCallback = oAuth2TokenCallback2 == null ? (OAuth2TokenCallback)new DefaultOAuth2TokenCallback(issuerId, null, null, null, null, 0L, 62, null) : oAuth2TokenCallback2;
        }
        return oAuth2TokenCallback;
    }

    private final OAuth2HttpResponse handleException(Throwable error) {
        Object object;
        ErrorObject errorObject;
        ErrorObject errorObject2;
        OAuth2HttpRequestHandlerKt.access$getLog$p().error("received exception when handling request.", error);
        String msg = URLEncoder.encode(error.getMessage(), Charset.forName("UTF-8"));
        Throwable throwable = error;
        Object object2 = throwable instanceof OAuth2Exception ? ((OAuth2Exception)error).getErrorObject() : (throwable instanceof ParseException ? ((errorObject2 = ((ParseException)error).getErrorObject()) == null ? OAuth2Error.INVALID_REQUEST.setDescription("failed to parse request: " + msg) : errorObject2) : (errorObject = throwable instanceof GeneralException ? ((GeneralException)error).getErrorObject() : null));
        if (errorObject == null) {
            throwable = OAuth2Error.SERVER_ERROR.setDescription("unexpected exception with message: " + msg);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"SERVER_ERROR.setDescript\u2026tion with message: $msg\")");
            object = throwable;
        } else {
            object = errorObject;
        }
        ErrorObject errorObject3 = object;
        return OAuth2HttpResponseKt.oauth2Error(errorObject3);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestType.values().length];
            nArray[RequestType.WELL_KNOWN.ordinal()] = 1;
            nArray[RequestType.AUTHORIZATION.ordinal()] = 2;
            nArray[RequestType.TOKEN.ordinal()] = 3;
            nArray[RequestType.END_SESSION.ordinal()] = 4;
            nArray[RequestType.JWKS.ordinal()] = 5;
            nArray[RequestType.DEBUGGER.ordinal()] = 6;
            nArray[RequestType.DEBUGGER_CALLBACK.ordinal()] = 7;
            nArray[RequestType.FAVICON.ordinal()] = 8;
            nArray[RequestType.PREFLIGHT.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

