/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.debugger;

import com.nimbusds.oauth2.sdk.OAuth2Error;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.debugger.ClientAuthentication;
import no.nav.security.mock.oauth2.debugger.ClientKt;
import no.nav.security.mock.oauth2.debugger.DebuggerRequestHandlerKt;
import no.nav.security.mock.oauth2.debugger.SessionManager;
import no.nav.security.mock.oauth2.debugger.TokenRequest;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import no.nav.security.mock.oauth2.http.Route;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005j\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\u000e\u001a\u00020\r*\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"client", "Lokhttp3/OkHttpClient;", "log", "Lmu/KLogger;", "handle", "Lkotlin/Function2;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "Lno/nav/security/mock/oauth2/http/ExceptionHandler;", "sessionManager", "Lno/nav/security/mock/oauth2/debugger/SessionManager;", "debuggerCallback", "Lno/nav/security/mock/oauth2/http/Route$Builder;", "debuggerForm", "mock-oauth2-server"})
public final class DebuggerRequestHandlerKt {
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);
    @NotNull
    private static final OkHttpClient client = new OkHttpClient().newBuilder().build();

    private static final Function2<OAuth2HttpRequest, Throwable, OAuth2HttpResponse> handle(SessionManager sessionManager) {
        return (Function2)new Function2<OAuth2HttpRequest, Throwable, OAuth2HttpResponse>(sessionManager){
            final /* synthetic */ SessionManager $sessionManager;
            {
                this.$sessionManager = $sessionManager;
                super(2);
            }

            @NotNull
            public final OAuth2HttpResponse invoke(@NotNull OAuth2HttpRequest request, @NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                Object object = new String[]{"Content-Type", "text/html", "Set-Cookie", this.$sessionManager.session(request).asCookie()};
                Object object2 = Headers.Companion.of(object);
                object = OAuth2HttpResponseKt.getTemplateMapper().debuggerErrorHtml(HttpUrlExtensionsKt.toDebuggerUrl(request.getUrl()), ExceptionsKt.stackTraceToString((Throwable)error));
                Object it = object2 = new OAuth2HttpResponse((Headers)object2, 500, (String)object);
                boolean bl = false;
                DebuggerRequestHandlerKt.access$getLog$p().error("received exception when handling url=" + request.getUrl(), error);
                return object2;
            }
        };
    }

    private static final Route.Builder debuggerForm(Route.Builder $this$debuggerForm, SessionManager sessionManager) {
        Route.Builder builder;
        Route.Builder $this$debuggerForm_u24lambda_u2d0 = builder = $this$debuggerForm;
        boolean bl = false;
        String[] stringArray = new String[]{"/debugger"};
        $this$debuggerForm_u24lambda_u2d0.get(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)debuggerForm.1.1.INSTANCE));
        $this$debuggerForm_u24lambda_u2d0.post("/debugger", (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)new Function1<OAuth2HttpRequest, OAuth2HttpResponse>(sessionManager){
            final /* synthetic */ SessionManager $sessionManager;
            {
                this.$sessionManager = $sessionManager;
                super(1);
            }

            @NotNull
            public final OAuth2HttpResponse invoke(@NotNull OAuth2HttpRequest it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DebuggerRequestHandlerKt.access$getLog$p().debug("handling POST request, return redirect");
                String string = it.getFormParameters().get("authorize_url");
                if (string == null) {
                    throw new IllegalStateException("authorize_url is missing".toString());
                }
                String authorizeUrl = string;
                String[] stringArray = new String[]{"authorize_url", "token_url", "client_secret", "client_auth_method"};
                HttpUrl httpUrl = HttpUrlExtensionsKt.removeAllEncodedQueryParams(HttpUrl.Companion.get(authorizeUrl).newBuilder().encodedQuery(it.getFormParameters().getParameterString()), stringArray).build();
                DebuggerRequestHandlerKt.access$getLog$p().debug("attempting to redirect to " + httpUrl + ", setting received params in encrypted cookie");
                SessionManager.Session session = this.$sessionManager.session(it);
                session.putAll(it.getFormParameters().getMap());
                String[] stringArray2 = new String[]{"Set-Cookie", session.asCookie()};
                return OAuth2HttpResponseKt.redirect(httpUrl.toString(), Headers.Companion.of(stringArray2));
            }
        }));
        return builder;
    }

    private static final Route.Builder debuggerCallback(Route.Builder $this$debuggerCallback, SessionManager sessionManager) {
        String[] stringArray = new String[]{"/debugger/callback"};
        return $this$debuggerCallback.any(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)new Function1<OAuth2HttpRequest, OAuth2HttpResponse>(sessionManager){
            final /* synthetic */ SessionManager $sessionManager;
            {
                this.$sessionManager = $sessionManager;
                super(1);
            }

            @NotNull
            public final OAuth2HttpResponse invoke(@NotNull OAuth2HttpRequest it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DebuggerRequestHandlerKt.access$getLog$p().debug("handling " + it.getMethod() + " request to debugger callback");
                SessionManager.Session session = this.$sessionManager.session(it);
                HttpUrl tokenUrl = HttpUrl.Companion.get(session.get("token_url"));
                String string = it.getUrl().queryParameter("code");
                if (string == null) {
                    String string2 = it.getFormParameters().get("code");
                    if (string2 == null) {
                        throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "no code parameter present");
                    }
                    string = string2;
                }
                String code = string;
                ClientAuthentication clientAuthentication = ClientAuthentication.Companion.fromMap(session.getParameters());
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"grant_type", (Object)"authorization_code"), TuplesKt.to((Object)"code", (Object)code), TuplesKt.to((Object)"scope", (Object)ClientKt.urlEncode(session.get("scope"))), TuplesKt.to((Object)"redirect_uri", (Object)ClientKt.urlEncode(session.get("redirect_uri")))};
                TokenRequest request = new TokenRequest(tokenUrl, clientAuthentication, MapsKt.mapOf((Pair[])pairArray));
                String response = ClientKt.post(DebuggerRequestHandlerKt.access$getClient$p(), request);
                return OAuth2HttpResponseKt.html(OAuth2HttpResponseKt.getTemplateMapper().debuggerCallbackHtml(request.toString(), response));
            }
        }));
    }

    public static final /* synthetic */ Function2 access$handle(SessionManager sessionManager) {
        return DebuggerRequestHandlerKt.handle(sessionManager);
    }

    public static final /* synthetic */ Route.Builder access$debuggerForm(Route.Builder $receiver, SessionManager sessionManager) {
        return DebuggerRequestHandlerKt.debuggerForm($receiver, sessionManager);
    }

    public static final /* synthetic */ Route.Builder access$debuggerCallback(Route.Builder $receiver, SessionManager sessionManager) {
        return DebuggerRequestHandlerKt.debuggerCallback($receiver, sessionManager);
    }

    public static final /* synthetic */ KLogger access$getLog$p() {
        return log;
    }

    public static final /* synthetic */ OkHttpClient access$getClient$p() {
        return client;
    }
}

