/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.token;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.TokenRequest;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrant;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001BW\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lno/nav/security/mock/oauth2/token/DefaultOAuth2TokenCallback;", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "issuerId", "", "subject", "typeHeader", "audience", "", "claims", "", "", "expiry", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/Map;J)V", "addClaims", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "tokenExpiry", "mock-oauth2-server"})
public class DefaultOAuth2TokenCallback
implements OAuth2TokenCallback {
    @NotNull
    private final String issuerId;
    @NotNull
    private final String subject;
    @NotNull
    private final String typeHeader;
    @Nullable
    private final List<String> audience;
    @NotNull
    private final Map<String, Object> claims;
    private final long expiry;

    @JvmOverloads
    public DefaultOAuth2TokenCallback(@NotNull String issuerId, @NotNull String subject, @NotNull String typeHeader, @Nullable List<String> audience, @NotNull Map<String, ? extends Object> claims, long expiry) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)typeHeader, (String)"typeHeader");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        this.issuerId = issuerId;
        this.subject = subject;
        this.typeHeader = typeHeader;
        this.audience = audience;
        this.claims = claims;
        this.expiry = expiry;
    }

    public /* synthetic */ DefaultOAuth2TokenCallback(String string, String string2, String string3, List list, Map map, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        String string4;
        if ((n & 1) != 0) {
            string = "default";
        }
        if ((n & 2) != 0) {
            string4 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"randomUUID().toString()");
            string2 = string4;
        }
        if ((n & 4) != 0) {
            string4 = JOSEObjectType.JWT.getType();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"JWT.type");
            string3 = string4;
        }
        if ((n & 8) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            l = 3600L;
        }
        this(string, string2, string3, list, map, l);
    }

    @Override
    @NotNull
    public String issuerId() {
        return this.issuerId;
    }

    @Override
    @NotNull
    public String subject(@NotNull TokenRequest tokenRequest) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        return Intrinsics.areEqual((Object)GrantType.CLIENT_CREDENTIALS, (Object)NimbusExtensionsKt.grantType(tokenRequest)) ? NimbusExtensionsKt.clientIdAsString(tokenRequest) : this.subject;
    }

    @Override
    @NotNull
    public String typeHeader(@NotNull TokenRequest tokenRequest) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        return this.typeHeader;
    }

    @Override
    @NotNull
    public List<String> audience(@NotNull TokenRequest tokenRequest) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        TokenExchangeGrant tokenExchangeGrant = NimbusExtensionsKt.tokenExchangeGrantOrNull(tokenRequest);
        List<String> audienceParam = tokenExchangeGrant == null ? null : tokenExchangeGrant.getAudience();
        return this.audience != null ? this.audience : (audienceParam != null ? audienceParam : (tokenRequest.getScope() != null ? NimbusExtensionsKt.scopesWithoutOidcScopes(tokenRequest) : CollectionsKt.listOf((Object)"default")));
    }

    @Override
    @NotNull
    public Map<String, Object> addClaims(@NotNull TokenRequest tokenRequest) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Map $this$addClaims_u24lambda_u2d0 = map = MapsKt.toMutableMap(this.claims);
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"azp", (Object)NimbusExtensionsKt.clientIdAsString(tokenRequest)), TuplesKt.to((Object)"tid", (Object)this.issuerId)};
        $this$addClaims_u24lambda_u2d0.putAll(MapsKt.mapOf((Pair[])pairArray));
        return map;
    }

    @Override
    public long tokenExpiry() {
        return this.expiry;
    }

    @JvmOverloads
    public DefaultOAuth2TokenCallback(@NotNull String issuerId, @NotNull String subject, @NotNull String typeHeader, @Nullable List<String> audience, @NotNull Map<String, ? extends Object> claims) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)typeHeader, (String)"typeHeader");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        this(issuerId, subject, typeHeader, audience, claims, 0L, 32, null);
    }

    @JvmOverloads
    public DefaultOAuth2TokenCallback(@NotNull String issuerId, @NotNull String subject, @NotNull String typeHeader, @Nullable List<String> audience) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)typeHeader, (String)"typeHeader");
        this(issuerId, subject, typeHeader, audience, null, 0L, 48, null);
    }

    @JvmOverloads
    public DefaultOAuth2TokenCallback(@NotNull String issuerId, @NotNull String subject, @NotNull String typeHeader) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)typeHeader, (String)"typeHeader");
        this(issuerId, subject, typeHeader, null, null, 0L, 56, null);
    }

    @JvmOverloads
    public DefaultOAuth2TokenCallback(@NotNull String issuerId, @NotNull String subject) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        this(issuerId, subject, null, null, null, 0L, 60, null);
    }

    @JvmOverloads
    public DefaultOAuth2TokenCallback(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        this(issuerId, null, null, null, null, 0L, 62, null);
    }

    @JvmOverloads
    public DefaultOAuth2TokenCallback() {
        this(null, null, null, null, null, 0L, 63, null);
    }
}

