/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.token;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.RSAKey;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.token.KeyGenerator;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B!\b\u0007\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0005\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lno/nav/security/mock/oauth2/token/KeyProvider;", "", "initialKeys", "", "Lcom/nimbusds/jose/jwk/JWK;", "algorithm", "", "(Ljava/util/List;Ljava/lang/String;)V", "generator", "Lno/nav/security/mock/oauth2/token/KeyGenerator;", "keyDeque", "Ljava/util/concurrent/LinkedBlockingDeque;", "signingKeys", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/nimbusds/jose/JWSAlgorithm;", "generate", "", "keyFromDequeOrNew", "keyId", "keyType", "signingKey", "Companion", "mock-oauth2-server"})
public class KeyProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<JWK> initialKeys;
    @NotNull
    private final String algorithm;
    @NotNull
    private final ConcurrentHashMap<String, JWK> signingKeys;
    @NotNull
    private KeyGenerator generator;
    @NotNull
    private final LinkedBlockingDeque<JWK> keyDeque;
    @NotNull
    public static final String INITIAL_KEYS_FILE = "/mock-oauth2-server-keys.json";

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public KeyProvider(@NotNull List<? extends JWK> initialKeys, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter(initialKeys, (String)"initialKeys");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this.initialKeys = initialKeys;
        this.algorithm = algorithm;
        this.signingKeys = new ConcurrentHashMap();
        Object object = JWSAlgorithm.parse((String)this.algorithm);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parse(algorithm)");
        this.generator = new KeyGenerator((JWSAlgorithm)object, null, 2, null);
        Object object2 = object = new LinkedBlockingDeque();
        KeyProvider keyProvider = this;
        boolean bl = false;
        Iterable $this$forEach$iv = this.initialKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$keyDeque_u24lambda_u2d1;
            JWK it = (JWK)element$iv;
            boolean bl2 = false;
            $this$keyDeque_u24lambda_u2d1.put(it);
        }
        keyProvider.keyDeque = object;
    }

    public /* synthetic */ KeyProvider(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = Companion.keysFromFile(INITIAL_KEYS_FILE);
        }
        if ((n & 2) != 0) {
            String string2 = JWSAlgorithm.RS256.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"RS256.name");
            string = string2;
        }
        this(list, string);
    }

    @NotNull
    public final JWK signingKey(@NotNull String keyId) {
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        JWK jWK = this.signingKeys.computeIfAbsent(keyId, arg_0 -> KeyProvider.signingKey$lambda-2(this, keyId, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jWK, (String)"signingKeys.computeIfAbs\u2026eyFromDequeOrNew(keyId) }");
        return jWK;
    }

    private final JWK keyFromDequeOrNew(String keyId) {
        JWK jWK;
        JWK jWK2 = this.keyDeque.poll();
        if (jWK2 == null) {
            jWK = null;
        } else {
            RSAKey rSAKey;
            JWK polledJwk = jWK2;
            boolean bl = false;
            String string = polledJwk.getKeyType().getValue();
            if (Intrinsics.areEqual((Object)string, (Object)KeyType.RSA.getValue())) {
                rSAKey = new RSAKey.Builder(polledJwk.toRSAKey()).keyID(keyId).build();
            } else if (Intrinsics.areEqual((Object)string, (Object)KeyType.EC.getValue())) {
                rSAKey = new ECKey.Builder(polledJwk.toECKey()).keyID(keyId).build();
            } else {
                throw new OAuth2Exception("Unsupported key type: " + polledJwk.getKeyType().getValue());
            }
            jWK = (JWK)rSAKey;
        }
        JWK jWK3 = jWK;
        return jWK3 == null ? this.generator.generateKey(keyId) : jWK3;
    }

    @NotNull
    public final JWSAlgorithm algorithm() {
        JWSAlgorithm jWSAlgorithm = JWSAlgorithm.parse((String)this.algorithm);
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"parse(algorithm)");
        return jWSAlgorithm;
    }

    @NotNull
    public final String keyType() {
        String string = this.generator.getKeyGenerator().getAlgorithm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generator.keyGenerator.algorithm");
        return string;
    }

    public final void generate(@NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        JWSAlgorithm jWSAlgorithm = JWSAlgorithm.parse((String)algorithm);
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"parse(algorithm)");
        this.generator = new KeyGenerator(jWSAlgorithm, null, 2, null);
    }

    @JvmOverloads
    public KeyProvider(@NotNull List<? extends JWK> initialKeys) {
        Intrinsics.checkNotNullParameter(initialKeys, (String)"initialKeys");
        this(initialKeys, null, 2, null);
    }

    @JvmOverloads
    public KeyProvider() {
        this(null, null, 3, null);
    }

    private static final JWK signingKey$lambda-2(KeyProvider this$0, String $keyId, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$keyId, (String)"$keyId");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.keyFromDequeOrNew($keyId);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lno/nav/security/mock/oauth2/token/KeyProvider$Companion;", "", "()V", "INITIAL_KEYS_FILE", "", "keysFromFile", "", "Lcom/nimbusds/jose/jwk/JWK;", "filename", "mock-oauth2-server"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<JWK> keysFromFile(@NotNull String filename) {
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            URL keysFromFile = KeyProvider.class.getResource(filename);
            if (keysFromFile != null) {
                void $this$mapTo$iv$iv;
                URL uRL = keysFromFile;
                Object object = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
                List list = JWKSet.parse((String)new String(byArray, (Charset)object)).getKeys();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(keysFromFile.readText()).keys");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JWK jWK = (JWK)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v0 = it;
                    if (v0 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.nimbusds.jose.jwk.JWK");
                    }
                    collection.add(v0);
                }
                return (List)destination$iv$iv;
            }
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

