/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.templates;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.StringWriter;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.templates.HtmlContent;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006J\u0016\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lno/nav/security/mock/oauth2/templates/TemplateMapper;", "", "config", "Lfreemarker/template/Configuration;", "(Lfreemarker/template/Configuration;)V", "asString", "", "htmlContent", "Lno/nav/security/mock/oauth2/templates/HtmlContent;", "authorizationCodeResponseHtml", "redirectUri", "code", "state", "debuggerCallbackHtml", "tokenRequest", "tokenResponse", "debuggerErrorHtml", "debuggerUrl", "Lokhttp3/HttpUrl;", "stacktrace", "debuggerFormHtml", "url", "clientAuthMethod", "loginHtml", "oAuth2HttpRequest", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "Companion", "mock-oauth2-server"})
public final class TemplateMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Configuration config;

    public TemplateMapper(@NotNull Configuration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @NotNull
    public final String loginHtml(@NotNull OAuth2HttpRequest oAuth2HttpRequest) {
        Intrinsics.checkNotNullParameter((Object)oAuth2HttpRequest, (String)"oAuth2HttpRequest");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"request_url", (Object)oAuth2HttpRequest.getUrl().newBuilder().query(null).build().toString()), TuplesKt.to((Object)"query", new OAuth2HttpRequest.Parameters(oAuth2HttpRequest.getUrl().query()).getMap())};
        return this.asString(new HtmlContent("login.ftl", MapsKt.mapOf((Pair[])pairArray)));
    }

    @NotNull
    public final String debuggerCallbackHtml(@NotNull String tokenRequest, @NotNull String tokenResponse) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)tokenResponse, (String)"tokenResponse");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"token_request", (Object)tokenRequest), TuplesKt.to((Object)"token_response", (Object)tokenResponse)};
        return this.asString(new HtmlContent("debugger_callback.ftl", MapsKt.mapOf((Pair[])pairArray)));
    }

    @NotNull
    public final String debuggerErrorHtml(@NotNull HttpUrl debuggerUrl, @NotNull String stacktrace) {
        Intrinsics.checkNotNullParameter((Object)debuggerUrl, (String)"debuggerUrl");
        Intrinsics.checkNotNullParameter((Object)stacktrace, (String)"stacktrace");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"debugger_url", (Object)debuggerUrl), TuplesKt.to((Object)"stacktrace", (Object)stacktrace)};
        return this.asString(new HtmlContent("error.ftl", MapsKt.mapOf((Pair[])pairArray)));
    }

    @NotNull
    public final String debuggerFormHtml(@NotNull HttpUrl url, @NotNull String clientAuthMethod) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)clientAuthMethod, (String)"clientAuthMethod");
        HttpUrl.Builder urlWithoutQuery = url.newBuilder().query(null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"url", (Object)urlWithoutQuery), TuplesKt.to((Object)"token_url", (Object)HttpUrlExtensionsKt.toTokenEndpointUrl(url)), TuplesKt.to((Object)"query", new OAuth2HttpRequest.Parameters(url.query()).getMap()), TuplesKt.to((Object)"client_auth_method", (Object)clientAuthMethod)};
        return this.asString(new HtmlContent("debugger.ftl", MapsKt.mapOf((Pair[])pairArray)));
    }

    @NotNull
    public final String authorizationCodeResponseHtml(@NotNull String redirectUri, @NotNull String code, @NotNull String state) {
        Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"redirect_uri", (Object)redirectUri), TuplesKt.to((Object)"code", (Object)code), TuplesKt.to((Object)"state", (Object)state)};
        return this.asString(new HtmlContent("authorization_code_response.ftl", MapsKt.mapOf((Pair[])pairArray)));
    }

    private final String asString(HtmlContent htmlContent) {
        StringWriter stringWriter;
        StringWriter $this$asString_u24lambda_u2d0 = stringWriter = new StringWriter();
        boolean bl = false;
        this.config.getTemplate(htmlContent.getTemplate()).process(htmlContent.getModel(), (Writer)$this$asString_u24lambda_u2d0);
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringWriter().apply {\n \u2026his)\n        }.toString()");
        return string;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lno/nav/security/mock/oauth2/templates/TemplateMapper$Companion;", "", "()V", "create", "Lno/nav/security/mock/oauth2/templates/TemplateMapper;", "configure", "Lkotlin/Function1;", "Lfreemarker/template/Configuration;", "", "Lkotlin/ExtensionFunctionType;", "mock-oauth2-server"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TemplateMapper create(@NotNull Function1<? super Configuration, Unit> configure) {
            Configuration configuration;
            Intrinsics.checkNotNullParameter(configure, (String)"configure");
            Configuration $this$create_u24lambda_u2d0 = configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            boolean bl = false;
            $this$create_u24lambda_u2d0.setTemplateLoader((TemplateLoader)new ClassTemplateLoader($this$create_u24lambda_u2d0.getClass().getClassLoader(), "templates"));
            configure.invoke((Object)configuration);
            Configuration config = configuration;
            return new TemplateMapper(config);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

