/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.token;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.TokenRequest;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.token.KeyGenerator;
import no.nav.security.mock.oauth2.token.KeyProvider;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJV\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ*\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002J0\u0010\"\u001a\u00020\u00062\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\u000eH\u0007J\u0012\u0010&\u001a\u00020'2\b\b\u0002\u0010%\u001a\u00020\u000eH\u0007J\"\u0010(\u001a\u00020)*\u00020)2\u0014\b\u0002\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\u0016H\u0002J\u001c\u0010*\u001a\u00020\u0006*\u00020\u00102\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "", "keyProvider", "Lno/nav/security/mock/oauth2/token/KeyProvider;", "(Lno/nav/security/mock/oauth2/token/KeyProvider;)V", "accessToken", "Lcom/nimbusds/jwt/SignedJWT;", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "issuerUrl", "Lokhttp3/HttpUrl;", "oAuth2TokenCallback", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "nonce", "", "defaultClaims", "Lcom/nimbusds/jwt/JWTClaimsSet;", "kotlin.jvm.PlatformType", "subject", "audience", "", "additionalClaims", "", "expiry", "", "exchangeAccessToken", "claimsSet", "idToken", "jwsHeader", "Lcom/nimbusds/jose/JWSHeader;", "keyId", "type", "algorithm", "Lcom/nimbusds/jose/JWSAlgorithm;", "jwt", "claims", "Ljava/time/Duration;", "issuerId", "publicJwkSet", "Lcom/nimbusds/jose/jwk/JWKSet;", "addClaims", "Lcom/nimbusds/jwt/JWTClaimsSet$Builder;", "sign", "mock-oauth2-server"})
public final class OAuth2TokenProvider {
    @NotNull
    private final KeyProvider keyProvider;

    @JvmOverloads
    public OAuth2TokenProvider(@NotNull KeyProvider keyProvider) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        this.keyProvider = keyProvider;
    }

    public /* synthetic */ OAuth2TokenProvider(KeyProvider keyProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            keyProvider = new KeyProvider(null, null, 3, null);
        }
        this(keyProvider);
    }

    @JvmOverloads
    @NotNull
    public final JWKSet publicJwkSet(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        JWKSet jWKSet = new JWKSet(this.keyProvider.signingKey(issuerId)).toPublicJWKSet();
        Intrinsics.checkNotNullExpressionValue((Object)jWKSet, (String)"JWKSet(keyProvider.signi\u2026suerId)).toPublicJWKSet()");
        return jWKSet;
    }

    public static /* synthetic */ JWKSet publicJwkSet$default(OAuth2TokenProvider oAuth2TokenProvider, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "default";
        }
        return oAuth2TokenProvider.publicJwkSet(string);
    }

    @NotNull
    public final SignedJWT idToken(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback, @Nullable String nonce) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        JWTClaimsSet jWTClaimsSet = this.defaultClaims(issuerUrl, oAuth2TokenCallback.subject(tokenRequest), CollectionsKt.listOf((Object)NimbusExtensionsKt.clientIdAsString(tokenRequest)), nonce, oAuth2TokenCallback.addClaims(tokenRequest), oAuth2TokenCallback.tokenExpiry());
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"defaultClaims(\n        i\u2026lback.tokenExpiry()\n    )");
        return this.sign(jWTClaimsSet, HttpUrlExtensionsKt.issuerId(issuerUrl), oAuth2TokenCallback.typeHeader(tokenRequest));
    }

    public static /* synthetic */ SignedJWT idToken$default(OAuth2TokenProvider oAuth2TokenProvider, TokenRequest tokenRequest, HttpUrl httpUrl, OAuth2TokenCallback oAuth2TokenCallback, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return oAuth2TokenProvider.idToken(tokenRequest, httpUrl, oAuth2TokenCallback, string);
    }

    @NotNull
    public final SignedJWT accessToken(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback, @Nullable String nonce) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        JWTClaimsSet jWTClaimsSet = this.defaultClaims(issuerUrl, oAuth2TokenCallback.subject(tokenRequest), oAuth2TokenCallback.audience(tokenRequest), nonce, oAuth2TokenCallback.addClaims(tokenRequest), oAuth2TokenCallback.tokenExpiry());
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"defaultClaims(\n        i\u2026lback.tokenExpiry()\n    )");
        return this.sign(jWTClaimsSet, HttpUrlExtensionsKt.issuerId(issuerUrl), oAuth2TokenCallback.typeHeader(tokenRequest));
    }

    public static /* synthetic */ SignedJWT accessToken$default(OAuth2TokenProvider oAuth2TokenProvider, TokenRequest tokenRequest, HttpUrl httpUrl, OAuth2TokenCallback oAuth2TokenCallback, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return oAuth2TokenProvider.accessToken(tokenRequest, httpUrl, oAuth2TokenCallback, string);
    }

    @NotNull
    public final SignedJWT exchangeAccessToken(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @NotNull JWTClaimsSet claimsSet, @NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)claimsSet, (String)"claimsSet");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        Instant now = Instant.now();
        boolean bl = false;
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder(claimsSet).issuer(issuerUrl.toString()).expirationTime(Date.from(now.plusSeconds(oAuth2TokenCallback.tokenExpiry()))).notBeforeTime(Date.from(now)).issueTime(Date.from(now)).jwtID(UUID.randomUUID().toString()).audience(oAuth2TokenCallback.audience(tokenRequest));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(claimsSet)\n     \u2026k.audience(tokenRequest))");
        JWTClaimsSet jWTClaimsSet = this.addClaims(builder, oAuth2TokenCallback.addClaims(tokenRequest)).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"Builder(claimsSet)\n     \u2026st))\n            .build()");
        return this.sign(jWTClaimsSet, HttpUrlExtensionsKt.issuerId(issuerUrl), oAuth2TokenCallback.typeHeader(tokenRequest));
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final SignedJWT jwt(@NotNull Map<String, ? extends Object> claims, @NotNull Duration expiry, @NotNull String issuerId) {
        void builder;
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        JWTClaimsSet.Builder builder2 = new JWTClaimsSet.Builder();
        OAuth2TokenProvider oAuth2TokenProvider = this;
        boolean bl = false;
        Instant now = Instant.now();
        builder.issueTime(Date.from(now)).notBeforeTime(Date.from(now)).expirationTime(Date.from(now.plusSeconds(expiry.toSeconds())));
        this.addClaims((JWTClaimsSet.Builder)builder, claims);
        JWTClaimsSet jWTClaimsSet = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"Builder().let { builder \u2026builder.build()\n        }");
        String string = JOSEObjectType.JWT.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JWT.type");
        return oAuth2TokenProvider.sign(jWTClaimsSet, issuerId, string);
    }

    public static /* synthetic */ SignedJWT jwt$default(OAuth2TokenProvider oAuth2TokenProvider, Map map, Duration duration, String string, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofHours(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofHours(1)");
            duration = duration2;
        }
        if ((n & 4) != 0) {
            string = "default";
        }
        return oAuth2TokenProvider.jwt(map, duration, string);
    }

    private final SignedJWT sign(JWTClaimsSet $this$sign, String issuerId, String type) {
        SignedJWT signedJWT;
        JWK key = this.keyProvider.signingKey(issuerId);
        JWSAlgorithm algorithm = this.keyProvider.algorithm();
        String keyType = this.keyProvider.keyType();
        boolean supported = KeyGenerator.Companion.isSupported(algorithm);
        if (supported && Intrinsics.areEqual((Object)keyType, (Object)KeyType.RSA.getValue())) {
            SignedJWT signedJWT2;
            String string = key.getKeyID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.keyID");
            SignedJWT $this$sign_u24lambda_u2d2 = signedJWT2 = new SignedJWT(this.jwsHeader(string, type, algorithm), $this$sign);
            boolean bl = false;
            $this$sign_u24lambda_u2d2.sign((JWSSigner)new RSASSASigner(key.toRSAKey().toPrivateKey()));
            signedJWT = signedJWT2;
        } else if (supported && Intrinsics.areEqual((Object)keyType, (Object)KeyType.EC.getValue())) {
            SignedJWT signedJWT3;
            String string = key.getKeyID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.keyID");
            SignedJWT $this$sign_u24lambda_u2d3 = signedJWT3 = new SignedJWT(this.jwsHeader(string, type, algorithm), $this$sign);
            boolean bl = false;
            $this$sign_u24lambda_u2d3.sign((JWSSigner)new ECDSASigner(key.toECKey().toECPrivateKey()));
            signedJWT = signedJWT3;
        } else {
            throw new OAuth2Exception("Unsupported algorithm: " + algorithm.getName());
        }
        return signedJWT;
    }

    private final JWSHeader jwsHeader(String keyId, String type, JWSAlgorithm algorithm) {
        JWSHeader jWSHeader = new JWSHeader.Builder(algorithm).keyID(keyId).type(new JOSEObjectType(type)).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWSHeader, (String)"Builder(algorithm)\n     \u2026ObjectType(type)).build()");
        return jWSHeader;
    }

    private final JWTClaimsSet.Builder addClaims(JWTClaimsSet.Builder $this$addClaims, Map<String, ? extends Object> claims) {
        JWTClaimsSet.Builder builder;
        JWTClaimsSet.Builder $this$addClaims_u24lambda_u2d5 = builder = $this$addClaims;
        boolean bl = false;
        Map<String, ? extends Object> $this$forEach$iv = claims;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> it = element$iv = iterator.next();
            boolean bl2 = false;
            $this$addClaims_u24lambda_u2d5.claim(it.getKey(), it.getValue());
        }
        return builder;
    }

    static /* synthetic */ JWTClaimsSet.Builder addClaims$default(OAuth2TokenProvider oAuth2TokenProvider, JWTClaimsSet.Builder builder, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        return oAuth2TokenProvider.addClaims(builder, map);
    }

    private final JWTClaimsSet defaultClaims(HttpUrl issuerUrl, String subject, List<String> audience, String nonce, Map<String, ? extends Object> additionalClaims, long expiry) {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        boolean bl = false;
        Instant now = Instant.now();
        builder.subject(subject).audience(audience).issuer(issuerUrl.toString()).issueTime(Date.from(now)).notBeforeTime(Date.from(now)).expirationTime(Date.from(now.plusSeconds(expiry))).jwtID(UUID.randomUUID().toString());
        String string = nonce;
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl2 = false;
            builder.claim("nonce", (Object)it);
        }
        this.addClaims(builder, additionalClaims);
        return builder.build();
    }

    @JvmOverloads
    public OAuth2TokenProvider() {
        this(null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final JWKSet publicJwkSet() {
        return OAuth2TokenProvider.publicJwkSet$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT jwt(@NotNull Map<String, ? extends Object> claims, @NotNull Duration expiry) {
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        return OAuth2TokenProvider.jwt$default(this, claims, expiry, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT jwt(@NotNull Map<String, ? extends Object> claims) {
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        return OAuth2TokenProvider.jwt$default(this, claims, null, null, 6, null);
    }
}

