/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import no.nav.security.mock.oauth2.MockOAuth2ServerKt;
import no.nav.security.mock.oauth2.OAuth2Config;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.http.MockWebServerWrapper;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequestHandler;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpRouterKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpServer;
import no.nav.security.mock.oauth2.http.Route;
import no.nav.security.mock.oauth2.token.DefaultOAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 B2\u00020\u0001:\u0001BB\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB#\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\tJ.\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00010\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0007J\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001bJ\u0006\u0010 \u001a\u00020\u0018J\u000e\u0010!\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001bJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0007JH\u0010*\u001a\u00020\u00162\b\b\u0002\u0010\u001f\u001a\u00020\u001b2\b\b\u0002\u0010+\u001a\u00020\u001b2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u001b2\u0014\b\u0002\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00010\u001a2\b\b\u0002\u0010\u001c\u001a\u00020-H\u0007J\u001e\u0010*\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020%J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001bJ\u000e\u00100\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001bJ\u000e\u00101\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001bJ\u0006\u00102\u001a\u00020'J\u0016\u00103\u001a\u00020'2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207J\u0012\u00103\u001a\u00020'2\b\b\u0002\u00106\u001a\u000207H\u0007J\u001c\u00108\u001a\u0002092\b\b\u0002\u0010:\u001a\u00020-2\b\b\u0002\u0010;\u001a\u00020<H\u0007J\u000e\u0010=\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001bJ\u000e\u0010>\u001a\u00020\u00182\u0006\u0010?\u001a\u00020\u001bJ\u000e\u0010@\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001bJ\u000e\u0010A\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lno/nav/security/mock/oauth2/MockOAuth2Server;", "", "additionalRoutes", "", "Lno/nav/security/mock/oauth2/http/Route;", "([Lno/nav/security/mock/oauth2/http/Route;)V", "config", "Lno/nav/security/mock/oauth2/OAuth2Config;", "(Lno/nav/security/mock/oauth2/OAuth2Config;)V", "(Lno/nav/security/mock/oauth2/OAuth2Config;[Lno/nav/security/mock/oauth2/http/Route;)V", "getConfig", "()Lno/nav/security/mock/oauth2/OAuth2Config;", "defaultRequestHandler", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequestHandler;", "httpServer", "Lno/nav/security/mock/oauth2/http/OAuth2HttpServer;", "router", "Lkotlin/Function1;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "Lno/nav/security/mock/oauth2/http/RequestHandler;", "anyToken", "Lcom/nimbusds/jwt/SignedJWT;", "issuerUrl", "Lokhttp3/HttpUrl;", "claims", "", "", "expiry", "Ljava/time/Duration;", "authorizationEndpointUrl", "issuerId", "baseUrl", "endSessionEndpointUrl", "enqueueCallback", "", "oAuth2TokenCallback", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "enqueueResponse", "", "response", "Lokhttp3/mockwebserver/MockResponse;", "issueToken", "subject", "audience", "", "clientId", "tokenCallback", "jwksUrl", "oauth2AuthorizationServerMetadataUrl", "shutdown", "start", "inetAddress", "Ljava/net/InetAddress;", "port", "", "takeRequest", "Lokhttp3/mockwebserver/RecordedRequest;", "timeout", "unit", "Ljava/util/concurrent/TimeUnit;", "tokenEndpointUrl", "url", "path", "userInfoUrl", "wellKnownUrl", "Companion", "mock-oauth2-server"})
public class MockOAuth2Server {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OAuth2Config config;
    @NotNull
    private final OAuth2HttpServer httpServer;
    @NotNull
    private final OAuth2HttpRequestHandler defaultRequestHandler;
    @NotNull
    private final Function1<OAuth2HttpRequest, OAuth2HttpResponse> router;

    public MockOAuth2Server(@NotNull OAuth2Config config, Route ... additionalRoutes) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)additionalRoutes, (String)"additionalRoutes");
        this.config = config;
        this.httpServer = this.config.getHttpServer();
        this.defaultRequestHandler = new OAuth2HttpRequestHandler(this.config);
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)additionalRoutes);
        spreadBuilder.add((Object)this.defaultRequestHandler.getAuthorizationServer());
        this.router = OAuth2HttpRouterKt.routes((Route[])spreadBuilder.toArray((Object[])new Route[spreadBuilder.size()]));
    }

    public /* synthetic */ MockOAuth2Server(OAuth2Config oAuth2Config, Route[] routeArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            oAuth2Config = new OAuth2Config(false, null, null, null, null, 31, null);
        }
        this(oAuth2Config, routeArray);
    }

    @NotNull
    public final OAuth2Config getConfig() {
        return this.config;
    }

    public MockOAuth2Server(Route ... additionalRoutes) {
        Intrinsics.checkNotNullParameter((Object)additionalRoutes, (String)"additionalRoutes");
        this(new OAuth2Config(false, null, null, null, null, 31, null), Arrays.copyOf(additionalRoutes, additionalRoutes.length));
    }

    public MockOAuth2Server(@NotNull OAuth2Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        boolean $i$f$emptyArray = false;
        Route[] routeArray = new Route[]{};
        this(config, Arrays.copyOf(routeArray, routeArray.length));
    }

    @JvmOverloads
    public final void start(int port) {
        try {
            InetAddress inetAddress = InetAddress.getByName("localhost");
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(\"localhost\")");
            this.start(inetAddress, port);
        }
        catch (IOException ex) {
            throw new OAuth2Exception("unable to start server: " + ex.getMessage(), ex);
        }
    }

    public static /* synthetic */ void start$default(MockOAuth2Server mockOAuth2Server, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        mockOAuth2Server.start(n);
    }

    public final void start(@NotNull InetAddress inetAddress, int port) {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        MockOAuth2ServerKt.access$getLog$p().debug("attempt to start server on port=" + port);
        this.httpServer.start(inetAddress, port, this.router);
    }

    public final void shutdown() {
        try {
            this.httpServer.stop();
        }
        catch (IOException ex) {
            throw new OAuth2Exception("unable to shutdown server: " + ex.getMessage(), ex);
        }
    }

    @NotNull
    public final HttpUrl url(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.httpServer.url(path);
    }

    @Deprecated(message="Use MockWebServer method/function instead", replaceWith=@ReplaceWith(expression="MockWebServer.enqueue()", imports={}))
    public final void enqueueResponse(@NotNull MockResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        throw new UnsupportedOperationException("cannot enqueue MockResponse, please use the MockWebServer directly with QueueDispatcher");
    }

    public final boolean enqueueCallback(@NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        return this.defaultRequestHandler.enqueueTokenCallback(oAuth2TokenCallback);
    }

    @JvmOverloads
    @NotNull
    public final RecordedRequest takeRequest(long timeout, @NotNull TimeUnit unit) {
        MockWebServerWrapper mockWebServerWrapper;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
                OAuth2HttpServer oAuth2HttpServer = this.httpServer;
                mockWebServerWrapper = oAuth2HttpServer instanceof MockWebServerWrapper ? (MockWebServerWrapper)oAuth2HttpServer : null;
                if (mockWebServerWrapper == null || (mockWebServerWrapper = mockWebServerWrapper.getMockWebServer()) == null) break block4;
                MockWebServerWrapper it = mockWebServerWrapper;
                boolean bl = false;
                RecordedRequest recordedRequest = it.takeRequest(timeout, unit);
                if (recordedRequest == null) {
                    throw new RuntimeException("no request found in queue within timeout " + timeout + " " + unit);
                }
                mockWebServerWrapper = recordedRequest;
                if (recordedRequest != null) break block5;
            }
            throw new UnsupportedOperationException("can only takeRequest when httpServer is of type MockWebServer");
        }
        return mockWebServerWrapper;
    }

    public static /* synthetic */ RecordedRequest takeRequest$default(MockOAuth2Server mockOAuth2Server, long l, TimeUnit timeUnit, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: takeRequest");
        }
        if ((n & 1) != 0) {
            l = 2L;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return mockOAuth2Server.takeRequest(l, timeUnit);
    }

    @NotNull
    public final HttpUrl wellKnownUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toWellKnownUrl(this.url(issuerId));
    }

    @NotNull
    public final HttpUrl oauth2AuthorizationServerMetadataUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toOAuth2AuthorizationServerMetadataUrl(this.url(issuerId));
    }

    @NotNull
    public final HttpUrl tokenEndpointUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toTokenEndpointUrl(this.url(issuerId));
    }

    @NotNull
    public final HttpUrl jwksUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toJwksUrl(this.url(issuerId));
    }

    @NotNull
    public final HttpUrl issuerUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return this.url(issuerId);
    }

    @NotNull
    public final HttpUrl authorizationEndpointUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toAuthorizationEndpointUrl(this.url(issuerId));
    }

    @NotNull
    public final HttpUrl endSessionEndpointUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toEndSessionEndpointUrl(this.url(issuerId));
    }

    @NotNull
    public final HttpUrl userInfoUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toUserInfoUrl(this.url(issuerId));
    }

    @NotNull
    public final HttpUrl baseUrl() {
        return this.url("");
    }

    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String clientId, @NotNull OAuth2TokenCallback tokenCallback) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)tokenCallback, (String)"tokenCallback");
        HttpUrl uri = this.tokenEndpointUrl(issuerId);
        HttpUrl issuerUrl = this.issuerUrl(issuerId);
        TokenRequest tokenRequest = new TokenRequest(uri.uri(), (ClientAuthentication)new ClientSecretBasic(new ClientID(clientId), new Secret("secret")), (AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode("123"), URI.create("http://localhost")));
        return this.config.getTokenProvider().accessToken(tokenRequest, issuerUrl, tokenCallback, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String subject, @Nullable String audience, @NotNull Map<String, ? extends Object> claims, long expiry) {
        List list;
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        MockOAuth2Server mockOAuth2Server = this;
        String string = issuerId;
        String string2 = "default";
        String string3 = issuerId;
        String string4 = subject;
        String string5 = JOSEObjectType.JWT.getType();
        String string6 = string5;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"JWT.type");
        String string7 = audience;
        if (string7 != null) {
            void it;
            String string8 = string7;
            String string9 = string6;
            String string10 = string4;
            String string11 = string3;
            String string12 = string2;
            String string13 = string;
            MockOAuth2Server mockOAuth2Server2 = mockOAuth2Server;
            boolean bl = false;
            List list2 = CollectionsKt.listOf((Object)it);
            mockOAuth2Server = mockOAuth2Server2;
            string = string13;
            string2 = string12;
            string3 = string11;
            string4 = string10;
            string6 = string9;
            list = list2;
        } else {
            list = null;
        }
        long l = expiry;
        Map<String, ? extends Object> map = claims;
        List list3 = list;
        String string14 = string6;
        String string15 = string4;
        String string16 = string3;
        return mockOAuth2Server.issueToken(string, string2, new DefaultOAuth2TokenCallback(string16, string15, string14, list3, map, l));
    }

    public static /* synthetic */ SignedJWT issueToken$default(MockOAuth2Server mockOAuth2Server, String string, String string2, String string3, Map map, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: issueToken");
        }
        if ((n & 1) != 0) {
            string = "default";
        }
        if ((n & 2) != 0) {
            String string4 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"randomUUID().toString()");
            string2 = string4;
        }
        if ((n & 4) != 0) {
            string3 = "default";
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            l = 3600L;
        }
        return mockOAuth2Server.issueToken(string, string2, string3, map, l);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT anyToken(@NotNull HttpUrl issuerUrl, @NotNull Map<String, ? extends Object> claims, @NotNull Duration expiry) {
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        JWTClaimsSet jwtClaimsSet = MockOAuth2ServerKt.toJwtClaimsSet(claims);
        GrantType grantType = new GrantType("MockGrant");
        AuthorizationGrant mockGrant2 = new AuthorizationGrant(grantType){

            @NotNull
            public Map<String, List<String>> toParameters() {
                return new LinkedHashMap<K, V>();
            }
        };
        return this.config.getTokenProvider().exchangeAccessToken(new TokenRequest(URI.create("http://mockgrant"), new ClientID("mockclientid"), mockGrant2), issuerUrl, jwtClaimsSet, new DefaultOAuth2TokenCallback(null, null, null, jwtClaimsSet.getAudience(), null, expiry.toMillis(), 23, null));
    }

    public static /* synthetic */ SignedJWT anyToken$default(MockOAuth2Server mockOAuth2Server, HttpUrl httpUrl, Map map, Duration duration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: anyToken");
        }
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofHours(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofHours(1)");
            duration = duration2;
        }
        return mockOAuth2Server.anyToken(httpUrl, map, duration);
    }

    @JvmOverloads
    public final void start() {
        MockOAuth2Server.start$default(this, 0, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final RecordedRequest takeRequest(long timeout) {
        return MockOAuth2Server.takeRequest$default(this, timeout, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final RecordedRequest takeRequest() {
        return MockOAuth2Server.takeRequest$default(this, 0L, null, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String subject, @Nullable String audience, @NotNull Map<String, ? extends Object> claims) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        return MockOAuth2Server.issueToken$default(this, issuerId, subject, audience, claims, 0L, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String subject, @Nullable String audience) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        return MockOAuth2Server.issueToken$default(this, issuerId, subject, audience, null, 0L, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String subject) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        return MockOAuth2Server.issueToken$default(this, issuerId, subject, null, null, 0L, 28, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return MockOAuth2Server.issueToken$default(this, issuerId, null, null, null, 0L, 30, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken() {
        return MockOAuth2Server.issueToken$default(this, null, null, null, null, 0L, 31, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT anyToken(@NotNull HttpUrl issuerUrl, @NotNull Map<String, ? extends Object> claims) {
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        return MockOAuth2Server.anyToken$default(this, issuerUrl, claims, null, 4, null);
    }

    static {
        try {
            new Buffer().copy();
        }
        catch (NoSuchMethodError e) {
            throw new RuntimeException("Unsupported version of com.squareup.okhttp3:mockwebserver in classpath. Version should be >= 4.9.2", e);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lno/nav/security/mock/oauth2/MockOAuth2Server$Companion;", "", "()V", "mock-oauth2-server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

