/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B+\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lno/nav/security/mock/oauth2/http/SslKeystore;", "", "keyPassword", "", "keystoreFile", "Ljava/io/File;", "keystoreType", "Lno/nav/security/mock/oauth2/http/SslKeystore$KeyStoreType;", "keystorePassword", "(Ljava/lang/String;Ljava/io/File;Lno/nav/security/mock/oauth2/http/SslKeystore$KeyStoreType;Ljava/lang/String;)V", "keyStore", "Ljava/security/KeyStore;", "(Ljava/lang/String;Ljava/security/KeyStore;)V", "getKeyPassword", "()Ljava/lang/String;", "getKeyStore", "()Ljava/security/KeyStore;", "Companion", "KeyStoreType", "mock-oauth2-server"})
public final class SslKeystore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String keyPassword;
    @NotNull
    private final KeyStore keyStore;
    @NotNull
    private static final String CERT_SIGNATURE_ALG = "SHA256withRSA";
    @NotNull
    private static final String KEY_ALG = "RSA";
    private static final int KEY_SIZE = 2048;

    @JvmOverloads
    public SslKeystore(@NotNull String keyPassword, @NotNull KeyStore keyStore) {
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        this.keyPassword = keyPassword;
        this.keyStore = keyStore;
    }

    public /* synthetic */ SslKeystore(String string, KeyStore keyStore, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            keyStore = Companion.generate("localhost", string);
        }
        this(string, keyStore);
    }

    @NotNull
    public final String getKeyPassword() {
        return this.keyPassword;
    }

    @NotNull
    public final KeyStore getKeyStore() {
        return this.keyStore;
    }

    @JvmOverloads
    public SslKeystore(@NotNull String keyPassword, @NotNull File keystoreFile, @NotNull KeyStoreType keystoreType, @NotNull String keystorePassword) {
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        Intrinsics.checkNotNullParameter((Object)keystoreFile, (String)"keystoreFile");
        Intrinsics.checkNotNullParameter((Object)((Object)keystoreType), (String)"keystoreType");
        Intrinsics.checkNotNullParameter((Object)keystorePassword, (String)"keystorePassword");
        KeyStore keyStore = SslKeystore.Companion.keyStore(keystoreFile, keystoreType, keystorePassword);
        Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"keyStore(keystoreFile, k\u2026reType, keystorePassword)");
        this(keyPassword, keyStore);
    }

    public /* synthetic */ SslKeystore(String string, File file, KeyStoreType keyStoreType, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            keyStoreType = KeyStoreType.PKCS12;
        }
        if ((n & 8) != 0) {
            string2 = "";
        }
        this(string, file, keyStoreType, string2);
    }

    @JvmOverloads
    public SslKeystore(@NotNull String keyPassword) {
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        this(keyPassword, null, 2, null);
    }

    @JvmOverloads
    public SslKeystore() {
        this(null, null, 3, null);
    }

    @JvmOverloads
    public SslKeystore(@NotNull String keyPassword, @NotNull File keystoreFile, @NotNull KeyStoreType keystoreType) {
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        Intrinsics.checkNotNullParameter((Object)keystoreFile, (String)"keystoreFile");
        Intrinsics.checkNotNullParameter((Object)((Object)keystoreType), (String)"keystoreType");
        this(keyPassword, keystoreFile, keystoreType, null, 8, null);
    }

    @JvmOverloads
    public SslKeystore(@NotNull String keyPassword, @NotNull File keystoreFile) {
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        Intrinsics.checkNotNullParameter((Object)keystoreFile, (String)"keystoreFile");
        this(keyPassword, keystoreFile, null, null, 12, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lno/nav/security/mock/oauth2/http/SslKeystore$KeyStoreType;", "", "(Ljava/lang/String;I)V", "PKCS12", "JKS", "mock-oauth2-server"})
    public static final class KeyStoreType
    extends Enum<KeyStoreType> {
        public static final /* enum */ KeyStoreType PKCS12 = new KeyStoreType();
        public static final /* enum */ KeyStoreType JKS = new KeyStoreType();
        private static final /* synthetic */ KeyStoreType[] $VALUES;

        public static KeyStoreType[] values() {
            return (KeyStoreType[])$VALUES.clone();
        }

        public static KeyStoreType valueOf(String value) {
            return Enum.valueOf(KeyStoreType.class, value);
        }

        static {
            $VALUES = keyStoreTypeArray = new KeyStoreType[]{KeyStoreType.PKCS12, KeyStoreType.JKS};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tH\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J,\u0010\u000f\u001a\n \n*\u0004\u0018\u00010\f0\f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0004H\u0002J\u001c\u0010\u0015\u001a\u00020\u0016*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0019H\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0019H\u0002J\u001e\u0010\u001e\u001a\u00020\u001f*\u00020 2\u0006\u0010\u0017\u001a\u00020\u00042\b\b\u0002\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lno/nav/security/mock/oauth2/http/SslKeystore$Companion;", "", "()V", "CERT_SIGNATURE_ALG", "", "KEY_ALG", "KEY_SIZE", "", "digestCalculator", "Lorg/bouncycastle/operator/DigestCalculator;", "kotlin.jvm.PlatformType", "generate", "Ljava/security/KeyStore;", "hostname", "keyPassword", "keyStore", "keystoreFile", "Ljava/io/File;", "keystoreType", "Lno/nav/security/mock/oauth2/http/SslKeystore$KeyStoreType;", "keystorePassword", "addExtensions", "Lorg/bouncycastle/cert/X509v3CertificateBuilder;", "cn", "publicKey", "Ljava/security/PublicKey;", "createAuthorityKeyId", "Lorg/bouncycastle/asn1/x509/AuthorityKeyIdentifier;", "createSubjectKeyId", "Lorg/bouncycastle/asn1/x509/SubjectKeyIdentifier;", "toX509Certificate", "Ljava/security/cert/X509Certificate;", "Ljava/security/KeyPair;", "expiry", "Ljava/time/Duration;", "mock-oauth2-server"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KeyStore generate(@NotNull String hostname, @NotNull String keyPassword) {
            KeyStore keyStore;
            KeyPairGenerator keyPairGenerator;
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
            KeyPairGenerator $this$generate_u24lambda_u240 = keyPairGenerator = KeyPairGenerator.getInstance(SslKeystore.KEY_ALG);
            boolean bl = false;
            $this$generate_u24lambda_u240.initialize(2048);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"keyPair");
            X509Certificate cert = no.nav.security.mock.oauth2.http.SslKeystore$Companion.toX509Certificate$default(this, keyPair, hostname, null, 2, null);
            KeyStore $this$generate_u24lambda_u241 = keyStore = KeyStore.getInstance("PKCS12");
            boolean bl2 = false;
            $this$generate_u24lambda_u241.load(null);
            Key key = keyPair.getPrivate();
            char[] cArray = keyPassword.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            X509Certificate[] x509CertificateArray = new X509Certificate[]{cert};
            $this$generate_u24lambda_u241.setKeyEntry(hostname, key, cArray, x509CertificateArray);
            KeyStore keyStore2 = keyStore;
            Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"getInstance(KeyStoreType\u2026ayOf(cert))\n            }");
            return keyStore2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final KeyStore keyStore(File keystoreFile, KeyStoreType keystoreType, String keystorePassword) {
            KeyStore keyStore;
            KeyStore $this$keyStore_u24lambda_u243 = keyStore = KeyStore.getInstance(keystoreType.name());
            boolean bl = false;
            Closeable closeable = new FileInputStream(keystoreFile);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl2 = false;
                InputStream inputStream = it;
                char[] cArray = keystorePassword.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                $this$keyStore_u24lambda_u243.load(inputStream, cArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return keyStore;
        }

        static /* synthetic */ KeyStore keyStore$default(Companion companion, File file, KeyStoreType keyStoreType, String string, int n, Object object) {
            if ((n & 2) != 0) {
                keyStoreType = KeyStoreType.PKCS12;
            }
            if ((n & 4) != 0) {
                string = "";
            }
            return companion.keyStore(file, keyStoreType, string);
        }

        private final X509Certificate toX509Certificate(KeyPair $this$toX509Certificate, String cn, Duration expiry) {
            Instant now = Instant.now();
            X500Name x500Name = new X500Name("CN=" + cn);
            ContentSigner contentSigner = new JcaContentSignerBuilder(SslKeystore.CERT_SIGNATURE_ALG).build($this$toX509Certificate.getPrivate());
            Intrinsics.checkNotNullExpressionValue((Object)contentSigner, (String)"JcaContentSignerBuilder(\u2026_ALG).build(this.private)");
            ContentSigner contentSigner2 = contentSigner;
            X509v3CertificateBuilder x509v3CertificateBuilder = (X509v3CertificateBuilder)new JcaX509v3CertificateBuilder(x500Name, BigInteger.valueOf(now.toEpochMilli()), Date.from(now), Date.from(now.plus(expiry)), x500Name, $this$toX509Certificate.getPublic());
            PublicKey publicKey = $this$toX509Certificate.getPublic();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"this.public");
            X509CertificateHolder certificateHolder = this.addExtensions(x509v3CertificateBuilder, cn, publicKey).build(contentSigner2);
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(certificateHolder);
            Intrinsics.checkNotNullExpressionValue((Object)x509Certificate, (String)"JcaX509CertificateConver\u2026ficate(certificateHolder)");
            return x509Certificate;
        }

        static /* synthetic */ X509Certificate toX509Certificate$default(Companion companion, KeyPair keyPair, String string, Duration duration, int n, Object object) {
            if ((n & 2) != 0) {
                Duration duration2 = Duration.ofDays(365L);
                Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofDays(365)");
                duration = duration2;
            }
            return companion.toX509Certificate(keyPair, string, duration);
        }

        private final X509v3CertificateBuilder addExtensions(X509v3CertificateBuilder $this$addExtensions, String cn, PublicKey publicKey) {
            X509v3CertificateBuilder x509v3CertificateBuilder;
            X509v3CertificateBuilder $this$addExtensions_u24lambda_u244 = x509v3CertificateBuilder = $this$addExtensions;
            boolean bl = false;
            $this$addExtensions_u24lambda_u244.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)Companion.createSubjectKeyId(publicKey)).addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)Companion.createAuthorityKeyId(publicKey)).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true)).addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(new GeneralName(2, cn))).addExtension(Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(128)).addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
            return x509v3CertificateBuilder;
        }

        private final SubjectKeyIdentifier createSubjectKeyId(PublicKey $this$createSubjectKeyId) {
            SubjectKeyIdentifier subjectKeyIdentifier = new X509ExtensionUtils(this.digestCalculator()).createSubjectKeyIdentifier(SubjectPublicKeyInfo.getInstance((Object)$this$createSubjectKeyId.getEncoded()));
            Intrinsics.checkNotNullExpressionValue((Object)subjectKeyIdentifier, (String)"X509ExtensionUtils(diges\u2026nfo.getInstance(encoded))");
            return subjectKeyIdentifier;
        }

        private final AuthorityKeyIdentifier createAuthorityKeyId(PublicKey $this$createAuthorityKeyId) {
            AuthorityKeyIdentifier authorityKeyIdentifier = new X509ExtensionUtils(this.digestCalculator()).createAuthorityKeyIdentifier(SubjectPublicKeyInfo.getInstance((Object)$this$createAuthorityKeyId.getEncoded()));
            Intrinsics.checkNotNullExpressionValue((Object)authorityKeyIdentifier, (String)"X509ExtensionUtils(diges\u2026nfo.getInstance(encoded))");
            return authorityKeyIdentifier;
        }

        private final DigestCalculator digestCalculator() {
            return new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

