/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.debugger;

import com.nimbusds.oauth2.sdk.OAuth2Error;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.debugger.ClientKt;
import okhttp3.Credentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0080\b\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\r\u001a\u00020\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0015\u001a\u00020\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lno/nav/security/mock/oauth2/debugger/ClientAuthentication;", "", "clientId", "", "clientSecret", "clientAuthMethod", "Lno/nav/security/mock/oauth2/debugger/ClientAuthentication$Method;", "(Ljava/lang/String;Ljava/lang/String;Lno/nav/security/mock/oauth2/debugger/ClientAuthentication$Method;)V", "getClientAuthMethod", "()Lno/nav/security/mock/oauth2/debugger/ClientAuthentication$Method;", "getClientId", "()Ljava/lang/String;", "getClientSecret", "basic", "component1", "component2", "component3", "copy", "equals", "", "other", "form", "hashCode", "", "toString", "Companion", "Method", "mock-oauth2-server"})
public final class ClientAuthentication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String clientId;
    @NotNull
    private final String clientSecret;
    @NotNull
    private final Method clientAuthMethod;

    public ClientAuthentication(@NotNull String clientId, @NotNull String clientSecret, @NotNull Method clientAuthMethod) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)((Object)clientAuthMethod), (String)"clientAuthMethod");
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.clientAuthMethod = clientAuthMethod;
    }

    @NotNull
    public final String getClientId() {
        return this.clientId;
    }

    @NotNull
    public final String getClientSecret() {
        return this.clientSecret;
    }

    @NotNull
    public final Method getClientAuthMethod() {
        return this.clientAuthMethod;
    }

    @NotNull
    public final String form() {
        return "client_id=" + ClientKt.urlEncode(this.clientId) + "&client_secret=" + ClientKt.urlEncode(this.clientSecret);
    }

    @NotNull
    public final String basic() {
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        return Credentials.basic((String)this.clientId, (String)this.clientSecret, (Charset)charset);
    }

    @NotNull
    public final String component1() {
        return this.clientId;
    }

    @NotNull
    public final String component2() {
        return this.clientSecret;
    }

    @NotNull
    public final Method component3() {
        return this.clientAuthMethod;
    }

    @NotNull
    public final ClientAuthentication copy(@NotNull String clientId, @NotNull String clientSecret, @NotNull Method clientAuthMethod) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)((Object)clientAuthMethod), (String)"clientAuthMethod");
        return new ClientAuthentication(clientId, clientSecret, clientAuthMethod);
    }

    public static /* synthetic */ ClientAuthentication copy$default(ClientAuthentication clientAuthentication, String string, String string2, Method method, int n, Object object) {
        if ((n & 1) != 0) {
            string = clientAuthentication.clientId;
        }
        if ((n & 2) != 0) {
            string2 = clientAuthentication.clientSecret;
        }
        if ((n & 4) != 0) {
            method = clientAuthentication.clientAuthMethod;
        }
        return clientAuthentication.copy(string, string2, method);
    }

    @NotNull
    public String toString() {
        return "ClientAuthentication(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", clientAuthMethod=" + this.clientAuthMethod + ")";
    }

    public int hashCode() {
        int result = this.clientId.hashCode();
        result = result * 31 + this.clientSecret.hashCode();
        result = result * 31 + this.clientAuthMethod.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClientAuthentication)) {
            return false;
        }
        ClientAuthentication clientAuthentication = (ClientAuthentication)other;
        if (!Intrinsics.areEqual((Object)this.clientId, (Object)clientAuthentication.clientId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clientSecret, (Object)clientAuthentication.clientSecret)) {
            return false;
        }
        return this.clientAuthMethod == clientAuthentication.clientAuthMethod;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006J \u0010\b\u001a\u00020\u0007*\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lno/nav/security/mock/oauth2/debugger/ClientAuthentication$Companion;", "", "()V", "fromMap", "Lno/nav/security/mock/oauth2/debugger/ClientAuthentication;", "map", "", "", "require", "key", "mock-oauth2-server"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClientAuthentication fromMap(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            return new ClientAuthentication(this.require(map, "client_id"), this.require(map, "client_secret"), Method.valueOf(this.require(map, "client_auth_method")));
        }

        private final String require(Map<String, String> $this$require, String key) {
            String string = $this$require.get(key);
            if (string == null) {
                throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "missing required parameter " + key);
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lno/nav/security/mock/oauth2/debugger/ClientAuthentication$Method;", "", "(Ljava/lang/String;I)V", "CLIENT_SECRET_POST", "CLIENT_SECRET_BASIC", "mock-oauth2-server"})
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method CLIENT_SECRET_POST = new Method();
        public static final /* enum */ Method CLIENT_SECRET_BASIC = new Method();
        private static final /* synthetic */ Method[] $VALUES;

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String value) {
            return Enum.valueOf(Method.class, value);
        }

        static {
            $VALUES = methodArray = new Method[]{Method.CLIENT_SECRET_POST, Method.CLIENT_SECRET_BASIC};
        }
    }
}

