/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.extensions;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.OAuth2ExceptionKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0004\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\f\u001a,\u0010\r\u001a\u0002H\u000e\"\n\b\u0000\u0010\u000e\u0018\u0001*\u00020\u000f*\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0086\b\u00a2\u0006\u0002\u0010\u0012\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0004\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0017\u001a\u001a\u0010\u0018\u001a\u00020\u0019*\u00020\u00062\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0018\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\t0\t0\u001e*\u00020\u0004\u001a\f\u0010 \u001a\u0004\u0018\u00010!*\u00020\u0004\u001a\u0012\u0010\"\u001a\u00020#*\u00020\u00172\u0006\u0010$\u001a\u00020\u0004\u001a$\u0010%\u001a\u00020&*\u00020\f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020,\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"log", "Lmu/KLogger;", "authorizationCode", "Lcom/nimbusds/oauth2/sdk/AuthorizationCode;", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "clientAuthentication", "Lcom/nimbusds/oauth2/sdk/auth/ClientAuthentication;", "Lcom/nimbusds/oauth2/sdk/http/HTTPRequest;", "clientIdAsString", "", "expiresIn", "", "Lcom/nimbusds/jwt/SignedJWT;", "grant", "T", "Lcom/nimbusds/oauth2/sdk/AuthorizationGrant;", "type", "Ljava/lang/Class;", "(Lcom/nimbusds/oauth2/sdk/TokenRequest;Ljava/lang/Class;)Lcom/nimbusds/oauth2/sdk/AuthorizationGrant;", "grantType", "Lcom/nimbusds/oauth2/sdk/GrantType;", "isPrompt", "", "Lcom/nimbusds/openid/connect/sdk/AuthenticationRequest;", "requirePrivateKeyJwt", "Lcom/nimbusds/oauth2/sdk/auth/PrivateKeyJWT;", "requiredAudience", "maxLifetimeSeconds", "", "scopesWithoutOidcScopes", "", "kotlin.jvm.PlatformType", "tokenExchangeGrantOrNull", "Lno/nav/security/mock/oauth2/grant/TokenExchangeGrant;", "verifyPkce", "", "tokenRequest", "verifySignatureAndIssuer", "Lcom/nimbusds/jwt/JWTClaimsSet;", "issuer", "Lcom/nimbusds/oauth2/sdk/id/Issuer;", "jwkSet", "Lcom/nimbusds/jose/jwk/JWKSet;", "jwsAlgorithm", "Lcom/nimbusds/jose/JWSAlgorithm;", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nNimbusExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NimbusExtensions.kt\nno/nav/security/mock/oauth2/extensions/NimbusExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n75#1,2:121\n1747#2,3:118\n819#2:123\n847#2:124\n848#2:129\n11335#3:125\n11670#3,3:126\n1#4:130\n*S KotlinDebug\n*F\n+ 1 NimbusExtensions.kt\nno/nav/security/mock/oauth2/extensions/NimbusExtensionsKt\n*L\n46#1:121,2\n41#1:118,3\n62#1:123\n62#1:124\n62#1:129\n63#1:125\n63#1:126,3\n*E\n"})
public final class NimbusExtensionsKt {
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);

    public static final boolean isPrompt(@NotNull AuthenticationRequest $this$isPrompt) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$isPrompt, (String)"<this>");
            Prompt prompt = $this$isPrompt.getPrompt();
            if (prompt != null) {
                Iterable $this$any$iv = (Iterable)prompt;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Prompt.Type it = (Prompt.Type)element$iv;
                        boolean bl2 = false;
                        if (!(it == Prompt.Type.LOGIN || it == Prompt.Type.CONSENT || it == Prompt.Type.SELECT_ACCOUNT)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final void verifyPkce(@NotNull AuthenticationRequest $this$verifyPkce, @NotNull TokenRequest tokenRequest) {
        void $this$grant$iv;
        Intrinsics.checkNotNullParameter((Object)$this$verifyPkce, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        TokenRequest tokenRequest2 = tokenRequest;
        Class<AuthorizationCodeGrant> type$iv = AuthorizationCodeGrant.class;
        boolean $i$f$grant = false;
        AuthorizationGrant authorizationGrant = $this$grant$iv.getAuthorizationGrant();
        if (!(authorizationGrant instanceof AuthorizationCodeGrant)) {
            authorizationGrant = null;
        }
        AuthorizationGrant authorizationGrant2 = (AuthorizationGrant)((AuthorizationCodeGrant)authorizationGrant);
        if (authorizationGrant2 == null) {
            throw new OAuth2Exception(OAuth2Error.INVALID_GRANT, "expected grant of type " + type$iv);
        }
        CodeVerifier verifier = ((AuthorizationCodeGrant)authorizationGrant2).getCodeVerifier();
        if (verifier != null) {
            if (!Intrinsics.areEqual((Object)CodeChallenge.compute((CodeChallengeMethod)$this$verifyPkce.getCodeChallengeMethod(), (CodeVerifier)verifier), (Object)$this$verifyPkce.getCodeChallenge())) {
                String msg = "invalid_pkce: code_verifier does not compute to code_challenge from request";
                throw new OAuth2Exception(OAuth2Error.INVALID_GRANT.setDescription(msg), msg);
            }
        } else {
            log.debug("no code_verifier found in token request, nothing to compare");
        }
    }

    @NotNull
    public static final GrantType grantType(@NotNull TokenRequest $this$grantType) {
        GrantType grantType;
        Intrinsics.checkNotNullParameter((Object)$this$grantType, (String)"<this>");
        AuthorizationGrant authorizationGrant = $this$grantType.getAuthorizationGrant();
        Object object = grantType = authorizationGrant != null ? authorizationGrant.getType() : null;
        if (grantType == null) {
            throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "missing required parameter grant_type");
        }
        return grantType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> scopesWithoutOidcScopes(@NotNull TokenRequest $this$scopesWithoutOidcScopes) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$scopesWithoutOidcScopes, (String)"<this>");
        Object object = $this$scopesWithoutOidcScopes.getScope();
        if (object != null && (object = object.toStringList()) != null) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = (Iterable)object;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                void $this$mapTo$iv$iv;
                String value = (String)element$iv$iv;
                boolean bl = false;
                OIDCScopeValue[] oIDCScopeValueArray = OIDCScopeValue.values();
                Intrinsics.checkNotNullExpressionValue((Object)oIDCScopeValueArray, (String)"values()");
                Object[] $this$map$iv = oIDCScopeValueArray;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    OIDCScopeValue oIDCScopeValue = (OIDCScopeValue)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(it.toString());
                }
                if (((List)destination$iv$iv2).contains(value)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public static final TokenExchangeGrant tokenExchangeGrantOrNull(@NotNull TokenRequest $this$tokenExchangeGrantOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$tokenExchangeGrantOrNull, (String)"<this>");
        AuthorizationGrant authorizationGrant = $this$tokenExchangeGrantOrNull.getAuthorizationGrant();
        return authorizationGrant instanceof TokenExchangeGrant ? (TokenExchangeGrant)authorizationGrant : null;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final AuthorizationCode authorizationCode(@NotNull TokenRequest $this$authorizationCode) {
        Intrinsics.checkNotNullParameter((Object)$this$authorizationCode, (String)"<this>");
        var2_1 = $this$authorizationCode.getAuthorizationGrant();
        if (var2_1 == null) ** GOTO lbl-1000
        it = var2_1;
        $i$a$-let-NimbusExtensionsKt$authorizationCode$1 = false;
        var3_4 = it instanceof AuthorizationCodeGrant ? (AuthorizationCodeGrant)it : null;
        if (var3_4 != null) {
            v0 = var3_4.getAuthorizationCode();
        } else lbl-1000:
        // 2 sources

        {
            v0 = var1_5 = null;
        }
        if (var1_5 == null) {
            throw new OAuth2Exception(OAuth2Error.INVALID_GRANT, "code cannot be null");
        }
        return var1_5;
    }

    public static final /* synthetic */ <T extends AuthorizationGrant> T grant(TokenRequest $this$grant, Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)$this$grant, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        boolean $i$f$grant = false;
        AuthorizationGrant authorizationGrant = $this$grant.getAuthorizationGrant();
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        if (authorizationGrant == null) {
            throw new OAuth2Exception(OAuth2Error.INVALID_GRANT, "expected grant of type " + type);
        }
        return (T)authorizationGrant;
    }

    @NotNull
    public static final String clientIdAsString(@NotNull TokenRequest $this$clientIdAsString) {
        Intrinsics.checkNotNullParameter((Object)$this$clientIdAsString, (String)"<this>");
        Object object = $this$clientIdAsString.getClientAuthentication();
        if (object == null || (object = object.getClientID()) == null || (object = object.getValue()) == null) {
            ClientID clientID = $this$clientIdAsString.getClientID();
            object = clientID != null ? clientID.getValue() : null;
            if (object == null) {
                throw new OAuth2Exception(OAuth2Error.INVALID_CLIENT, "client_id cannot be null");
            }
        }
        return object;
    }

    public static final int expiresIn(@NotNull SignedJWT $this$expiresIn) {
        Intrinsics.checkNotNullParameter((Object)$this$expiresIn, (String)"<this>");
        return (int)Duration.between(Instant.now(), $this$expiresIn.getJWTClaimsSet().getExpirationTime().toInstant()).getSeconds();
    }

    @NotNull
    public static final JWTClaimsSet verifySignatureAndIssuer(@NotNull SignedJWT $this$verifySignatureAndIssuer, @NotNull Issuer issuer, @NotNull JWKSet jwkSet, @NotNull JWSAlgorithm jwsAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)$this$verifySignatureAndIssuer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)jwkSet, (String)"jwkSet");
        Intrinsics.checkNotNullParameter((Object)jwsAlgorithm, (String)"jwsAlgorithm");
        ConfigurableJWTProcessor jwtProcessor = (ConfigurableJWTProcessor)new DefaultJWTProcessor();
        JOSEObjectType[] jOSEObjectTypeArray = new JOSEObjectType[]{new JOSEObjectType("JWT")};
        jwtProcessor.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(jOSEObjectTypeArray));
        JWSKeySelector keySelector = (JWSKeySelector)new JWSVerificationKeySelector(jwsAlgorithm, (JWKSource)new ImmutableJWKSet(jwkSet));
        jwtProcessor.setJWSKeySelector(keySelector);
        Object[] objectArray = new String[]{"sub", "iat", "exp"};
        jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier(new JWTClaimsSet.Builder().issuer(issuer.toString()).build(), (Set)new HashSet(CollectionsKt.listOf((Object[])objectArray))));
        JWTClaimsSet jWTClaimsSet = jwtProcessor.process($this$verifySignatureAndIssuer, null);
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"jwtProcessor.process(this, null)");
        return jWTClaimsSet;
    }

    public static /* synthetic */ JWTClaimsSet verifySignatureAndIssuer$default(SignedJWT signedJWT, Issuer issuer, JWKSet jWKSet, JWSAlgorithm jWSAlgorithm, int n, Object object) {
        if ((n & 4) != 0) {
            JWSAlgorithm jWSAlgorithm2 = JWSAlgorithm.RS256;
            Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm2, (String)"RS256");
            jWSAlgorithm = jWSAlgorithm2;
        }
        return NimbusExtensionsKt.verifySignatureAndIssuer(signedJWT, issuer, jWKSet, jWSAlgorithm);
    }

    @NotNull
    public static final ClientAuthentication clientAuthentication(@NotNull HTTPRequest $this$clientAuthentication) {
        Intrinsics.checkNotNullParameter((Object)$this$clientAuthentication, (String)"<this>");
        ClientAuthentication clientAuthentication = ClientAuthentication.parse((HTTPRequest)$this$clientAuthentication);
        if (clientAuthentication == null) {
            throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "request must contain some form of ClientAuthentication.");
        }
        return clientAuthentication;
    }

    @NotNull
    public static final PrivateKeyJWT requirePrivateKeyJwt(@NotNull ClientAuthentication $this$requirePrivateKeyJwt, @NotNull String requiredAudience, long maxLifetimeSeconds) {
        PrivateKeyJWT it;
        PrivateKeyJWT privateKeyJWT;
        Intrinsics.checkNotNullParameter((Object)$this$requirePrivateKeyJwt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)requiredAudience, (String)"requiredAudience");
        PrivateKeyJWT privateKeyJWT2 = privateKeyJWT = $this$requirePrivateKeyJwt instanceof PrivateKeyJWT ? (PrivateKeyJWT)$this$requirePrivateKeyJwt : null;
        if (privateKeyJWT != null) {
            it = privateKeyJWT;
            boolean bl = false;
            SignedJWT signedJWT = it.getClientAssertion();
            Intrinsics.checkNotNullExpressionValue((Object)signedJWT, (String)"it.clientAssertion");
            if ((long)NimbusExtensionsKt.expiresIn(signedJWT) > maxLifetimeSeconds) {
                OAuth2ExceptionKt.invalidRequest("invalid client_assertion: client_assertion expiry is too long( should be < " + maxLifetimeSeconds + ")");
                throw new KotlinNothingValueException();
            }
            if (!it.getClientAssertion().getJWTClaimsSet().getAudience().contains(requiredAudience)) {
                OAuth2ExceptionKt.invalidRequest("invalid client_assertion: client_assertion must contain required audience '" + requiredAudience + "'");
                throw new KotlinNothingValueException();
            }
        } else {
            throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "request must contain a valid client_assertion.");
        }
        return it;
    }
}

