/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.token;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.mock.oauth2.OAuth2Exception;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\t\u0010\u001b\u001a\u00020\u0016H\u00d6\u0001J\u001c\u0010\u001c\u001a\u00020\u0014*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001c\u0010\u001d\u001a\u00020\u0014*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lno/nav/security/mock/oauth2/token/KeyGenerator;", "", "algorithm", "Lcom/nimbusds/jose/JWSAlgorithm;", "keyGenerator", "Ljava/security/KeyPairGenerator;", "(Lcom/nimbusds/jose/JWSAlgorithm;Ljava/security/KeyPairGenerator;)V", "getAlgorithm", "()Lcom/nimbusds/jose/JWSAlgorithm;", "getKeyGenerator", "()Ljava/security/KeyPairGenerator;", "setKeyGenerator", "(Ljava/security/KeyPairGenerator;)V", "component1", "component2", "copy", "equals", "", "other", "generateKey", "Lcom/nimbusds/jose/jwk/JWK;", "keyId", "", "hashCode", "", "toCurve", "Lcom/nimbusds/jose/jwk/Curve;", "toString", "generateECKey", "generateRSAKey", "Companion", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nKeyGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyGenerator.kt\nno/nav/security/mock/oauth2/token/KeyGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n819#2:102\n847#2,2:103\n*S KotlinDebug\n*F\n+ 1 KeyGenerator.kt\nno/nav/security/mock/oauth2/token/KeyGenerator\n*L\n62#1:102\n62#1:103,2\n*E\n"})
public final class KeyGenerator {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final JWSAlgorithm algorithm;
    @NotNull
    private KeyPairGenerator keyGenerator;
    @NotNull
    private static final List<JWSAlgorithm> rsaAlgorithmFamily;
    @NotNull
    private static final List<JWSAlgorithm> ecAlgorithmFamily;
    @NotNull
    private static final List<Companion.Algorithm> supportedAlgorithms;

    public KeyGenerator(@NotNull JWSAlgorithm algorithm, @NotNull KeyPairGenerator keyGenerator) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)keyGenerator, (String)"keyGenerator");
        this.algorithm = algorithm;
        this.keyGenerator = keyGenerator;
    }

    public /* synthetic */ KeyGenerator(JWSAlgorithm jWSAlgorithm, KeyPairGenerator keyPairGenerator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            JWSAlgorithm jWSAlgorithm2 = JWSAlgorithm.RS256;
            Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm2, (String)"RS256");
            jWSAlgorithm = jWSAlgorithm2;
        }
        if ((n & 2) != 0) {
            String string = jWSAlgorithm.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"algorithm.name");
            keyPairGenerator = Companion.generate(string);
        }
        this(jWSAlgorithm, keyPairGenerator);
    }

    @NotNull
    public final JWSAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final KeyPairGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public final void setKeyGenerator(@NotNull KeyPairGenerator keyPairGenerator) {
        Intrinsics.checkNotNullParameter((Object)keyPairGenerator, (String)"<set-?>");
        this.keyGenerator = keyPairGenerator;
    }

    @NotNull
    public final JWK generateKey(@NotNull String keyId) {
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        if (!Intrinsics.areEqual((Object)this.keyGenerator.getAlgorithm(), (Object)KeyType.RSA.getValue())) {
            return this.generateECKey(this.keyGenerator, keyId, this.algorithm);
        }
        return this.generateRSAKey(this.keyGenerator, keyId, this.algorithm);
    }

    private final JWK generateECKey(KeyPairGenerator $this$generateECKey, String keyId, JWSAlgorithm algorithm) {
        KeyPair it = $this$generateECKey.generateKeyPair();
        boolean bl = false;
        Curve curve = this.toCurve(algorithm);
        PublicKey publicKey = it.getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        ECKey.Builder builder = new ECKey.Builder(curve, (ECPublicKey)publicKey);
        PrivateKey privateKey = it.getPrivate();
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPrivateKey");
        ECKey eCKey = builder.privateKey((ECPrivateKey)privateKey).keyUse(KeyUse.SIGNATURE).keyID(keyId).algorithm((Algorithm)algorithm).build();
        Intrinsics.checkNotNullExpressionValue((Object)eCKey, (String)"generateKeyPair()\n      \u2026   .build()\n            }");
        return (JWK)eCKey;
    }

    private final Curve toCurve(JWSAlgorithm algorithm) {
        Set set = Curve.forJWSAlgorithm((JWSAlgorithm)algorithm);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"forJWSAlgorithm(algorithm)");
        Object object = CollectionsKt.single((Iterable)set);
        if (object == null) {
            boolean bl = false;
            throw new OAuth2Exception("Unsupported: " + algorithm);
        }
        return (Curve)object;
    }

    private final JWK generateRSAKey(KeyPairGenerator $this$generateRSAKey, String keyId, JWSAlgorithm algorithm) {
        KeyPair it = $this$generateRSAKey.generateKeyPair();
        boolean bl = false;
        PublicKey publicKey = it.getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        RSAKey.Builder builder = new RSAKey.Builder((RSAPublicKey)publicKey);
        PrivateKey privateKey = it.getPrivate();
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPrivateKey");
        RSAKey rSAKey = builder.privateKey((RSAPrivateKey)privateKey).keyUse(KeyUse.SIGNATURE).keyID(keyId).algorithm((Algorithm)algorithm).build();
        Intrinsics.checkNotNullExpressionValue((Object)rSAKey, (String)"generateKeyPair()\n      \u2026   .build()\n            }");
        return (JWK)rSAKey;
    }

    @NotNull
    public final JWSAlgorithm component1() {
        return this.algorithm;
    }

    @NotNull
    public final KeyPairGenerator component2() {
        return this.keyGenerator;
    }

    @NotNull
    public final KeyGenerator copy(@NotNull JWSAlgorithm algorithm, @NotNull KeyPairGenerator keyGenerator) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)keyGenerator, (String)"keyGenerator");
        return new KeyGenerator(algorithm, keyGenerator);
    }

    public static /* synthetic */ KeyGenerator copy$default(KeyGenerator keyGenerator, JWSAlgorithm jWSAlgorithm, KeyPairGenerator keyPairGenerator, int n, Object object) {
        if ((n & 1) != 0) {
            jWSAlgorithm = keyGenerator.algorithm;
        }
        if ((n & 2) != 0) {
            keyPairGenerator = keyGenerator.keyGenerator;
        }
        return keyGenerator.copy(jWSAlgorithm, keyPairGenerator);
    }

    @NotNull
    public String toString() {
        return "KeyGenerator(algorithm=" + this.algorithm + ", keyGenerator=" + this.keyGenerator + ")";
    }

    public int hashCode() {
        int result = this.algorithm.hashCode();
        result = result * 31 + this.keyGenerator.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KeyGenerator)) {
            return false;
        }
        KeyGenerator keyGenerator = (KeyGenerator)other;
        if (!Intrinsics.areEqual((Object)this.algorithm, (Object)keyGenerator.algorithm)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.keyGenerator, (Object)keyGenerator.keyGenerator);
    }

    public KeyGenerator() {
        this(null, null, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterNotTo$iv$iv;
        Companion = new Companion(null);
        JWSAlgorithm.Family family = JWSAlgorithm.Family.RSA;
        Intrinsics.checkNotNullExpressionValue((Object)family, (String)"RSA");
        rsaAlgorithmFamily = CollectionsKt.toList((Iterable)((Iterable)family));
        JWSAlgorithm.Family family2 = JWSAlgorithm.Family.EC;
        Intrinsics.checkNotNullExpressionValue((Object)family2, (String)"EC");
        Iterable $this$filterNot$iv = (Iterable)family2;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            JWSAlgorithm it = (JWSAlgorithm)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getName(), (Object)"ES256K") || Intrinsics.areEqual((Object)it.getName(), (Object)"ES512")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ecAlgorithmFamily = (List)var3_3;
        Object[] objectArray = new Companion.Algorithm[2];
        KeyType keyType = KeyType.RSA;
        Intrinsics.checkNotNullExpressionValue((Object)keyType, (String)"RSA");
        objectArray[0] = new Companion.Algorithm(rsaAlgorithmFamily, keyType);
        KeyType keyType2 = KeyType.EC;
        Intrinsics.checkNotNullExpressionValue((Object)keyType2, (String)"EC");
        objectArray[1] = new Companion.Algorithm(ecAlgorithmFamily, keyType2);
        supportedAlgorithms = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0005R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lno/nav/security/mock/oauth2/token/KeyGenerator$Companion;", "", "()V", "ecAlgorithmFamily", "", "Lcom/nimbusds/jose/JWSAlgorithm;", "kotlin.jvm.PlatformType", "getEcAlgorithmFamily", "()Ljava/util/List;", "rsaAlgorithmFamily", "getRsaAlgorithmFamily", "supportedAlgorithms", "Lno/nav/security/mock/oauth2/token/KeyGenerator$Companion$Algorithm;", "generate", "Ljava/security/KeyPairGenerator;", "algorithm", "", "isSupported", "", "Algorithm", "mock-oauth2-server"})
    @SourceDebugExtension(value={"SMAP\nKeyGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyGenerator.kt\nno/nav/security/mock/oauth2/token/KeyGenerator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1360#2:102\n1446#2,5:103\n1603#2,9:108\n1855#2:117\n1856#2:119\n1612#2:120\n1#3:118\n*S KotlinDebug\n*F\n+ 1 KeyGenerator.kt\nno/nav/security/mock/oauth2/token/KeyGenerator$Companion\n*L\n73#1:102\n73#1:103,5\n77#1:108,9\n77#1:117\n77#1:119\n77#1:120\n77#1:118\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<JWSAlgorithm> getRsaAlgorithmFamily() {
            return rsaAlgorithmFamily;
        }

        @NotNull
        public final List<JWSAlgorithm> getEcAlgorithmFamily() {
            return ecAlgorithmFamily;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isSupported(@NotNull JWSAlgorithm algorithm) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            Iterable $this$flatMap$iv = supportedAlgorithms;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Algorithm it = (Algorithm)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getFamily();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return ((List)destination$iv$iv).contains(algorithm);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final KeyPairGenerator generate(@NotNull String algorithm) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            JWSAlgorithm parsedAlgo = JWSAlgorithm.parse((String)algorithm);
            Iterable $this$mapNotNull$iv = supportedAlgorithms;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                KeyPairGenerator keyPairGenerator;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Algorithm it = (Algorithm)element$iv$iv;
                boolean bl2 = false;
                if (it.getFamily().contains(parsedAlgo)) {
                    KeyPairGenerator keyPairGenerator2;
                    void $this$generate_u24lambda_u242_u24lambda_u241;
                    KeyPairGenerator keyPairGenerator3;
                    Intrinsics.checkNotNullExpressionValue((Object)parsedAlgo, (String)"parsedAlgo");
                    KeyPairGenerator keyPairGenerator4 = keyPairGenerator3 = KeyPairGenerator.getInstance(it.getKeyType().getValue());
                    JWSAlgorithm jWSAlgorithm = parsedAlgo;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getKeyType().getValue(), (Object)KeyType.RSA.getValue())) {
                        $this$generate_u24lambda_u242_u24lambda_u241.initialize(Integer.parseInt(((Object)parsedAlgo.getName().subSequence(2, 5)).toString()));
                    } else {
                        $this$generate_u24lambda_u242_u24lambda_u241.initialize(2048);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)keyPairGenerator3, (String)"getInstance(it.keyType.v\u2026                        }");
                    JWSAlgorithm jWSAlgorithm2 = jWSAlgorithm;
                    keyPairGenerator = new KeyGenerator(jWSAlgorithm2, keyPairGenerator2).getKeyGenerator();
                } else {
                    keyPairGenerator = null;
                }
                if (keyPairGenerator == null) continue;
                KeyPairGenerator it$iv$iv = keyPairGenerator;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            KeyPairGenerator keyPairGenerator = (KeyPairGenerator)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
            if (keyPairGenerator == null) {
                throw new OAuth2Exception("Unsupported algorithm: " + algorithm);
            }
            return keyPairGenerator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lno/nav/security/mock/oauth2/token/KeyGenerator$Companion$Algorithm;", "", "family", "", "Lcom/nimbusds/jose/JWSAlgorithm;", "keyType", "Lcom/nimbusds/jose/jwk/KeyType;", "(Ljava/util/List;Lcom/nimbusds/jose/jwk/KeyType;)V", "getFamily", "()Ljava/util/List;", "getKeyType", "()Lcom/nimbusds/jose/jwk/KeyType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "mock-oauth2-server"})
        public static final class Algorithm {
            @NotNull
            private final List<JWSAlgorithm> family;
            @NotNull
            private final KeyType keyType;

            public Algorithm(@NotNull List<JWSAlgorithm> family, @NotNull KeyType keyType) {
                Intrinsics.checkNotNullParameter(family, (String)"family");
                Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
                this.family = family;
                this.keyType = keyType;
            }

            @NotNull
            public final List<JWSAlgorithm> getFamily() {
                return this.family;
            }

            @NotNull
            public final KeyType getKeyType() {
                return this.keyType;
            }

            @NotNull
            public final List<JWSAlgorithm> component1() {
                return this.family;
            }

            @NotNull
            public final KeyType component2() {
                return this.keyType;
            }

            @NotNull
            public final Algorithm copy(@NotNull List<JWSAlgorithm> family, @NotNull KeyType keyType) {
                Intrinsics.checkNotNullParameter(family, (String)"family");
                Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
                return new Algorithm(family, keyType);
            }

            public static /* synthetic */ Algorithm copy$default(Algorithm algorithm, List list, KeyType keyType, int n, Object object) {
                if ((n & 1) != 0) {
                    list = algorithm.family;
                }
                if ((n & 2) != 0) {
                    keyType = algorithm.keyType;
                }
                return algorithm.copy(list, keyType);
            }

            @NotNull
            public String toString() {
                return "Algorithm(family=" + this.family + ", keyType=" + this.keyType + ")";
            }

            public int hashCode() {
                int result = ((Object)this.family).hashCode();
                result = result * 31 + this.keyType.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Algorithm)) {
                    return false;
                }
                Algorithm algorithm = (Algorithm)other;
                if (!Intrinsics.areEqual(this.family, algorithm.family)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.keyType, (Object)algorithm.keyType);
            }
        }
    }
}

