/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.mock.oauth2.http.MockWebServerWrapper;
import no.nav.security.mock.oauth2.http.NettyWrapper;
import no.nav.security.mock.oauth2.http.OAuth2HttpServer;
import no.nav.security.mock.oauth2.http.Ssl;
import no.nav.security.mock.oauth2.http.SslKeystore;
import no.nav.security.mock.oauth2.token.KeyProvider;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenProvider;
import no.nav.security.mock.oauth2.token.RequestMappingTokenCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0003#$%BA\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0003\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0003\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\fH\u00c6\u0003JC\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0003\u0010\u0006\u001a\u00020\u00072\u000e\b\u0003\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0003\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config;", "", "interactiveLogin", "", "loginPagePath", "", "tokenProvider", "Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "tokenCallbacks", "", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "httpServer", "Lno/nav/security/mock/oauth2/http/OAuth2HttpServer;", "(ZLjava/lang/String;Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;Ljava/util/Set;Lno/nav/security/mock/oauth2/http/OAuth2HttpServer;)V", "getHttpServer", "()Lno/nav/security/mock/oauth2/http/OAuth2HttpServer;", "getInteractiveLogin", "()Z", "getLoginPagePath", "()Ljava/lang/String;", "getTokenCallbacks", "()Ljava/util/Set;", "getTokenProvider", "()Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "OAuth2HttpServerDeserializer", "OAuth2TokenProviderDeserializer", "mock-oauth2-server"})
public final class OAuth2Config {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean interactiveLogin;
    @Nullable
    private final String loginPagePath;
    @NotNull
    private final OAuth2TokenProvider tokenProvider;
    @NotNull
    private final Set<OAuth2TokenCallback> tokenCallbacks;
    @NotNull
    private final OAuth2HttpServer httpServer;

    @JvmOverloads
    public OAuth2Config(boolean interactiveLogin, @Nullable String loginPagePath, @JsonDeserialize(using=OAuth2TokenProviderDeserializer.class) @NotNull OAuth2TokenProvider tokenProvider, @JsonDeserialize(contentAs=RequestMappingTokenCallback.class) @NotNull Set<? extends OAuth2TokenCallback> tokenCallbacks, @JsonDeserialize(using=OAuth2HttpServerDeserializer.class) @NotNull OAuth2HttpServer httpServer) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        Intrinsics.checkNotNullParameter(tokenCallbacks, (String)"tokenCallbacks");
        Intrinsics.checkNotNullParameter((Object)httpServer, (String)"httpServer");
        this.interactiveLogin = interactiveLogin;
        this.loginPagePath = loginPagePath;
        this.tokenProvider = tokenProvider;
        this.tokenCallbacks = tokenCallbacks;
        this.httpServer = httpServer;
    }

    public /* synthetic */ OAuth2Config(boolean bl, String string, OAuth2TokenProvider oAuth2TokenProvider, Set set, OAuth2HttpServer oAuth2HttpServer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            oAuth2TokenProvider = new OAuth2TokenProvider(null, 1, null);
        }
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x10) != 0) {
            oAuth2HttpServer = new MockWebServerWrapper(null, 1, null);
        }
        this(bl, string, oAuth2TokenProvider, set, oAuth2HttpServer);
    }

    public final boolean getInteractiveLogin() {
        return this.interactiveLogin;
    }

    @Nullable
    public final String getLoginPagePath() {
        return this.loginPagePath;
    }

    @NotNull
    public final OAuth2TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    @NotNull
    public final Set<OAuth2TokenCallback> getTokenCallbacks() {
        return this.tokenCallbacks;
    }

    @NotNull
    public final OAuth2HttpServer getHttpServer() {
        return this.httpServer;
    }

    public final boolean component1() {
        return this.interactiveLogin;
    }

    @Nullable
    public final String component2() {
        return this.loginPagePath;
    }

    @NotNull
    public final OAuth2TokenProvider component3() {
        return this.tokenProvider;
    }

    @NotNull
    public final Set<OAuth2TokenCallback> component4() {
        return this.tokenCallbacks;
    }

    @NotNull
    public final OAuth2HttpServer component5() {
        return this.httpServer;
    }

    @NotNull
    public final OAuth2Config copy(boolean interactiveLogin, @Nullable String loginPagePath, @JsonDeserialize(using=OAuth2TokenProviderDeserializer.class) @NotNull OAuth2TokenProvider tokenProvider, @JsonDeserialize(contentAs=RequestMappingTokenCallback.class) @NotNull Set<? extends OAuth2TokenCallback> tokenCallbacks, @JsonDeserialize(using=OAuth2HttpServerDeserializer.class) @NotNull OAuth2HttpServer httpServer) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        Intrinsics.checkNotNullParameter(tokenCallbacks, (String)"tokenCallbacks");
        Intrinsics.checkNotNullParameter((Object)httpServer, (String)"httpServer");
        return new OAuth2Config(interactiveLogin, loginPagePath, tokenProvider, tokenCallbacks, httpServer);
    }

    public static /* synthetic */ OAuth2Config copy$default(OAuth2Config oAuth2Config, boolean bl, String string, OAuth2TokenProvider oAuth2TokenProvider, Set set, OAuth2HttpServer oAuth2HttpServer, int n, Object object) {
        if ((n & 1) != 0) {
            bl = oAuth2Config.interactiveLogin;
        }
        if ((n & 2) != 0) {
            string = oAuth2Config.loginPagePath;
        }
        if ((n & 4) != 0) {
            oAuth2TokenProvider = oAuth2Config.tokenProvider;
        }
        if ((n & 8) != 0) {
            set = oAuth2Config.tokenCallbacks;
        }
        if ((n & 0x10) != 0) {
            oAuth2HttpServer = oAuth2Config.httpServer;
        }
        return oAuth2Config.copy(bl, string, oAuth2TokenProvider, set, oAuth2HttpServer);
    }

    @NotNull
    public String toString() {
        return "OAuth2Config(interactiveLogin=" + this.interactiveLogin + ", loginPagePath=" + this.loginPagePath + ", tokenProvider=" + this.tokenProvider + ", tokenCallbacks=" + this.tokenCallbacks + ", httpServer=" + this.httpServer + ")";
    }

    public int hashCode() {
        int n = this.interactiveLogin ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result = n;
        result = result * 31 + (this.loginPagePath == null ? 0 : this.loginPagePath.hashCode());
        result = result * 31 + this.tokenProvider.hashCode();
        result = result * 31 + ((Object)this.tokenCallbacks).hashCode();
        result = result * 31 + this.httpServer.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OAuth2Config)) {
            return false;
        }
        OAuth2Config oAuth2Config = (OAuth2Config)other;
        if (this.interactiveLogin != oAuth2Config.interactiveLogin) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.loginPagePath, (Object)oAuth2Config.loginPagePath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tokenProvider, (Object)oAuth2Config.tokenProvider)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tokenCallbacks, oAuth2Config.tokenCallbacks)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.httpServer, (Object)oAuth2Config.httpServer);
    }

    @JvmOverloads
    public OAuth2Config(boolean interactiveLogin, @Nullable String loginPagePath, @JsonDeserialize(using=OAuth2TokenProviderDeserializer.class) @NotNull OAuth2TokenProvider tokenProvider, @JsonDeserialize(contentAs=RequestMappingTokenCallback.class) @NotNull Set<? extends OAuth2TokenCallback> tokenCallbacks) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        Intrinsics.checkNotNullParameter(tokenCallbacks, (String)"tokenCallbacks");
        this(interactiveLogin, loginPagePath, tokenProvider, tokenCallbacks, null, 16, null);
    }

    @JvmOverloads
    public OAuth2Config(boolean interactiveLogin, @Nullable String loginPagePath, @JsonDeserialize(using=OAuth2TokenProviderDeserializer.class) @NotNull OAuth2TokenProvider tokenProvider) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        this(interactiveLogin, loginPagePath, tokenProvider, null, null, 24, null);
    }

    @JvmOverloads
    public OAuth2Config(boolean interactiveLogin, @Nullable String loginPagePath) {
        this(interactiveLogin, loginPagePath, null, null, null, 28, null);
    }

    @JvmOverloads
    public OAuth2Config(boolean interactiveLogin) {
        this(interactiveLogin, null, null, null, null, 30, null);
    }

    @JvmOverloads
    public OAuth2Config() {
        this(false, null, null, null, null, 31, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$Companion;", "", "()V", "fromJson", "Lno/nav/security/mock/oauth2/OAuth2Config;", "json", "", "mock-oauth2-server"})
    @SourceDebugExtension(value={"SMAP\nOAuth2Config.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2Config.kt\nno/nav/security/mock/oauth2/OAuth2Config$Companion\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,109:1\n50#2:110\n43#2:111\n*S KotlinDebug\n*F\n+ 1 OAuth2Config.kt\nno/nav/security/mock/oauth2/OAuth2Config$Companion\n*L\n105#1:110\n105#1:111\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OAuth2Config fromJson(@NotNull String json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            ObjectMapper $this$readValue$iv = ExtensionsKt.jacksonObjectMapper();
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            return (OAuth2Config)$this$readValue$iv.readValue(json, (TypeReference)new TypeReference<OAuth2Config>(){});
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\t\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpServer;", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "ServerConfig", "ServerType", "SslConfig", "mock-oauth2-server"})
    public static final class OAuth2HttpServerDeserializer
    extends JsonDeserializer<OAuth2HttpServer> {
        @NotNull
        public OAuth2HttpServer deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            ServerConfig serverConfig;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            TreeNode treeNode = p.readValueAsTree();
            Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"readValueAsTree(...)");
            JsonNode node = (JsonNode)treeNode;
            if (node.isObject()) {
                Object object = p.getCodec().treeToValue((TreeNode)node, ServerConfig.class);
                Intrinsics.checkNotNull((Object)object);
                serverConfig = (ServerConfig)object;
            } else {
                String string = node.textValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textValue(...)");
                serverConfig = new ServerConfig(ServerType.valueOf(string), null, 2, null);
            }
            ServerConfig serverConfig2 = serverConfig;
            SslConfig sslConfig = serverConfig2.getSsl();
            Ssl ssl = sslConfig != null ? sslConfig.ssl() : null;
            return switch (WhenMappings.$EnumSwitchMapping$0[serverConfig2.getType().ordinal()]) {
                case 1 -> new NettyWrapper(ssl);
                case 2 -> new MockWebServerWrapper(ssl);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$ServerConfig;", "", "type", "Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$ServerType;", "ssl", "Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$SslConfig;", "(Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$ServerType;Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$SslConfig;)V", "getSsl", "()Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$SslConfig;", "getType", "()Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$ServerType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "mock-oauth2-server"})
        public static final class ServerConfig {
            @NotNull
            private final ServerType type;
            @Nullable
            private final SslConfig ssl;

            public ServerConfig(@NotNull ServerType type, @Nullable SslConfig ssl) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                this.type = type;
                this.ssl = ssl;
            }

            public /* synthetic */ ServerConfig(ServerType serverType, SslConfig sslConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    sslConfig = null;
                }
                this(serverType, sslConfig);
            }

            @NotNull
            public final ServerType getType() {
                return this.type;
            }

            @Nullable
            public final SslConfig getSsl() {
                return this.ssl;
            }

            @NotNull
            public final ServerType component1() {
                return this.type;
            }

            @Nullable
            public final SslConfig component2() {
                return this.ssl;
            }

            @NotNull
            public final ServerConfig copy(@NotNull ServerType type, @Nullable SslConfig ssl) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return new ServerConfig(type, ssl);
            }

            public static /* synthetic */ ServerConfig copy$default(ServerConfig serverConfig, ServerType serverType, SslConfig sslConfig, int n, Object object) {
                if ((n & 1) != 0) {
                    serverType = serverConfig.type;
                }
                if ((n & 2) != 0) {
                    sslConfig = serverConfig.ssl;
                }
                return serverConfig.copy(serverType, sslConfig);
            }

            @NotNull
            public String toString() {
                return "ServerConfig(type=" + this.type + ", ssl=" + this.ssl + ")";
            }

            public int hashCode() {
                int result = this.type.hashCode();
                result = result * 31 + (this.ssl == null ? 0 : this.ssl.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ServerConfig)) {
                    return false;
                }
                ServerConfig serverConfig = (ServerConfig)other;
                if (this.type != serverConfig.type) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.ssl, (Object)serverConfig.ssl);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$ServerType;", "", "(Ljava/lang/String;I)V", "MockWebServerWrapper", "NettyWrapper", "mock-oauth2-server"})
        public static final class ServerType
        extends Enum<ServerType> {
            public static final /* enum */ ServerType MockWebServerWrapper = new ServerType();
            public static final /* enum */ ServerType NettyWrapper = new ServerType();
            private static final /* synthetic */ ServerType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static ServerType[] values() {
                return (ServerType[])$VALUES.clone();
            }

            public static ServerType valueOf(String value) {
                return Enum.valueOf(ServerType.class, value);
            }

            @NotNull
            public static EnumEntries<ServerType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = serverTypeArray = new ServerType[]{ServerType.MockWebServerWrapper, ServerType.NettyWrapper};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$SslConfig;", "", "keyPassword", "", "keystoreFile", "Ljava/io/File;", "keystoreType", "Lno/nav/security/mock/oauth2/http/SslKeystore$KeyStoreType;", "keystorePassword", "(Ljava/lang/String;Ljava/io/File;Lno/nav/security/mock/oauth2/http/SslKeystore$KeyStoreType;Ljava/lang/String;)V", "getKeyPassword", "()Ljava/lang/String;", "getKeystoreFile", "()Ljava/io/File;", "getKeystorePassword", "getKeystoreType", "()Lno/nav/security/mock/oauth2/http/SslKeystore$KeyStoreType;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "ssl", "Lno/nav/security/mock/oauth2/http/Ssl;", "sslKeyStore", "Lno/nav/security/mock/oauth2/http/SslKeystore;", "toString", "mock-oauth2-server"})
        public static final class SslConfig {
            @NotNull
            private final String keyPassword;
            @Nullable
            private final File keystoreFile;
            @NotNull
            private final SslKeystore.KeyStoreType keystoreType;
            @NotNull
            private final String keystorePassword;

            public SslConfig(@NotNull String keyPassword, @Nullable File keystoreFile, @NotNull SslKeystore.KeyStoreType keystoreType, @NotNull String keystorePassword) {
                Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
                Intrinsics.checkNotNullParameter((Object)((Object)keystoreType), (String)"keystoreType");
                Intrinsics.checkNotNullParameter((Object)keystorePassword, (String)"keystorePassword");
                this.keyPassword = keyPassword;
                this.keystoreFile = keystoreFile;
                this.keystoreType = keystoreType;
                this.keystorePassword = keystorePassword;
            }

            public /* synthetic */ SslConfig(String string, File file, SslKeystore.KeyStoreType keyStoreType, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = "";
                }
                if ((n & 2) != 0) {
                    file = null;
                }
                if ((n & 4) != 0) {
                    keyStoreType = SslKeystore.KeyStoreType.PKCS12;
                }
                if ((n & 8) != 0) {
                    string2 = "";
                }
                this(string, file, keyStoreType, string2);
            }

            @NotNull
            public final String getKeyPassword() {
                return this.keyPassword;
            }

            @Nullable
            public final File getKeystoreFile() {
                return this.keystoreFile;
            }

            @NotNull
            public final SslKeystore.KeyStoreType getKeystoreType() {
                return this.keystoreType;
            }

            @NotNull
            public final String getKeystorePassword() {
                return this.keystorePassword;
            }

            @NotNull
            public final Ssl ssl() {
                return new Ssl(this.sslKeyStore());
            }

            private final SslKeystore sslKeyStore() {
                return this.keystoreFile == null ? new SslKeystore(null, null, 3, null) : new SslKeystore(this.keyPassword, this.keystoreFile, this.keystoreType, this.keystorePassword);
            }

            @NotNull
            public final String component1() {
                return this.keyPassword;
            }

            @Nullable
            public final File component2() {
                return this.keystoreFile;
            }

            @NotNull
            public final SslKeystore.KeyStoreType component3() {
                return this.keystoreType;
            }

            @NotNull
            public final String component4() {
                return this.keystorePassword;
            }

            @NotNull
            public final SslConfig copy(@NotNull String keyPassword, @Nullable File keystoreFile, @NotNull SslKeystore.KeyStoreType keystoreType, @NotNull String keystorePassword) {
                Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
                Intrinsics.checkNotNullParameter((Object)((Object)keystoreType), (String)"keystoreType");
                Intrinsics.checkNotNullParameter((Object)keystorePassword, (String)"keystorePassword");
                return new SslConfig(keyPassword, keystoreFile, keystoreType, keystorePassword);
            }

            public static /* synthetic */ SslConfig copy$default(SslConfig sslConfig, String string, File file, SslKeystore.KeyStoreType keyStoreType, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = sslConfig.keyPassword;
                }
                if ((n & 2) != 0) {
                    file = sslConfig.keystoreFile;
                }
                if ((n & 4) != 0) {
                    keyStoreType = sslConfig.keystoreType;
                }
                if ((n & 8) != 0) {
                    string2 = sslConfig.keystorePassword;
                }
                return sslConfig.copy(string, file, keyStoreType, string2);
            }

            @NotNull
            public String toString() {
                return "SslConfig(keyPassword=" + this.keyPassword + ", keystoreFile=" + this.keystoreFile + ", keystoreType=" + this.keystoreType + ", keystorePassword=" + this.keystorePassword + ")";
            }

            public int hashCode() {
                int result = this.keyPassword.hashCode();
                result = result * 31 + (this.keystoreFile == null ? 0 : this.keystoreFile.hashCode());
                result = result * 31 + this.keystoreType.hashCode();
                result = result * 31 + this.keystorePassword.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SslConfig)) {
                    return false;
                }
                SslConfig sslConfig = (SslConfig)other;
                if (!Intrinsics.areEqual((Object)this.keyPassword, (Object)sslConfig.keyPassword)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.keystoreFile, (Object)sslConfig.keystoreFile)) {
                    return false;
                }
                if (this.keystoreType != sslConfig.keystoreType) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.keystorePassword, (Object)sslConfig.keystorePassword);
            }

            public SslConfig() {
                this(null, null, null, null, 15, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ServerType.values().length];
                try {
                    nArray[ServerType.NettyWrapper.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ServerType.MockWebServerWrapper.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u000b"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2TokenProviderDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "KeyProviderConfig", "ProviderConfig", "mock-oauth2-server"})
    public static final class OAuth2TokenProviderDeserializer
    extends JsonDeserializer<OAuth2TokenProvider> {
        @NotNull
        public OAuth2TokenProvider deserialize(@NotNull JsonParser p, @Nullable DeserializationContext ctxt) {
            Object object;
            Object jwks2;
            ProviderConfig config;
            block6: {
                Object object2;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    TreeNode treeNode = p.readValueAsTree();
                    Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"readValueAsTree(...)");
                    JsonNode node = (JsonNode)treeNode;
                    if (!node.isObject()) {
                        return new OAuth2TokenProvider(null, 1, null);
                    }
                    Object object3 = p.getCodec().treeToValue((TreeNode)node, ProviderConfig.class);
                    Intrinsics.checkNotNull((Object)object3);
                    config = (ProviderConfig)object3;
                    object2 = config.getKeyProvider();
                    if (object2 == null || (object2 = ((KeyProviderConfig)object2).getInitialKeys()) == null) break block5;
                    Object it = object2;
                    boolean bl = false;
                    List list = CollectionsKt.listOf((Object)JWK.parse((String)it));
                    object2 = list;
                    if (list != null) break block6;
                }
                object2 = jwks2 = CollectionsKt.emptyList();
            }
            if ((object = config.getKeyProvider()) == null || (object = ((KeyProviderConfig)object).getAlgorithm()) == null) {
                object = JWSAlgorithm.RS256.getName();
            }
            Object object4 = object;
            Intrinsics.checkNotNull((Object)object4);
            return new OAuth2TokenProvider(new KeyProvider((List<? extends JWK>)jwks2, (String)object4));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2TokenProviderDeserializer$KeyProviderConfig;", "", "initialKeys", "", "algorithm", "(Ljava/lang/String;Ljava/lang/String;)V", "getAlgorithm", "()Ljava/lang/String;", "getInitialKeys", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "mock-oauth2-server"})
        public static final class KeyProviderConfig {
            @Nullable
            private final String initialKeys;
            @NotNull
            private final String algorithm;

            public KeyProviderConfig(@Nullable String initialKeys, @NotNull String algorithm) {
                Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
                this.initialKeys = initialKeys;
                this.algorithm = algorithm;
            }

            @Nullable
            public final String getInitialKeys() {
                return this.initialKeys;
            }

            @NotNull
            public final String getAlgorithm() {
                return this.algorithm;
            }

            @Nullable
            public final String component1() {
                return this.initialKeys;
            }

            @NotNull
            public final String component2() {
                return this.algorithm;
            }

            @NotNull
            public final KeyProviderConfig copy(@Nullable String initialKeys, @NotNull String algorithm) {
                Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
                return new KeyProviderConfig(initialKeys, algorithm);
            }

            public static /* synthetic */ KeyProviderConfig copy$default(KeyProviderConfig keyProviderConfig, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = keyProviderConfig.initialKeys;
                }
                if ((n & 2) != 0) {
                    string2 = keyProviderConfig.algorithm;
                }
                return keyProviderConfig.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "KeyProviderConfig(initialKeys=" + this.initialKeys + ", algorithm=" + this.algorithm + ")";
            }

            public int hashCode() {
                int result = this.initialKeys == null ? 0 : this.initialKeys.hashCode();
                result = result * 31 + this.algorithm.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof KeyProviderConfig)) {
                    return false;
                }
                KeyProviderConfig keyProviderConfig = (KeyProviderConfig)other;
                if (!Intrinsics.areEqual((Object)this.initialKeys, (Object)keyProviderConfig.initialKeys)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.algorithm, (Object)keyProviderConfig.algorithm);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2TokenProviderDeserializer$ProviderConfig;", "", "keyProvider", "Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2TokenProviderDeserializer$KeyProviderConfig;", "(Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2TokenProviderDeserializer$KeyProviderConfig;)V", "getKeyProvider", "()Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2TokenProviderDeserializer$KeyProviderConfig;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "mock-oauth2-server"})
        public static final class ProviderConfig {
            @Nullable
            private final KeyProviderConfig keyProvider;

            public ProviderConfig(@Nullable KeyProviderConfig keyProvider) {
                this.keyProvider = keyProvider;
            }

            @Nullable
            public final KeyProviderConfig getKeyProvider() {
                return this.keyProvider;
            }

            @Nullable
            public final KeyProviderConfig component1() {
                return this.keyProvider;
            }

            @NotNull
            public final ProviderConfig copy(@Nullable KeyProviderConfig keyProvider) {
                return new ProviderConfig(keyProvider);
            }

            public static /* synthetic */ ProviderConfig copy$default(ProviderConfig providerConfig, KeyProviderConfig keyProviderConfig, int n, Object object) {
                if ((n & 1) != 0) {
                    keyProviderConfig = providerConfig.keyProvider;
                }
                return providerConfig.copy(keyProviderConfig);
            }

            @NotNull
            public String toString() {
                return "ProviderConfig(keyProvider=" + this.keyProvider + ")";
            }

            public int hashCode() {
                return this.keyProvider == null ? 0 : this.keyProvider.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ProviderConfig)) {
                    return false;
                }
                ProviderConfig providerConfig = (ProviderConfig)other;
                return Intrinsics.areEqual((Object)this.keyProvider, (Object)providerConfig.keyProvider);
            }
        }
    }
}

