/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.token;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.oauth2.sdk.TokenRequest;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.RequestMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J-\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J2\u0010#\u001a\u0004\u0018\u0001H$\"\u0006\b\u0000\u0010$\u0018\u0001*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0003H\u0082\b\u00a2\u0006\u0002\u0010&J&\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u0011*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010(\u001a\n )*\u0004\u0018\u00010\u00030\u0003*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lno/nav/security/mock/oauth2/token/RequestMappingTokenCallback;", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "issuerId", "", "requestMappings", "", "Lno/nav/security/mock/oauth2/token/RequestMapping;", "tokenExpiry", "", "(Ljava/lang/String;Ljava/util/Set;J)V", "getIssuerId", "()Ljava/lang/String;", "getRequestMappings", "()Ljava/util/Set;", "getTokenExpiry", "()J", "addClaims", "", "", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "audience", "", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "subject", "toString", "typeHeader", "getClaimOrNull", "T", "key", "(Ljava/util/Set;Lcom/nimbusds/oauth2/sdk/TokenRequest;Ljava/lang/String;)Ljava/lang/Object;", "getClaims", "getTypeHeader", "kotlin.jvm.PlatformType", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nOAuth2TokenCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2TokenCallback.kt\nno/nav/security/mock/oauth2/token/RequestMappingTokenCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n94#1:112\n94#1:113\n288#2,2:114\n288#2,2:116\n*S KotlinDebug\n*F\n+ 1 OAuth2TokenCallback.kt\nno/nav/security/mock/oauth2/token/RequestMappingTokenCallback\n*L\n77#1:112\n83#1:113\n91#1:114,2\n97#1:116,2\n*E\n"})
public final class RequestMappingTokenCallback
implements OAuth2TokenCallback {
    @NotNull
    private final String issuerId;
    @NotNull
    private final Set<RequestMapping> requestMappings;
    private final long tokenExpiry;

    public RequestMappingTokenCallback(@NotNull String issuerId, @NotNull Set<RequestMapping> requestMappings, long tokenExpiry) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter(requestMappings, (String)"requestMappings");
        this.issuerId = issuerId;
        this.requestMappings = requestMappings;
        this.tokenExpiry = tokenExpiry;
    }

    public /* synthetic */ RequestMappingTokenCallback(String string, Set set, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = Duration.ofHours(1L).toSeconds();
        }
        this(string, set, l);
    }

    @NotNull
    public final String getIssuerId() {
        return this.issuerId;
    }

    @NotNull
    public final Set<RequestMapping> getRequestMappings() {
        return this.requestMappings;
    }

    public final long getTokenExpiry() {
        return this.tokenExpiry;
    }

    @Override
    @NotNull
    public String issuerId() {
        return this.issuerId;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String subject(@NotNull TokenRequest tokenRequest) {
        void $this$getClaimOrNull$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        RequestMappingTokenCallback requestMappingTokenCallback = this;
        Set<RequestMapping> set = this.requestMappings;
        String key$iv = "sub";
        boolean $i$f$getClaimOrNull = false;
        Object object = super.getClaims((Set<RequestMapping>)$this$getClaimOrNull$iv, tokenRequest).get(key$iv);
        if (!(object instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    @Override
    @NotNull
    public String typeHeader(@NotNull TokenRequest tokenRequest) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        String string = this.getTypeHeader(this.requestMappings, tokenRequest);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeHeader(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> audience(@NotNull TokenRequest tokenRequest) {
        List list;
        void $this$getClaimOrNull$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        RequestMappingTokenCallback requestMappingTokenCallback = this;
        Set<RequestMapping> set = this.requestMappings;
        String key$iv = "aud";
        boolean $i$f$getClaimOrNull = false;
        Object object = super.getClaims((Set<RequestMapping>)$this$getClaimOrNull$iv, tokenRequest).get(key$iv);
        if (!(object instanceof List)) {
            object = null;
        }
        if ((list = (List)object) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public Map<String, Object> addClaims(@NotNull TokenRequest tokenRequest) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        return this.getClaims(this.requestMappings, tokenRequest);
    }

    @Override
    public long tokenExpiry() {
        return this.tokenExpiry;
    }

    private final Map<String, Object> getClaims(Set<RequestMapping> $this$getClaims, TokenRequest tokenRequest) {
        Object object;
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = $this$getClaims;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RequestMapping it = (RequestMapping)element$iv;
                boolean bl = false;
                if (!it.isMatch(tokenRequest)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (RequestMapping)v0) == null || (object = ((RequestMapping)object).getClaims()) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    private final /* synthetic */ <T> T getClaimOrNull(Set<RequestMapping> $this$getClaimOrNull, TokenRequest tokenRequest, String key) {
        boolean $i$f$getClaimOrNull = false;
        Object object = this.getClaims($this$getClaimOrNull, tokenRequest).get(key);
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)object;
    }

    private final String getTypeHeader(Set<RequestMapping> $this$getTypeHeader, TokenRequest tokenRequest) {
        Object object;
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = $this$getTypeHeader;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RequestMapping it = (RequestMapping)element$iv;
                boolean bl = false;
                if (!it.isMatch(tokenRequest)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (RequestMapping)v0) == null || (object = ((RequestMapping)object).getTypeHeader()) == null) {
            object = JOSEObjectType.JWT.getType();
        }
        return object;
    }

    @NotNull
    public final String component1() {
        return this.issuerId;
    }

    @NotNull
    public final Set<RequestMapping> component2() {
        return this.requestMappings;
    }

    public final long component3() {
        return this.tokenExpiry;
    }

    @NotNull
    public final RequestMappingTokenCallback copy(@NotNull String issuerId, @NotNull Set<RequestMapping> requestMappings, long tokenExpiry) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter(requestMappings, (String)"requestMappings");
        return new RequestMappingTokenCallback(issuerId, requestMappings, tokenExpiry);
    }

    public static /* synthetic */ RequestMappingTokenCallback copy$default(RequestMappingTokenCallback requestMappingTokenCallback, String string, Set set, long l, int n, Object object) {
        if ((n & 1) != 0) {
            string = requestMappingTokenCallback.issuerId;
        }
        if ((n & 2) != 0) {
            set = requestMappingTokenCallback.requestMappings;
        }
        if ((n & 4) != 0) {
            l = requestMappingTokenCallback.tokenExpiry;
        }
        return requestMappingTokenCallback.copy(string, set, l);
    }

    @NotNull
    public String toString() {
        return "RequestMappingTokenCallback(issuerId=" + this.issuerId + ", requestMappings=" + this.requestMappings + ", tokenExpiry=" + this.tokenExpiry + ")";
    }

    public int hashCode() {
        int result = this.issuerId.hashCode();
        result = result * 31 + ((Object)this.requestMappings).hashCode();
        result = result * 31 + Long.hashCode(this.tokenExpiry);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RequestMappingTokenCallback)) {
            return false;
        }
        RequestMappingTokenCallback requestMappingTokenCallback = (RequestMappingTokenCallback)other;
        if (!Intrinsics.areEqual((Object)this.issuerId, (Object)requestMappingTokenCallback.issuerId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.requestMappings, requestMappingTokenCallback.requestMappings)) {
            return false;
        }
        return this.tokenExpiry == requestMappingTokenCallback.tokenExpiry;
    }
}

