/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.debugger;

import com.nimbusds.oauth2.sdk.OAuth2Error;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.debugger.ClientAuthentication;
import no.nav.security.mock.oauth2.debugger.ClientKt;
import no.nav.security.mock.oauth2.debugger.SessionManager;
import no.nav.security.mock.oauth2.debugger.TokenRequest;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import no.nav.security.mock.oauth2.http.Route;
import no.nav.security.mock.oauth2.http.Ssl;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005j\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a \u0010\u000e\u001a\u00020\r*\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"log", "Lmu/KLogger;", "client", "Lokhttp3/OkHttpClient;", "handle", "Lkotlin/Function2;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "Lno/nav/security/mock/oauth2/http/ExceptionHandler;", "sessionManager", "Lno/nav/security/mock/oauth2/debugger/SessionManager;", "debuggerForm", "Lno/nav/security/mock/oauth2/http/Route$Builder;", "debuggerCallback", "ssl", "Lno/nav/security/mock/oauth2/http/Ssl;", "mock-oauth2-server"})
public final class DebuggerRequestHandlerKt {
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(DebuggerRequestHandlerKt::log$lambda$0);
    @NotNull
    private static final OkHttpClient client = new OkHttpClient().newBuilder().build();

    private static final Function2<OAuth2HttpRequest, Throwable, OAuth2HttpResponse> handle(SessionManager sessionManager) {
        return (arg_0, arg_1) -> DebuggerRequestHandlerKt.handle$lambda$2(sessionManager, arg_0, arg_1);
    }

    private static final Route.Builder debuggerForm(Route.Builder $this$debuggerForm, SessionManager sessionManager) {
        Route.Builder builder;
        Route.Builder $this$debuggerForm_u24lambda_u245 = builder = $this$debuggerForm;
        boolean bl = false;
        String[] stringArray = new String[]{"/debugger"};
        $this$debuggerForm_u24lambda_u245.get(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)DebuggerRequestHandlerKt::debuggerForm$lambda$5$lambda$3));
        $this$debuggerForm_u24lambda_u245.post("/debugger", (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)arg_0 -> DebuggerRequestHandlerKt.debuggerForm$lambda$5$lambda$4(sessionManager, arg_0)));
        return builder;
    }

    private static final Route.Builder debuggerCallback(Route.Builder $this$debuggerCallback, SessionManager sessionManager, Ssl ssl) {
        String[] stringArray = new String[]{"/debugger/callback"};
        return $this$debuggerCallback.any(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)arg_0 -> DebuggerRequestHandlerKt.debuggerCallback$lambda$6(sessionManager, ssl, arg_0)));
    }

    static /* synthetic */ Route.Builder debuggerCallback$default(Route.Builder builder, SessionManager sessionManager, Ssl ssl, int n, Object object) {
        if ((n & 2) != 0) {
            ssl = null;
        }
        return DebuggerRequestHandlerKt.debuggerCallback(builder, sessionManager, ssl);
    }

    private static final Unit log$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final OAuth2HttpResponse handle$lambda$2(SessionManager $sessionManager, OAuth2HttpRequest request, Throwable error) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Object object = new String[]{"Content-Type", "text/html", "Set-Cookie", $sessionManager.session(request).asCookie()};
        Object object2 = Headers.Companion.of(object);
        object = OAuth2HttpResponseKt.getTemplateMapper().debuggerErrorHtml(HttpUrlExtensionsKt.toDebuggerUrl(request.getUrl()), ExceptionsKt.stackTraceToString((Throwable)error));
        Object it = object2 = new OAuth2HttpResponse((Headers)object2, 500, (String)object, null, 8, null);
        boolean bl = false;
        log.error("received exception when handling url=" + request.getUrl(), error);
        return object2;
    }

    private static final OAuth2HttpResponse debuggerForm$lambda$5$lambda$3(OAuth2HttpRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        log.debug("handling GET request, return html form");
        HttpUrl url = HttpUrlExtensionsKt.toAuthorizationEndpointUrl(it.getUrl()).newBuilder().query("client_id=debugger&response_type=code&redirect_uri=" + HttpUrlExtensionsKt.toDebuggerCallbackUrl(it.getUrl()) + "&response_mode=query&scope=openid+somescope&state=1234&nonce=5678").build();
        return OAuth2HttpResponseKt.html(OAuth2HttpResponseKt.getTemplateMapper().debuggerFormHtml(url, "CLIENT_SECRET_BASIC"));
    }

    private static final OAuth2HttpResponse debuggerForm$lambda$5$lambda$4(SessionManager $sessionManager, OAuth2HttpRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        log.debug("handling POST request, return redirect");
        String string = it.getFormParameters().get("authorize_url");
        if (string == null) {
            throw new IllegalStateException("authorize_url is missing".toString());
        }
        String authorizeUrl = string;
        String[] stringArray = new String[]{"authorize_url", "token_url", "client_secret", "client_auth_method"};
        HttpUrl httpUrl = HttpUrlExtensionsKt.removeAllEncodedQueryParams(HttpUrl.Companion.get(authorizeUrl).newBuilder().encodedQuery(it.getFormParameters().getParameterString()), stringArray).build();
        log.debug("attempting to redirect to " + httpUrl + ", setting received params in encrypted cookie");
        SessionManager.Session session = $sessionManager.session(it);
        session.putAll(it.getFormParameters().getMap());
        String[] stringArray2 = new String[]{"Set-Cookie", session.asCookie()};
        return OAuth2HttpResponseKt.redirect(httpUrl.toString(), Headers.Companion.of(stringArray2));
    }

    private static final OAuth2HttpResponse debuggerCallback$lambda$6(SessionManager $sessionManager, Ssl $ssl, OAuth2HttpRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        log.debug("handling " + it.getMethod() + " request to debugger callback");
        SessionManager.Session session = $sessionManager.session(it);
        HttpUrl tokenUrl = HttpUrl.Companion.get(session.get("token_url"));
        String string = it.getUrl().queryParameter("code");
        if (string == null && (string = it.getFormParameters().get("code")) == null) {
            throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "no code parameter present");
        }
        String code = string;
        ClientAuthentication clientAuthentication = ClientAuthentication.Companion.fromMap(session.getParameters());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"grant_type", (Object)"authorization_code"), TuplesKt.to((Object)"code", (Object)code), TuplesKt.to((Object)"scope", (Object)ClientKt.urlEncode(session.get("scope"))), TuplesKt.to((Object)"redirect_uri", (Object)ClientKt.urlEncode(session.get("redirect_uri")))};
        TokenRequest request = new TokenRequest(tokenUrl, clientAuthentication, MapsKt.mapOf((Pair[])pairArray));
        String response = $ssl != null ? ClientKt.post(ClientKt.withSsl$default(client, $ssl, false, 2, null), request) : ClientKt.post(client, request);
        return OAuth2HttpResponseKt.html(OAuth2HttpResponseKt.getTemplateMapper().debuggerCallbackHtml(request.toString(), response));
    }

    public static final /* synthetic */ Function2 access$handle(SessionManager sessionManager) {
        return DebuggerRequestHandlerKt.handle(sessionManager);
    }

    public static final /* synthetic */ Route.Builder access$debuggerForm(Route.Builder $receiver, SessionManager sessionManager) {
        return DebuggerRequestHandlerKt.debuggerForm($receiver, sessionManager);
    }

    public static final /* synthetic */ Route.Builder access$debuggerCallback(Route.Builder $receiver, SessionManager sessionManager, Ssl ssl) {
        return DebuggerRequestHandlerKt.debuggerCallback($receiver, sessionManager, ssl);
    }
}

