/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.debugger;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.DirectDecrypter;
import com.nimbusds.jose.crypto.DirectEncrypter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.mock.oauth2.debugger.SessionManagerKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lno/nav/security/mock/oauth2/debugger/SessionManager;", "", "<init>", "()V", "encryptionKey", "Ljavax/crypto/SecretKey;", "session", "Lno/nav/security/mock/oauth2/debugger/SessionManager$Session;", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "Session", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionManager.kt\nno/nav/security/mock/oauth2/debugger/SessionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class SessionManager {
    @NotNull
    private final SecretKey encryptionKey;

    /*
     * WARNING - void declaration
     */
    public SessionManager() {
        void $this$encryptionKey_u24lambda_u240;
        KeyGenerator keyGenerator;
        KeyGenerator keyGenerator2 = keyGenerator = KeyGenerator.getInstance("AES");
        SessionManager sessionManager = this;
        boolean bl = false;
        $this$encryptionKey_u24lambda_u240.init(128);
        SecretKey secretKey = keyGenerator.generateKey();
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"generateKey(...)");
        sessionManager.encryptionKey = secretKey;
    }

    @NotNull
    public final Session session(@NotNull OAuth2HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new Session(this.encryptionKey, request);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\n\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0012J\u0011\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0086\u0002J\u001b\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u0086\u0002J\u0006\u0010\u0017\u001a\u00020\fJ\u0014\u0010\u0018\u001a\u00020\f*\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0014\u0010\u0019\u001a\u00020\f*\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lno/nav/security/mock/oauth2/debugger/SessionManager$Session;", "", "encryptionKey", "Ljavax/crypto/SecretKey;", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "<init>", "(Ljavax/crypto/SecretKey;Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;)V", "getRequest", "()Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "parameters", "", "", "getParameters", "()Ljava/util/Map;", "putAll", "", "map", "", "get", "key", "set", "value", "asCookie", "encrypt", "decrypt", "getSessionCookie", "Companion", "mock-oauth2-server"})
    @SourceDebugExtension(value={"SMAP\nSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionManager.kt\nno/nav/security/mock/oauth2/debugger/SessionManager$Session\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,80:1\n1#2:81\n58#3:82\n51#3:83\n*S KotlinDebug\n*F\n+ 1 SessionManager.kt\nno/nav/security/mock/oauth2/debugger/SessionManager$Session\n*L\n32#1:82\n32#1:83\n*E\n"})
    public static final class Session {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SecretKey encryptionKey;
        @NotNull
        private final OAuth2HttpRequest request;
        @NotNull
        private final Map<String, String> parameters;
        @NotNull
        public static final String DEBUGGER_SESSION_COOKIE = "debugger-session";

        /*
         * WARNING - void declaration
         */
        public Session(@NotNull SecretKey encryptionKey, @NotNull OAuth2HttpRequest request) {
            Object object;
            block3: {
                block2: {
                    void it;
                    Intrinsics.checkNotNullParameter((Object)encryptionKey, (String)"encryptionKey");
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    this.encryptionKey = encryptionKey;
                    this.request = request;
                    Session session = this;
                    object = this.getSessionCookie();
                    if (object == null) break block2;
                    String string = object;
                    Session session2 = session;
                    boolean bl = false;
                    ObjectMapper $this$readValue$iv = OAuth2HttpResponseKt.getObjectMapper();
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    Map map = (Map)$this$readValue$iv.readValue((String)it, (TypeReference)new TypeReference<Map<String, String>>(){});
                    session = session2;
                    object = map;
                    if (map != null) break block3;
                }
                object = new LinkedHashMap();
            }
            session.parameters = object;
        }

        @NotNull
        public final OAuth2HttpRequest getRequest() {
            return this.request;
        }

        @NotNull
        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        public final void putAll(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.parameters.putAll(map);
        }

        @NotNull
        public final String get(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String string = this.parameters.get(key);
            if (string == null) {
                throw new RuntimeException("could not get " + key + " from session.");
            }
            return string;
        }

        @Nullable
        public final String set(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.parameters.put(key, value);
        }

        @NotNull
        public final String asCookie() {
            String string = OAuth2HttpResponseKt.getObjectMapper().writeValueAsString(this.parameters);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            String it = this.encrypt(string, this.encryptionKey);
            boolean bl = false;
            return "debugger-session=" + it + "; HttpOnly; Path=/";
        }

        private final String encrypt(String $this$encrypt, SecretKey key) {
            JWEObject jWEObject;
            JWEObject it = jWEObject = new JWEObject(new JWEHeader(JWEAlgorithm.DIR, EncryptionMethod.A128GCM), new Payload($this$encrypt));
            boolean bl = false;
            it.encrypt((JWEEncrypter)new DirectEncrypter(key));
            String string = jWEObject.serialize();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize(...)");
            return string;
        }

        private final String decrypt(String $this$decrypt, SecretKey key) {
            JWEObject jWEObject;
            JWEObject it = jWEObject = JWEObject.parse((String)$this$decrypt);
            boolean bl = false;
            it.decrypt((JWEDecrypter)new DirectDecrypter(key));
            String string = jWEObject.getPayload().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String getSessionCookie() {
            String string;
            Object $this$getSessionCookie_u24lambda_u244;
            Object object = this;
            try {
                $this$getSessionCookie_u24lambda_u244 = object;
                boolean bl = false;
                String string2 = ((Session)$this$getSessionCookie_u24lambda_u244).request.getCookies().get(DEBUGGER_SESSION_COOKIE);
                $this$getSessionCookie_u24lambda_u244 = Result.constructor-impl(string2 != null ? super.decrypt(string2, ((Session)$this$getSessionCookie_u24lambda_u244).encryptionKey) : null);
            }
            catch (Throwable bl) {
                $this$getSessionCookie_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$getSessionCookie_u24lambda_u244;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) {
                String result = (String)object;
                boolean bl = false;
                string = result;
            } else {
                Throwable error = throwable;
                boolean bl = false;
                SessionManagerKt.access$getLog$p().error("received exception when decrypting cookie", error);
                string = null;
            }
            return string;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lno/nav/security/mock/oauth2/debugger/SessionManager$Session$Companion;", "", "<init>", "()V", "DEBUGGER_SESSION_COOKIE", "", "mock-oauth2-server"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

