/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.extensions;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.OAuth2ExceptionKt;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\b\u001a\u0018\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f*\u00020\b\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\b\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\b\u001a,\u0010\u0013\u001a\u0002H\u0014\"\n\b\u0000\u0010\u0014\u0018\u0001*\u00020\u0015*\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0017H\u0086\b\u00a2\u0006\u0002\u0010\u0018\u001a\n\u0010\u0019\u001a\u00020\r*\u00020\b\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u001c\u001a$\u0010\u001d\u001a\u00020\u001e*\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$\u001a\n\u0010%\u001a\u00020&*\u00020'\u001a\u001a\u0010(\u001a\u00020)*\u00020&2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020,\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"log", "Lmu/KLogger;", "isPrompt", "", "Lcom/nimbusds/openid/connect/sdk/AuthenticationRequest;", "verifyPkce", "", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "grantType", "Lcom/nimbusds/oauth2/sdk/GrantType;", "scopesWithoutOidcScopes", "", "", "kotlin.jvm.PlatformType", "tokenExchangeGrantOrNull", "Lno/nav/security/mock/oauth2/grant/TokenExchangeGrant;", "authorizationCode", "Lcom/nimbusds/oauth2/sdk/AuthorizationCode;", "grant", "T", "Lcom/nimbusds/oauth2/sdk/AuthorizationGrant;", "type", "Ljava/lang/Class;", "(Lcom/nimbusds/oauth2/sdk/TokenRequest;Ljava/lang/Class;)Lcom/nimbusds/oauth2/sdk/AuthorizationGrant;", "clientIdAsString", "expiresIn", "", "Lcom/nimbusds/jwt/SignedJWT;", "verifySignatureAndIssuer", "Lcom/nimbusds/jwt/JWTClaimsSet;", "issuer", "Lcom/nimbusds/oauth2/sdk/id/Issuer;", "jwkSet", "Lcom/nimbusds/jose/jwk/JWKSet;", "jwsAlgorithm", "Lcom/nimbusds/jose/JWSAlgorithm;", "clientAuthentication", "Lcom/nimbusds/oauth2/sdk/auth/ClientAuthentication;", "Lcom/nimbusds/oauth2/sdk/http/HTTPRequest;", "requirePrivateKeyJwt", "Lcom/nimbusds/oauth2/sdk/auth/PrivateKeyJWT;", "requiredAudience", "maxLifetimeSeconds", "", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nNimbusExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NimbusExtensions.kt\nno/nav/security/mock/oauth2/extensions/NimbusExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n75#1,2:130\n1755#2,3:127\n827#2:132\n855#2:133\n856#2:138\n11165#3:134\n11500#3,3:135\n1#4:139\n*S KotlinDebug\n*F\n+ 1 NimbusExtensions.kt\nno/nav/security/mock/oauth2/extensions/NimbusExtensionsKt\n*L\n46#1:130,2\n41#1:127,3\n62#1:132\n62#1:133\n62#1:138\n63#1:134\n63#1:135,3\n*E\n"})
public final class NimbusExtensionsKt {
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(NimbusExtensionsKt::log$lambda$0);

    public static final boolean isPrompt(@NotNull AuthenticationRequest $this$isPrompt) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$isPrompt, (String)"<this>");
            Prompt prompt = $this$isPrompt.getPrompt();
            if (prompt != null) {
                Iterable $this$any$iv = (Iterable)prompt;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Prompt.Type it = (Prompt.Type)element$iv;
                        boolean bl2 = false;
                        if (!(it == Prompt.Type.LOGIN || it == Prompt.Type.CONSENT || it == Prompt.Type.SELECT_ACCOUNT)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final void verifyPkce(@NotNull AuthenticationRequest $this$verifyPkce, @NotNull TokenRequest tokenRequest) {
        void $this$grant$iv;
        Intrinsics.checkNotNullParameter((Object)$this$verifyPkce, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        TokenRequest tokenRequest2 = tokenRequest;
        Class<AuthorizationCodeGrant> type$iv = AuthorizationCodeGrant.class;
        boolean $i$f$grant = false;
        AuthorizationGrant authorizationGrant = $this$grant$iv.getAuthorizationGrant();
        if (!(authorizationGrant instanceof AuthorizationCodeGrant)) {
            authorizationGrant = null;
        }
        AuthorizationGrant authorizationGrant2 = (AuthorizationGrant)((AuthorizationCodeGrant)authorizationGrant);
        if (authorizationGrant2 == null) {
            throw new OAuth2Exception(OAuth2Error.INVALID_GRANT, "expected grant of type " + type$iv);
        }
        CodeVerifier verifier = ((AuthorizationCodeGrant)authorizationGrant2).getCodeVerifier();
        if (verifier != null) {
            if (!Intrinsics.areEqual((Object)CodeChallenge.compute((CodeChallengeMethod)$this$verifyPkce.getCodeChallengeMethod(), (CodeVerifier)verifier), (Object)$this$verifyPkce.getCodeChallenge())) {
                String msg = "invalid_pkce: code_verifier does not compute to code_challenge from request";
                throw new OAuth2Exception(OAuth2Error.INVALID_GRANT.setDescription(msg), msg);
            }
        } else {
            log.debug("no code_verifier found in token request, nothing to compare");
        }
    }

    @NotNull
    public static final GrantType grantType(@NotNull TokenRequest $this$grantType) {
        Intrinsics.checkNotNullParameter((Object)$this$grantType, (String)"<this>");
        AuthorizationGrant authorizationGrant = $this$grantType.getAuthorizationGrant();
        if (authorizationGrant == null || (authorizationGrant = authorizationGrant.getType()) == null) {
            throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "missing required parameter grant_type");
        }
        return authorizationGrant;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> scopesWithoutOidcScopes(@NotNull TokenRequest $this$scopesWithoutOidcScopes) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$scopesWithoutOidcScopes, (String)"<this>");
        Object object = $this$scopesWithoutOidcScopes.getScope();
        if (object != null && (object = object.toStringList()) != null) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = (Iterable)object;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                void $this$mapTo$iv$iv;
                String value = (String)element$iv$iv;
                boolean bl = false;
                OIDCScopeValue[] oIDCScopeValueArray = OIDCScopeValue.values();
                Intrinsics.checkNotNullExpressionValue((Object)oIDCScopeValueArray, (String)"values(...)");
                Object[] $this$map$iv = oIDCScopeValueArray;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    OIDCScopeValue oIDCScopeValue = (OIDCScopeValue)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(it.toString());
                }
                if (((List)destination$iv$iv2).contains(value)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public static final TokenExchangeGrant tokenExchangeGrantOrNull(@NotNull TokenRequest $this$tokenExchangeGrantOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$tokenExchangeGrantOrNull, (String)"<this>");
        AuthorizationGrant authorizationGrant = $this$tokenExchangeGrantOrNull.getAuthorizationGrant();
        return authorizationGrant instanceof TokenExchangeGrant ? (TokenExchangeGrant)authorizationGrant : null;
    }

    @NotNull
    public static final AuthorizationCode authorizationCode(@NotNull TokenRequest $this$authorizationCode) {
        AuthorizationCode authorizationCode;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$authorizationCode, (String)"<this>");
                AuthorizationGrant authorizationGrant = $this$authorizationCode.getAuthorizationGrant();
                if (authorizationGrant == null) break block3;
                AuthorizationGrant it = authorizationGrant;
                boolean bl = false;
                AuthorizationCodeGrant authorizationCodeGrant = it instanceof AuthorizationCodeGrant ? (AuthorizationCodeGrant)it : null;
                if (authorizationCodeGrant != null && (authorizationCode = authorizationCodeGrant.getAuthorizationCode()) != null) break block4;
            }
            throw new OAuth2Exception(OAuth2Error.INVALID_GRANT, "code cannot be null");
        }
        return authorizationCode;
    }

    public static final /* synthetic */ <T extends AuthorizationGrant> T grant(TokenRequest $this$grant, Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)$this$grant, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        boolean $i$f$grant = false;
        AuthorizationGrant authorizationGrant = $this$grant.getAuthorizationGrant();
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        if (authorizationGrant == null) {
            throw new OAuth2Exception(OAuth2Error.INVALID_GRANT, "expected grant of type " + type);
        }
        return (T)authorizationGrant;
    }

    @NotNull
    public static final String clientIdAsString(@NotNull TokenRequest $this$clientIdAsString) {
        Intrinsics.checkNotNullParameter((Object)$this$clientIdAsString, (String)"<this>");
        Object object = $this$clientIdAsString.getClientAuthentication();
        if (object == null || (object = object.getClientID()) == null || (object = object.getValue()) == null) {
            ClientID clientID = $this$clientIdAsString.getClientID();
            object = clientID != null ? clientID.getValue() : null;
            if (object == null) {
                throw new OAuth2Exception(OAuth2Error.INVALID_CLIENT, "client_id cannot be null");
            }
        }
        return object;
    }

    public static final int expiresIn(@NotNull SignedJWT $this$expiresIn) {
        Intrinsics.checkNotNullParameter((Object)$this$expiresIn, (String)"<this>");
        return (int)Duration.between(Instant.now(), $this$expiresIn.getJWTClaimsSet().getExpirationTime().toInstant()).getSeconds();
    }

    @NotNull
    public static final JWTClaimsSet verifySignatureAndIssuer(@NotNull SignedJWT $this$verifySignatureAndIssuer, @NotNull Issuer issuer, @NotNull JWKSet jwkSet, @NotNull JWSAlgorithm jwsAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)$this$verifySignatureAndIssuer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)jwkSet, (String)"jwkSet");
        Intrinsics.checkNotNullParameter((Object)jwsAlgorithm, (String)"jwsAlgorithm");
        ConfigurableJWTProcessor jwtProcessor2 = (ConfigurableJWTProcessor)new DefaultJWTProcessor();
        JOSEObjectType[] jOSEObjectTypeArray = new JOSEObjectType[]{new JOSEObjectType("JWT")};
        jwtProcessor2.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(jOSEObjectTypeArray));
        JWSKeySelector keySelector = (JWSKeySelector)new JWSVerificationKeySelector(jwsAlgorithm, (JWKSource)new ImmutableJWKSet(jwkSet));
        jwtProcessor2.setJWSKeySelector(keySelector);
        Object[] objectArray = new String[]{"sub", "iat", "exp"};
        jwtProcessor2.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier(new JWTClaimsSet.Builder().issuer(issuer.toString()).build(), (Set)new HashSet(CollectionsKt.listOf((Object[])objectArray))));
        JWTClaimsSet jWTClaimsSet = jwtProcessor2.process($this$verifySignatureAndIssuer, null);
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"process(...)");
        return jWTClaimsSet;
    }

    public static /* synthetic */ JWTClaimsSet verifySignatureAndIssuer$default(SignedJWT signedJWT, Issuer issuer, JWKSet jWKSet, JWSAlgorithm jWSAlgorithm, int n, Object object) {
        if ((n & 4) != 0) {
            jWSAlgorithm = JWSAlgorithm.RS256;
        }
        return NimbusExtensionsKt.verifySignatureAndIssuer(signedJWT, issuer, jWKSet, jWSAlgorithm);
    }

    @NotNull
    public static final ClientAuthentication clientAuthentication(@NotNull HTTPRequest $this$clientAuthentication) {
        Intrinsics.checkNotNullParameter((Object)$this$clientAuthentication, (String)"<this>");
        ClientAuthentication clientAuthentication = ClientAuthentication.parse((HTTPRequest)$this$clientAuthentication);
        if (clientAuthentication == null) {
            throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "request must contain some form of ClientAuthentication.");
        }
        return clientAuthentication;
    }

    @NotNull
    public static final PrivateKeyJWT requirePrivateKeyJwt(@NotNull ClientAuthentication $this$requirePrivateKeyJwt, @NotNull String requiredAudience, long maxLifetimeSeconds) {
        PrivateKeyJWT it;
        PrivateKeyJWT privateKeyJWT;
        Intrinsics.checkNotNullParameter((Object)$this$requirePrivateKeyJwt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)requiredAudience, (String)"requiredAudience");
        PrivateKeyJWT privateKeyJWT2 = privateKeyJWT = $this$requirePrivateKeyJwt instanceof PrivateKeyJWT ? (PrivateKeyJWT)$this$requirePrivateKeyJwt : null;
        if (privateKeyJWT != null) {
            it = privateKeyJWT;
            boolean bl = false;
            SignedJWT signedJWT = it.getClientAssertion();
            Intrinsics.checkNotNullExpressionValue((Object)signedJWT, (String)"getClientAssertion(...)");
            if ((long)NimbusExtensionsKt.expiresIn(signedJWT) > maxLifetimeSeconds) {
                OAuth2ExceptionKt.invalidRequest("invalid client_assertion: client_assertion expiry is too long( should be < " + maxLifetimeSeconds + ")");
                throw new KotlinNothingValueException();
            }
            if (!it.getClientAssertion().getJWTClaimsSet().getAudience().contains(requiredAudience)) {
                OAuth2ExceptionKt.invalidRequest("invalid client_assertion: client_assertion must contain required audience '" + requiredAudience + "'");
                throw new KotlinNothingValueException();
            }
        } else {
            throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "request must contain a valid client_assertion.");
        }
        return it;
    }

    private static final Unit log$lambda$0() {
        return Unit.INSTANCE;
    }
}

