/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import freemarker.template.Configuration;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.templates.TemplateMapper;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0013\u001a\u00020\t2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u000e\u001a\u0006\u0010\u0015\u001a\u00020\t\u001a\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "templateMapper", "Lno/nav/security/mock/oauth2/templates/TemplateMapper;", "getTemplateMapper", "()Lno/nav/security/mock/oauth2/templates/TemplateMapper;", "json", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "anyObject", "", "html", "content", "", "redirect", "location", "headers", "Lokhttp3/Headers;", "notFound", "body", "methodNotAllowed", "authenticationSuccess", "authenticationSuccessResponse", "Lcom/nimbusds/openid/connect/sdk/AuthenticationSuccessResponse;", "oauth2Error", "error", "Lcom/nimbusds/oauth2/sdk/ErrorObject;", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nOAuth2HttpResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2HttpResponse.kt\nno/nav/security/mock/oauth2/http/OAuth2HttpResponseKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
public final class OAuth2HttpResponseKt {
    @NotNull
    private static final ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();
    @NotNull
    private static final TemplateMapper templateMapper = TemplateMapper.Companion.create((Function1<? super Configuration, Unit>)((Function1)OAuth2HttpResponseKt::templateMapper$lambda$0));

    @NotNull
    public static final ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    @NotNull
    public static final TemplateMapper getTemplateMapper() {
        return templateMapper;
    }

    @NotNull
    public static final OAuth2HttpResponse json(@NotNull Object anyObject) {
        Intrinsics.checkNotNullParameter((Object)anyObject, (String)"anyObject");
        String[] stringArray = new String[]{HttpHeaderNames.CONTENT_TYPE.toString(), "application/json;charset=UTF-8"};
        return new OAuth2HttpResponse(Headers.Companion.of(stringArray), 200, anyObject instanceof String ? (String)anyObject : objectMapper.enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString(anyObject), null, 8, null);
    }

    @NotNull
    public static final OAuth2HttpResponse html(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String[] stringArray = new String[]{HttpHeaderNames.CONTENT_TYPE.toString(), "text/html;charset=UTF-8"};
        return new OAuth2HttpResponse(Headers.Companion.of(stringArray), 200, content, null, 8, null);
    }

    @NotNull
    public static final OAuth2HttpResponse redirect(@NotNull String location, @NotNull Headers headers) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        String[] stringArray = new String[]{HttpHeaderNames.LOCATION.toString(), location};
        return new OAuth2HttpResponse(Headers.Companion.of(stringArray).newBuilder().addAll(headers).build(), 302, null, null, 12, null);
    }

    public static /* synthetic */ OAuth2HttpResponse redirect$default(String string, Headers headers, int n, Object object) {
        if ((n & 2) != 0) {
            headers = Headers.Companion.of(new String[0]);
        }
        return OAuth2HttpResponseKt.redirect(string, headers);
    }

    @NotNull
    public static final OAuth2HttpResponse notFound(@Nullable String body) {
        return new OAuth2HttpResponse(null, 404, body, null, 9, null);
    }

    public static /* synthetic */ OAuth2HttpResponse notFound$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return OAuth2HttpResponseKt.notFound(string);
    }

    @NotNull
    public static final OAuth2HttpResponse methodNotAllowed() {
        return new OAuth2HttpResponse(null, 405, "method not allowed", null, 9, null);
    }

    @NotNull
    public static final OAuth2HttpResponse authenticationSuccess(@NotNull AuthenticationSuccessResponse authenticationSuccessResponse) {
        OAuth2HttpResponse oAuth2HttpResponse;
        Intrinsics.checkNotNullParameter((Object)authenticationSuccessResponse, (String)"authenticationSuccessResponse");
        if (Intrinsics.areEqual((Object)authenticationSuccessResponse.getResponseMode(), (Object)ResponseMode.FORM_POST)) {
            String string = authenticationSuccessResponse.getRedirectionURI().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = authenticationSuccessResponse.getAuthorizationCode().getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            String string3 = authenticationSuccessResponse.getState().getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
            oAuth2HttpResponse = new OAuth2HttpResponse(null, 200, templateMapper.authorizationCodeResponseHtml(string, string2, string3), null, 9, null);
        } else {
            String[] stringArray = new String[]{HttpHeaderNames.LOCATION.toString(), authenticationSuccessResponse.toURI().toString()};
            OAuth2HttpResponse oAuth2HttpResponse2 = new OAuth2HttpResponse(Headers.Companion.of(stringArray), 302, null, null, 12, null);
            oAuth2HttpResponse = oAuth2HttpResponse2;
        }
        return oAuth2HttpResponse;
    }

    @NotNull
    public static final OAuth2HttpResponse oauth2Error(@NotNull ErrorObject error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Integer n = error.getHTTPStatusCode();
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 302) ? n : null;
        int responseCode = n2 != null ? n2 : 400;
        String[] stringArray = new String[]{HttpHeaderNames.CONTENT_TYPE.toString(), "application/json;charset=UTF-8"};
        Headers headers = Headers.Companion.of(stringArray);
        String string = objectMapper.enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)error.toJSONObject());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return new OAuth2HttpResponse(headers, responseCode, string2, null, 8, null);
    }

    private static final Unit templateMapper$lambda$0(Configuration $this$create) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        return Unit.INSTANCE;
    }
}

