/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.token;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.token.KeyGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB#\b\u0007\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0006\u0010\u0006\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007J#\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u0096\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lno/nav/security/mock/oauth2/token/KeyProvider;", "Lcom/nimbusds/jose/jwk/source/JWKSource;", "Lcom/nimbusds/jose/proc/SecurityContext;", "initialKeys", "", "Lcom/nimbusds/jose/jwk/JWK;", "algorithm", "", "<init>", "(Ljava/util/List;Ljava/lang/String;)V", "signingKeys", "Ljava/util/concurrent/ConcurrentHashMap;", "generator", "Lno/nav/security/mock/oauth2/token/KeyGenerator;", "keyDeque", "Ljava/util/concurrent/LinkedBlockingDeque;", "signingKey", "keyId", "keyFromDequeOrNew", "Lcom/nimbusds/jose/JWSAlgorithm;", "keyType", "generate", "", "get", "", "jwkSelector", "Lcom/nimbusds/jose/jwk/JWKSelector;", "context", "Companion", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nKeyProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyProvider.kt\nno/nav/security/mock/oauth2/token/KeyProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1863#2,2:79\n*S KotlinDebug\n*F\n+ 1 KeyProvider.kt\nno/nav/security/mock/oauth2/token/KeyProvider\n*L\n28#1:79,2\n*E\n"})
public class KeyProvider
implements JWKSource<SecurityContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<JWK> initialKeys;
    @NotNull
    private final String algorithm;
    @NotNull
    private final ConcurrentHashMap<String, JWK> signingKeys;
    @NotNull
    private KeyGenerator generator;
    @NotNull
    private final LinkedBlockingDeque<JWK> keyDeque;
    @NotNull
    public static final String INITIAL_KEYS_FILE = "/mock-oauth2-server-keys.json";

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public KeyProvider(@NotNull List<? extends JWK> initialKeys, @NotNull String algorithm) {
        LinkedBlockingDeque linkedBlockingDeque;
        Intrinsics.checkNotNullParameter(initialKeys, (String)"initialKeys");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this.initialKeys = initialKeys;
        this.algorithm = algorithm;
        this.signingKeys = new ConcurrentHashMap();
        JWSAlgorithm jWSAlgorithm = JWSAlgorithm.parse((String)this.algorithm);
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"parse(...)");
        this.generator = new KeyGenerator(jWSAlgorithm, null, 2, null);
        LinkedBlockingDeque linkedBlockingDeque2 = linkedBlockingDeque = new LinkedBlockingDeque();
        KeyProvider keyProvider = this;
        boolean bl = false;
        Iterable $this$forEach$iv = this.initialKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$keyDeque_u24lambda_u241;
            JWK it = (JWK)element$iv;
            boolean bl2 = false;
            $this$keyDeque_u24lambda_u241.put(it);
        }
        keyProvider.keyDeque = linkedBlockingDeque;
    }

    public /* synthetic */ KeyProvider(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = Companion.keysFromFile(INITIAL_KEYS_FILE);
        }
        if ((n & 2) != 0) {
            string = JWSAlgorithm.RS256.getName();
        }
        this(list, string);
    }

    @NotNull
    public final JWK signingKey(@NotNull String keyId) {
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        JWK jWK = this.signingKeys.computeIfAbsent(keyId, arg_0 -> KeyProvider.signingKey$lambda$3(arg_0 -> KeyProvider.signingKey$lambda$2(this, keyId, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jWK, (String)"computeIfAbsent(...)");
        return jWK;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final JWK keyFromDequeOrNew(String keyId) {
        JWK jWK;
        JWK jWK2 = this.keyDeque.poll();
        if (jWK2 != null) {
            RSAKey rSAKey;
            JWK polledJwk = jWK2;
            boolean bl = false;
            String string = polledJwk.getKeyType().getValue();
            if (Intrinsics.areEqual((Object)string, (Object)KeyType.RSA.getValue())) {
                rSAKey = new RSAKey.Builder(polledJwk.toRSAKey()).keyID(keyId).build();
            } else {
                if (!Intrinsics.areEqual((Object)string, (Object)KeyType.EC.getValue())) throw new OAuth2Exception("Unsupported key type: " + polledJwk.getKeyType().getValue());
                rSAKey = jWK2 = new ECKey.Builder(polledJwk.toECKey()).keyID(keyId).build();
            }
            if (rSAKey != null) {
                jWK = jWK2;
                return jWK;
            }
        }
        jWK = this.generator.generateKey(keyId);
        return jWK;
    }

    @NotNull
    public final JWSAlgorithm algorithm() {
        JWSAlgorithm jWSAlgorithm = JWSAlgorithm.parse((String)this.algorithm);
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"parse(...)");
        return jWSAlgorithm;
    }

    @NotNull
    public final String keyType() {
        String string = this.generator.getKeyGenerator().getAlgorithm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAlgorithm(...)");
        return string;
    }

    public final void generate(@NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        JWSAlgorithm jWSAlgorithm = JWSAlgorithm.parse((String)algorithm);
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"parse(...)");
        this.generator = new KeyGenerator(jWSAlgorithm, null, 2, null);
    }

    @NotNull
    public List<JWK> get(@Nullable JWKSelector jwkSelector, @Nullable SecurityContext context) {
        Object object;
        block3: {
            block2: {
                object = jwkSelector;
                if (object == null) break block2;
                Collection<JWK> collection = this.signingKeys.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                if ((object = object.select(new JWKSet(CollectionsKt.toList((Iterable)collection)).toPublicJWKSet())) != null) break block3;
            }
            object = new ArrayList();
        }
        return object;
    }

    @JvmOverloads
    public KeyProvider(@NotNull List<? extends JWK> initialKeys) {
        Intrinsics.checkNotNullParameter(initialKeys, (String)"initialKeys");
        this(initialKeys, null, 2, null);
    }

    @JvmOverloads
    public KeyProvider() {
        this(null, null, 3, null);
    }

    private static final JWK signingKey$lambda$2(KeyProvider this$0, String $keyId, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.keyFromDequeOrNew($keyId);
    }

    private static final JWK signingKey$lambda$3(Function1 $tmp0, Object p0) {
        return (JWK)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lno/nav/security/mock/oauth2/token/KeyProvider$Companion;", "", "<init>", "()V", "INITIAL_KEYS_FILE", "", "keysFromFile", "", "Lcom/nimbusds/jose/jwk/JWK;", "filename", "mock-oauth2-server"})
    @SourceDebugExtension(value={"SMAP\nKeyProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyProvider.kt\nno/nav/security/mock/oauth2/token/KeyProvider$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1557#2:79\n1628#2,3:80\n*S KotlinDebug\n*F\n+ 1 KeyProvider.kt\nno/nav/security/mock/oauth2/token/KeyProvider$Companion\n*L\n66#1:79\n66#1:80,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<JWK> keysFromFile(@NotNull String filename) {
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            URL keysFromFile = KeyProvider.class.getResource(filename);
            if (keysFromFile != null) {
                void $this$mapTo$iv$iv;
                URL uRL = keysFromFile;
                Object object = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
                List list = JWKSet.parse((String)new String(byArray, (Charset)object)).getKeys();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeys(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JWK jWK = (JWK)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.nimbusds.jose.jwk.JWK");
                    collection.add(it);
                }
                return (List)destination$iv$iv;
            }
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

