/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import java.io.File;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.mock.oauth2.http.MockWebServerWrapper;
import no.nav.security.mock.oauth2.http.NettyWrapper;
import no.nav.security.mock.oauth2.http.OAuth2HttpServer;
import no.nav.security.mock.oauth2.http.Ssl;
import no.nav.security.mock.oauth2.http.SslKeystore;
import no.nav.security.mock.oauth2.token.KeyProvider;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenProvider;
import no.nav.security.mock.oauth2.token.RequestMappingTokenCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0003*+,BY\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0003\u0010\b\u001a\u00020\t\u0012\u000e\b\u0003\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\b\u0003\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003J\t\u0010#\u001a\u00020\u000eH\u00c6\u0003JY\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0003\u0010\b\u001a\u00020\t2\u000e\b\u0003\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0003\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00032\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006-"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config;", "", "interactiveLogin", "", "loginPagePath", "", "staticAssetsPath", "rotateRefreshToken", "tokenProvider", "Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "tokenCallbacks", "", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "httpServer", "Lno/nav/security/mock/oauth2/http/OAuth2HttpServer;", "<init>", "(ZLjava/lang/String;Ljava/lang/String;ZLno/nav/security/mock/oauth2/token/OAuth2TokenProvider;Ljava/util/Set;Lno/nav/security/mock/oauth2/http/OAuth2HttpServer;)V", "getInteractiveLogin", "()Z", "getLoginPagePath", "()Ljava/lang/String;", "getStaticAssetsPath", "getRotateRefreshToken", "getTokenProvider", "()Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "getTokenCallbacks", "()Ljava/util/Set;", "getHttpServer", "()Lno/nav/security/mock/oauth2/http/OAuth2HttpServer;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "OAuth2TokenProviderDeserializer", "OAuth2HttpServerDeserializer", "Companion", "mock-oauth2-server"})
public final class OAuth2Config {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean interactiveLogin;
    @Nullable
    private final String loginPagePath;
    @Nullable
    private final String staticAssetsPath;
    private final boolean rotateRefreshToken;
    @NotNull
    private final OAuth2TokenProvider tokenProvider;
    @NotNull
    private final Set<OAuth2TokenCallback> tokenCallbacks;
    @NotNull
    private final OAuth2HttpServer httpServer;

    @JvmOverloads
    public OAuth2Config(boolean interactiveLogin, @Nullable String loginPagePath, @Nullable String staticAssetsPath, boolean rotateRefreshToken, @JsonDeserialize(using=OAuth2TokenProviderDeserializer.class) @NotNull OAuth2TokenProvider tokenProvider, @JsonDeserialize(contentAs=RequestMappingTokenCallback.class) @NotNull Set<? extends OAuth2TokenCallback> tokenCallbacks, @JsonDeserialize(using=OAuth2HttpServerDeserializer.class) @NotNull OAuth2HttpServer httpServer) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        Intrinsics.checkNotNullParameter(tokenCallbacks, (String)"tokenCallbacks");
        Intrinsics.checkNotNullParameter((Object)httpServer, (String)"httpServer");
        this.interactiveLogin = interactiveLogin;
        this.loginPagePath = loginPagePath;
        this.staticAssetsPath = staticAssetsPath;
        this.rotateRefreshToken = rotateRefreshToken;
        this.tokenProvider = tokenProvider;
        this.tokenCallbacks = tokenCallbacks;
        this.httpServer = httpServer;
    }

    public /* synthetic */ OAuth2Config(boolean bl, String string, String string2, boolean bl2, OAuth2TokenProvider oAuth2TokenProvider, Set set, OAuth2HttpServer oAuth2HttpServer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            oAuth2TokenProvider = new OAuth2TokenProvider(null, null, 3, null);
        }
        if ((n & 0x20) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x40) != 0) {
            oAuth2HttpServer = new MockWebServerWrapper(null, 1, null);
        }
        this(bl, string, string2, bl2, oAuth2TokenProvider, set, oAuth2HttpServer);
    }

    public final boolean getInteractiveLogin() {
        return this.interactiveLogin;
    }

    @Nullable
    public final String getLoginPagePath() {
        return this.loginPagePath;
    }

    @Nullable
    public final String getStaticAssetsPath() {
        return this.staticAssetsPath;
    }

    public final boolean getRotateRefreshToken() {
        return this.rotateRefreshToken;
    }

    @NotNull
    public final OAuth2TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    @NotNull
    public final Set<OAuth2TokenCallback> getTokenCallbacks() {
        return this.tokenCallbacks;
    }

    @NotNull
    public final OAuth2HttpServer getHttpServer() {
        return this.httpServer;
    }

    public final boolean component1() {
        return this.interactiveLogin;
    }

    @Nullable
    public final String component2() {
        return this.loginPagePath;
    }

    @Nullable
    public final String component3() {
        return this.staticAssetsPath;
    }

    public final boolean component4() {
        return this.rotateRefreshToken;
    }

    @NotNull
    public final OAuth2TokenProvider component5() {
        return this.tokenProvider;
    }

    @NotNull
    public final Set<OAuth2TokenCallback> component6() {
        return this.tokenCallbacks;
    }

    @NotNull
    public final OAuth2HttpServer component7() {
        return this.httpServer;
    }

    @NotNull
    public final OAuth2Config copy(boolean interactiveLogin, @Nullable String loginPagePath, @Nullable String staticAssetsPath, boolean rotateRefreshToken, @JsonDeserialize(using=OAuth2TokenProviderDeserializer.class) @NotNull OAuth2TokenProvider tokenProvider, @JsonDeserialize(contentAs=RequestMappingTokenCallback.class) @NotNull Set<? extends OAuth2TokenCallback> tokenCallbacks, @JsonDeserialize(using=OAuth2HttpServerDeserializer.class) @NotNull OAuth2HttpServer httpServer) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        Intrinsics.checkNotNullParameter(tokenCallbacks, (String)"tokenCallbacks");
        Intrinsics.checkNotNullParameter((Object)httpServer, (String)"httpServer");
        return new OAuth2Config(interactiveLogin, loginPagePath, staticAssetsPath, rotateRefreshToken, tokenProvider, tokenCallbacks, httpServer);
    }

    public static /* synthetic */ OAuth2Config copy$default(OAuth2Config oAuth2Config, boolean bl, String string, String string2, boolean bl2, OAuth2TokenProvider oAuth2TokenProvider, Set set, OAuth2HttpServer oAuth2HttpServer, int n, Object object) {
        if ((n & 1) != 0) {
            bl = oAuth2Config.interactiveLogin;
        }
        if ((n & 2) != 0) {
            string = oAuth2Config.loginPagePath;
        }
        if ((n & 4) != 0) {
            string2 = oAuth2Config.staticAssetsPath;
        }
        if ((n & 8) != 0) {
            bl2 = oAuth2Config.rotateRefreshToken;
        }
        if ((n & 0x10) != 0) {
            oAuth2TokenProvider = oAuth2Config.tokenProvider;
        }
        if ((n & 0x20) != 0) {
            set = oAuth2Config.tokenCallbacks;
        }
        if ((n & 0x40) != 0) {
            oAuth2HttpServer = oAuth2Config.httpServer;
        }
        return oAuth2Config.copy(bl, string, string2, bl2, oAuth2TokenProvider, set, oAuth2HttpServer);
    }

    @NotNull
    public String toString() {
        return "OAuth2Config(interactiveLogin=" + this.interactiveLogin + ", loginPagePath=" + this.loginPagePath + ", staticAssetsPath=" + this.staticAssetsPath + ", rotateRefreshToken=" + this.rotateRefreshToken + ", tokenProvider=" + this.tokenProvider + ", tokenCallbacks=" + this.tokenCallbacks + ", httpServer=" + this.httpServer + ")";
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.interactiveLogin);
        result = result * 31 + (this.loginPagePath == null ? 0 : this.loginPagePath.hashCode());
        result = result * 31 + (this.staticAssetsPath == null ? 0 : this.staticAssetsPath.hashCode());
        result = result * 31 + Boolean.hashCode(this.rotateRefreshToken);
        result = result * 31 + this.tokenProvider.hashCode();
        result = result * 31 + ((Object)this.tokenCallbacks).hashCode();
        result = result * 31 + this.httpServer.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OAuth2Config)) {
            return false;
        }
        OAuth2Config oAuth2Config = (OAuth2Config)other;
        if (this.interactiveLogin != oAuth2Config.interactiveLogin) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.loginPagePath, (Object)oAuth2Config.loginPagePath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.staticAssetsPath, (Object)oAuth2Config.staticAssetsPath)) {
            return false;
        }
        if (this.rotateRefreshToken != oAuth2Config.rotateRefreshToken) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tokenProvider, (Object)oAuth2Config.tokenProvider)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tokenCallbacks, oAuth2Config.tokenCallbacks)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.httpServer, (Object)oAuth2Config.httpServer);
    }

    @JvmOverloads
    public OAuth2Config(boolean interactiveLogin, @Nullable String loginPagePath, @Nullable String staticAssetsPath, boolean rotateRefreshToken, @JsonDeserialize(using=OAuth2TokenProviderDeserializer.class) @NotNull OAuth2TokenProvider tokenProvider, @JsonDeserialize(contentAs=RequestMappingTokenCallback.class) @NotNull Set<? extends OAuth2TokenCallback> tokenCallbacks) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        Intrinsics.checkNotNullParameter(tokenCallbacks, (String)"tokenCallbacks");
        this(interactiveLogin, loginPagePath, staticAssetsPath, rotateRefreshToken, tokenProvider, tokenCallbacks, null, 64, null);
    }

    @JvmOverloads
    public OAuth2Config(boolean interactiveLogin, @Nullable String loginPagePath, @Nullable String staticAssetsPath, boolean rotateRefreshToken, @JsonDeserialize(using=OAuth2TokenProviderDeserializer.class) @NotNull OAuth2TokenProvider tokenProvider) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        this(interactiveLogin, loginPagePath, staticAssetsPath, rotateRefreshToken, tokenProvider, null, null, 96, null);
    }

    @JvmOverloads
    public OAuth2Config(boolean interactiveLogin, @Nullable String loginPagePath, @Nullable String staticAssetsPath, boolean rotateRefreshToken) {
        this(interactiveLogin, loginPagePath, staticAssetsPath, rotateRefreshToken, null, null, null, 112, null);
    }

    @JvmOverloads
    public OAuth2Config(boolean interactiveLogin, @Nullable String loginPagePath, @Nullable String staticAssetsPath) {
        this(interactiveLogin, loginPagePath, staticAssetsPath, false, null, null, null, 120, null);
    }

    @JvmOverloads
    public OAuth2Config(boolean interactiveLogin, @Nullable String loginPagePath) {
        this(interactiveLogin, loginPagePath, null, false, null, null, null, 124, null);
    }

    @JvmOverloads
    public OAuth2Config(boolean interactiveLogin) {
        this(interactiveLogin, null, null, false, null, null, null, 126, null);
    }

    @JvmOverloads
    public OAuth2Config() {
        this(false, null, null, false, null, null, null, 127, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$Companion;", "", "<init>", "()V", "fromJson", "Lno/nav/security/mock/oauth2/OAuth2Config;", "json", "", "mock-oauth2-server"})
    @SourceDebugExtension(value={"SMAP\nOAuth2Config.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2Config.kt\nno/nav/security/mock/oauth2/OAuth2Config$Companion\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n116#2:126\n54#2:127\n117#2:128\n61#2,8:129\n71#2:138\n1#3:137\n*S KotlinDebug\n*F\n+ 1 OAuth2Config.kt\nno/nav/security/mock/oauth2/OAuth2Config$Companion\n*L\n122#1:126\n122#1:127\n122#1:128\n122#1:129,8\n122#1:138\n122#1:137\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final OAuth2Config fromJson(@NotNull String json) {
            void $this$checkTypeMismatch$iv$iv;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            ObjectMapper $this$readValue$iv = ExtensionsKt.jacksonObjectMapper();
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef22 = false;
            Object $i$f$jacksonTypeRef22 = $this$readValue$iv.readValue(json, (TypeReference)new TypeReference<OAuth2Config>(){});
            boolean $i$f$checkTypeMismatch = false;
            if (!($this$checkTypeMismatch$iv$iv instanceof OAuth2Config)) {
                String string;
                String nullability$iv$iv = "(non-null)";
                StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(OAuth2Config.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
                void v1 = $this$checkTypeMismatch$iv$iv;
                if (v1 != null) {
                    void it$iv$iv;
                    void var7_8 = v1;
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl = false;
                    string = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                    stringBuilder = stringBuilder2;
                } else {
                    string = null;
                }
                String string2 = stringBuilder.append(string).toString();
                throw new RuntimeJsonMappingException(string2);
            }
            return (OAuth2Config)$this$checkTypeMismatch$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\n\u000b\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpServer;", "<init>", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "ServerType", "ServerConfig", "SslConfig", "mock-oauth2-server"})
    public static final class OAuth2HttpServerDeserializer
    extends JsonDeserializer<OAuth2HttpServer> {
        @NotNull
        public OAuth2HttpServer deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            ServerConfig serverConfig;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            TreeNode treeNode = p.readValueAsTree();
            Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"readValueAsTree(...)");
            JsonNode node = (JsonNode)treeNode;
            if (node.isObject()) {
                Object object = p.getCodec().treeToValue((TreeNode)node, ServerConfig.class);
                Intrinsics.checkNotNull((Object)object);
                serverConfig = (ServerConfig)object;
            } else {
                String string = node.textValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textValue(...)");
                serverConfig = new ServerConfig(ServerType.valueOf(string), null, 2, null);
            }
            ServerConfig serverConfig2 = serverConfig;
            SslConfig sslConfig = serverConfig2.getSsl();
            Ssl ssl = sslConfig != null ? sslConfig.ssl() : null;
            return switch (WhenMappings.$EnumSwitchMapping$0[serverConfig2.getType().ordinal()]) {
                case 1 -> new NettyWrapper(ssl);
                case 2 -> new MockWebServerWrapper(ssl);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$ServerConfig;", "", "type", "Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$ServerType;", "ssl", "Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$SslConfig;", "<init>", "(Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$ServerType;Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$SslConfig;)V", "getType", "()Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$ServerType;", "getSsl", "()Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$SslConfig;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "mock-oauth2-server"})
        public static final class ServerConfig {
            @NotNull
            private final ServerType type;
            @Nullable
            private final SslConfig ssl;

            public ServerConfig(@NotNull ServerType type, @Nullable SslConfig ssl) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                this.type = type;
                this.ssl = ssl;
            }

            public /* synthetic */ ServerConfig(ServerType serverType, SslConfig sslConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    sslConfig = null;
                }
                this(serverType, sslConfig);
            }

            @NotNull
            public final ServerType getType() {
                return this.type;
            }

            @Nullable
            public final SslConfig getSsl() {
                return this.ssl;
            }

            @NotNull
            public final ServerType component1() {
                return this.type;
            }

            @Nullable
            public final SslConfig component2() {
                return this.ssl;
            }

            @NotNull
            public final ServerConfig copy(@NotNull ServerType type, @Nullable SslConfig ssl) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return new ServerConfig(type, ssl);
            }

            public static /* synthetic */ ServerConfig copy$default(ServerConfig serverConfig, ServerType serverType, SslConfig sslConfig, int n, Object object) {
                if ((n & 1) != 0) {
                    serverType = serverConfig.type;
                }
                if ((n & 2) != 0) {
                    sslConfig = serverConfig.ssl;
                }
                return serverConfig.copy(serverType, sslConfig);
            }

            @NotNull
            public String toString() {
                return "ServerConfig(type=" + this.type + ", ssl=" + this.ssl + ")";
            }

            public int hashCode() {
                int result = this.type.hashCode();
                result = result * 31 + (this.ssl == null ? 0 : this.ssl.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ServerConfig)) {
                    return false;
                }
                ServerConfig serverConfig = (ServerConfig)other;
                if (this.type != serverConfig.type) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.ssl, (Object)serverConfig.ssl);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$ServerType;", "", "<init>", "(Ljava/lang/String;I)V", "MockWebServerWrapper", "NettyWrapper", "mock-oauth2-server"})
        public static final class ServerType
        extends Enum<ServerType> {
            public static final /* enum */ ServerType MockWebServerWrapper = new ServerType();
            public static final /* enum */ ServerType NettyWrapper = new ServerType();
            private static final /* synthetic */ ServerType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static ServerType[] values() {
                return (ServerType[])$VALUES.clone();
            }

            public static ServerType valueOf(String value) {
                return Enum.valueOf(ServerType.class, value);
            }

            @NotNull
            public static EnumEntries<ServerType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = serverTypeArray = new ServerType[]{ServerType.MockWebServerWrapper, ServerType.NettyWrapper};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J3\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006!"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2HttpServerDeserializer$SslConfig;", "", "keyPassword", "", "keystoreFile", "Ljava/io/File;", "keystoreType", "Lno/nav/security/mock/oauth2/http/SslKeystore$KeyStoreType;", "keystorePassword", "<init>", "(Ljava/lang/String;Ljava/io/File;Lno/nav/security/mock/oauth2/http/SslKeystore$KeyStoreType;Ljava/lang/String;)V", "getKeyPassword", "()Ljava/lang/String;", "getKeystoreFile", "()Ljava/io/File;", "getKeystoreType", "()Lno/nav/security/mock/oauth2/http/SslKeystore$KeyStoreType;", "getKeystorePassword", "ssl", "Lno/nav/security/mock/oauth2/http/Ssl;", "sslKeyStore", "Lno/nav/security/mock/oauth2/http/SslKeystore;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "mock-oauth2-server"})
        public static final class SslConfig {
            @NotNull
            private final String keyPassword;
            @Nullable
            private final File keystoreFile;
            @NotNull
            private final SslKeystore.KeyStoreType keystoreType;
            @NotNull
            private final String keystorePassword;

            public SslConfig(@NotNull String keyPassword, @Nullable File keystoreFile, @NotNull SslKeystore.KeyStoreType keystoreType, @NotNull String keystorePassword) {
                Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
                Intrinsics.checkNotNullParameter((Object)((Object)keystoreType), (String)"keystoreType");
                Intrinsics.checkNotNullParameter((Object)keystorePassword, (String)"keystorePassword");
                this.keyPassword = keyPassword;
                this.keystoreFile = keystoreFile;
                this.keystoreType = keystoreType;
                this.keystorePassword = keystorePassword;
            }

            public /* synthetic */ SslConfig(String string, File file, SslKeystore.KeyStoreType keyStoreType, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = "";
                }
                if ((n & 2) != 0) {
                    file = null;
                }
                if ((n & 4) != 0) {
                    keyStoreType = SslKeystore.KeyStoreType.PKCS12;
                }
                if ((n & 8) != 0) {
                    string2 = "";
                }
                this(string, file, keyStoreType, string2);
            }

            @NotNull
            public final String getKeyPassword() {
                return this.keyPassword;
            }

            @Nullable
            public final File getKeystoreFile() {
                return this.keystoreFile;
            }

            @NotNull
            public final SslKeystore.KeyStoreType getKeystoreType() {
                return this.keystoreType;
            }

            @NotNull
            public final String getKeystorePassword() {
                return this.keystorePassword;
            }

            @NotNull
            public final Ssl ssl() {
                return new Ssl(this.sslKeyStore());
            }

            private final SslKeystore sslKeyStore() {
                return this.keystoreFile == null ? new SslKeystore(null, null, 3, null) : new SslKeystore(this.keyPassword, this.keystoreFile, this.keystoreType, this.keystorePassword);
            }

            @NotNull
            public final String component1() {
                return this.keyPassword;
            }

            @Nullable
            public final File component2() {
                return this.keystoreFile;
            }

            @NotNull
            public final SslKeystore.KeyStoreType component3() {
                return this.keystoreType;
            }

            @NotNull
            public final String component4() {
                return this.keystorePassword;
            }

            @NotNull
            public final SslConfig copy(@NotNull String keyPassword, @Nullable File keystoreFile, @NotNull SslKeystore.KeyStoreType keystoreType, @NotNull String keystorePassword) {
                Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
                Intrinsics.checkNotNullParameter((Object)((Object)keystoreType), (String)"keystoreType");
                Intrinsics.checkNotNullParameter((Object)keystorePassword, (String)"keystorePassword");
                return new SslConfig(keyPassword, keystoreFile, keystoreType, keystorePassword);
            }

            public static /* synthetic */ SslConfig copy$default(SslConfig sslConfig, String string, File file, SslKeystore.KeyStoreType keyStoreType, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = sslConfig.keyPassword;
                }
                if ((n & 2) != 0) {
                    file = sslConfig.keystoreFile;
                }
                if ((n & 4) != 0) {
                    keyStoreType = sslConfig.keystoreType;
                }
                if ((n & 8) != 0) {
                    string2 = sslConfig.keystorePassword;
                }
                return sslConfig.copy(string, file, keyStoreType, string2);
            }

            @NotNull
            public String toString() {
                return "SslConfig(keyPassword=" + this.keyPassword + ", keystoreFile=" + this.keystoreFile + ", keystoreType=" + this.keystoreType + ", keystorePassword=" + this.keystorePassword + ")";
            }

            public int hashCode() {
                int result = this.keyPassword.hashCode();
                result = result * 31 + (this.keystoreFile == null ? 0 : this.keystoreFile.hashCode());
                result = result * 31 + this.keystoreType.hashCode();
                result = result * 31 + this.keystorePassword.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SslConfig)) {
                    return false;
                }
                SslConfig sslConfig = (SslConfig)other;
                if (!Intrinsics.areEqual((Object)this.keyPassword, (Object)sslConfig.keyPassword)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.keystoreFile, (Object)sslConfig.keystoreFile)) {
                    return false;
                }
                if (this.keystoreType != sslConfig.keystoreType) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.keystorePassword, (Object)sslConfig.keystorePassword);
            }

            public SslConfig() {
                this(null, null, null, null, 15, null);
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ServerType.values().length];
                try {
                    nArray[ServerType.NettyWrapper.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ServerType.MockWebServerWrapper.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\f"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2TokenProviderDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "<init>", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "ProviderConfig", "KeyProviderConfig", "mock-oauth2-server"})
    public static final class OAuth2TokenProviderDeserializer
    extends JsonDeserializer<OAuth2TokenProvider> {
        @NotNull
        public OAuth2TokenProvider deserialize(@NotNull JsonParser p, @Nullable DeserializationContext ctxt) {
            Object object;
            Instant systemTime;
            Object object2;
            ProviderConfig config;
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    TreeNode treeNode = p.readValueAsTree();
                    Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"readValueAsTree(...)");
                    JsonNode node = (JsonNode)treeNode;
                    if (!node.isObject()) {
                        return new OAuth2TokenProvider(null, null, 3, null);
                    }
                    Object object3 = p.getCodec().treeToValue((TreeNode)node, ProviderConfig.class);
                    Intrinsics.checkNotNull((Object)object3);
                    config = (ProviderConfig)object3;
                    object2 = config.getKeyProvider();
                    if (object2 == null || (object2 = ((KeyProviderConfig)object2).getInitialKeys()) == null) break block7;
                    Object it = object2;
                    boolean bl = false;
                    List list = CollectionsKt.listOf((Object)JWK.parse((String)it));
                    object2 = list;
                    if (list != null) break block8;
                }
                object2 = CollectionsKt.emptyList();
            }
            Object jwks = object2;
            String string = config.getSystemTime();
            if (string != null) {
                String it = string;
                boolean bl = false;
                v4 = Instant.parse(it);
            } else {
                v4 = systemTime = null;
            }
            if ((object = config.getKeyProvider()) == null || (object = ((KeyProviderConfig)object).getAlgorithm()) == null) {
                object = JWSAlgorithm.RS256.getName();
            }
            Object object4 = object;
            Intrinsics.checkNotNull((Object)object4);
            return new OAuth2TokenProvider(new KeyProvider((List<? extends JWK>)jwks, (String)object4), systemTime);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2TokenProviderDeserializer$KeyProviderConfig;", "", "initialKeys", "", "algorithm", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getInitialKeys", "()Ljava/lang/String;", "getAlgorithm", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "mock-oauth2-server"})
        public static final class KeyProviderConfig {
            @Nullable
            private final String initialKeys;
            @NotNull
            private final String algorithm;

            public KeyProviderConfig(@Nullable String initialKeys, @NotNull String algorithm) {
                Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
                this.initialKeys = initialKeys;
                this.algorithm = algorithm;
            }

            @Nullable
            public final String getInitialKeys() {
                return this.initialKeys;
            }

            @NotNull
            public final String getAlgorithm() {
                return this.algorithm;
            }

            @Nullable
            public final String component1() {
                return this.initialKeys;
            }

            @NotNull
            public final String component2() {
                return this.algorithm;
            }

            @NotNull
            public final KeyProviderConfig copy(@Nullable String initialKeys, @NotNull String algorithm) {
                Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
                return new KeyProviderConfig(initialKeys, algorithm);
            }

            public static /* synthetic */ KeyProviderConfig copy$default(KeyProviderConfig keyProviderConfig, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = keyProviderConfig.initialKeys;
                }
                if ((n & 2) != 0) {
                    string2 = keyProviderConfig.algorithm;
                }
                return keyProviderConfig.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "KeyProviderConfig(initialKeys=" + this.initialKeys + ", algorithm=" + this.algorithm + ")";
            }

            public int hashCode() {
                int result = this.initialKeys == null ? 0 : this.initialKeys.hashCode();
                result = result * 31 + this.algorithm.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof KeyProviderConfig)) {
                    return false;
                }
                KeyProviderConfig keyProviderConfig = (KeyProviderConfig)other;
                if (!Intrinsics.areEqual((Object)this.initialKeys, (Object)keyProviderConfig.initialKeys)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.algorithm, (Object)keyProviderConfig.algorithm);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2TokenProviderDeserializer$ProviderConfig;", "", "keyProvider", "Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2TokenProviderDeserializer$KeyProviderConfig;", "systemTime", "", "<init>", "(Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2TokenProviderDeserializer$KeyProviderConfig;Ljava/lang/String;)V", "getKeyProvider", "()Lno/nav/security/mock/oauth2/OAuth2Config$OAuth2TokenProviderDeserializer$KeyProviderConfig;", "getSystemTime", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "mock-oauth2-server"})
        public static final class ProviderConfig {
            @Nullable
            private final KeyProviderConfig keyProvider;
            @Nullable
            private final String systemTime;

            public ProviderConfig(@Nullable KeyProviderConfig keyProvider, @Nullable String systemTime) {
                this.keyProvider = keyProvider;
                this.systemTime = systemTime;
            }

            @Nullable
            public final KeyProviderConfig getKeyProvider() {
                return this.keyProvider;
            }

            @Nullable
            public final String getSystemTime() {
                return this.systemTime;
            }

            @Nullable
            public final KeyProviderConfig component1() {
                return this.keyProvider;
            }

            @Nullable
            public final String component2() {
                return this.systemTime;
            }

            @NotNull
            public final ProviderConfig copy(@Nullable KeyProviderConfig keyProvider, @Nullable String systemTime) {
                return new ProviderConfig(keyProvider, systemTime);
            }

            public static /* synthetic */ ProviderConfig copy$default(ProviderConfig providerConfig, KeyProviderConfig keyProviderConfig, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    keyProviderConfig = providerConfig.keyProvider;
                }
                if ((n & 2) != 0) {
                    string = providerConfig.systemTime;
                }
                return providerConfig.copy(keyProviderConfig, string);
            }

            @NotNull
            public String toString() {
                return "ProviderConfig(keyProvider=" + this.keyProvider + ", systemTime=" + this.systemTime + ")";
            }

            public int hashCode() {
                int result = this.keyProvider == null ? 0 : this.keyProvider.hashCode();
                result = result * 31 + (this.systemTime == null ? 0 : this.systemTime.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ProviderConfig)) {
                    return false;
                }
                ProviderConfig providerConfig = (ProviderConfig)other;
                if (!Intrinsics.areEqual((Object)this.keyProvider, (Object)providerConfig.keyProvider)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.systemTime, (Object)providerConfig.systemTime);
            }
        }
    }
}

