/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.grant;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2TokenResponse;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenProvider;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lno/nav/security/mock/oauth2/grant/PasswordGrantHandler;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "tokenProvider", "Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "<init>", "(Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;)V", "tokenResponse", "Lno/nav/security/mock/oauth2/http/OAuth2TokenResponse;", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "issuerUrl", "Lokhttp3/HttpUrl;", "oAuth2TokenCallback", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "PasswordGrantTokenCallback", "mock-oauth2-server"})
public final class PasswordGrantHandler
implements GrantHandler {
    @NotNull
    private final OAuth2TokenProvider tokenProvider;

    public PasswordGrantHandler(@NotNull OAuth2TokenProvider tokenProvider) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        this.tokenProvider = tokenProvider;
    }

    @Override
    @NotNull
    public OAuth2TokenResponse tokenResponse(@NotNull OAuth2HttpRequest request, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        TokenRequest tokenRequest = request.asNimbusTokenRequest();
        Scope scope = tokenRequest.getScope();
        String scope2 = scope != null ? scope.toString() : null;
        PasswordGrantTokenCallback passwordGrantTokenCallback = new PasswordGrantTokenCallback(oAuth2TokenCallback);
        SignedJWT accessToken = OAuth2TokenProvider.accessToken$default(this.tokenProvider, tokenRequest, issuerUrl, passwordGrantTokenCallback, null, 8, null);
        SignedJWT idToken = this.tokenProvider.idToken(tokenRequest, issuerUrl, passwordGrantTokenCallback, null);
        String string = accessToken.serialize();
        String string2 = idToken.serialize();
        int n = NimbusExtensionsKt.expiresIn(accessToken);
        return new OAuth2TokenResponse("Bearer", null, string2, string, null, n, scope2, 18, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0001J\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0001J\t\u0010\u000e\u001a\u00020\u0006H\u0096\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lno/nav/security/mock/oauth2/grant/PasswordGrantHandler$PasswordGrantTokenCallback;", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "tokenCallback", "<init>", "(Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;)V", "subject", "", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "addClaims", "", "", "audience", "", "issuerId", "tokenExpiry", "", "typeHeader", "mock-oauth2-server"})
    @SourceDebugExtension(value={"SMAP\nPasswordGrantHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasswordGrantHandler.kt\nno/nav/security/mock/oauth2/grant/PasswordGrantHandler$PasswordGrantTokenCallback\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
    private static final class PasswordGrantTokenCallback
    implements OAuth2TokenCallback {
        @NotNull
        private final OAuth2TokenCallback tokenCallback;

        public PasswordGrantTokenCallback(@NotNull OAuth2TokenCallback tokenCallback) {
            Intrinsics.checkNotNullParameter((Object)tokenCallback, (String)"tokenCallback");
            this.tokenCallback = tokenCallback;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @Nullable
        public String subject(@NotNull TokenRequest tokenRequest) {
            String string;
            Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
            AuthorizationGrant authorizationGrant = tokenRequest.getAuthorizationGrant();
            if (authorizationGrant != null) {
                String string2;
                AuthorizationGrant it = authorizationGrant;
                boolean bl = false;
                ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = it instanceof ResourceOwnerPasswordCredentialsGrant ? (ResourceOwnerPasswordCredentialsGrant)it : null;
                if (resourceOwnerPasswordCredentialsGrant != null && (string2 = resourceOwnerPasswordCredentialsGrant.getUsername()) != null) {
                    string = string2;
                    return string;
                }
            }
            string = this.tokenCallback.subject(tokenRequest);
            return string;
        }

        @Override
        @NotNull
        public String issuerId() {
            return this.tokenCallback.issuerId();
        }

        @Override
        @NotNull
        public String typeHeader(@NotNull TokenRequest tokenRequest) {
            Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
            return this.tokenCallback.typeHeader(tokenRequest);
        }

        @Override
        @NotNull
        public List<String> audience(@NotNull TokenRequest tokenRequest) {
            Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
            return this.tokenCallback.audience(tokenRequest);
        }

        @Override
        @NotNull
        public Map<String, Object> addClaims(@NotNull TokenRequest tokenRequest) {
            Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
            return this.tokenCallback.addClaims(tokenRequest);
        }

        @Override
        public long tokenExpiry() {
            return this.tokenCallback.tokenExpiry();
        }
    }
}

