/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.mock.oauth2.http.Interceptor;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRouterKt;
import no.nav.security.mock.oauth2.http.PathRoute;
import no.nav.security.mock.oauth2.http.RequestInterceptor;
import no.nav.security.mock.oauth2.http.ResponseInterceptor;
import no.nav.security.mock.oauth2.http.Route;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BA\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u001c\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\bj\u0002`\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0011\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tH\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J*\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u0017j\u0002`\u0018*\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0011\u001a\u00020\tH\u0002J2\u0010\u0019\u001a\u00020\u000b*\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u0017j\u0002`\u00182\u0006\u0010\u0011\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\tH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lno/nav/security/mock/oauth2/http/PathRouter;", "Lno/nav/security/mock/oauth2/http/PathRoute;", "routes", "", "Lno/nav/security/mock/oauth2/http/Route;", "interceptors", "Lno/nav/security/mock/oauth2/http/Interceptor;", "exceptionHandler", "Lkotlin/Function2;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "Lno/nav/security/mock/oauth2/http/ExceptionHandler;", "<init>", "(Ljava/util/List;Ljava/util/List;Lkotlin/jvm/functions/Function2;)V", "matchPath", "", "request", "match", "invoke", "toString", "", "findHandler", "Lkotlin/Function1;", "Lno/nav/security/mock/oauth2/http/RequestHandler;", "invokeWith", "noMatch", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nOAuth2HttpRouter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2HttpRouter.kt\nno/nav/security/mock/oauth2/http/PathRouter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1761#2,3:216\n295#2,2:219\n295#2,2:221\n808#2,11:223\n1803#2,3:234\n808#2,11:237\n1803#2,3:248\n*S KotlinDebug\n*F\n+ 1 OAuth2HttpRouter.kt\nno/nav/security/mock/oauth2/http/PathRouter\n*L\n113#1:216,3\n115#1:219,2\n126#1:221,2\n134#1:223,11\n134#1:234,3\n139#1:237,11\n139#1:248,3\n*E\n"})
public final class PathRouter
implements PathRoute {
    @NotNull
    private final List<Route> routes;
    @NotNull
    private final List<Interceptor> interceptors;
    @NotNull
    private final Function2<OAuth2HttpRequest, Throwable, OAuth2HttpResponse> exceptionHandler;

    public PathRouter(@NotNull List<Route> routes, @NotNull List<Interceptor> interceptors, @NotNull Function2<? super OAuth2HttpRequest, ? super Throwable, OAuth2HttpResponse> exceptionHandler2) {
        Intrinsics.checkNotNullParameter(routes, (String)"routes");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        Intrinsics.checkNotNullParameter(exceptionHandler2, (String)"exceptionHandler");
        this.routes = routes;
        this.interceptors = interceptors;
        this.exceptionHandler = exceptionHandler2;
    }

    @Override
    public boolean matchPath(@NotNull OAuth2HttpRequest request) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Iterable $this$any$iv = this.routes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Route it = (Route)element$iv;
                    boolean bl2 = false;
                    if (!this.matchPath(it, request)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean match(@NotNull OAuth2HttpRequest request) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Iterable $this$firstOrNull$iv = this.routes;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Route it = (Route)element$iv;
                boolean bl = false;
                if (!it.match(request)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    @NotNull
    public OAuth2HttpResponse invoke(@NotNull OAuth2HttpRequest request) {
        Object object;
        Object $this$invoke_u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object2 = this;
        try {
            $this$invoke_u24lambda_u242 = object2;
            boolean bl = false;
            $this$invoke_u24lambda_u242 = Result.constructor-impl((Object)super.invokeWith(super.findHandler(((PathRouter)$this$invoke_u24lambda_u242).routes, request), request, ((PathRouter)$this$invoke_u24lambda_u242).interceptors));
        }
        catch (Throwable bl) {
            $this$invoke_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$invoke_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = (OAuth2HttpResponse)this.exceptionHandler.invoke((Object)request, (Object)it);
        }
        return (OAuth2HttpResponse)object;
    }

    @NotNull
    public String toString() {
        return this.routes.toString();
    }

    private final Function1<OAuth2HttpRequest, OAuth2HttpResponse> findHandler(List<Route> $this$findHandler, OAuth2HttpRequest request) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$findHandler;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Route it = (Route)element$iv;
                boolean bl = false;
                if (!it.match(request)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Route route = v0;
        return route != null ? (Function1)route : arg_0 -> PathRouter.findHandler$lambda$5(this, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private final OAuth2HttpResponse invokeWith(Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> $this$invokeWith, OAuth2HttpRequest request, List<Interceptor> interceptors) {
        OAuth2HttpResponse oAuth2HttpResponse;
        if (interceptors.size() > 0) {
            OAuth2HttpResponse filteredResponse;
            void $this$fold$iv;
            void $this$filterIsInstanceTo$iv$iv;
            void $this$fold$iv2;
            void $this$filterIsInstanceTo$iv$iv2;
            Iterable $this$filterIsInstance$iv = interceptors;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof RequestInterceptor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$fold = false;
            OAuth2HttpRequest accumulator$iv = request;
            for (Object element$iv : $this$fold$iv2) {
                void interceptor;
                RequestInterceptor requestInterceptor = (RequestInterceptor)element$iv;
                OAuth2HttpRequest next = accumulator$iv;
                boolean bl = false;
                accumulator$iv = interceptor.intercept(next);
            }
            OAuth2HttpRequest filteredRequest = accumulator$iv;
            OAuth2HttpResponse res = (OAuth2HttpResponse)$this$invokeWith.invoke((Object)filteredRequest);
            Iterable $this$filterIsInstance$iv2 = interceptors;
            boolean $i$f$filterIsInstance2 = false;
            Iterable element$iv = $this$filterIsInstance$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo2 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ResponseInterceptor)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
            OAuth2HttpResponse initial$iv = OAuth2HttpResponse.copy$default(res, null, 0, null, null, 15, null);
            boolean $i$f$fold2 = false;
            OAuth2HttpResponse accumulator$iv2 = initial$iv;
            for (Object element$iv2 : $this$fold$iv) {
                void interceptor;
                Object element$iv$iv;
                element$iv$iv = (ResponseInterceptor)element$iv2;
                OAuth2HttpResponse next = accumulator$iv2;
                boolean bl = false;
                accumulator$iv2 = interceptor.intercept(request, next);
            }
            oAuth2HttpResponse = filteredResponse = accumulator$iv2;
        } else {
            oAuth2HttpResponse = (OAuth2HttpResponse)$this$invokeWith.invoke((Object)request);
        }
        return oAuth2HttpResponse;
    }

    private final OAuth2HttpResponse noMatch(OAuth2HttpRequest request) {
        OAuth2HttpRouterKt.access$getLog$p().debug("no route matching url=" + request.getUrl() + " with method=" + request.getMethod());
        return this.matchPath(request) ? OAuth2HttpResponseKt.methodNotAllowed() : OAuth2HttpResponseKt.notFound("no routes found");
    }

    private final boolean matchPath(Route $this$matchPath, OAuth2HttpRequest request) {
        PathRoute pathRoute = $this$matchPath instanceof PathRoute ? (PathRoute)$this$matchPath : null;
        return pathRoute != null ? pathRoute.matchPath(request) : false;
    }

    private static final OAuth2HttpResponse findHandler$lambda$5(PathRouter this$0, OAuth2HttpRequest req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        return this$0.noMatch(req);
    }
}

