/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.token;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.oauth2.sdk.TokenRequest;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c2\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J=\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lno/nav/security/mock/oauth2/token/RequestMapping;", "", "requestParam", "", "match", "claims", "", "typeHeader", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "getClaims", "()Ljava/util/Map;", "getTypeHeader", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "isMatch", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "toString", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nOAuth2TokenCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2TokenCallback.kt\nno/nav/security/mock/oauth2/token/RequestMapping\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1747#2,3:150\n*S KotlinDebug\n*F\n+ 1 OAuth2TokenCallback.kt\nno/nav/security/mock/oauth2/token/RequestMapping\n*L\n144#1:150,3\n*E\n"})
public final class RequestMapping {
    @NotNull
    private final String requestParam;
    @NotNull
    private final String match;
    @NotNull
    private final Map<String, Object> claims;
    @NotNull
    private final String typeHeader;

    public RequestMapping(@NotNull String requestParam, @NotNull String match, @NotNull Map<String, ? extends Object> claims, @NotNull String typeHeader) {
        Intrinsics.checkNotNullParameter((Object)requestParam, (String)"requestParam");
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        Intrinsics.checkNotNullParameter((Object)typeHeader, (String)"typeHeader");
        this.requestParam = requestParam;
        this.match = match;
        this.claims = claims;
        this.typeHeader = typeHeader;
    }

    public /* synthetic */ RequestMapping(String string, String string2, Map map, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            String string4 = JOSEObjectType.JWT.getType();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getType(...)");
            string3 = string4;
        }
        this(string, string2, map, string3);
    }

    @NotNull
    public final Map<String, Object> getClaims() {
        return this.claims;
    }

    @NotNull
    public final String getTypeHeader() {
        return this.typeHeader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMatch(@NotNull TokenRequest tokenRequest) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        List list = (List)tokenRequest.toHTTPRequest().getBodyAsFormParameters().get(this.requestParam);
        if (list == null) return false;
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)this.match, (Object)"*")) return true;
            if (Intrinsics.areEqual((Object)this.match, (Object)it)) return true;
            Regex regex = new Regex(this.match);
            Intrinsics.checkNotNull((Object)it);
            if (regex.matchEntire((CharSequence)it) != null) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final String component1() {
        return this.requestParam;
    }

    private final String component2() {
        return this.match;
    }

    @NotNull
    public final Map<String, Object> component3() {
        return this.claims;
    }

    @NotNull
    public final String component4() {
        return this.typeHeader;
    }

    @NotNull
    public final RequestMapping copy(@NotNull String requestParam, @NotNull String match, @NotNull Map<String, ? extends Object> claims, @NotNull String typeHeader) {
        Intrinsics.checkNotNullParameter((Object)requestParam, (String)"requestParam");
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        Intrinsics.checkNotNullParameter((Object)typeHeader, (String)"typeHeader");
        return new RequestMapping(requestParam, match, claims, typeHeader);
    }

    public static /* synthetic */ RequestMapping copy$default(RequestMapping requestMapping, String string, String string2, Map map, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = requestMapping.requestParam;
        }
        if ((n & 2) != 0) {
            string2 = requestMapping.match;
        }
        if ((n & 4) != 0) {
            map = requestMapping.claims;
        }
        if ((n & 8) != 0) {
            string3 = requestMapping.typeHeader;
        }
        return requestMapping.copy(string, string2, map, string3);
    }

    @NotNull
    public String toString() {
        return "RequestMapping(requestParam=" + this.requestParam + ", match=" + this.match + ", claims=" + this.claims + ", typeHeader=" + this.typeHeader + ")";
    }

    public int hashCode() {
        int result = this.requestParam.hashCode();
        result = result * 31 + this.match.hashCode();
        result = result * 31 + ((Object)this.claims).hashCode();
        result = result * 31 + this.typeHeader.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RequestMapping)) {
            return false;
        }
        RequestMapping requestMapping = (RequestMapping)other;
        if (!Intrinsics.areEqual((Object)this.requestParam, (Object)requestMapping.requestParam)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.match, (Object)requestMapping.match)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.claims, requestMapping.claims)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.typeHeader, (Object)requestMapping.typeHeader);
    }
}

