/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.debugger;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.DirectDecrypter;
import com.nimbusds.jose.crypto.DirectEncrypter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.mock.oauth2.debugger.SessionManagerKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lno/nav/security/mock/oauth2/debugger/SessionManager;", "", "()V", "encryptionKey", "Ljavax/crypto/SecretKey;", "session", "Lno/nav/security/mock/oauth2/debugger/SessionManager$Session;", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "Session", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionManager.kt\nno/nav/security/mock/oauth2/debugger/SessionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class SessionManager {
    @NotNull
    private final SecretKey encryptionKey;

    /*
     * WARNING - void declaration
     */
    public SessionManager() {
        void $this$encryptionKey_u24lambda_u240;
        KeyGenerator keyGenerator;
        KeyGenerator keyGenerator2 = keyGenerator = KeyGenerator.getInstance("AES");
        SessionManager sessionManager = this;
        boolean bl = false;
        $this$encryptionKey_u24lambda_u240.init(128);
        SecretKey secretKey = keyGenerator.generateKey();
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"generateKey(...)");
        sessionManager.encryptionKey = secretKey;
    }

    @NotNull
    public final Session session(@NotNull OAuth2HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new Session(this.encryptionKey, request);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\tJ\u0011\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0086\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0015J\u001b\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0086\u0002J\u0014\u0010\u0018\u001a\u00020\t*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0014\u0010\u0019\u001a\u00020\t*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lno/nav/security/mock/oauth2/debugger/SessionManager$Session;", "", "encryptionKey", "Ljavax/crypto/SecretKey;", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "(Ljavax/crypto/SecretKey;Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;)V", "parameters", "", "", "getParameters", "()Ljava/util/Map;", "getRequest", "()Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "asCookie", "get", "key", "getSessionCookie", "putAll", "", "map", "", "set", "value", "decrypt", "encrypt", "Companion", "mock-oauth2-server"})
    @SourceDebugExtension(value={"SMAP\nSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionManager.kt\nno/nav/security/mock/oauth2/debugger/SessionManager$Session\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,75:1\n1#2:76\n56#3:77\n49#3:78\n*S KotlinDebug\n*F\n+ 1 SessionManager.kt\nno/nav/security/mock/oauth2/debugger/SessionManager$Session\n*L\n30#1:77\n30#1:78\n*E\n"})
    public static final class Session {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SecretKey encryptionKey;
        @NotNull
        private final OAuth2HttpRequest request;
        @NotNull
        private final Map<String, String> parameters;
        @NotNull
        public static final String DEBUGGER_SESSION_COOKIE = "debugger-session";

        /*
         * WARNING - void declaration
         */
        public Session(@NotNull SecretKey encryptionKey, @NotNull OAuth2HttpRequest request) {
            Object object;
            block3: {
                block2: {
                    void it;
                    Intrinsics.checkNotNullParameter((Object)encryptionKey, (String)"encryptionKey");
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    this.encryptionKey = encryptionKey;
                    this.request = request;
                    Session session = this;
                    object = this.getSessionCookie();
                    if (object == null) break block2;
                    String string = object;
                    Session session2 = session;
                    boolean bl = false;
                    ObjectMapper $this$readValue$iv = OAuth2HttpResponseKt.getObjectMapper();
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    Map map = (Map)$this$readValue$iv.readValue((String)it, (TypeReference)new TypeReference<Map<String, String>>(){});
                    session = session2;
                    object = map;
                    if (map != null) break block3;
                }
                object = new LinkedHashMap();
            }
            session.parameters = object;
        }

        @NotNull
        public final OAuth2HttpRequest getRequest() {
            return this.request;
        }

        @NotNull
        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        public final void putAll(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.parameters.putAll(map);
        }

        @NotNull
        public final String get(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String string = this.parameters.get(key);
            if (string == null) {
                throw new RuntimeException("could not get " + key + " from session.");
            }
            return string;
        }

        @Nullable
        public final String set(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.parameters.put(key, value);
        }

        @NotNull
        public final String asCookie() {
            String string = OAuth2HttpResponseKt.getObjectMapper().writeValueAsString(this.parameters);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            String it = this.encrypt(string, this.encryptionKey);
            boolean bl = false;
            return "debugger-session=" + it + "; HttpOnly; Path=/";
        }

        private final String encrypt(String $this$encrypt, SecretKey key) {
            JWEObject jWEObject;
            JWEObject it = jWEObject = new JWEObject(new JWEHeader(JWEAlgorithm.DIR, EncryptionMethod.A128GCM), new Payload($this$encrypt));
            boolean bl = false;
            it.encrypt((JWEEncrypter)new DirectEncrypter(key));
            String string = jWEObject.serialize();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize(...)");
            return string;
        }

        private final String decrypt(String $this$decrypt, SecretKey key) {
            JWEObject jWEObject;
            JWEObject it = jWEObject = JWEObject.parse((String)$this$decrypt);
            boolean bl = false;
            it.decrypt((JWEDecrypter)new DirectDecrypter(key));
            String string = jWEObject.getPayload().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String getSessionCookie() {
            String string;
            Object $this$getSessionCookie_u24lambda_u244;
            Object object = this;
            try {
                $this$getSessionCookie_u24lambda_u244 = object;
                boolean bl = false;
                String string2 = ((Session)$this$getSessionCookie_u24lambda_u244).request.getCookies().get(DEBUGGER_SESSION_COOKIE);
                $this$getSessionCookie_u24lambda_u244 = Result.constructor-impl(string2 != null ? super.decrypt(string2, ((Session)$this$getSessionCookie_u24lambda_u244).encryptionKey) : null);
            }
            catch (Throwable bl) {
                $this$getSessionCookie_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$getSessionCookie_u24lambda_u244;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) {
                String result = (String)object;
                boolean bl = false;
                string = result;
            } else {
                Throwable error = throwable;
                boolean bl = false;
                SessionManagerKt.access$getLog$p().error("received exception when decrypting cookie", error);
                string = null;
            }
            return string;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lno/nav/security/mock/oauth2/debugger/SessionManager$Session$Companion;", "", "()V", "DEBUGGER_SESSION_COOKIE", "", "mock-oauth2-server"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

