/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.grant;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.grant.AuthorizationCodeHandlerKt;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import no.nav.security.mock.oauth2.grant.RefreshTokenManager;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2TokenResponse;
import no.nav.security.mock.oauth2.login.Login;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenProvider;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\rJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lno/nav/security/mock/oauth2/grant/AuthorizationCodeHandler;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "tokenProvider", "Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "refreshTokenManager", "Lno/nav/security/mock/oauth2/grant/RefreshTokenManager;", "<init>", "(Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;Lno/nav/security/mock/oauth2/grant/RefreshTokenManager;)V", "codeToAuthRequestCache", "", "Lcom/nimbusds/oauth2/sdk/AuthorizationCode;", "Lcom/nimbusds/openid/connect/sdk/AuthenticationRequest;", "codeToLoginCache", "Lno/nav/security/mock/oauth2/login/Login;", "authorizationCodeResponse", "Lcom/nimbusds/openid/connect/sdk/AuthenticationSuccessResponse;", "authenticationRequest", "login", "tokenResponse", "Lno/nav/security/mock/oauth2/http/OAuth2TokenResponse;", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "issuerUrl", "Lokhttp3/HttpUrl;", "oAuth2TokenCallback", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "getLoginTokenCallbackOrDefault", "code", "OAuth2TokenCallback", "takeLoginFromCache", "takeAuthenticationRequestFromCache", "LoginOAuth2TokenCallback", "mock-oauth2-server"})
public final class AuthorizationCodeHandler
implements GrantHandler {
    @NotNull
    private final OAuth2TokenProvider tokenProvider;
    @NotNull
    private final RefreshTokenManager refreshTokenManager;
    @NotNull
    private final Map<AuthorizationCode, AuthenticationRequest> codeToAuthRequestCache;
    @NotNull
    private final Map<AuthorizationCode, Login> codeToLoginCache;

    public AuthorizationCodeHandler(@NotNull OAuth2TokenProvider tokenProvider, @NotNull RefreshTokenManager refreshTokenManager) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        Intrinsics.checkNotNullParameter((Object)refreshTokenManager, (String)"refreshTokenManager");
        this.tokenProvider = tokenProvider;
        this.refreshTokenManager = refreshTokenManager;
        this.codeToAuthRequestCache = new HashMap();
        this.codeToLoginCache = new HashMap();
    }

    @NotNull
    public final AuthenticationSuccessResponse authorizationCodeResponse(@NotNull AuthenticationRequest authenticationRequest, @Nullable Login login) {
        Intrinsics.checkNotNullParameter((Object)authenticationRequest, (String)"authenticationRequest");
        if (authenticationRequest.getResponseType().impliesCodeFlow()) {
            AuthorizationCode code = new AuthorizationCode();
            AuthorizationCodeHandlerKt.access$getLog$p().debug("issuing authorization code " + code);
            this.codeToAuthRequestCache.put(code, authenticationRequest);
            Login login2 = login;
            if (login2 != null) {
                Login login3;
                Login it = login3 = login2;
                boolean bl = false;
                AuthorizationCodeHandlerKt.access$getLog$p().debug("adding user with username " + it.getUsername() + " to cache");
                this.codeToLoginCache.put(code, login);
            }
            return new AuthenticationSuccessResponse(authenticationRequest.getRedirectionURI(), code, null, null, authenticationRequest.getState(), null, authenticationRequest.getResponseMode());
        }
        throw new OAuth2Exception(OAuth2Error.INVALID_GRANT, "hybrid og implicit flow not supported (yet).");
    }

    public static /* synthetic */ AuthenticationSuccessResponse authorizationCodeResponse$default(AuthorizationCodeHandler authorizationCodeHandler, AuthenticationRequest authenticationRequest, Login login, int n, Object object) {
        if ((n & 2) != 0) {
            login = null;
        }
        return authorizationCodeHandler.authorizationCodeResponse(authenticationRequest, login);
    }

    @Override
    @NotNull
    public OAuth2TokenResponse tokenResponse(@NotNull OAuth2HttpRequest request, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        AuthenticationRequest authenticationRequest;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        TokenRequest tokenRequest = request.asNimbusTokenRequest();
        AuthorizationCode code = NimbusExtensionsKt.authorizationCode(tokenRequest);
        AuthorizationCodeHandlerKt.access$getLog$p().debug("issuing token for code=" + code);
        AuthenticationRequest authenticationRequest2 = authenticationRequest = this.takeAuthenticationRequestFromCache(code);
        if (authenticationRequest2 != null) {
            NimbusExtensionsKt.verifyPkce(authenticationRequest2, tokenRequest);
        }
        Scope scope = tokenRequest.getScope();
        String scope2 = scope != null ? scope.toString() : null;
        AuthenticationRequest authenticationRequest3 = authenticationRequest;
        String nonce = authenticationRequest3 != null && (authenticationRequest3 = authenticationRequest3.getNonce()) != null ? authenticationRequest3.getValue() : null;
        OAuth2TokenCallback loginTokenCallbackOrDefault = this.getLoginTokenCallbackOrDefault(code, oAuth2TokenCallback);
        SignedJWT idToken = this.tokenProvider.idToken(tokenRequest, issuerUrl, loginTokenCallbackOrDefault, nonce);
        SignedJWT accessToken = this.tokenProvider.accessToken(tokenRequest, issuerUrl, loginTokenCallbackOrDefault, nonce);
        String refreshToken = this.refreshTokenManager.refreshToken(loginTokenCallbackOrDefault, nonce);
        return new OAuth2TokenResponse("Bearer", null, idToken.serialize(), accessToken.serialize(), refreshToken, NimbusExtensionsKt.expiresIn(idToken), scope2, 2, null);
    }

    private final OAuth2TokenCallback getLoginTokenCallbackOrDefault(AuthorizationCode code, OAuth2TokenCallback OAuth2TokenCallback2) {
        OAuth2TokenCallback oAuth2TokenCallback;
        Login login = this.takeLoginFromCache(code);
        if (login != null) {
            Login it = login;
            boolean bl = false;
            oAuth2TokenCallback = new LoginOAuth2TokenCallback(it, OAuth2TokenCallback2);
        } else {
            oAuth2TokenCallback = OAuth2TokenCallback2;
        }
        return oAuth2TokenCallback;
    }

    private final Login takeLoginFromCache(AuthorizationCode code) {
        return this.codeToLoginCache.remove(code);
    }

    private final AuthenticationRequest takeAuthenticationRequestFromCache(AuthorizationCode code) {
        return this.codeToAuthRequestCache.remove(code);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lno/nav/security/mock/oauth2/grant/AuthorizationCodeHandler$LoginOAuth2TokenCallback;", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "login", "Lno/nav/security/mock/oauth2/login/Login;", "oAuth2TokenCallback", "<init>", "(Lno/nav/security/mock/oauth2/login/Login;Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;)V", "getLogin", "()Lno/nav/security/mock/oauth2/login/Login;", "getOAuth2TokenCallback", "()Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "issuerId", "", "subject", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "typeHeader", "audience", "", "addClaims", "", "", "tokenExpiry", "", "mock-oauth2-server"})
    @SourceDebugExtension(value={"SMAP\nAuthorizationCodeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationCodeHandler.kt\nno/nav/security/mock/oauth2/grant/AuthorizationCodeHandler$LoginOAuth2TokenCallback\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,133:1\n32#2:134\n33#2:137\n56#3:135\n49#3:136\n*S KotlinDebug\n*F\n+ 1 AuthorizationCodeHandler.kt\nno/nav/security/mock/oauth2/grant/AuthorizationCodeHandler$LoginOAuth2TokenCallback\n*L\n121#1:134\n121#1:137\n122#1:135\n122#1:136\n*E\n"})
    private static final class LoginOAuth2TokenCallback
    implements OAuth2TokenCallback {
        @NotNull
        private final Login login;
        @NotNull
        private final OAuth2TokenCallback oAuth2TokenCallback;

        public LoginOAuth2TokenCallback(@NotNull Login login, @NotNull OAuth2TokenCallback oAuth2TokenCallback) {
            Intrinsics.checkNotNullParameter((Object)login, (String)"login");
            Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
            this.login = login;
            this.oAuth2TokenCallback = oAuth2TokenCallback;
        }

        @NotNull
        public final Login getLogin() {
            return this.login;
        }

        @NotNull
        public final OAuth2TokenCallback getOAuth2TokenCallback() {
            return this.oAuth2TokenCallback;
        }

        @Override
        @NotNull
        public String issuerId() {
            return this.oAuth2TokenCallback.issuerId();
        }

        @Override
        @NotNull
        public String subject(@NotNull TokenRequest tokenRequest) {
            Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
            return this.login.getUsername();
        }

        @Override
        @NotNull
        public String typeHeader(@NotNull TokenRequest tokenRequest) {
            Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
            return this.oAuth2TokenCallback.typeHeader(tokenRequest);
        }

        @Override
        @NotNull
        public List<String> audience(@NotNull TokenRequest tokenRequest) {
            Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
            return this.oAuth2TokenCallback.audience(tokenRequest);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Map<String, Object> addClaims(@NotNull TokenRequest tokenRequest) {
            Map map;
            block3: {
                Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
                Map $this$addClaims_u24lambda_u242 = map = MapsKt.toMutableMap(this.oAuth2TokenCallback.addClaims(tokenRequest));
                boolean bl = false;
                String string = this.login.getClaims();
                if (string == null) break block3;
                String it = string;
                boolean bl2 = false;
                try {
                    void $this$forEach$iv;
                    Iterator iterator = AuthorizationCodeHandlerKt.access$getJsonMapper$p().readTree(it).fields();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fields(...)");
                    Iterator iterator2 = iterator;
                    boolean $i$f$forEach = false;
                    void var9_10 = $this$forEach$iv;
                    while (var9_10.hasNext()) {
                        String content$iv;
                        void $this$readValue$iv;
                        Object element$iv = var9_10.next();
                        Map.Entry field = (Map.Entry)element$iv;
                        boolean bl3 = false;
                        Object k = field.getKey();
                        Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                        ObjectMapper objectMapper = AuthorizationCodeHandlerKt.access$getJsonMapper$p();
                        Intrinsics.checkNotNullExpressionValue((Object)((JsonNode)field.getValue()).toString(), (String)"toString(...)");
                        boolean $i$f$readValue = false;
                        boolean $i$f$jacksonTypeRef = false;
                        $this$addClaims_u24lambda_u242.put(k, $this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<Object>(){}));
                    }
                }
                catch (JsonProcessingException exception) {
                    AuthorizationCodeHandlerKt.access$getLog$p().warn("claims value " + it + " could not be processed as JSON, details: " + exception.getMessage());
                }
            }
            return map;
        }

        @Override
        public long tokenExpiry() {
            return this.oAuth2TokenCallback.tokenExpiry();
        }
    }
}

