/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.grant;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.OAuth2ExceptionKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import no.nav.security.mock.oauth2.grant.RefreshTokenGrantHandlerKt;
import no.nav.security.mock.oauth2.grant.RefreshTokenManager;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2TokenResponse;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenProvider;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lno/nav/security/mock/oauth2/grant/RefreshTokenGrantHandler;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "tokenProvider", "Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "refreshTokenManager", "Lno/nav/security/mock/oauth2/grant/RefreshTokenManager;", "rotateRefreshToken", "", "<init>", "(Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;Lno/nav/security/mock/oauth2/grant/RefreshTokenManager;Z)V", "tokenResponse", "Lno/nav/security/mock/oauth2/http/OAuth2TokenResponse;", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "issuerUrl", "Lokhttp3/HttpUrl;", "oAuth2TokenCallback", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "refreshTokenGrant", "Lcom/nimbusds/oauth2/sdk/RefreshTokenGrant;", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "mock-oauth2-server"})
public final class RefreshTokenGrantHandler
implements GrantHandler {
    @NotNull
    private final OAuth2TokenProvider tokenProvider;
    @NotNull
    private final RefreshTokenManager refreshTokenManager;
    private final boolean rotateRefreshToken;

    public RefreshTokenGrantHandler(@NotNull OAuth2TokenProvider tokenProvider, @NotNull RefreshTokenManager refreshTokenManager, boolean rotateRefreshToken) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        Intrinsics.checkNotNullParameter((Object)refreshTokenManager, (String)"refreshTokenManager");
        this.tokenProvider = tokenProvider;
        this.refreshTokenManager = refreshTokenManager;
        this.rotateRefreshToken = rotateRefreshToken;
    }

    public /* synthetic */ RefreshTokenGrantHandler(OAuth2TokenProvider oAuth2TokenProvider, RefreshTokenManager refreshTokenManager, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(oAuth2TokenProvider, refreshTokenManager, bl);
    }

    @Override
    @NotNull
    public OAuth2TokenResponse tokenResponse(@NotNull OAuth2HttpRequest request, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        OAuth2TokenCallback refreshTokenCallbackOrDefault;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        TokenRequest tokenRequest = request.asNimbusTokenRequest();
        String refreshToken = this.refreshTokenGrant(tokenRequest).getRefreshToken().getValue();
        RefreshTokenGrantHandlerKt.access$getLog$p().debug("issuing token for refreshToken=" + refreshToken);
        Scope scope = tokenRequest.getScope();
        String scope2 = scope != null ? scope.toString() : null;
        String string = refreshToken;
        Intrinsics.checkNotNull((Object)string);
        OAuth2TokenCallback oAuth2TokenCallback2 = this.refreshTokenManager.get(string);
        if (oAuth2TokenCallback2 == null) {
            oAuth2TokenCallback2 = refreshTokenCallbackOrDefault = oAuth2TokenCallback;
        }
        if (this.rotateRefreshToken) {
            String string2 = refreshToken;
            Intrinsics.checkNotNull((Object)string2);
            refreshToken = this.refreshTokenManager.rotate(string2, refreshTokenCallbackOrDefault);
        }
        SignedJWT idToken = OAuth2TokenProvider.idToken$default(this.tokenProvider, tokenRequest, issuerUrl, refreshTokenCallbackOrDefault, null, 8, null);
        SignedJWT accessToken = OAuth2TokenProvider.accessToken$default(this.tokenProvider, tokenRequest, issuerUrl, refreshTokenCallbackOrDefault, null, 8, null);
        return new OAuth2TokenResponse("Bearer", null, idToken.serialize(), accessToken.serialize(), refreshToken, NimbusExtensionsKt.expiresIn(idToken), scope2, 2, null);
    }

    private final RefreshTokenGrant refreshTokenGrant(TokenRequest $this$refreshTokenGrant) {
        AuthorizationGrant authorizationGrant = $this$refreshTokenGrant.getAuthorizationGrant();
        RefreshTokenGrant refreshTokenGrant = authorizationGrant instanceof RefreshTokenGrant ? (RefreshTokenGrant)authorizationGrant : null;
        if (refreshTokenGrant == null) {
            GrantType grantType = GrantType.REFRESH_TOKEN;
            Intrinsics.checkNotNullExpressionValue((Object)grantType, (String)"REFRESH_TOKEN");
            OAuth2ExceptionKt.invalidGrant(grantType);
            throw new KotlinNothingValueException();
        }
        return refreshTokenGrant;
    }
}

