/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import java.net.InetAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.extensions.AsOAuth2HttpRequestKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpServer;
import no.nav.security.mock.oauth2.http.OAuth2HttpServerKt;
import no.nav.security.mock.oauth2.http.Ssl;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001eB\u0015\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014j\u0002`\u0013H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0001H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lno/nav/security/mock/oauth2/http/MockWebServerWrapper;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpServer;", "ssl", "Lno/nav/security/mock/oauth2/http/Ssl;", "<init>", "(Lno/nav/security/mock/oauth2/http/Ssl;)V", "getSsl", "()Lno/nav/security/mock/oauth2/http/Ssl;", "mockWebServer", "Lokhttp3/mockwebserver/MockWebServer;", "getMockWebServer", "()Lokhttp3/mockwebserver/MockWebServer;", "address", "Ljava/net/InetAddress;", "start", "inetAddress", "port", "", "requestHandler", "Lno/nav/security/mock/oauth2/http/RequestHandler;", "Lkotlin/Function1;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "(Ljava/net/InetAddress;ILkotlin/jvm/functions/Function1;)Lno/nav/security/mock/oauth2/http/OAuth2HttpServer;", "stop", "url", "Lokhttp3/HttpUrl;", "path", "", "sslConfig", "MockWebServerDispatcher", "mock-oauth2-server"})
public final class MockWebServerWrapper
implements OAuth2HttpServer {
    @Nullable
    private final Ssl ssl;
    @NotNull
    private final MockWebServer mockWebServer;
    @Nullable
    private InetAddress address;

    @JvmOverloads
    public MockWebServerWrapper(@Nullable Ssl ssl) {
        this.ssl = ssl;
        this.mockWebServer = new MockWebServer();
    }

    public /* synthetic */ MockWebServerWrapper(Ssl ssl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ssl = null;
        }
        this(ssl);
    }

    @Nullable
    public final Ssl getSsl() {
        return this.ssl;
    }

    @NotNull
    public final MockWebServer getMockWebServer() {
        return this.mockWebServer;
    }

    @Override
    @NotNull
    public OAuth2HttpServer start(@NotNull InetAddress inetAddress, int port, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        MockWebServerWrapper mockWebServerWrapper;
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        MockWebServerWrapper $this$start_u24lambda_u240 = mockWebServerWrapper = this;
        boolean bl = false;
        $this$start_u24lambda_u240.mockWebServer.start(inetAddress, port);
        $this$start_u24lambda_u240.mockWebServer.setDispatcher((Dispatcher)new MockWebServerDispatcher(requestHandler, null, 2, null));
        if ($this$start_u24lambda_u240.ssl != null) {
            MockWebServer mockWebServer = $this$start_u24lambda_u240.mockWebServer;
            SSLSocketFactory sSLSocketFactory = $this$start_u24lambda_u240.ssl.sslContext().getSocketFactory();
            Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"getSocketFactory(...)");
            mockWebServer.useHttps(sSLSocketFactory, false);
        }
        $this$start_u24lambda_u240.address = inetAddress;
        OAuth2HttpServerKt.access$getLog$p().debug("started server on address=" + inetAddress + " and port=" + $this$start_u24lambda_u240.mockWebServer.getPort() + ", httpsEnabled=" + ($this$start_u24lambda_u240.ssl != null));
        return mockWebServerWrapper;
    }

    @Override
    @NotNull
    public OAuth2HttpServer stop() {
        MockWebServerWrapper mockWebServerWrapper;
        MockWebServerWrapper $this$stop_u24lambda_u241 = mockWebServerWrapper = this;
        boolean bl = false;
        $this$stop_u24lambda_u241.mockWebServer.shutdown();
        return mockWebServerWrapper;
    }

    @Override
    public int port() {
        return this.mockWebServer.getPort();
    }

    @Override
    @NotNull
    public HttpUrl url(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        HttpUrl.Builder builder = this.mockWebServer.url(path).newBuilder();
        Object object = this.address;
        if (object == null || (object = ((InetAddress)object).getHostName()) == null) {
            object = this.mockWebServer.getHostName();
        }
        return builder.host((String)object).build();
    }

    @Override
    @Nullable
    public Ssl sslConfig() {
        return this.ssl;
    }

    @Override
    @NotNull
    public OAuth2HttpServer start(@NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        return OAuth2HttpServer.DefaultImpls.start(this, requestHandler);
    }

    @Override
    @NotNull
    public OAuth2HttpServer start(int port, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        return OAuth2HttpServer.DefaultImpls.start(this, port, requestHandler);
    }

    @Override
    public void close() {
        OAuth2HttpServer.DefaultImpls.close(this);
    }

    @JvmOverloads
    public MockWebServerWrapper() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\t*\u00020\u0006H\u0002R \u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lno/nav/security/mock/oauth2/http/MockWebServerWrapper$MockWebServerDispatcher;", "Lokhttp3/mockwebserver/Dispatcher;", "requestHandler", "Lno/nav/security/mock/oauth2/http/RequestHandler;", "Lkotlin/Function1;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "responseQueue", "Ljava/util/concurrent/BlockingQueue;", "Lokhttp3/mockwebserver/MockResponse;", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/BlockingQueue;)V", "Lkotlin/jvm/functions/Function1;", "dispatch", "request", "Lokhttp3/mockwebserver/RecordedRequest;", "toMockResponse", "mock-oauth2-server"})
    public static final class MockWebServerDispatcher
    extends Dispatcher {
        @NotNull
        private final Function1<OAuth2HttpRequest, OAuth2HttpResponse> requestHandler;
        @NotNull
        private final BlockingQueue<MockResponse> responseQueue;

        public MockWebServerDispatcher(@NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler, @NotNull BlockingQueue<MockResponse> responseQueue) {
            Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
            Intrinsics.checkNotNullParameter(responseQueue, (String)"responseQueue");
            this.requestHandler = requestHandler;
            this.responseQueue = responseQueue;
        }

        public /* synthetic */ MockWebServerDispatcher(Function1 function1, BlockingQueue blockingQueue, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                blockingQueue = new LinkedBlockingQueue();
            }
            this((Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)function1, blockingQueue);
        }

        @NotNull
        public MockResponse dispatch(@NotNull RecordedRequest request) {
            MockResponse mockResponse;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    mockResponse = (MockResponse)this.responseQueue.peek();
                    if (mockResponse == null) break block2;
                    MockResponse it = mockResponse;
                    boolean bl = false;
                    MockResponse mockResponse2 = this.responseQueue.take();
                    mockResponse = mockResponse2;
                    if (mockResponse2 != null) break block3;
                }
                mockResponse = this.toMockResponse((OAuth2HttpResponse)this.requestHandler.invoke((Object)AsOAuth2HttpRequestKt.asOAuth2HttpRequest(request)));
            }
            return mockResponse;
        }

        private final MockResponse toMockResponse(OAuth2HttpResponse $this$toMockResponse) {
            MockResponse it = new MockResponse().setHeaders($this$toMockResponse.getHeaders()).setResponseCode($this$toMockResponse.getStatus());
            boolean bl = false;
            return $this$toMockResponse.getBody() != null ? it.setBody($this$toMockResponse.getBody()) : ($this$toMockResponse.getBytesBody() != null ? it.setBody(new Buffer().write($this$toMockResponse.getBytesBody())) : it.setBody(""));
        }
    }
}

