/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.token;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.TokenRequest;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.token.KeyGenerator;
import no.nav.security.mock.oauth2.token.KeyProvider;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006j\u0002`\u0005\u00a2\u0006\u0004\b\b\u0010\tB\u001f\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\u000bJ\u0012\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J*\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0012J*\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0012J&\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cJ0\u0010\"\u001a\u00020\u00162\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010$2\b\b\u0002\u0010%\u001a\u00020&2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u001c\u0010'\u001a\u00020\u0016*\u00020!2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u0012H\u0002J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u0014H\u0002J\"\u0010-\u001a\u00020.*\u00020.2\u0014\b\u0002\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010$H\u0002J[\u0010/\u001a\n 0*\u0004\u0018\u00010!0!2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u00101\u001a\u0004\u0018\u00010\u00122\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0012032\b\u0010\u001d\u001a\u0004\u0018\u00010\u00122\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010$2\u0006\u0010%\u001a\u000205H\u0002\u00a2\u0006\u0002\u00106J\u000e\u00107\u001a\u00020\u0007*\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0013\u0010\n\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u00068"}, d2={"Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "", "keyProvider", "Lno/nav/security/mock/oauth2/token/KeyProvider;", "timeProvider", "Lno/nav/security/mock/oauth2/token/TimeProvider;", "Lkotlin/Function0;", "Ljava/time/Instant;", "<init>", "(Lno/nav/security/mock/oauth2/token/KeyProvider;Lkotlin/jvm/functions/Function0;)V", "systemTime", "(Lno/nav/security/mock/oauth2/token/KeyProvider;Ljava/time/Instant;)V", "Lkotlin/jvm/functions/Function0;", "getSystemTime", "()Ljava/time/Instant;", "publicJwkSet", "Lcom/nimbusds/jose/jwk/JWKSet;", "issuerId", "", "getAlgorithm", "Lcom/nimbusds/jose/JWSAlgorithm;", "idToken", "Lcom/nimbusds/jwt/SignedJWT;", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "issuerUrl", "Lokhttp3/HttpUrl;", "oAuth2TokenCallback", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "nonce", "accessToken", "exchangeAccessToken", "claimsSet", "Lcom/nimbusds/jwt/JWTClaimsSet;", "jwt", "claims", "", "expiry", "Ljava/time/Duration;", "sign", "type", "jwsHeader", "Lcom/nimbusds/jose/JWSHeader;", "keyId", "algorithm", "addClaims", "Lcom/nimbusds/jwt/JWTClaimsSet$Builder;", "defaultClaims", "kotlin.jvm.PlatformType", "subject", "audience", "", "additionalClaims", "", "(Lokhttp3/HttpUrl;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/util/Map;J)Lcom/nimbusds/jwt/JWTClaimsSet;", "orNow", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nOAuth2TokenProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2TokenProvider.kt\nno/nav/security/mock/oauth2/token/OAuth2TokenProvider\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n216#2,2:182\n1#3:184\n*S KotlinDebug\n*F\n+ 1 OAuth2TokenProvider.kt\nno/nav/security/mock/oauth2/token/OAuth2TokenProvider\n*L\n154#1:182,2\n*E\n"})
public final class OAuth2TokenProvider {
    @NotNull
    private final KeyProvider keyProvider;
    @NotNull
    private final Function0<Instant> timeProvider;

    @JvmOverloads
    public OAuth2TokenProvider(@NotNull KeyProvider keyProvider, @NotNull Function0<Instant> timeProvider) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        Intrinsics.checkNotNullParameter(timeProvider, (String)"timeProvider");
        this.keyProvider = keyProvider;
        this.timeProvider = timeProvider;
    }

    public /* synthetic */ OAuth2TokenProvider(KeyProvider keyProvider, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            keyProvider = new KeyProvider(null, null, 3, null);
        }
        this(keyProvider, (Function0<Instant>)function0);
    }

    @Nullable
    public final Instant getSystemTime() {
        return (Instant)this.timeProvider.invoke();
    }

    @JvmOverloads
    public OAuth2TokenProvider(@NotNull KeyProvider keyProvider, @Nullable Instant systemTime) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        this(keyProvider, (Function0<Instant>)((Function0)() -> OAuth2TokenProvider._init_$lambda$0(systemTime)));
    }

    public /* synthetic */ OAuth2TokenProvider(KeyProvider keyProvider, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            keyProvider = new KeyProvider(null, null, 3, null);
        }
        if ((n & 2) != 0) {
            instant = null;
        }
        this(keyProvider, instant);
    }

    @JvmOverloads
    @NotNull
    public final JWKSet publicJwkSet(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        JWKSet jWKSet = new JWKSet(this.keyProvider.signingKey(issuerId)).toPublicJWKSet();
        Intrinsics.checkNotNullExpressionValue((Object)jWKSet, (String)"toPublicJWKSet(...)");
        return jWKSet;
    }

    public static /* synthetic */ JWKSet publicJwkSet$default(OAuth2TokenProvider oAuth2TokenProvider, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "default";
        }
        return oAuth2TokenProvider.publicJwkSet(string);
    }

    @NotNull
    public final JWSAlgorithm getAlgorithm() {
        return this.keyProvider.algorithm();
    }

    @NotNull
    public final SignedJWT idToken(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback, @Nullable String nonce) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        JWTClaimsSet jWTClaimsSet = this.defaultClaims(issuerUrl, oAuth2TokenCallback.subject(tokenRequest), CollectionsKt.listOf((Object)NimbusExtensionsKt.clientIdAsString(tokenRequest)), nonce, oAuth2TokenCallback.addClaims(tokenRequest), oAuth2TokenCallback.tokenExpiry());
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"defaultClaims(...)");
        return this.sign(jWTClaimsSet, HttpUrlExtensionsKt.issuerId(issuerUrl), oAuth2TokenCallback.typeHeader(tokenRequest));
    }

    public static /* synthetic */ SignedJWT idToken$default(OAuth2TokenProvider oAuth2TokenProvider, TokenRequest tokenRequest, HttpUrl httpUrl, OAuth2TokenCallback oAuth2TokenCallback, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return oAuth2TokenProvider.idToken(tokenRequest, httpUrl, oAuth2TokenCallback, string);
    }

    @NotNull
    public final SignedJWT accessToken(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback, @Nullable String nonce) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        JWTClaimsSet jWTClaimsSet = this.defaultClaims(issuerUrl, oAuth2TokenCallback.subject(tokenRequest), oAuth2TokenCallback.audience(tokenRequest), nonce, oAuth2TokenCallback.addClaims(tokenRequest), oAuth2TokenCallback.tokenExpiry());
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"defaultClaims(...)");
        return this.sign(jWTClaimsSet, HttpUrlExtensionsKt.issuerId(issuerUrl), oAuth2TokenCallback.typeHeader(tokenRequest));
    }

    public static /* synthetic */ SignedJWT accessToken$default(OAuth2TokenProvider oAuth2TokenProvider, TokenRequest tokenRequest, HttpUrl httpUrl, OAuth2TokenCallback oAuth2TokenCallback, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return oAuth2TokenProvider.accessToken(tokenRequest, httpUrl, oAuth2TokenCallback, string);
    }

    @NotNull
    public final SignedJWT exchangeAccessToken(@NotNull TokenRequest tokenRequest, @NotNull HttpUrl issuerUrl, @NotNull JWTClaimsSet claimsSet, @NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)claimsSet, (String)"claimsSet");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        Instant now = this.orNow(this.getSystemTime());
        boolean bl = false;
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder(claimsSet).issuer(issuerUrl.toString()).expirationTime(Date.from(now.plusSeconds(oAuth2TokenCallback.tokenExpiry()))).notBeforeTime(Date.from(now)).issueTime(Date.from(now)).jwtID(UUID.randomUUID().toString()).audience(oAuth2TokenCallback.audience(tokenRequest));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"audience(...)");
        JWTClaimsSet jWTClaimsSet = this.addClaims(builder, oAuth2TokenCallback.addClaims(tokenRequest)).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"build(...)");
        return this.sign(jWTClaimsSet, HttpUrlExtensionsKt.issuerId(issuerUrl), oAuth2TokenCallback.typeHeader(tokenRequest));
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final SignedJWT jwt(@NotNull Map<String, ? extends Object> claims, @NotNull Duration expiry, @NotNull String issuerId) {
        void builder;
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        JWTClaimsSet.Builder builder2 = new JWTClaimsSet.Builder();
        OAuth2TokenProvider oAuth2TokenProvider = this;
        boolean bl = false;
        Instant now = this.orNow(this.getSystemTime());
        builder.issueTime(Date.from(now)).notBeforeTime(Date.from(now)).expirationTime(Date.from(now.plusSeconds(expiry.toSeconds())));
        this.addClaims((JWTClaimsSet.Builder)builder, claims);
        JWTClaimsSet jWTClaimsSet = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"let(...)");
        String string = JOSEObjectType.JWT.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
        return oAuth2TokenProvider.sign(jWTClaimsSet, issuerId, string);
    }

    public static /* synthetic */ SignedJWT jwt$default(OAuth2TokenProvider oAuth2TokenProvider, Map map, Duration duration, String string, int n, Object object) {
        if ((n & 2) != 0) {
            duration = Duration.ofHours(1L);
        }
        if ((n & 4) != 0) {
            string = "default";
        }
        return oAuth2TokenProvider.jwt(map, duration, string);
    }

    private final SignedJWT sign(JWTClaimsSet $this$sign, String issuerId, String type) {
        SignedJWT signedJWT;
        JWK key = this.keyProvider.signingKey(issuerId);
        JWSAlgorithm algorithm = this.keyProvider.algorithm();
        String keyType = this.keyProvider.keyType();
        boolean supported = KeyGenerator.Companion.isSupported(algorithm);
        if (supported && Intrinsics.areEqual((Object)keyType, (Object)KeyType.RSA.getValue())) {
            SignedJWT signedJWT2;
            String string = key.getKeyID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeyID(...)");
            SignedJWT $this$sign_u24lambda_u243 = signedJWT2 = new SignedJWT(this.jwsHeader(string, type, algorithm), $this$sign);
            boolean bl = false;
            $this$sign_u24lambda_u243.sign((JWSSigner)new RSASSASigner(key.toRSAKey().toPrivateKey()));
            signedJWT = signedJWT2;
        } else if (supported && Intrinsics.areEqual((Object)keyType, (Object)KeyType.EC.getValue())) {
            SignedJWT signedJWT3;
            String string = key.getKeyID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeyID(...)");
            SignedJWT $this$sign_u24lambda_u244 = signedJWT3 = new SignedJWT(this.jwsHeader(string, type, algorithm), $this$sign);
            boolean bl = false;
            $this$sign_u24lambda_u244.sign((JWSSigner)new ECDSASigner(key.toECKey().toECPrivateKey()));
            signedJWT = signedJWT3;
        } else {
            throw new OAuth2Exception("Unsupported algorithm: " + algorithm.getName());
        }
        return signedJWT;
    }

    private final JWSHeader jwsHeader(String keyId, String type, JWSAlgorithm algorithm) {
        JWSHeader jWSHeader = new JWSHeader.Builder(algorithm).keyID(keyId).type(new JOSEObjectType(type)).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWSHeader, (String)"build(...)");
        return jWSHeader;
    }

    private final JWTClaimsSet.Builder addClaims(JWTClaimsSet.Builder $this$addClaims, Map<String, ? extends Object> claims) {
        JWTClaimsSet.Builder builder;
        JWTClaimsSet.Builder $this$addClaims_u24lambda_u246 = builder = $this$addClaims;
        boolean bl = false;
        Map<String, ? extends Object> $this$forEach$iv = claims;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> it = element$iv = iterator.next();
            boolean bl2 = false;
            $this$addClaims_u24lambda_u246.claim(it.getKey(), it.getValue());
        }
        return builder;
    }

    static /* synthetic */ JWTClaimsSet.Builder addClaims$default(OAuth2TokenProvider oAuth2TokenProvider, JWTClaimsSet.Builder builder, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        return oAuth2TokenProvider.addClaims(builder, map);
    }

    private final JWTClaimsSet defaultClaims(HttpUrl issuerUrl, String subject, List<String> audience, String nonce, Map<String, ? extends Object> additionalClaims, long expiry) {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        boolean bl = false;
        Instant now = this.orNow(this.getSystemTime());
        builder.subject(subject).audience(audience).issuer(issuerUrl.toString()).issueTime(Date.from(now)).notBeforeTime(Date.from(now)).expirationTime(Date.from(now.plusSeconds(expiry))).jwtID(UUID.randomUUID().toString());
        String string = nonce;
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl2 = false;
            builder.claim("nonce", (Object)it);
        }
        this.addClaims(builder, additionalClaims);
        return builder.build();
    }

    private final Instant orNow(Instant $this$orNow) {
        Instant instant = $this$orNow;
        if (instant == null) {
            Instant instant2 = Instant.now();
            instant = instant2;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
        }
        return instant;
    }

    @JvmOverloads
    public OAuth2TokenProvider(@NotNull Function0<Instant> timeProvider) {
        Intrinsics.checkNotNullParameter(timeProvider, (String)"timeProvider");
        this(null, timeProvider, 1, null);
    }

    @JvmOverloads
    public OAuth2TokenProvider(@NotNull KeyProvider keyProvider) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        this(keyProvider, (Instant)null, 2, (DefaultConstructorMarker)null);
    }

    @JvmOverloads
    public OAuth2TokenProvider() {
        this((KeyProvider)null, (Instant)null, 3, (DefaultConstructorMarker)null);
    }

    @JvmOverloads
    @NotNull
    public final JWKSet publicJwkSet() {
        return OAuth2TokenProvider.publicJwkSet$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT jwt(@NotNull Map<String, ? extends Object> claims, @NotNull Duration expiry) {
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        return OAuth2TokenProvider.jwt$default(this, claims, expiry, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT jwt(@NotNull Map<String, ? extends Object> claims) {
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        return OAuth2TokenProvider.jwt$default(this, claims, null, null, 6, null);
    }

    private static final Instant _init_$lambda$0(Instant $systemTime) {
        return $systemTime;
    }
}

