/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.OAuth2Exception;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0003\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0003\u00a8\u0006\n"}, d2={"missingParameter", "", "name", "", "invalidGrant", "grantType", "Lcom/nimbusds/oauth2/sdk/GrantType;", "invalidRequest", "message", "notFound", "mock-oauth2-server"})
public final class OAuth2ExceptionKt {
    @NotNull
    public static final Void missingParameter(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String it = "missing required parameter " + name;
        boolean bl = false;
        throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST.setDescription(it), it);
    }

    @NotNull
    public static final Void invalidGrant(@NotNull GrantType grantType) {
        Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
        String it = "grant_type " + grantType + " not supported.";
        boolean bl = false;
        throw new OAuth2Exception(OAuth2Error.INVALID_GRANT.setDescription(it), it);
    }

    @NotNull
    public static final Void invalidRequest(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String it = message;
        boolean bl = false;
        throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST.setDescription(message), message);
    }

    @NotNull
    public static final Void notFound(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        throw new OAuth2Exception(new ErrorObject("not_found", "Resource not found", 404), message);
    }
}

