/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.grant;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.JWTBearerGrant;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.TokenRequest;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.OAuth2ExceptionKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2TokenResponse;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenProvider;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lno/nav/security/mock/oauth2/grant/JwtBearerGrantHandler;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "tokenProvider", "Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "<init>", "(Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;)V", "tokenResponse", "Lno/nav/security/mock/oauth2/http/OAuth2TokenResponse;", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "issuerUrl", "Lokhttp3/HttpUrl;", "oAuth2TokenCallback", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "responseScope", "", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "assertion", "Lcom/nimbusds/jwt/JWTClaimsSet;", "mock-oauth2-server"})
public final class JwtBearerGrantHandler
implements GrantHandler {
    @NotNull
    private final OAuth2TokenProvider tokenProvider;

    public JwtBearerGrantHandler(@NotNull OAuth2TokenProvider tokenProvider) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        this.tokenProvider = tokenProvider;
    }

    @Override
    @NotNull
    public OAuth2TokenResponse tokenResponse(@NotNull OAuth2HttpRequest request, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        TokenRequest tokenRequest = request.asNimbusTokenRequest();
        JWTClaimsSet receivedClaimsSet = this.assertion(tokenRequest);
        SignedJWT accessToken = this.tokenProvider.exchangeAccessToken(tokenRequest, issuerUrl, receivedClaimsSet, oAuth2TokenCallback);
        return new OAuth2TokenResponse("Bearer", null, null, accessToken.serialize(), null, NimbusExtensionsKt.expiresIn(accessToken), this.responseScope(tokenRequest), 22, null);
    }

    private final String responseScope(TokenRequest $this$responseScope) {
        Object object = $this$responseScope.getScope();
        if (object == null || (object = object.toString()) == null) {
            Object object2 = this.assertion($this$responseScope).getClaim("scope");
            if (object2 != null) {
                object = object2.toString();
            } else {
                OAuth2ExceptionKt.invalidRequest("scope must be specified in request or as a claim in assertion parameter");
                throw new KotlinNothingValueException();
            }
        }
        return object;
    }

    private final JWTClaimsSet assertion(TokenRequest $this$assertion) {
        AuthorizationGrant authorizationGrant = $this$assertion.getAuthorizationGrant();
        JWTBearerGrant jWTBearerGrant = authorizationGrant instanceof JWTBearerGrant ? (JWTBearerGrant)authorizationGrant : null;
        if (jWTBearerGrant == null || (jWTBearerGrant = jWTBearerGrant.getJWTAssertion()) == null || (jWTBearerGrant = jWTBearerGrant.getJWTClaimsSet()) == null) {
            throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "missing required parameter assertion");
        }
        return jWTBearerGrant;
    }
}

