/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.io.File;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import no.nav.security.mock.oauth2.OAuth2Config;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.OAuth2ExceptionKt;
import no.nav.security.mock.oauth2.debugger.DebuggerRequestHandler;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.grant.AuthorizationCodeHandler;
import no.nav.security.mock.oauth2.grant.ClientCredentialsGrantHandler;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import no.nav.security.mock.oauth2.grant.JwtBearerGrantHandler;
import no.nav.security.mock.oauth2.grant.PasswordGrantHandler;
import no.nav.security.mock.oauth2.grant.RefreshTokenGrantHandler;
import no.nav.security.mock.oauth2.grant.RefreshTokenManager;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrantHandler;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrantKt;
import no.nav.security.mock.oauth2.http.CorsInterceptor;
import no.nav.security.mock.oauth2.http.Interceptor;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequestHandlerKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRouterKt;
import no.nav.security.mock.oauth2.http.OAuth2TokenResponse;
import no.nav.security.mock.oauth2.http.Route;
import no.nav.security.mock.oauth2.introspect.IntrospectKt;
import no.nav.security.mock.oauth2.login.Login;
import no.nav.security.mock.oauth2.login.LoginRequestHandler;
import no.nav.security.mock.oauth2.token.DefaultOAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import no.nav.security.mock.oauth2.userinfo.UserInfoKt;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fJ\f\u0010 \u001a\u00020!*\u00020!H\u0002J\f\u0010\"\u001a\u00020!*\u00020!H\u0002J\f\u0010#\u001a\u00020!*\u00020!H\u0002J\f\u0010$\u001a\u00020!*\u00020!H\u0002J\u0014\u0010%\u001a\u00020!*\u00020!2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010&\u001a\u00020!*\u00020!H\u0002J\f\u0010'\u001a\u00020!*\u00020!H\u0002J\f\u0010(\u001a\u00020!*\u00020!H\u0002J\u0010\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0014j\u0002`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006,"}, d2={"Lno/nav/security/mock/oauth2/http/OAuth2HttpRequestHandler;", "", "config", "Lno/nav/security/mock/oauth2/OAuth2Config;", "<init>", "(Lno/nav/security/mock/oauth2/OAuth2Config;)V", "loginRequestHandler", "Lno/nav/security/mock/oauth2/login/LoginRequestHandler;", "debuggerRequestHandler", "Lno/nav/security/mock/oauth2/debugger/DebuggerRequestHandler;", "tokenCallbackQueue", "Ljava/util/concurrent/BlockingQueue;", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "refreshTokenManager", "Lno/nav/security/mock/oauth2/grant/RefreshTokenManager;", "grantHandlers", "", "Lcom/nimbusds/oauth2/sdk/GrantType;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "exceptionHandler", "Lkotlin/Function2;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "Lno/nav/security/mock/oauth2/http/ExceptionHandler;", "authorizationServer", "Lno/nav/security/mock/oauth2/http/Route;", "getAuthorizationServer", "()Lno/nav/security/mock/oauth2/http/Route;", "enqueueTokenCallback", "", "oAuth2TokenCallback", "wellKnown", "Lno/nav/security/mock/oauth2/http/Route$Builder;", "jwks", "authorization", "endSession", "revocation", "token", "staticAssets", "preflight", "tokenCallbackFromQueueOrDefault", "issuerId", "", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nOAuth2HttpRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2HttpRequestHandler.kt\nno/nav/security/mock/oauth2/http/OAuth2HttpRequestHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n295#2,2:213\n*S KotlinDebug\n*F\n+ 1 OAuth2HttpRequestHandler.kt\nno/nav/security/mock/oauth2/http/OAuth2HttpRequestHandler\n*L\n208#1:213,2\n*E\n"})
public final class OAuth2HttpRequestHandler {
    @NotNull
    private final OAuth2Config config;
    @NotNull
    private final LoginRequestHandler loginRequestHandler;
    @NotNull
    private final DebuggerRequestHandler debuggerRequestHandler;
    @NotNull
    private final BlockingQueue<OAuth2TokenCallback> tokenCallbackQueue;
    @NotNull
    private final RefreshTokenManager refreshTokenManager;
    @NotNull
    private final Map<GrantType, GrantHandler> grantHandlers;
    @NotNull
    private final Function2<OAuth2HttpRequest, Throwable, OAuth2HttpResponse> exceptionHandler;
    @NotNull
    private final Route authorizationServer;

    public OAuth2HttpRequestHandler(@NotNull OAuth2Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.loginRequestHandler = new LoginRequestHandler(OAuth2HttpResponseKt.getTemplateMapper(), this.config);
        this.debuggerRequestHandler = new DebuggerRequestHandler(null, this.config.getHttpServer().sslConfig(), null, 5, null);
        this.tokenCallbackQueue = new LinkedBlockingQueue();
        this.refreshTokenManager = new RefreshTokenManager(null, 1, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)GrantType.AUTHORIZATION_CODE, (Object)new AuthorizationCodeHandler(this.config.getTokenProvider(), this.refreshTokenManager)), TuplesKt.to((Object)GrantType.CLIENT_CREDENTIALS, (Object)new ClientCredentialsGrantHandler(this.config.getTokenProvider())), TuplesKt.to((Object)GrantType.JWT_BEARER, (Object)new JwtBearerGrantHandler(this.config.getTokenProvider())), TuplesKt.to((Object)TokenExchangeGrantKt.getTOKEN_EXCHANGE(), (Object)new TokenExchangeGrantHandler(this.config.getTokenProvider())), TuplesKt.to((Object)GrantType.REFRESH_TOKEN, (Object)new RefreshTokenGrantHandler(this.config.getTokenProvider(), this.refreshTokenManager, this.config.getRotateRefreshToken())), TuplesKt.to((Object)GrantType.PASSWORD, (Object)new PasswordGrantHandler(this.config.getTokenProvider()))};
        this.grantHandlers = MapsKt.mapOf((Pair[])pairArray);
        this.exceptionHandler = OAuth2HttpRequestHandler::exceptionHandler$lambda$0;
        this.authorizationServer = OAuth2HttpRouterKt.routes((Function1<? super Route.Builder, Unit>)((Function1)arg_0 -> OAuth2HttpRequestHandler.authorizationServer$lambda$2(this, arg_0)));
    }

    @NotNull
    public final Route getAuthorizationServer() {
        return this.authorizationServer;
    }

    public final boolean enqueueTokenCallback(@NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        return this.tokenCallbackQueue.add(oAuth2TokenCallback);
    }

    private final Route.Builder wellKnown(Route.Builder $this$wellKnown) {
        String[] stringArray = new String[]{"/.well-known/openid-configuration", "/.well-known/oauth-authorization-server"};
        return $this$wellKnown.get(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)OAuth2HttpRequestHandler::wellKnown$lambda$3));
    }

    private final Route.Builder jwks(Route.Builder $this$jwks) {
        String[] stringArray = new String[]{"/jwks"};
        return $this$jwks.get(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)arg_0 -> OAuth2HttpRequestHandler.jwks$lambda$4(this, arg_0)));
    }

    private final Route.Builder authorization(Route.Builder $this$authorization) {
        Route.Builder builder;
        Route.Builder $this$authorization_u24lambda_u247 = builder = $this$authorization;
        boolean bl = false;
        GrantHandler grantHandler = this.grantHandlers.get(GrantType.AUTHORIZATION_CODE);
        Intrinsics.checkNotNull((Object)grantHandler, (String)"null cannot be cast to non-null type no.nav.security.mock.oauth2.grant.AuthorizationCodeHandler");
        AuthorizationCodeHandler authorizationCodeHandler = (AuthorizationCodeHandler)grantHandler;
        String[] stringArray = new String[]{"/authorize"};
        $this$authorization_u24lambda_u247.get(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)arg_0 -> OAuth2HttpRequestHandler.authorization$lambda$7$lambda$5(this, authorizationCodeHandler, arg_0)));
        $this$authorization_u24lambda_u247.post("/authorize", (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)arg_0 -> OAuth2HttpRequestHandler.authorization$lambda$7$lambda$6(this, authorizationCodeHandler, arg_0)));
        return builder;
    }

    private final Route.Builder endSession(Route.Builder $this$endSession) {
        String[] stringArray = new String[]{"/endsession"};
        return $this$endSession.any(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)OAuth2HttpRequestHandler::endSession$lambda$10));
    }

    private final Route.Builder revocation(Route.Builder $this$revocation, RefreshTokenManager refreshTokenManager) {
        return $this$revocation.post("/revoke", (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)arg_0 -> OAuth2HttpRequestHandler.revocation$lambda$11(refreshTokenManager, arg_0)));
    }

    private final Route.Builder token(Route.Builder $this$token) {
        Route.Builder builder;
        Route.Builder $this$token_u24lambda_u2414 = builder = $this$token;
        boolean bl = false;
        String[] stringArray = new String[]{"/token"};
        $this$token_u24lambda_u2414.get(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)OAuth2HttpRequestHandler::token$lambda$14$lambda$12));
        $this$token_u24lambda_u2414.post("/token", (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)arg_0 -> OAuth2HttpRequestHandler.token$lambda$14$lambda$13(this, arg_0)));
        return builder;
    }

    private final Route.Builder staticAssets(Route.Builder $this$staticAssets) {
        Route.Builder builder;
        Route.Builder $this$staticAssets_u24lambda_u2416 = builder = $this$staticAssets;
        boolean bl = false;
        if (this.config.getStaticAssetsPath() != null) {
            String[] stringArray = new String[]{"/static/*"};
            $this$staticAssets_u24lambda_u2416.get(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)arg_0 -> OAuth2HttpRequestHandler.staticAssets$lambda$16$lambda$15(this, arg_0)));
        }
        return builder;
    }

    private final Route.Builder preflight(Route.Builder $this$preflight) {
        return $this$preflight.options((Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)OAuth2HttpRequestHandler::preflight$lambda$17));
    }

    private final OAuth2TokenCallback tokenCallbackFromQueueOrDefault(String issuerId) {
        OAuth2TokenCallback oAuth2TokenCallback;
        OAuth2TokenCallback oAuth2TokenCallback2 = (OAuth2TokenCallback)this.tokenCallbackQueue.peek();
        if (Intrinsics.areEqual((Object)issuerId, (Object)(oAuth2TokenCallback2 != null ? oAuth2TokenCallback2.issuerId() : null))) {
            OAuth2TokenCallback oAuth2TokenCallback3 = this.tokenCallbackQueue.take();
            Intrinsics.checkNotNullExpressionValue((Object)oAuth2TokenCallback3, (String)"take(...)");
            oAuth2TokenCallback = oAuth2TokenCallback3;
        } else {
            Object v3;
            block4: {
                Iterable $this$firstOrNull$iv = this.config.getTokenCallbacks();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    OAuth2TokenCallback it = (OAuth2TokenCallback)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.issuerId(), (Object)issuerId)) continue;
                    v3 = element$iv;
                    break block4;
                }
                v3 = null;
            }
            if ((oAuth2TokenCallback = (OAuth2TokenCallback)v3) == null) {
                oAuth2TokenCallback = new DefaultOAuth2TokenCallback(issuerId, null, null, null, null, 0L, 62, null);
            }
        }
        return oAuth2TokenCallback;
    }

    private static final OAuth2HttpResponse exceptionHandler$lambda$0(OAuth2HttpRequest request, Throwable error) {
        ErrorObject errorObject;
        Object object;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        OAuth2HttpRequestHandlerKt.access$getLog$p().error("received exception when handling request: " + request.getUrl() + ".", error);
        String msg = URLEncoder.encode(error.getMessage(), Charset.forName("UTF-8"));
        Throwable throwable = error;
        if (throwable instanceof OAuth2Exception) {
            object = ((OAuth2Exception)error).getErrorObject();
        } else if (throwable instanceof ParseException) {
            object = ((ParseException)error).getErrorObject();
            if (object == null) {
                object = OAuth2Error.INVALID_REQUEST.setDescription("failed to parse request: " + msg);
            }
        } else {
            object = errorObject = throwable instanceof GeneralException ? ((GeneralException)error).getErrorObject() : null;
        }
        if (object == null) {
            ErrorObject errorObject2 = OAuth2Error.SERVER_ERROR.setDescription("unexpected exception with message: " + msg);
            errorObject = errorObject2;
            Intrinsics.checkNotNullExpressionValue((Object)errorObject2, (String)"setDescription(...)");
        }
        ErrorObject errorObject3 = errorObject;
        return OAuth2HttpResponseKt.oauth2Error(errorObject3);
    }

    private static final OAuth2HttpResponse authorizationServer$lambda$2$lambda$1(OAuth2HttpRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new OAuth2HttpResponse(null, 200, null, null, 13, null);
    }

    private static final Unit authorizationServer$lambda$2(OAuth2HttpRequestHandler this$0, Route.Builder $this$routes) {
        Intrinsics.checkNotNullParameter((Object)$this$routes, (String)"$this$routes");
        $this$routes.exceptionHandler(this$0.exceptionHandler);
        Object[] objectArray = new Interceptor[]{new CorsInterceptor(null, 1, null)};
        $this$routes.interceptors((Interceptor[])objectArray);
        this$0.wellKnown($this$routes);
        this$0.jwks($this$routes);
        this$0.authorization($this$routes);
        this$0.token($this$routes);
        this$0.endSession($this$routes);
        this$0.revocation($this$routes, this$0.refreshTokenManager);
        UserInfoKt.userInfo($this$routes, this$0.config.getTokenProvider());
        IntrospectKt.introspect($this$routes, this$0.config.getTokenProvider());
        this$0.preflight($this$routes);
        this$0.staticAssets($this$routes);
        objectArray = new String[]{"/favicon.ico"};
        $this$routes.get((String[])objectArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)OAuth2HttpRequestHandler::authorizationServer$lambda$2$lambda$1));
        objectArray = new Route[]{this$0.debuggerRequestHandler};
        $this$routes.attach((Route[])objectArray);
        return Unit.INSTANCE;
    }

    private static final OAuth2HttpResponse wellKnown$lambda$3(OAuth2HttpRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        OAuth2HttpRequestHandlerKt.access$getLog$p().debug("returning well-known json data for url=" + it.getUrl());
        return OAuth2HttpResponseKt.json(it.toWellKnown());
    }

    private static final OAuth2HttpResponse jwks$lambda$4(OAuth2HttpRequestHandler this$0, OAuth2HttpRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle jwks request on url=" + it.getUrl());
        String issuerId = HttpUrlExtensionsKt.issuerId(it.getUrl());
        JWKSet jwkSet = this$0.config.getTokenProvider().publicJwkSet(issuerId);
        Map map = jwkSet.toJSONObject();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"toJSONObject(...)");
        return OAuth2HttpResponseKt.json(map);
    }

    private static final OAuth2HttpResponse authorization$lambda$7$lambda$5(OAuth2HttpRequestHandler this$0, AuthorizationCodeHandler $authorizationCodeHandler, OAuth2HttpRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AuthenticationRequest authRequest = it.asAuthenticationRequest();
        return this$0.config.getInteractiveLogin() || NimbusExtensionsKt.isPrompt(authRequest) ? OAuth2HttpResponseKt.html(this$0.loginRequestHandler.loginHtml(it)) : OAuth2HttpResponseKt.authenticationSuccess(AuthorizationCodeHandler.authorizationCodeResponse$default($authorizationCodeHandler, authRequest, null, 2, null));
    }

    private static final OAuth2HttpResponse authorization$lambda$7$lambda$6(OAuth2HttpRequestHandler this$0, AuthorizationCodeHandler $authorizationCodeHandler, OAuth2HttpRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AuthenticationRequest authRequest = it.asAuthenticationRequest();
        Login login = this$0.loginRequestHandler.loginSubmit(it);
        return OAuth2HttpResponseKt.authenticationSuccess($authorizationCodeHandler.authorizationCodeResponse(authRequest, login));
    }

    private static final OAuth2HttpResponse endSession$lambda$10(OAuth2HttpRequest it) {
        Object object;
        block7: {
            block4: {
                Object object2;
                block6: {
                    String postLogoutRedirectUri;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle end session request " + it);
                        object = it.getUrl().queryParameter("post_logout_redirect_uri");
                        if (object == null) break block4;
                        postLogoutRedirectUri = object;
                        boolean bl = false;
                        object2 = it.getUrl().queryParameter("state");
                        if (object2 == null) break block5;
                        String state = object2;
                        boolean bl2 = false;
                        OAuth2HttpResponse oAuth2HttpResponse = OAuth2HttpResponseKt.redirect$default(postLogoutRedirectUri + "?state=" + state, null, 2, null);
                        object2 = oAuth2HttpResponse;
                        if (oAuth2HttpResponse != null) break block6;
                    }
                    object2 = OAuth2HttpResponseKt.redirect$default(postLogoutRedirectUri, null, 2, null);
                }
                object = object2;
                if (object2 != null) break block7;
            }
            object = OAuth2HttpResponseKt.html("logged out");
        }
        return object;
    }

    private static final OAuth2HttpResponse revocation$lambda$11(RefreshTokenManager $refreshTokenManager, OAuth2HttpRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle revocation request " + it);
        String hint = it.getFormParameters().get("token_type_hint");
        if (!Intrinsics.areEqual((Object)hint, (Object)"refresh_token")) {
            throw new OAuth2Exception(new ErrorObject("unsupported_token_type", "unsupported token type: " + hint, 400), "unsupported token type: " + hint);
        }
        String string = it.getFormParameters().get("token");
        Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
        String token = string;
        $refreshTokenManager.remove(token);
        return new OAuth2HttpResponse(null, 200, "ok", null, 9, null);
    }

    private static final OAuth2HttpResponse token$lambda$14$lambda$12(OAuth2HttpRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new OAuth2HttpResponse(null, 405, "unsupported method", null, 9, null);
    }

    private static final OAuth2HttpResponse token$lambda$14$lambda$13(OAuth2HttpRequestHandler this$0, OAuth2HttpRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle token request " + it);
        GrantType grantType = it.grantType();
        OAuth2TokenCallback tokenCallback = this$0.tokenCallbackFromQueueOrDefault(HttpUrlExtensionsKt.issuerId(it.getUrl()));
        GrantHandler grantHandler = this$0.grantHandlers.get(grantType);
        if (grantHandler == null) {
            OAuth2ExceptionKt.invalidGrant(grantType);
            throw new KotlinNothingValueException();
        }
        GrantHandler grantHandler2 = grantHandler;
        OAuth2TokenResponse tokenResponse = grantHandler2.tokenResponse(it, HttpUrlExtensionsKt.toIssuerUrl(it.getUrl()), tokenCallback);
        return OAuth2HttpResponseKt.json(tokenResponse);
    }

    private static final OAuth2HttpResponse staticAssets$lambda$16$lambda$15(OAuth2HttpRequestHandler this$0, OAuth2HttpRequest it) {
        OAuth2HttpResponse oAuth2HttpResponse;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String path = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)it.getUrl().pathSegments(), (int)1), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        String normalized = ((Object)Paths.get(path, new String[0]).normalize()).toString();
        File file = new File(this$0.config.getStaticAssetsPath(), normalized);
        String string = file.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
        if (StringsKt.startsWith$default((String)string, (String)this$0.config.getStaticAssetsPath(), (boolean)false, (int)2, null) && file.exists()) {
            String string2 = Files.probeContentType(file.toPath());
            if (string2 == null) {
                string2 = "application/octet-stream";
            }
            String contentType = string2;
            byte[] byArray = FilesKt.readBytes((File)file);
            String[] stringArray = new String[]{"Content-Type", contentType};
            Headers headers = Headers.Companion.of(stringArray);
            oAuth2HttpResponse = new OAuth2HttpResponse(headers, 200, null, byArray, 4, null);
        } else {
            oAuth2HttpResponse = new OAuth2HttpResponse(null, 404, "not found", null, 9, null);
        }
        return oAuth2HttpResponse;
    }

    private static final OAuth2HttpResponse preflight$lambda$17(OAuth2HttpRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new OAuth2HttpResponse(null, 204, null, null, 13, null);
    }
}

