/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.userinfo;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ErrorObject;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import no.nav.security.mock.oauth2.http.Route;
import no.nav.security.mock.oauth2.token.OAuth2TokenProvider;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0002\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"log", "Lmu/KLogger;", "userInfo", "Lno/nav/security/mock/oauth2/http/Route$Builder;", "tokenProvider", "Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "verifyBearerToken", "Lcom/nimbusds/jwt/JWTClaimsSet;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "bearerToken", "", "Lokhttp3/Headers;", "invalidToken", "Lno/nav/security/mock/oauth2/OAuth2Exception;", "msg", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nUserInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserInfo.kt\nno/nav/security/mock/oauth2/userinfo/UserInfoKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class UserInfoKt {
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(UserInfoKt::log$lambda$0);

    @NotNull
    public static final Route.Builder userInfo(@NotNull Route.Builder $this$userInfo, @NotNull OAuth2TokenProvider tokenProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$userInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        String[] stringArray = new String[]{"/userinfo"};
        return $this$userInfo.get(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)arg_0 -> UserInfoKt.userInfo$lambda$1(tokenProvider, arg_0)));
    }

    private static final JWTClaimsSet verifyBearerToken(OAuth2HttpRequest $this$verifyBearerToken, OAuth2TokenProvider tokenProvider) {
        JWTClaimsSet jWTClaimsSet;
        try {
            jWTClaimsSet = tokenProvider.verify(HttpUrlExtensionsKt.toIssuerUrl($this$verifyBearerToken.getUrl()), UserInfoKt.bearerToken($this$verifyBearerToken.getHeaders()));
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "could not verify bearer token";
            }
            throw UserInfoKt.invalidToken(string);
        }
        return jWTClaimsSet;
    }

    private static final String bearerToken(Headers $this$bearerToken) {
        Object object;
        block3: {
            block2: {
                Object object2;
                List list;
                String string = $this$bearerToken.get("Authorization");
                if (string == null || (list = StringsKt.split$default((CharSequence)string, (String[])(object2 = new String[]{"Bearer "}), (boolean)false, (int)0, (int)6, null)) == null) break block2;
                object = list;
                List it = object;
                boolean bl = false;
                Object object3 = object2 = it.size() == 2 ? object : null;
                if (object2 != null && (object = (String)CollectionsKt.last((List)object2)) != null) break block3;
            }
            throw UserInfoKt.invalidToken("missing bearer token");
        }
        return object;
    }

    private static final OAuth2Exception invalidToken(String msg) {
        return new OAuth2Exception(new ErrorObject("invalid_token", msg, 401), msg);
    }

    private static final Unit log$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final OAuth2HttpResponse userInfo$lambda$1(OAuth2TokenProvider $tokenProvider, OAuth2HttpRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        log.debug("received request to userinfo endpoint, returning claims from token");
        Map claims = UserInfoKt.verifyBearerToken(it, $tokenProvider).getClaims();
        Intrinsics.checkNotNull((Object)claims);
        return OAuth2HttpResponseKt.json(claims);
    }
}

