/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import no.nav.security.mock.oauth2.OAuth2ExceptionKt;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.extensions.StringKt;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrant;
import no.nav.security.mock.oauth2.http.WellKnown;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u00018B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J3\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010*\u001a\u00020+J\t\u0010,\u001a\u00020-H\u00d6\u0001J\u0016\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020-\u0018\u00010/H\u0002J\r\u00100\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b1J\b\u00102\u001a\u00020\u0005H\u0002J\b\u00103\u001a\u00020-H\u0002J\b\u00104\u001a\u00020\u0005H\u0002J\t\u00105\u001a\u00020\u0005H\u00d6\u0001J\u0006\u00106\u001a\u000207R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\u00a8\u00069"}, d2={"Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "", "headers", "Lokhttp3/Headers;", "method", "", "originalUrl", "Lokhttp3/HttpUrl;", "body", "(Lokhttp3/Headers;Ljava/lang/String;Lokhttp3/HttpUrl;Ljava/lang/String;)V", "getBody", "()Ljava/lang/String;", "cookies", "", "getCookies", "()Ljava/util/Map;", "formParameters", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest$Parameters;", "getFormParameters", "()Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest$Parameters;", "getHeaders", "()Lokhttp3/Headers;", "getMethod", "getOriginalUrl", "()Lokhttp3/HttpUrl;", "url", "getUrl", "asAuthenticationRequest", "Lcom/nimbusds/openid/connect/sdk/AuthenticationRequest;", "asNimbusHTTPRequest", "Lcom/nimbusds/oauth2/sdk/http/HTTPRequest;", "asNimbusTokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "asTokenExchangeRequest", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "grantType", "Lcom/nimbusds/oauth2/sdk/GrantType;", "hashCode", "", "parseHostHeader", "Lkotlin/Pair;", "proxyAwareUrl", "proxyAwareUrl$mock_oauth2_server", "resolveHost", "resolvePort", "resolveScheme", "toString", "toWellKnown", "Lno/nav/security/mock/oauth2/http/WellKnown;", "Parameters", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nOAuth2HttpRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2HttpRequest.kt\nno/nav/security/mock/oauth2/http/OAuth2HttpRequest\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n216#2,2:146\n1869#3,2:148\n1#4:150\n*S KotlinDebug\n*F\n+ 1 OAuth2HttpRequest.kt\nno/nav/security/mock/oauth2/http/OAuth2HttpRequest\n*L\n54#1:146,2\n64#1:148,2\n*E\n"})
public final class OAuth2HttpRequest {
    @NotNull
    private final Headers headers;
    @NotNull
    private final String method;
    @NotNull
    private final HttpUrl originalUrl;
    @Nullable
    private final String body;
    @NotNull
    private final Parameters formParameters;
    @NotNull
    private final Map<String, String> cookies;

    public OAuth2HttpRequest(@NotNull Headers headers, @NotNull String method, @NotNull HttpUrl originalUrl, @Nullable String body) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)originalUrl, (String)"originalUrl");
        this.headers = headers;
        this.method = method;
        this.originalUrl = originalUrl;
        this.body = body;
        this.formParameters = new Parameters(this.body);
        Object object = this.headers.get("Cookie");
        if (object == null || (object = StringKt.keyValuesToMap((String)object, ";")) == null) {
            object = MapsKt.emptyMap();
        }
        this.cookies = object;
    }

    public /* synthetic */ OAuth2HttpRequest(Headers headers, String string, HttpUrl httpUrl, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(headers, string, httpUrl, string2);
    }

    @NotNull
    public final Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public final HttpUrl getOriginalUrl() {
        return this.originalUrl;
    }

    @Nullable
    public final String getBody() {
        return this.body;
    }

    @NotNull
    public final HttpUrl getUrl() {
        return this.proxyAwareUrl$mock_oauth2_server();
    }

    @NotNull
    public final Parameters getFormParameters() {
        return this.formParameters;
    }

    @NotNull
    public final Map<String, String> getCookies() {
        return this.cookies;
    }

    @NotNull
    public final TokenRequest asTokenExchangeRequest() {
        HTTPRequest httpRequest = this.asNimbusHTTPRequest();
        ClientAuthentication clientAuthentication = NimbusExtensionsKt.clientAuthentication(httpRequest);
        if (Intrinsics.areEqual((Object)clientAuthentication.getMethod(), (Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) {
            clientAuthentication = (ClientAuthentication)NimbusExtensionsKt.requirePrivateKeyJwt(clientAuthentication, HttpUrlExtensionsKt.toIssuerUrl(this.getUrl()).toString(), 120L, this.getUrl().toString());
        }
        TokenExchangeGrant tokenExchangeGrant = TokenExchangeGrant.Companion.parse(this.formParameters.getMap());
        TokenRequest.Builder builder = new TokenRequest.Builder(this.getUrl().uri(), clientAuthentication, (AuthorizationGrant)tokenExchangeGrant);
        Map<String, String> $this$forEach$iv = this.formParameters.getMap();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            String value = entry.getValue();
            String[] stringArray = new String[]{value};
            builder.customParameter(key, stringArray);
        }
        TokenRequest tokenRequest = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)tokenRequest, (String)"build(...)");
        return tokenRequest;
    }

    @NotNull
    public final HTTPRequest asNimbusHTTPRequest() {
        HTTPRequest hTTPRequest;
        String inputBody = this.body;
        HTTPRequest $this$asNimbusHTTPRequest_u24lambda_u242 = hTTPRequest = new HTTPRequest(HTTPRequest.Method.valueOf((String)this.method), this.getUrl().url());
        boolean bl = false;
        Iterable $this$forEach$iv = (Iterable)this.headers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair header = (Pair)element$iv;
            boolean bl2 = false;
            String[] stringArray = new String[]{header.getSecond()};
            $this$asNimbusHTTPRequest_u24lambda_u242.setHeader((String)header.getFirst(), stringArray);
        }
        $this$asNimbusHTTPRequest_u24lambda_u242.setBody(inputBody);
        return hTTPRequest;
    }

    @NotNull
    public final TokenRequest asNimbusTokenRequest() {
        TokenRequest tokenRequest = TokenRequest.parse((HTTPRequest)this.asNimbusHTTPRequest());
        Intrinsics.checkNotNullExpressionValue((Object)tokenRequest, (String)"parse(...)");
        return tokenRequest;
    }

    @NotNull
    public final AuthenticationRequest asAuthenticationRequest() {
        AuthenticationRequest authenticationRequest = AuthenticationRequest.parse((URI)this.getUrl().uri());
        Intrinsics.checkNotNullExpressionValue((Object)authenticationRequest, (String)"parse(...)");
        return authenticationRequest;
    }

    @NotNull
    public final GrantType grantType() {
        String string;
        block6: {
            block5: {
                CharSequence charSequence;
                String string2 = this.formParameters.getMap().get("grant_type");
                if (string2 == null) break block5;
                CharSequence charSequence2 = string2;
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence2;
                }
                string = (String)charSequence;
                if (string != null) break block6;
            }
            OAuth2ExceptionKt.missingParameter("grant_type");
            throw new KotlinNothingValueException();
        }
        String it = string;
        boolean bl = false;
        return new GrantType(it);
    }

    @NotNull
    public final WellKnown toWellKnown() {
        String string = HttpUrlExtensionsKt.toIssuerUrl(this.proxyAwareUrl$mock_oauth2_server()).toString();
        String string2 = HttpUrlExtensionsKt.toAuthorizationEndpointUrl(this.proxyAwareUrl$mock_oauth2_server()).toString();
        String string3 = HttpUrlExtensionsKt.toTokenEndpointUrl(this.proxyAwareUrl$mock_oauth2_server()).toString();
        String string4 = HttpUrlExtensionsKt.toEndSessionEndpointUrl(this.proxyAwareUrl$mock_oauth2_server()).toString();
        String string5 = HttpUrlExtensionsKt.toRevocationEndpointUrl(this.proxyAwareUrl$mock_oauth2_server()).toString();
        String string6 = HttpUrlExtensionsKt.toIntrospectUrl(this.proxyAwareUrl$mock_oauth2_server()).toString();
        String string7 = HttpUrlExtensionsKt.toJwksUrl(this.proxyAwareUrl$mock_oauth2_server()).toString();
        String string8 = HttpUrlExtensionsKt.toUserInfoUrl(this.proxyAwareUrl$mock_oauth2_server()).toString();
        return new WellKnown(string, string2, string4, string5, string3, string8, string7, string6, null, null, null, null, null, 7936, null);
    }

    @NotNull
    public final HttpUrl proxyAwareUrl$mock_oauth2_server() {
        return new HttpUrl.Builder().scheme(this.resolveScheme()).host(this.resolveHost()).port(this.resolvePort()).encodedPath(this.originalUrl.encodedPath()).query(this.originalUrl.query()).build();
    }

    private final String resolveScheme() {
        String string = this.headers.get("x-forwarded-proto");
        if (string == null) {
            string = this.originalUrl.scheme();
        }
        return string;
    }

    private final String resolveHost() {
        Object object = this.parseHostHeader();
        if (object == null || (object = (String)object.getFirst()) == null) {
            object = this.originalUrl.host();
        }
        return object;
    }

    private final int resolvePort() {
        String xForwardedProto = this.headers.get("x-forwarded-proto");
        String string = this.headers.get("x-forwarded-port");
        int xForwardedPort = string != null ? Integer.parseInt(string) : -1;
        Pair<String, Integer> pair = this.parseHostHeader();
        int hostHeaderPort = pair != null ? ((Number)pair.getSecond()).intValue() : -1;
        return xForwardedPort != -1 ? xForwardedPort : (hostHeaderPort != -1 ? hostHeaderPort : (xForwardedProto != null ? (Intrinsics.areEqual((Object)xForwardedProto, (Object)"https") ? 443 : 80) : this.originalUrl.port()));
    }

    private final Pair<String, Integer> parseHostHeader() {
        String hostHeader = this.headers.get("host");
        if (hostHeader != null) {
            String[] stringArray = new String[]{":"};
            List hostPort = StringsKt.split$default((CharSequence)hostHeader, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            int port = hostPort.size() == 2 ? Integer.parseInt((String)hostPort.get(1)) : -1;
            return TuplesKt.to(hostPort.get(0), (Object)port);
        }
        return null;
    }

    @NotNull
    public final Headers component1() {
        return this.headers;
    }

    @NotNull
    public final String component2() {
        return this.method;
    }

    @NotNull
    public final HttpUrl component3() {
        return this.originalUrl;
    }

    @Nullable
    public final String component4() {
        return this.body;
    }

    @NotNull
    public final OAuth2HttpRequest copy(@NotNull Headers headers, @NotNull String method, @NotNull HttpUrl originalUrl, @Nullable String body) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)originalUrl, (String)"originalUrl");
        return new OAuth2HttpRequest(headers, method, originalUrl, body);
    }

    public static /* synthetic */ OAuth2HttpRequest copy$default(OAuth2HttpRequest oAuth2HttpRequest, Headers headers, String string, HttpUrl httpUrl, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            headers = oAuth2HttpRequest.headers;
        }
        if ((n & 2) != 0) {
            string = oAuth2HttpRequest.method;
        }
        if ((n & 4) != 0) {
            httpUrl = oAuth2HttpRequest.originalUrl;
        }
        if ((n & 8) != 0) {
            string2 = oAuth2HttpRequest.body;
        }
        return oAuth2HttpRequest.copy(headers, string, httpUrl, string2);
    }

    @NotNull
    public String toString() {
        return "OAuth2HttpRequest(headers=" + this.headers + ", method=" + this.method + ", originalUrl=" + this.originalUrl + ", body=" + this.body + ")";
    }

    public int hashCode() {
        int result = this.headers.hashCode();
        result = result * 31 + this.method.hashCode();
        result = result * 31 + this.originalUrl.hashCode();
        result = result * 31 + (this.body == null ? 0 : this.body.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OAuth2HttpRequest)) {
            return false;
        }
        OAuth2HttpRequest oAuth2HttpRequest = (OAuth2HttpRequest)other;
        if (!Intrinsics.areEqual((Object)this.headers, (Object)oAuth2HttpRequest.headers)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.method, (Object)oAuth2HttpRequest.method)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.originalUrl, (Object)oAuth2HttpRequest.originalUrl)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.body, (Object)oAuth2HttpRequest.body);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest$Parameters;", "", "parameterString", "", "(Ljava/lang/String;)V", "map", "", "getMap", "()Ljava/util/Map;", "getParameterString", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "get", "name", "hashCode", "", "toString", "mock-oauth2-server"})
    public static final class Parameters {
        @Nullable
        private final String parameterString;
        @NotNull
        private final Map<String, String> map;

        public Parameters(@Nullable String parameterString) {
            this.parameterString = parameterString;
            Object object = this.parameterString;
            if (object == null || (object = StringKt.keyValuesToMap((String)object, "&")) == null) {
                object = MapsKt.emptyMap();
            }
            this.map = object;
        }

        @Nullable
        public final String getParameterString() {
            return this.parameterString;
        }

        @NotNull
        public final Map<String, String> getMap() {
            return this.map;
        }

        @Nullable
        public final String get(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.map.get(name);
        }

        @Nullable
        public final String component1() {
            return this.parameterString;
        }

        @NotNull
        public final Parameters copy(@Nullable String parameterString) {
            return new Parameters(parameterString);
        }

        public static /* synthetic */ Parameters copy$default(Parameters parameters, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = parameters.parameterString;
            }
            return parameters.copy(string);
        }

        @NotNull
        public String toString() {
            return "Parameters(parameterString=" + this.parameterString + ")";
        }

        public int hashCode() {
            return this.parameterString == null ? 0 : this.parameterString.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Parameters)) {
                return false;
            }
            Parameters parameters = (Parameters)other;
            return Intrinsics.areEqual((Object)this.parameterString, (Object)parameters.parameterString);
        }
    }
}

