/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import no.nav.security.mock.oauth2.OAuth2Config;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.OAuth2ExceptionKt;
import no.nav.security.mock.oauth2.debugger.DebuggerRequestHandler;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.grant.AuthorizationCodeHandler;
import no.nav.security.mock.oauth2.grant.ClientCredentialsGrantHandler;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import no.nav.security.mock.oauth2.grant.JwtBearerGrantHandler;
import no.nav.security.mock.oauth2.grant.PasswordGrantHandler;
import no.nav.security.mock.oauth2.grant.RefreshTokenGrantHandler;
import no.nav.security.mock.oauth2.grant.RefreshTokenManager;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrantHandler;
import no.nav.security.mock.oauth2.grant.TokenExchangeGrantKt;
import no.nav.security.mock.oauth2.http.CorsInterceptor;
import no.nav.security.mock.oauth2.http.Interceptor;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequestHandler;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequestHandlerKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRouterKt;
import no.nav.security.mock.oauth2.http.OAuth2TokenResponse;
import no.nav.security.mock.oauth2.http.Route;
import no.nav.security.mock.oauth2.introspect.IntrospectKt;
import no.nav.security.mock.oauth2.login.Login;
import no.nav.security.mock.oauth2.login.LoginRequestHandler;
import no.nav.security.mock.oauth2.token.DefaultOAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import no.nav.security.mock.oauth2.userinfo.UserInfoKt;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001bJ\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0002J\f\u0010\"\u001a\u00020#*\u00020#H\u0002J\f\u0010$\u001a\u00020#*\u00020#H\u0002J\f\u0010%\u001a\u00020#*\u00020#H\u0002J\f\u0010&\u001a\u00020#*\u00020#H\u0002J\u0014\u0010'\u001a\u00020#*\u00020#2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\f\u0010(\u001a\u00020#*\u00020#H\u0002J\f\u0010)\u001a\u00020#*\u00020#H\u0002J\f\u0010*\u001a\u00020#*\u00020#H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lno/nav/security/mock/oauth2/http/OAuth2HttpRequestHandler;", "", "config", "Lno/nav/security/mock/oauth2/OAuth2Config;", "(Lno/nav/security/mock/oauth2/OAuth2Config;)V", "authorizationServer", "Lno/nav/security/mock/oauth2/http/Route;", "getAuthorizationServer", "()Lno/nav/security/mock/oauth2/http/Route;", "debuggerRequestHandler", "Lno/nav/security/mock/oauth2/debugger/DebuggerRequestHandler;", "exceptionHandler", "Lkotlin/Function2;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "Lno/nav/security/mock/oauth2/http/ExceptionHandler;", "grantHandlers", "", "Lcom/nimbusds/oauth2/sdk/GrantType;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "loginRequestHandler", "Lno/nav/security/mock/oauth2/login/LoginRequestHandler;", "refreshTokenManager", "Lno/nav/security/mock/oauth2/grant/RefreshTokenManager;", "tokenCallbackQueue", "Ljava/util/concurrent/BlockingQueue;", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "enqueueTokenCallback", "", "oAuth2TokenCallback", "tokenCallbackFromQueueOrDefault", "issuerId", "", "authorization", "Lno/nav/security/mock/oauth2/http/Route$Builder;", "endSession", "jwks", "preflight", "revocation", "staticAssets", "token", "wellKnown", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nOAuth2HttpRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2HttpRequestHandler.kt\nno/nav/security/mock/oauth2/http/OAuth2HttpRequestHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n295#2,2:213\n*S KotlinDebug\n*F\n+ 1 OAuth2HttpRequestHandler.kt\nno/nav/security/mock/oauth2/http/OAuth2HttpRequestHandler\n*L\n208#1:213,2\n*E\n"})
public final class OAuth2HttpRequestHandler {
    @NotNull
    private final OAuth2Config config;
    @NotNull
    private final LoginRequestHandler loginRequestHandler;
    @NotNull
    private final DebuggerRequestHandler debuggerRequestHandler;
    @NotNull
    private final BlockingQueue<OAuth2TokenCallback> tokenCallbackQueue;
    @NotNull
    private final RefreshTokenManager refreshTokenManager;
    @NotNull
    private final Map<GrantType, GrantHandler> grantHandlers;
    @NotNull
    private final Function2<OAuth2HttpRequest, Throwable, OAuth2HttpResponse> exceptionHandler;
    @NotNull
    private final Route authorizationServer;

    public OAuth2HttpRequestHandler(@NotNull OAuth2Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.loginRequestHandler = new LoginRequestHandler(OAuth2HttpResponseKt.getTemplateMapper(), this.config);
        this.debuggerRequestHandler = new DebuggerRequestHandler(null, this.config.getHttpServer().sslConfig(), null, 5, null);
        this.tokenCallbackQueue = new LinkedBlockingQueue();
        this.refreshTokenManager = new RefreshTokenManager(null, 1, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)GrantType.AUTHORIZATION_CODE, (Object)new AuthorizationCodeHandler(this.config.getTokenProvider(), this.refreshTokenManager)), TuplesKt.to((Object)GrantType.CLIENT_CREDENTIALS, (Object)new ClientCredentialsGrantHandler(this.config.getTokenProvider())), TuplesKt.to((Object)GrantType.JWT_BEARER, (Object)new JwtBearerGrantHandler(this.config.getTokenProvider())), TuplesKt.to((Object)TokenExchangeGrantKt.getTOKEN_EXCHANGE(), (Object)new TokenExchangeGrantHandler(this.config.getTokenProvider())), TuplesKt.to((Object)GrantType.REFRESH_TOKEN, (Object)new RefreshTokenGrantHandler(this.config.getTokenProvider(), this.refreshTokenManager, this.config.getRotateRefreshToken())), TuplesKt.to((Object)GrantType.PASSWORD, (Object)new PasswordGrantHandler(this.config.getTokenProvider()))};
        this.grantHandlers = MapsKt.mapOf((Pair[])pairArray);
        this.exceptionHandler = exceptionHandler.1.INSTANCE;
        this.authorizationServer = OAuth2HttpRouterKt.routes((Function1<? super Route.Builder, Unit>)((Function1)new Function1<Route.Builder, Unit>(this){
            final /* synthetic */ OAuth2HttpRequestHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Route.Builder $this$routes) {
                Intrinsics.checkNotNullParameter((Object)$this$routes, (String)"$this$routes");
                $this$routes.exceptionHandler((Function2<? super OAuth2HttpRequest, ? super Throwable, OAuth2HttpResponse>)OAuth2HttpRequestHandler.access$getExceptionHandler$p(this.this$0));
                Object[] objectArray = new Interceptor[]{new CorsInterceptor(null, 1, null)};
                $this$routes.interceptors((Interceptor[])objectArray);
                OAuth2HttpRequestHandler.access$wellKnown(this.this$0, $this$routes);
                OAuth2HttpRequestHandler.access$jwks(this.this$0, $this$routes);
                OAuth2HttpRequestHandler.access$authorization(this.this$0, $this$routes);
                OAuth2HttpRequestHandler.access$token(this.this$0, $this$routes);
                OAuth2HttpRequestHandler.access$endSession(this.this$0, $this$routes);
                OAuth2HttpRequestHandler.access$revocation(this.this$0, $this$routes, OAuth2HttpRequestHandler.access$getRefreshTokenManager$p(this.this$0));
                UserInfoKt.userInfo($this$routes, OAuth2HttpRequestHandler.access$getConfig$p(this.this$0).getTokenProvider());
                IntrospectKt.introspect($this$routes, OAuth2HttpRequestHandler.access$getConfig$p(this.this$0).getTokenProvider());
                OAuth2HttpRequestHandler.access$preflight(this.this$0, $this$routes);
                OAuth2HttpRequestHandler.access$staticAssets(this.this$0, $this$routes);
                objectArray = new String[]{"/favicon.ico"};
                $this$routes.get((String[])objectArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)authorizationServer.1.INSTANCE));
                objectArray = new Route[]{OAuth2HttpRequestHandler.access$getDebuggerRequestHandler$p(this.this$0)};
                $this$routes.attach((Route[])objectArray);
            }
        }));
    }

    @NotNull
    public final Route getAuthorizationServer() {
        return this.authorizationServer;
    }

    public final boolean enqueueTokenCallback(@NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        return this.tokenCallbackQueue.add(oAuth2TokenCallback);
    }

    private final Route.Builder wellKnown(Route.Builder $this$wellKnown) {
        String[] stringArray = new String[]{"/.well-known/openid-configuration", "/.well-known/oauth-authorization-server"};
        return $this$wellKnown.get(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)wellKnown.1.INSTANCE));
    }

    private final Route.Builder jwks(Route.Builder $this$jwks) {
        String[] stringArray = new String[]{"/jwks"};
        return $this$jwks.get(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)new Function1<OAuth2HttpRequest, OAuth2HttpResponse>(this){
            final /* synthetic */ OAuth2HttpRequestHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final OAuth2HttpResponse invoke(OAuth2HttpRequest it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle jwks request on url=" + it.getUrl());
                String issuerId = HttpUrlExtensionsKt.issuerId(it.getUrl());
                JWKSet jwkSet = OAuth2HttpRequestHandler.access$getConfig$p(this.this$0).getTokenProvider().publicJwkSet(issuerId);
                Map map = jwkSet.toJSONObject();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"toJSONObject(...)");
                return OAuth2HttpResponseKt.json(map);
            }
        }));
    }

    private final Route.Builder authorization(Route.Builder $this$authorization) {
        Route.Builder builder;
        Route.Builder $this$authorization_u24lambda_u240 = builder = $this$authorization;
        boolean bl = false;
        GrantHandler grantHandler = this.grantHandlers.get(GrantType.AUTHORIZATION_CODE);
        Intrinsics.checkNotNull((Object)grantHandler, (String)"null cannot be cast to non-null type no.nav.security.mock.oauth2.grant.AuthorizationCodeHandler");
        AuthorizationCodeHandler authorizationCodeHandler = (AuthorizationCodeHandler)grantHandler;
        String[] stringArray = new String[]{"/authorize"};
        $this$authorization_u24lambda_u240.get(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)new Function1<OAuth2HttpRequest, OAuth2HttpResponse>(this, authorizationCodeHandler){
            final /* synthetic */ OAuth2HttpRequestHandler this$0;
            final /* synthetic */ AuthorizationCodeHandler $authorizationCodeHandler;
            {
                this.this$0 = $receiver;
                this.$authorizationCodeHandler = $authorizationCodeHandler;
                super(1);
            }

            public final OAuth2HttpResponse invoke(OAuth2HttpRequest it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AuthenticationRequest authRequest = it.asAuthenticationRequest();
                return OAuth2HttpRequestHandler.access$getConfig$p(this.this$0).getInteractiveLogin() || NimbusExtensionsKt.isPrompt(authRequest) ? OAuth2HttpResponseKt.html(OAuth2HttpRequestHandler.access$getLoginRequestHandler$p(this.this$0).loginHtml(it)) : OAuth2HttpResponseKt.authenticationSuccess(AuthorizationCodeHandler.authorizationCodeResponse$default(this.$authorizationCodeHandler, authRequest, null, 2, null));
            }
        }));
        $this$authorization_u24lambda_u240.post("/authorize", (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)new Function1<OAuth2HttpRequest, OAuth2HttpResponse>(this, authorizationCodeHandler){
            final /* synthetic */ OAuth2HttpRequestHandler this$0;
            final /* synthetic */ AuthorizationCodeHandler $authorizationCodeHandler;
            {
                this.this$0 = $receiver;
                this.$authorizationCodeHandler = $authorizationCodeHandler;
                super(1);
            }

            public final OAuth2HttpResponse invoke(OAuth2HttpRequest it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AuthenticationRequest authRequest = it.asAuthenticationRequest();
                Login login = OAuth2HttpRequestHandler.access$getLoginRequestHandler$p(this.this$0).loginSubmit(it);
                return OAuth2HttpResponseKt.authenticationSuccess(this.$authorizationCodeHandler.authorizationCodeResponse(authRequest, login));
            }
        }));
        return builder;
    }

    private final Route.Builder endSession(Route.Builder $this$endSession) {
        String[] stringArray = new String[]{"/endsession"};
        return $this$endSession.any(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)endSession.1.INSTANCE));
    }

    private final Route.Builder revocation(Route.Builder $this$revocation, RefreshTokenManager refreshTokenManager) {
        return $this$revocation.post("/revoke", (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)new Function1<OAuth2HttpRequest, OAuth2HttpResponse>(refreshTokenManager){
            final /* synthetic */ RefreshTokenManager $refreshTokenManager;
            {
                this.$refreshTokenManager = $refreshTokenManager;
                super(1);
            }

            public final OAuth2HttpResponse invoke(OAuth2HttpRequest it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle revocation request " + it);
                String hint = it.getFormParameters().get("token_type_hint");
                if (!Intrinsics.areEqual((Object)hint, (Object)"refresh_token")) {
                    throw new OAuth2Exception(new ErrorObject("unsupported_token_type", "unsupported token type: " + hint, 400), "unsupported token type: " + hint);
                }
                String string = it.getFormParameters().get("token");
                Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String{ no.nav.security.mock.oauth2.grant.RefreshTokenManagerKt.RefreshToken }");
                String token2 = string;
                this.$refreshTokenManager.remove(token2);
                return new OAuth2HttpResponse(null, 200, "ok", null, 9, null);
            }
        }));
    }

    private final Route.Builder token(Route.Builder $this$token) {
        Route.Builder builder;
        Route.Builder $this$token_u24lambda_u241 = builder = $this$token;
        boolean bl = false;
        String[] stringArray = new String[]{"/token"};
        $this$token_u24lambda_u241.get(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)token.1.1.INSTANCE));
        $this$token_u24lambda_u241.post("/token", (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)new Function1<OAuth2HttpRequest, OAuth2HttpResponse>(this){
            final /* synthetic */ OAuth2HttpRequestHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final OAuth2HttpResponse invoke(OAuth2HttpRequest it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                OAuth2HttpRequestHandlerKt.access$getLog$p().debug("handle token request " + it);
                GrantType grantType = it.grantType();
                OAuth2TokenCallback tokenCallback = OAuth2HttpRequestHandler.access$tokenCallbackFromQueueOrDefault(this.this$0, HttpUrlExtensionsKt.issuerId(it.getUrl()));
                GrantHandler grantHandler = (GrantHandler)OAuth2HttpRequestHandler.access$getGrantHandlers$p(this.this$0).get(grantType);
                if (grantHandler == null) {
                    OAuth2ExceptionKt.invalidGrant(grantType);
                    throw new KotlinNothingValueException();
                }
                GrantHandler grantHandler2 = grantHandler;
                OAuth2TokenResponse tokenResponse = grantHandler2.tokenResponse(it, HttpUrlExtensionsKt.toIssuerUrl(it.getUrl()), tokenCallback);
                return OAuth2HttpResponseKt.json(tokenResponse);
            }
        }));
        return builder;
    }

    private final Route.Builder staticAssets(Route.Builder $this$staticAssets) {
        Route.Builder builder;
        Route.Builder $this$staticAssets_u24lambda_u242 = builder = $this$staticAssets;
        boolean bl = false;
        if (this.config.getStaticAssetsPath() != null) {
            String[] stringArray = new String[]{"/static/*"};
            $this$staticAssets_u24lambda_u242.get(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)new Function1<OAuth2HttpRequest, OAuth2HttpResponse>(this){
                final /* synthetic */ OAuth2HttpRequestHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final OAuth2HttpResponse invoke(OAuth2HttpRequest it) {
                    OAuth2HttpResponse oAuth2HttpResponse;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String path = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)it.getUrl().pathSegments(), (int)1), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                    String normalized = ((Object)Paths.get(path, new String[0]).normalize()).toString();
                    File file = new File(OAuth2HttpRequestHandler.access$getConfig$p(this.this$0).getStaticAssetsPath(), normalized);
                    String string = file.getCanonicalPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
                    if (StringsKt.startsWith$default((String)string, (String)OAuth2HttpRequestHandler.access$getConfig$p(this.this$0).getStaticAssetsPath(), (boolean)false, (int)2, null) && file.exists()) {
                        String string2 = Files.probeContentType(file.toPath());
                        if (string2 == null) {
                            string2 = "application/octet-stream";
                        }
                        String contentType = string2;
                        byte[] byArray = FilesKt.readBytes((File)file);
                        String[] stringArray = new String[]{"Content-Type", contentType};
                        Headers headers = Headers.Companion.of(stringArray);
                        oAuth2HttpResponse = new OAuth2HttpResponse(headers, 200, null, byArray, 4, null);
                    } else {
                        oAuth2HttpResponse = new OAuth2HttpResponse(null, 404, "not found", null, 9, null);
                    }
                    return oAuth2HttpResponse;
                }
            }));
        }
        return builder;
    }

    private final Route.Builder preflight(Route.Builder $this$preflight) {
        return $this$preflight.options((Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)preflight.1.INSTANCE));
    }

    private final OAuth2TokenCallback tokenCallbackFromQueueOrDefault(String issuerId) {
        OAuth2TokenCallback oAuth2TokenCallback;
        OAuth2TokenCallback oAuth2TokenCallback2 = (OAuth2TokenCallback)this.tokenCallbackQueue.peek();
        if (Intrinsics.areEqual((Object)issuerId, (Object)(oAuth2TokenCallback2 != null ? oAuth2TokenCallback2.issuerId() : null))) {
            OAuth2TokenCallback oAuth2TokenCallback3 = this.tokenCallbackQueue.take();
            Intrinsics.checkNotNullExpressionValue((Object)oAuth2TokenCallback3, (String)"take(...)");
            oAuth2TokenCallback = oAuth2TokenCallback3;
        } else {
            Object v3;
            block4: {
                Iterable $this$firstOrNull$iv = this.config.getTokenCallbacks();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    OAuth2TokenCallback it = (OAuth2TokenCallback)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.issuerId(), (Object)issuerId)) continue;
                    v3 = element$iv;
                    break block4;
                }
                v3 = null;
            }
            if ((oAuth2TokenCallback = (OAuth2TokenCallback)v3) == null) {
                oAuth2TokenCallback = new DefaultOAuth2TokenCallback(issuerId, null, null, null, null, 0L, 62, null);
            }
        }
        return oAuth2TokenCallback;
    }

    public static final /* synthetic */ OAuth2Config access$getConfig$p(OAuth2HttpRequestHandler $this) {
        return $this.config;
    }

    public static final /* synthetic */ LoginRequestHandler access$getLoginRequestHandler$p(OAuth2HttpRequestHandler $this) {
        return $this.loginRequestHandler;
    }

    public static final /* synthetic */ OAuth2TokenCallback access$tokenCallbackFromQueueOrDefault(OAuth2HttpRequestHandler $this, String issuerId) {
        return $this.tokenCallbackFromQueueOrDefault(issuerId);
    }

    public static final /* synthetic */ Map access$getGrantHandlers$p(OAuth2HttpRequestHandler $this) {
        return $this.grantHandlers;
    }

    public static final /* synthetic */ Function2 access$getExceptionHandler$p(OAuth2HttpRequestHandler $this) {
        return $this.exceptionHandler;
    }

    public static final /* synthetic */ Route.Builder access$wellKnown(OAuth2HttpRequestHandler $this, Route.Builder $receiver) {
        return $this.wellKnown($receiver);
    }

    public static final /* synthetic */ Route.Builder access$jwks(OAuth2HttpRequestHandler $this, Route.Builder $receiver) {
        return $this.jwks($receiver);
    }

    public static final /* synthetic */ Route.Builder access$authorization(OAuth2HttpRequestHandler $this, Route.Builder $receiver) {
        return $this.authorization($receiver);
    }

    public static final /* synthetic */ Route.Builder access$token(OAuth2HttpRequestHandler $this, Route.Builder $receiver) {
        return $this.token($receiver);
    }

    public static final /* synthetic */ Route.Builder access$endSession(OAuth2HttpRequestHandler $this, Route.Builder $receiver) {
        return $this.endSession($receiver);
    }

    public static final /* synthetic */ Route.Builder access$revocation(OAuth2HttpRequestHandler $this, Route.Builder $receiver, RefreshTokenManager refreshTokenManager) {
        return $this.revocation($receiver, refreshTokenManager);
    }

    public static final /* synthetic */ RefreshTokenManager access$getRefreshTokenManager$p(OAuth2HttpRequestHandler $this) {
        return $this.refreshTokenManager;
    }

    public static final /* synthetic */ Route.Builder access$preflight(OAuth2HttpRequestHandler $this, Route.Builder $receiver) {
        return $this.preflight($receiver);
    }

    public static final /* synthetic */ Route.Builder access$staticAssets(OAuth2HttpRequestHandler $this, Route.Builder $receiver) {
        return $this.staticAssets($receiver);
    }

    public static final /* synthetic */ DebuggerRequestHandler access$getDebuggerRequestHandler$p(OAuth2HttpRequestHandler $this) {
        return $this.debuggerRequestHandler;
    }
}

