/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.token;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.token.KeyGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB!\b\u0007\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0006\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lno/nav/security/mock/oauth2/token/KeyProvider;", "Lcom/nimbusds/jose/jwk/source/JWKSource;", "Lcom/nimbusds/jose/proc/SecurityContext;", "initialKeys", "", "Lcom/nimbusds/jose/jwk/JWK;", "algorithm", "", "(Ljava/util/List;Ljava/lang/String;)V", "generator", "Lno/nav/security/mock/oauth2/token/KeyGenerator;", "keyDeque", "Ljava/util/concurrent/LinkedBlockingDeque;", "signingKeys", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/nimbusds/jose/JWSAlgorithm;", "generate", "", "get", "", "jwkSelector", "Lcom/nimbusds/jose/jwk/JWKSelector;", "context", "keyFromDequeOrNew", "keyId", "keyType", "signingKey", "Companion", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nKeyProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyProvider.kt\nno/nav/security/mock/oauth2/token/KeyProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1869#2,2:78\n*S KotlinDebug\n*F\n+ 1 KeyProvider.kt\nno/nav/security/mock/oauth2/token/KeyProvider\n*L\n28#1:78,2\n*E\n"})
public class KeyProvider
implements JWKSource<SecurityContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<JWK> initialKeys;
    @NotNull
    private final String algorithm;
    @NotNull
    private final ConcurrentHashMap<String, JWK> signingKeys;
    @NotNull
    private KeyGenerator generator;
    @NotNull
    private final LinkedBlockingDeque<JWK> keyDeque;
    @NotNull
    public static final String INITIAL_KEYS_FILE = "/mock-oauth2-server-keys.json";

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public KeyProvider(@NotNull List<? extends JWK> initialKeys, @NotNull String algorithm) {
        LinkedBlockingDeque linkedBlockingDeque;
        Intrinsics.checkNotNullParameter(initialKeys, (String)"initialKeys");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this.initialKeys = initialKeys;
        this.algorithm = algorithm;
        this.signingKeys = new ConcurrentHashMap();
        JWSAlgorithm jWSAlgorithm = JWSAlgorithm.parse((String)this.algorithm);
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"parse(...)");
        this.generator = new KeyGenerator(jWSAlgorithm, null, 2, null);
        LinkedBlockingDeque linkedBlockingDeque2 = linkedBlockingDeque = new LinkedBlockingDeque();
        KeyProvider keyProvider = this;
        boolean bl = false;
        Iterable $this$forEach$iv = this.initialKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$keyDeque_u24lambda_u241;
            JWK it = (JWK)element$iv;
            boolean bl2 = false;
            $this$keyDeque_u24lambda_u241.put(it);
        }
        keyProvider.keyDeque = linkedBlockingDeque;
    }

    public /* synthetic */ KeyProvider(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = Companion.keysFromFile(INITIAL_KEYS_FILE);
        }
        if ((n & 2) != 0) {
            String string2 = JWSAlgorithm.RS256.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            string = string2;
        }
        this(list, string);
    }

    @NotNull
    public final JWK signingKey(@NotNull String keyId) {
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        JWK jWK = this.signingKeys.computeIfAbsent(keyId, arg_0 -> KeyProvider.signingKey$lambda$2((Function1)new Function1<String, JWK>(this, keyId){
            final /* synthetic */ KeyProvider this$0;
            final /* synthetic */ String $keyId;
            {
                this.this$0 = $receiver;
                this.$keyId = $keyId;
                super(1);
            }

            public final JWK invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return KeyProvider.access$keyFromDequeOrNew(this.this$0, this.$keyId);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jWK, (String)"computeIfAbsent(...)");
        return jWK;
    }

    private final JWK keyFromDequeOrNew(String keyId) {
        JWK jWK;
        block8: {
            block7: {
                RSAKey rSAKey;
                jWK = this.keyDeque.poll();
                if (jWK == null) break block7;
                JWK polledJwk = jWK;
                boolean bl = false;
                String string = polledJwk.getKeyType().getValue();
                if (Intrinsics.areEqual((Object)string, (Object)KeyType.RSA.getValue())) {
                    rSAKey = new RSAKey.Builder(polledJwk.toRSAKey()).keyID(keyId).build();
                } else if (Intrinsics.areEqual((Object)string, (Object)KeyType.EC.getValue())) {
                    rSAKey = new ECKey.Builder(polledJwk.toECKey()).keyID(keyId).build();
                } else {
                    throw new OAuth2Exception("Unsupported key type: " + polledJwk.getKeyType().getValue());
                }
                JWK jWK2 = (JWK)rSAKey;
                jWK = jWK2;
                if (jWK2 != null) break block8;
            }
            jWK = this.generator.generateKey(keyId);
        }
        return jWK;
    }

    @NotNull
    public final JWSAlgorithm algorithm() {
        JWSAlgorithm jWSAlgorithm = JWSAlgorithm.parse((String)this.algorithm);
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"parse(...)");
        return jWSAlgorithm;
    }

    @NotNull
    public final String keyType() {
        String string = this.generator.getKeyGenerator().getAlgorithm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAlgorithm(...)");
        return string;
    }

    public final void generate(@NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        JWSAlgorithm jWSAlgorithm = JWSAlgorithm.parse((String)algorithm);
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"parse(...)");
        this.generator = new KeyGenerator(jWSAlgorithm, null, 2, null);
    }

    @NotNull
    public List<JWK> get(@Nullable JWKSelector jwkSelector, @Nullable SecurityContext context) {
        List list;
        JWKSelector jWKSelector = jwkSelector;
        if (jWKSelector != null) {
            Collection<JWK> collection = this.signingKeys.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            list = jWKSelector.select(new JWKSet(CollectionsKt.toList((Iterable)collection)).toPublicJWKSet());
        } else {
            list = null;
        }
        List list2 = list;
        return list2 == null ? (List)new ArrayList() : list2;
    }

    @JvmOverloads
    public KeyProvider(@NotNull List<? extends JWK> initialKeys) {
        Intrinsics.checkNotNullParameter(initialKeys, (String)"initialKeys");
        this(initialKeys, null, 2, null);
    }

    @JvmOverloads
    public KeyProvider() {
        this(null, null, 3, null);
    }

    private static final JWK signingKey$lambda$2(Function1 $tmp0, Object p0) {
        return (JWK)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ JWK access$keyFromDequeOrNew(KeyProvider $this, String keyId) {
        return $this.keyFromDequeOrNew(keyId);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lno/nav/security/mock/oauth2/token/KeyProvider$Companion;", "", "()V", "INITIAL_KEYS_FILE", "", "keysFromFile", "", "Lcom/nimbusds/jose/jwk/JWK;", "filename", "mock-oauth2-server"})
    @SourceDebugExtension(value={"SMAP\nKeyProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyProvider.kt\nno/nav/security/mock/oauth2/token/KeyProvider$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1563#2:78\n1634#2,3:79\n*S KotlinDebug\n*F\n+ 1 KeyProvider.kt\nno/nav/security/mock/oauth2/token/KeyProvider$Companion\n*L\n66#1:78\n66#1:79,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<JWK> keysFromFile(@NotNull String filename) {
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            URL keysFromFile = KeyProvider.class.getResource(filename);
            if (keysFromFile != null) {
                void $this$mapTo$iv$iv;
                URL uRL = keysFromFile;
                Object object = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
                List list = JWKSet.parse((String)new String(byArray, (Charset)object)).getKeys();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeys(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JWK jWK = (JWK)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.nimbusds.jose.jwk.JWK");
                    collection.add(it);
                }
                return (List)destination$iv$iv;
            }
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

