/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpRouterKt;
import no.nav.security.mock.oauth2.http.PathRoute;
import no.nav.security.mock.oauth2.http.Route;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\u001a&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n\u001a&\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n\u001a&\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n\u001a&\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n\u001a4\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0007\u001a4\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0002\u001a\u001f\u0010\u0011\u001a\u00020\u00032\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0012\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0013\u001a\u001f\u0010\u0011\u001a\u00020\u00032\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0007\u00a2\u0006\u0002\b\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000*0\b\u0000\u0010\u0018\"\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\t0\u00192\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\t0\u0019*\"\u0010\u001b\"\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a8\u0006\u001c"}, d2={"log", "Lmu/KLogger;", "get", "Lno/nav/security/mock/oauth2/http/Route;", "path", "", "requestHandler", "Lkotlin/Function1;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "Lno/nav/security/mock/oauth2/http/RequestHandler;", "options", "post", "put", "route", "method", "routeFromPathAndMethod", "routes", "", "([Lno/nav/security/mock/oauth2/http/Route;)Lno/nav/security/mock/oauth2/http/Route;", "config", "Lno/nav/security/mock/oauth2/http/Route$Builder;", "", "Lkotlin/ExtensionFunctionType;", "ExceptionHandler", "Lkotlin/Function2;", "", "RequestHandler", "mock-oauth2-server"})
public final class OAuth2HttpRouterKt {
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);

    @NotNull
    public static final Route routes(Route ... route) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        return OAuth2HttpRouterKt.routes((Function1<? super Route.Builder, Unit>)((Function1)new Function1<Route.Builder, Unit>(route){
            final /* synthetic */ Route[] $route;
            {
                this.$route = $route;
                super(1);
            }

            public final void invoke(Route.Builder $this$routes) {
                Intrinsics.checkNotNullParameter((Object)$this$routes, (String)"$this$routes");
                $this$routes.attach(Arrays.copyOf(this.$route, this.$route.length));
            }
        }));
    }

    @NotNull
    public static final Route routes(@NotNull Function1<? super Route.Builder, Unit> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Route.Builder builder = new Route.Builder();
        config.invoke((Object)builder);
        return builder.build();
    }

    @JvmOverloads
    @NotNull
    public static final Route route(@NotNull String path, @Nullable String method, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        return OAuth2HttpRouterKt.routeFromPathAndMethod(path, method, requestHandler);
    }

    public static /* synthetic */ Route route$default(String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return OAuth2HttpRouterKt.route(string, string2, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)function1);
    }

    @NotNull
    public static final Route put(@NotNull String path, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        return OAuth2HttpRouterKt.routeFromPathAndMethod(path, "PUT", requestHandler);
    }

    @NotNull
    public static final Route post(@NotNull String path, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        return OAuth2HttpRouterKt.routeFromPathAndMethod(path, "POST", requestHandler);
    }

    @NotNull
    public static final Route get(@NotNull String path, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        return OAuth2HttpRouterKt.routeFromPathAndMethod(path, "GET", requestHandler);
    }

    @NotNull
    public static final Route options(@NotNull String path, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        return OAuth2HttpRouterKt.routeFromPathAndMethod(path, "OPTIONS", requestHandler);
    }

    private static final Route routeFromPathAndMethod(String path, String method, Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        return new PathRoute(path, requestHandler, method){
            final /* synthetic */ String $path;
            final /* synthetic */ Function1<OAuth2HttpRequest, OAuth2HttpResponse> $requestHandler;
            final /* synthetic */ String $method;
            {
                this.$path = $path;
                this.$requestHandler = $requestHandler;
                this.$method = $method;
            }

            public boolean matchPath(OAuth2HttpRequest request) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                if (StringsKt.contains$default((CharSequence)this.$path, (CharSequence)"*", (boolean)false, (int)2, null)) {
                    String string = StringsKt.replace$default((String)this.$path, (String)"*", (String)".*", (boolean)false, (int)4, null);
                    Regex regex = new Regex(string);
                    bl = regex.matches((CharSequence)("/" + CollectionsKt.joinToString$default((Iterable)request.getUrl().pathSegments(), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null)));
                } else {
                    bl = HttpUrlExtensionsKt.endsWith(request.getUrl(), this.$path);
                }
                return bl;
            }

            public boolean match(OAuth2HttpRequest request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                return this.matchPath(request) && this.matchMethod(request);
            }

            public OAuth2HttpResponse invoke(OAuth2HttpRequest request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                return (OAuth2HttpResponse)this.$requestHandler.invoke((Object)request);
            }

            public String toString() {
                return "[path=" + this.$path + ", method=" + this.$method + "]";
            }

            private final boolean matchMethod(OAuth2HttpRequest request) {
                boolean bl;
                String string = this.$method;
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    bl = Intrinsics.areEqual((Object)it, (Object)request.getMethod());
                } else {
                    bl = true;
                }
                return bl;
            }
        };
    }

    static /* synthetic */ Route routeFromPathAndMethod$default(String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return OAuth2HttpRouterKt.routeFromPathAndMethod(string, string2, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)function1);
    }

    @JvmOverloads
    @NotNull
    public static final Route route(@NotNull String path, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        return OAuth2HttpRouterKt.route$default(path, null, requestHandler, 2, null);
    }

    public static final /* synthetic */ Route access$routeFromPathAndMethod(String path, String method, Function1 requestHandler) {
        return OAuth2HttpRouterKt.routeFromPathAndMethod(path, method, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)requestHandler);
    }

    public static final /* synthetic */ KLogger access$getLog$p() {
        return log;
    }
}

