/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.spring.oidc.validation.interceptor;

import java.io.IOException;
import no.nav.security.oidc.context.OIDCRequestContextHolder;
import no.nav.security.oidc.context.OIDCValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class BearerTokenClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private OIDCRequestContextHolder contextHolder;
    private Logger logger = LoggerFactory.getLogger(BearerTokenClientHttpRequestInterceptor.class);

    public BearerTokenClientHttpRequestInterceptor(OIDCRequestContextHolder contextHolder) {
        this.contextHolder = contextHolder;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        OIDCValidationContext context = this.contextHolder.getOIDCValidationContext();
        if (context != null && context.hasValidToken()) {
            this.logger.debug("adding tokens to Authorization header");
            StringBuffer headerValue = new StringBuffer();
            boolean first = true;
            for (String issuer : context.getIssuers()) {
                this.logger.debug("adding token for issuer {}", (Object)issuer);
                if (!first) {
                    headerValue.append(",");
                }
                headerValue.append("Bearer " + context.getToken(issuer).getIdToken());
            }
            request.getHeaders().add("Authorization", headerValue.toString());
        } else {
            this.logger.debug("no tokens found, nothing added to request");
        }
        return execution.execute(request, body);
    }
}

