/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.spring.oidc.validation.interceptor;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.nav.security.oidc.api.Protected;
import no.nav.security.oidc.api.ProtectedWithClaims;
import no.nav.security.oidc.api.Unprotected;
import no.nav.security.oidc.context.OIDCClaims;
import no.nav.security.oidc.context.OIDCRequestContextHolder;
import no.nav.security.oidc.context.OIDCValidationContext;
import no.nav.security.spring.oidc.validation.interceptor.OIDCUnauthorizedException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class OIDCTokenControllerHandlerInterceptor
implements HandlerInterceptor {
    private Logger logger = LoggerFactory.getLogger(OIDCTokenControllerHandlerInterceptor.class);
    private OIDCRequestContextHolder contextHolder;
    private String[] ignoreConfig;
    private Map<Object, Boolean> handlerFlags = new ConcurrentHashMap<Object, Boolean>();

    public OIDCTokenControllerHandlerInterceptor(AnnotationAttributes enableOIDCTokenValidation, OIDCRequestContextHolder contextHolder) {
        this.contextHolder = contextHolder;
        if (enableOIDCTokenValidation != null) {
            this.ignoreConfig = enableOIDCTokenValidation.getStringArray("ignore");
            if (this.ignoreConfig == null) {
                this.ignoreConfig = new String[0];
            }
        } else {
            this.ignoreConfig = new String[0];
        }
    }

    public void afterCompletion(HttpServletRequest arg0, HttpServletResponse arg1, Object handler, Exception arg3) throws Exception {
    }

    public void postHandle(HttpServletRequest arg0, HttpServletResponse arg1, Object handler, ModelAndView arg3) throws Exception {
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        OIDCValidationContext validationContext = this.contextHolder.getOIDCValidationContext();
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            if (this.shouldIgnore(handlerMethod.getBean())) {
                return true;
            }
            Unprotected unprotectedAnnotation = (Unprotected)handlerMethod.getMethodAnnotation(Unprotected.class);
            if (unprotectedAnnotation != null) {
                this.logger.debug("method " + handlerMethod + " marked @Unprotected");
                return true;
            }
            ProtectedWithClaims withClaimsAnnotation = (ProtectedWithClaims)handlerMethod.getMethodAnnotation(ProtectedWithClaims.class);
            if (withClaimsAnnotation != null) {
                this.logger.debug("method " + handlerMethod + " marked @ProtectedWithClaims");
                return this.handleProtectedWithClaimsAnnotation(validationContext, withClaimsAnnotation);
            }
            Protected protectedAnnotation = (Protected)handlerMethod.getMethodAnnotation(Protected.class);
            if (protectedAnnotation != null) {
                this.logger.debug("method " + handlerMethod + " marked @Protected");
                return this.handleProtectedAnnotation(validationContext);
            }
            Method method = handlerMethod.getMethod();
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass.isAnnotationPresent(Unprotected.class)) {
                this.logger.debug("method " + handlerMethod + " marked @Unprotected throug annotation on class");
                return true;
            }
            if (declaringClass.isAnnotationPresent(ProtectedWithClaims.class)) {
                this.logger.debug("method " + handlerMethod + " marked @ProtectedWithClaims");
                return this.handleProtectedWithClaimsAnnotation(validationContext, declaringClass.getAnnotation(ProtectedWithClaims.class));
            }
            if (declaringClass.isAnnotationPresent(Protected.class)) {
                this.logger.debug("method " + handlerMethod + " marked @Protected");
                return this.handleProtectedAnnotation(validationContext);
            }
            this.logger.debug("method " + handlerMethod + " not marked, access denied (returning NOT_IMPLEMENTED)");
            throw new OIDCUnauthorizedException("Server misconfigured - controller/method [" + handlerMethod.getBean().getClass().getName() + "." + handlerMethod.getMethod().getName() + "] not annotated @Unprotected, @Protected or added to ignore list");
        }
        this.logger.debug("Handler is of type {}, allowing unprotected access to the resources it accesses", (Object)handler.getClass().getSimpleName());
        return true;
    }

    protected boolean handleProtectedAnnotation(OIDCValidationContext validationContext) {
        if (validationContext.hasValidToken()) {
            return true;
        }
        this.logger.debug("no token found in validation context");
        throw new OIDCUnauthorizedException("Authorization token required");
    }

    protected boolean handleProtectedWithClaimsAnnotation(OIDCValidationContext validationContext, ProtectedWithClaims annotation) {
        String issuer = annotation.issuer();
        String[] claims = annotation.claimMap();
        if (StringUtils.isNotBlank((CharSequence)issuer)) {
            OIDCClaims tokenClaims = validationContext.getClaims(issuer);
            if (tokenClaims == null) {
                this.logger.trace(String.format("could not find token for issuer '%s' in validation context. Login may be required.", issuer));
                throw new OIDCUnauthorizedException("Authorization token not authorized");
            }
            if (!this.containsRequiredClaims(tokenClaims, annotation.combineWithOr(), annotation.claimMap())) {
                this.logger.info("token does not contain all annotated claims");
                throw new OIDCUnauthorizedException("Authorization token not authorized");
            }
        }
        return true;
    }

    protected boolean containsRequiredClaims(OIDCClaims tokenClaims, boolean combineWithOr, String ... claims) {
        this.logger.debug("choose matching logic based on combineWithOr=" + combineWithOr);
        return combineWithOr ? this.containsAnyClaim(tokenClaims, claims) : this.containsAllClaims(tokenClaims, claims);
    }

    protected boolean containsAllClaims(OIDCClaims tokenClaims, String ... claims) {
        for (String string : claims) {
            String name = StringUtils.substringBefore((String)string, (String)"=").trim();
            String value = StringUtils.substringAfter((String)string, (String)"=").trim();
            if (!StringUtils.isNotBlank((CharSequence)name) || tokenClaims.containsClaim(name, value)) continue;
            this.logger.debug(String.format("token does not contain %s = %s", name, value));
            return false;
        }
        return true;
    }

    protected boolean containsAnyClaim(OIDCClaims tokenClaims, String ... claims) {
        if (claims != null && claims.length > 0) {
            for (String string : claims) {
                String name = StringUtils.substringBefore((String)string, (String)"=").trim();
                String value = StringUtils.substringAfter((String)string, (String)"=").trim();
                if (!StringUtils.isNotBlank((CharSequence)name) || !tokenClaims.containsClaim(name, value)) continue;
                return true;
            }
            this.logger.debug("token does not contain any of the listed claims");
            return false;
        }
        this.logger.debug("no claims listed, so claim checking is ok.");
        return true;
    }

    private boolean shouldIgnore(Object object) {
        Boolean flag = this.handlerFlags.get(object);
        if (flag != null) {
            return flag;
        }
        String fullName = object.getClass().getName();
        for (String ignore : this.ignoreConfig) {
            if (!fullName.startsWith(ignore)) continue;
            this.logger.info("Adding " + fullName + " to OIDC validation ignore list");
            this.handlerFlags.put(object, true);
            return true;
        }
        this.logger.info("Adding " + fullName + " to OIDC validation interceptor list");
        this.handlerFlags.put(object, false);
        return false;
    }
}

