/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core;

import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import no.nav.security.token.support.client.core.OAuth2ClientException;
import no.nav.security.token.support.client.core.OAuth2GrantType;

public class ClientProperties {
    private static final List<OAuth2GrantType> GRANT_TYPES = List.of(OAuth2GrantType.JWT_BEARER, OAuth2GrantType.CLIENT_CREDENTIALS);
    private static final List<ClientAuthenticationMethod> CLIENT_AUTH_METHODS = List.of(ClientAuthenticationMethod.CLIENT_SECRET_BASIC, ClientAuthenticationMethod.CLIENT_SECRET_POST, ClientAuthenticationMethod.PRIVATE_KEY_JWT);
    @NotNull
    private URI resourceUrl;
    @NotNull
    private URI tokenEndpointUrl;
    @NotEmpty
    private String clientId;
    @NotEmpty
    private String clientSecret;
    private ClientAuthenticationMethod clientAuthMethod = ClientAuthenticationMethod.CLIENT_SECRET_BASIC;
    @NotNull
    private OAuth2GrantType grantType;
    @NotEmpty
    private List<String> scope;

    public void setGrantType(OAuth2GrantType oAuth2GrantType) {
        this.setGrantType((String)Optional.ofNullable(oAuth2GrantType.getValue()).orElse(null));
    }

    public void setGrantType(String value) {
        this.grantType = GRANT_TYPES.stream().filter(grant -> grant.getValue().equals(value)).findFirst().orElseThrow(this.unsupported(OAuth2GrantType.class, value));
    }

    public void setClientAuthMethod(ClientAuthenticationMethod clientAuthMethod) {
        this.setClientAuthMethod((String)Optional.ofNullable(clientAuthMethod.getValue()).orElse(null));
    }

    public void setClientAuthMethod(String value) {
        this.clientAuthMethod = CLIENT_AUTH_METHODS.stream().filter(c -> c.getValue().equals(value)).findFirst().orElseThrow(this.unsupported(ClientAuthenticationMethod.class, value));
    }

    private Supplier<OAuth2ClientException> unsupported(Class<?> clazz, String value) {
        return () -> new OAuth2ClientException(String.format("unsupported %s with value %s, must be one of %s", clazz.getSimpleName(), value, CLIENT_AUTH_METHODS));
    }

    public URI getResourceUrl() {
        return this.resourceUrl;
    }

    public URI getTokenEndpointUrl() {
        return this.tokenEndpointUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public ClientAuthenticationMethod getClientAuthMethod() {
        return this.clientAuthMethod;
    }

    public OAuth2GrantType getGrantType() {
        return this.grantType;
    }

    public List<String> getScope() {
        return this.scope;
    }

    public void setResourceUrl(URI resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public void setTokenEndpointUrl(URI tokenEndpointUrl) {
        this.tokenEndpointUrl = tokenEndpointUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientProperties)) {
            return false;
        }
        ClientProperties other = (ClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$resourceUrl = this.getResourceUrl();
        URI other$resourceUrl = other.getResourceUrl();
        if (this$resourceUrl == null ? other$resourceUrl != null : !((Object)this$resourceUrl).equals(other$resourceUrl)) {
            return false;
        }
        URI this$tokenEndpointUrl = this.getTokenEndpointUrl();
        URI other$tokenEndpointUrl = other.getTokenEndpointUrl();
        if (this$tokenEndpointUrl == null ? other$tokenEndpointUrl != null : !((Object)this$tokenEndpointUrl).equals(other$tokenEndpointUrl)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        ClientAuthenticationMethod this$clientAuthMethod = this.getClientAuthMethod();
        ClientAuthenticationMethod other$clientAuthMethod = other.getClientAuthMethod();
        if (this$clientAuthMethod == null ? other$clientAuthMethod != null : !this$clientAuthMethod.equals(other$clientAuthMethod)) {
            return false;
        }
        OAuth2GrantType this$grantType = this.getGrantType();
        OAuth2GrantType other$grantType = other.getGrantType();
        if (this$grantType == null ? other$grantType != null : !((Object)this$grantType).equals(other$grantType)) {
            return false;
        }
        List<String> this$scope = this.getScope();
        List<String> other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $resourceUrl = this.getResourceUrl();
        result = result * 59 + ($resourceUrl == null ? 43 : ((Object)$resourceUrl).hashCode());
        URI $tokenEndpointUrl = this.getTokenEndpointUrl();
        result = result * 59 + ($tokenEndpointUrl == null ? 43 : ((Object)$tokenEndpointUrl).hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        ClientAuthenticationMethod $clientAuthMethod = this.getClientAuthMethod();
        result = result * 59 + ($clientAuthMethod == null ? 43 : $clientAuthMethod.hashCode());
        OAuth2GrantType $grantType = this.getGrantType();
        result = result * 59 + ($grantType == null ? 43 : $grantType.hashCode());
        List<String> $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        return result;
    }

    public String toString() {
        return "ClientProperties(resourceUrl=" + this.getResourceUrl() + ", tokenEndpointUrl=" + this.getTokenEndpointUrl() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", clientAuthMethod=" + this.getClientAuthMethod() + ", grantType=" + this.getGrantType() + ", scope=" + this.getScope() + ")";
    }
}

