/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import no.nav.security.token.support.client.core.ClientAuthenticationProperties;
import no.nav.security.token.support.client.core.OAuth2GrantType;

public class ClientProperties {
    private static final List<OAuth2GrantType> GRANT_TYPES = List.of(OAuth2GrantType.JWT_BEARER, OAuth2GrantType.CLIENT_CREDENTIALS);
    @NotNull
    private final URI tokenEndpointUrl;
    @NotNull
    private final OAuth2GrantType grantType;
    @NotEmpty
    private final List<String> scope;
    @NotNull
    private final ClientAuthenticationProperties authentication;
    private final URI resourceUrl;

    public ClientProperties(@NotNull URI tokenEndpointUrl, @NotNull OAuth2GrantType grantType, @NotEmpty List<String> scope, @NotNull ClientAuthenticationProperties authentication, URI resourceUrl) {
        this.tokenEndpointUrl = tokenEndpointUrl;
        this.grantType = ClientProperties.getSupported(grantType);
        this.scope = scope;
        this.authentication = authentication;
        this.resourceUrl = resourceUrl;
    }

    private static OAuth2GrantType getSupported(OAuth2GrantType oAuth2GrantType) {
        return Optional.ofNullable(oAuth2GrantType).filter(GRANT_TYPES::contains).orElseThrow(ClientProperties.unsupported(oAuth2GrantType));
    }

    private static Supplier<IllegalArgumentException> unsupported(OAuth2GrantType oAuth2GrantType) {
        return () -> new IllegalArgumentException(String.format("unsupported %s with value %s, must be one of %s", OAuth2GrantType.class.getSimpleName(), oAuth2GrantType, GRANT_TYPES));
    }

    public static ClientPropertiesBuilder builder() {
        return new ClientPropertiesBuilder();
    }

    public ClientPropertiesBuilder toBuilder() {
        return new ClientPropertiesBuilder().tokenEndpointUrl(this.tokenEndpointUrl).grantType(this.grantType).scope(this.scope).authentication(this.authentication).resourceUrl(this.resourceUrl);
    }

    public URI getTokenEndpointUrl() {
        return this.tokenEndpointUrl;
    }

    public OAuth2GrantType getGrantType() {
        return this.grantType;
    }

    public List<String> getScope() {
        return this.scope;
    }

    public ClientAuthenticationProperties getAuthentication() {
        return this.authentication;
    }

    public URI getResourceUrl() {
        return this.resourceUrl;
    }

    public String toString() {
        return "ClientProperties(tokenEndpointUrl=" + this.getTokenEndpointUrl() + ", grantType=" + this.getGrantType() + ", scope=" + this.getScope() + ", authentication=" + this.getAuthentication() + ", resourceUrl=" + this.getResourceUrl() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientProperties)) {
            return false;
        }
        ClientProperties other = (ClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$tokenEndpointUrl = this.getTokenEndpointUrl();
        URI other$tokenEndpointUrl = other.getTokenEndpointUrl();
        if (this$tokenEndpointUrl == null ? other$tokenEndpointUrl != null : !((Object)this$tokenEndpointUrl).equals(other$tokenEndpointUrl)) {
            return false;
        }
        OAuth2GrantType this$grantType = this.getGrantType();
        OAuth2GrantType other$grantType = other.getGrantType();
        if (this$grantType == null ? other$grantType != null : !((Object)this$grantType).equals(other$grantType)) {
            return false;
        }
        List<String> this$scope = this.getScope();
        List<String> other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
            return false;
        }
        ClientAuthenticationProperties this$authentication = this.getAuthentication();
        ClientAuthenticationProperties other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !((Object)this$authentication).equals(other$authentication)) {
            return false;
        }
        URI this$resourceUrl = this.getResourceUrl();
        URI other$resourceUrl = other.getResourceUrl();
        return !(this$resourceUrl == null ? other$resourceUrl != null : !((Object)this$resourceUrl).equals(other$resourceUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $tokenEndpointUrl = this.getTokenEndpointUrl();
        result = result * 59 + ($tokenEndpointUrl == null ? 43 : ((Object)$tokenEndpointUrl).hashCode());
        OAuth2GrantType $grantType = this.getGrantType();
        result = result * 59 + ($grantType == null ? 43 : $grantType.hashCode());
        List<String> $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        ClientAuthenticationProperties $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : ((Object)$authentication).hashCode());
        URI $resourceUrl = this.getResourceUrl();
        result = result * 59 + ($resourceUrl == null ? 43 : ((Object)$resourceUrl).hashCode());
        return result;
    }

    public static class ClientPropertiesBuilder {
        private URI tokenEndpointUrl;
        private OAuth2GrantType grantType;
        private List<String> scope;
        private ClientAuthenticationProperties authentication;
        private URI resourceUrl;

        ClientPropertiesBuilder() {
        }

        public ClientPropertiesBuilder tokenEndpointUrl(URI tokenEndpointUrl) {
            this.tokenEndpointUrl = tokenEndpointUrl;
            return this;
        }

        public ClientPropertiesBuilder grantType(OAuth2GrantType grantType) {
            this.grantType = grantType;
            return this;
        }

        public ClientPropertiesBuilder scope(List<String> scope) {
            this.scope = scope;
            return this;
        }

        public ClientPropertiesBuilder authentication(ClientAuthenticationProperties authentication) {
            this.authentication = authentication;
            return this;
        }

        public ClientPropertiesBuilder resourceUrl(URI resourceUrl) {
            this.resourceUrl = resourceUrl;
            return this;
        }

        public ClientProperties build() {
            return new ClientProperties(this.tokenEndpointUrl, this.grantType, this.scope, this.authentication, this.resourceUrl);
        }

        public String toString() {
            return "ClientProperties.ClientPropertiesBuilder(tokenEndpointUrl=" + this.tokenEndpointUrl + ", grantType=" + this.grantType + ", scope=" + this.scope + ", authentication=" + this.authentication + ", resourceUrl=" + this.resourceUrl + ")";
        }
    }
}

