/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core.auth;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.net.URI;
import java.sql.Date;
import java.time.Instant;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import no.nav.security.token.support.client.core.ClientAuthenticationProperties;

public class ClientAssertion {
    private static final int EXPIRY_IN_SECONDS = 60;
    private final URI tokenEndpointUrl;
    private final String clientId;
    private final RSAKey rsaKey;
    private final int expiryInSeconds;

    public ClientAssertion(@NotNull URI tokenEndpointUrl, @NotNull ClientAuthenticationProperties clientAuthenticationProperties) {
        this(tokenEndpointUrl, clientAuthenticationProperties.getClientId(), clientAuthenticationProperties.getClientRsaKey(), 60);
    }

    public ClientAssertion(URI tokenEndpointUrl, String clientId, RSAKey rsaKey, int expiryInSeconds) {
        this.tokenEndpointUrl = tokenEndpointUrl;
        this.rsaKey = rsaKey;
        this.clientId = clientId;
        this.expiryInSeconds = expiryInSeconds;
    }

    public String assertion() {
        Instant now = Instant.now();
        return this.createSignedJWT(this.rsaKey, new JWTClaimsSet.Builder().audience(this.tokenEndpointUrl.toString()).expirationTime(Date.from(now.plusSeconds(this.expiryInSeconds))).issuer(this.clientId).subject(this.clientId).claim("jti", (Object)UUID.randomUUID().toString()).notBeforeTime(Date.from(now)).build()).serialize();
    }

    public String assertionType() {
        return "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    }

    private SignedJWT createSignedJWT(RSAKey rsaJwk, JWTClaimsSet claimsSet) {
        try {
            JWSHeader.Builder header = new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(rsaJwk.getKeyID()).type(JOSEObjectType.JWT);
            SignedJWT signedJWT = new SignedJWT(header.build(), claimsSet);
            RSASSASigner signer = new RSASSASigner(rsaJwk.toPrivateKey());
            signedJWT.sign((JWSSigner)signer);
            return signedJWT;
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
    }
}

