/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core;

import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.validation.constraints.NotNull;
import no.nav.security.token.support.client.core.jwk.JwkFactory;

public class ClientAuthenticationProperties {
    private static final List<ClientAuthenticationMethod> CLIENT_AUTH_METHODS = List.of(ClientAuthenticationMethod.CLIENT_SECRET_BASIC, ClientAuthenticationMethod.CLIENT_SECRET_POST, ClientAuthenticationMethod.PRIVATE_KEY_JWT);
    @NotNull
    private final String clientId;
    private final ClientAuthenticationMethod clientAuthMethod;
    private final String clientSecret;
    private final String clientJwk;
    private final RSAKey clientRsaKey;

    public ClientAuthenticationProperties(@NotNull String clientId, ClientAuthenticationMethod clientAuthMethod, String clientSecret, String clientJwk) {
        this.clientId = clientId;
        this.clientAuthMethod = ClientAuthenticationProperties.getSupported(clientAuthMethod);
        this.clientSecret = clientSecret;
        this.clientJwk = clientJwk;
        this.clientRsaKey = ClientAuthenticationProperties.loadKey(clientJwk);
        this.validateAfterPropertiesSet();
    }

    private static RSAKey loadKey(String clientPrivateKey) {
        return Optional.ofNullable(clientPrivateKey).map(JwkFactory::fromJsonFile).orElse(null);
    }

    private static ClientAuthenticationMethod getSupported(ClientAuthenticationMethod clientAuthMethod) {
        return clientAuthMethod == null ? ClientAuthenticationMethod.CLIENT_SECRET_BASIC : Optional.of(clientAuthMethod).filter(CLIENT_AUTH_METHODS::contains).orElseThrow(ClientAuthenticationProperties.unsupported(clientAuthMethod));
    }

    private void validateAfterPropertiesSet() {
        Objects.requireNonNull(this.clientId, "clientId cannot be null");
        if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)this.clientAuthMethod)) {
            Objects.requireNonNull(this.clientSecret, "clientSecret cannot be null");
        } else if (ClientAuthenticationMethod.CLIENT_SECRET_POST.equals((Object)this.clientAuthMethod)) {
            Objects.requireNonNull(this.clientSecret, "clientSecret cannot be null");
        } else if (ClientAuthenticationMethod.PRIVATE_KEY_JWT.equals((Object)this.clientAuthMethod)) {
            Objects.requireNonNull(this.clientJwk, "clientPrivateKey must be set");
        }
    }

    private static Supplier<IllegalArgumentException> unsupported(ClientAuthenticationMethod clientAuthMethod) {
        return () -> new IllegalArgumentException(String.format("unsupported %s with value %s, must be one of %s", ClientAuthenticationMethod.class.getSimpleName(), clientAuthMethod, CLIENT_AUTH_METHODS));
    }

    public static ClientAuthenticationPropertiesBuilder builder() {
        return new ClientAuthenticationPropertiesBuilder();
    }

    public ClientAuthenticationPropertiesBuilder toBuilder() {
        return new ClientAuthenticationPropertiesBuilder().clientId(this.clientId).clientAuthMethod(this.clientAuthMethod).clientSecret(this.clientSecret).clientJwk(this.clientJwk);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientAuthenticationProperties)) {
            return false;
        }
        ClientAuthenticationProperties other = (ClientAuthenticationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        ClientAuthenticationMethod this$clientAuthMethod = this.getClientAuthMethod();
        ClientAuthenticationMethod other$clientAuthMethod = other.getClientAuthMethod();
        if (this$clientAuthMethod == null ? other$clientAuthMethod != null : !this$clientAuthMethod.equals(other$clientAuthMethod)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$clientJwk = this.clientJwk;
        String other$clientJwk = other.clientJwk;
        if (this$clientJwk == null ? other$clientJwk != null : !this$clientJwk.equals(other$clientJwk)) {
            return false;
        }
        RSAKey this$clientRsaKey = this.getClientRsaKey();
        RSAKey other$clientRsaKey = other.getClientRsaKey();
        return !(this$clientRsaKey == null ? other$clientRsaKey != null : !this$clientRsaKey.equals(other$clientRsaKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientAuthenticationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        ClientAuthenticationMethod $clientAuthMethod = this.getClientAuthMethod();
        result = result * 59 + ($clientAuthMethod == null ? 43 : $clientAuthMethod.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $clientJwk = this.clientJwk;
        result = result * 59 + ($clientJwk == null ? 43 : $clientJwk.hashCode());
        RSAKey $clientRsaKey = this.getClientRsaKey();
        result = result * 59 + ($clientRsaKey == null ? 43 : $clientRsaKey.hashCode());
        return result;
    }

    public String toString() {
        return "ClientAuthenticationProperties(clientId=" + this.getClientId() + ", clientAuthMethod=" + this.getClientAuthMethod() + ", clientSecret=" + this.getClientSecret() + ", clientJwk=" + this.clientJwk + ", clientRsaKey=" + this.getClientRsaKey() + ")";
    }

    public String getClientId() {
        return this.clientId;
    }

    public ClientAuthenticationMethod getClientAuthMethod() {
        return this.clientAuthMethod;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public RSAKey getClientRsaKey() {
        return this.clientRsaKey;
    }

    public static class ClientAuthenticationPropertiesBuilder {
        private String clientId;
        private ClientAuthenticationMethod clientAuthMethod;
        private String clientSecret;
        private String clientJwk;

        ClientAuthenticationPropertiesBuilder() {
        }

        public ClientAuthenticationPropertiesBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public ClientAuthenticationPropertiesBuilder clientAuthMethod(ClientAuthenticationMethod clientAuthMethod) {
            this.clientAuthMethod = clientAuthMethod;
            return this;
        }

        public ClientAuthenticationPropertiesBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public ClientAuthenticationPropertiesBuilder clientJwk(String clientJwk) {
            this.clientJwk = clientJwk;
            return this;
        }

        public ClientAuthenticationProperties build() {
            return new ClientAuthenticationProperties(this.clientId, this.clientAuthMethod, this.clientSecret, this.clientJwk);
        }

        public String toString() {
            return "ClientAuthenticationProperties.ClientAuthenticationPropertiesBuilder(clientId=" + this.clientId + ", clientAuthMethod=" + this.clientAuthMethod + ", clientSecret=" + this.clientSecret + ", clientJwk=" + this.clientJwk + ")";
        }
    }
}

