/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.util.concurrent.TimeUnit;
import no.nav.security.token.support.client.core.oauth2.OAuth2AccessTokenResponse;
import org.checkerframework.checker.nullness.qual.NonNull;

public class OAuth2CacheFactory {
    public static <T> Cache<T, OAuth2AccessTokenResponse> accessTokenResponseCache(long maximumSize, long skewInSeconds) {
        return Caffeine.newBuilder().maximumSize(maximumSize).expireAfter(OAuth2CacheFactory.evictOnResponseExpiresIn(skewInSeconds)).build();
    }

    private static <T> Expiry<T, OAuth2AccessTokenResponse> evictOnResponseExpiresIn(final long skewInSeconds) {
        return new Expiry<T, OAuth2AccessTokenResponse>(){

            public long expireAfterCreate(@NonNull T key, @NonNull OAuth2AccessTokenResponse response, long currentTime) {
                long seconds = (long)response.getExpiresIn() > skewInSeconds ? (long)response.getExpiresIn() - skewInSeconds : (long)response.getExpiresIn();
                return TimeUnit.SECONDS.toNanos(seconds);
            }

            public long expireAfterUpdate(@NonNull T key, @NonNull OAuth2AccessTokenResponse response, long currentTime, long currentDuration) {
                return currentDuration;
            }

            public long expireAfterRead(@NonNull T key, @NonNull OAuth2AccessTokenResponse response, long currentTime, long currentDuration) {
                return currentDuration;
            }
        };
    }
}

