/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core;

import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.validation.constraints.NotNull;
import no.nav.security.token.support.client.core.ClientAuthenticationProperties;
import no.nav.security.token.support.client.core.OAuth2ClientException;
import no.nav.security.token.support.client.core.OAuth2GrantType;

public class ClientProperties {
    private static final List<OAuth2GrantType> GRANT_TYPES = List.of(OAuth2GrantType.JWT_BEARER, OAuth2GrantType.CLIENT_CREDENTIALS, OAuth2GrantType.TOKEN_EXCHANGE);
    @NotNull
    private final URI tokenEndpointUrl;
    @NotNull
    private final OAuth2GrantType grantType;
    private final List<String> scope;
    @NotNull
    private final ClientAuthenticationProperties authentication;
    private final URI resourceUrl;
    private final TokenExchangeProperties tokenExchange;
    private final URI wellKnownUrl;
    private AuthorizationServerMetadata authorizationServerMetadata;
    private ResourceRetriever resourceRetriever;

    public ClientProperties(URI tokenEndpointUrl, URI wellKnownUrl, @NotNull OAuth2GrantType grantType, List<String> scope, @NotNull ClientAuthenticationProperties authentication, URI resourceUrl, TokenExchangeProperties tokenExchange) {
        this.wellKnownUrl = wellKnownUrl;
        if (tokenEndpointUrl != null) {
            this.tokenEndpointUrl = tokenEndpointUrl;
        } else {
            this.resourceRetriever = new DefaultResourceRetriever();
            this.authorizationServerMetadata = this.retrieveAuthorizationServerMetadata();
            this.tokenEndpointUrl = this.authorizationServerMetadata.getTokenEndpointURI();
        }
        this.grantType = ClientProperties.getSupported(grantType);
        this.scope = Optional.ofNullable(scope).orElse(Collections.emptyList());
        this.authentication = authentication;
        this.resourceUrl = resourceUrl;
        this.tokenExchange = tokenExchange;
    }

    private AuthorizationServerMetadata retrieveAuthorizationServerMetadata() {
        if (this.wellKnownUrl == null) {
            throw new OAuth2ClientException("wellKnownUrl cannot be null, please check your configuration.");
        }
        try {
            return AuthorizationServerMetadata.parse((String)this.resourceRetriever.retrieveResource(this.wellKnownUrl.toURL()).getContent());
        }
        catch (ParseException | IOException e) {
            throw new OAuth2ClientException("received exception when retrieving metadata from url " + this.wellKnownUrl, e);
        }
    }

    private static OAuth2GrantType getSupported(OAuth2GrantType oAuth2GrantType) {
        return Optional.ofNullable(oAuth2GrantType).filter(GRANT_TYPES::contains).orElseThrow(ClientProperties.unsupported(oAuth2GrantType));
    }

    private static Supplier<IllegalArgumentException> unsupported(OAuth2GrantType oAuth2GrantType) {
        return () -> new IllegalArgumentException(String.format("unsupported %s with value %s, must be one of %s", OAuth2GrantType.class.getSimpleName(), oAuth2GrantType, GRANT_TYPES));
    }

    public static ClientPropertiesBuilder builder() {
        return new ClientPropertiesBuilder();
    }

    public ClientPropertiesBuilder toBuilder() {
        return new ClientPropertiesBuilder().tokenEndpointUrl(this.tokenEndpointUrl).wellKnownUrl(this.wellKnownUrl).grantType(this.grantType).scope(this.scope).authentication(this.authentication).resourceUrl(this.resourceUrl).tokenExchange(this.tokenExchange);
    }

    public URI getTokenEndpointUrl() {
        return this.tokenEndpointUrl;
    }

    public OAuth2GrantType getGrantType() {
        return this.grantType;
    }

    public List<String> getScope() {
        return this.scope;
    }

    public ClientAuthenticationProperties getAuthentication() {
        return this.authentication;
    }

    public URI getResourceUrl() {
        return this.resourceUrl;
    }

    public TokenExchangeProperties getTokenExchange() {
        return this.tokenExchange;
    }

    public URI getWellKnownUrl() {
        return this.wellKnownUrl;
    }

    public AuthorizationServerMetadata getAuthorizationServerMetadata() {
        return this.authorizationServerMetadata;
    }

    public ResourceRetriever getResourceRetriever() {
        return this.resourceRetriever;
    }

    public String toString() {
        return "ClientProperties(tokenEndpointUrl=" + this.getTokenEndpointUrl() + ", grantType=" + this.getGrantType() + ", scope=" + this.getScope() + ", authentication=" + this.getAuthentication() + ", resourceUrl=" + this.getResourceUrl() + ", tokenExchange=" + this.getTokenExchange() + ", wellKnownUrl=" + this.getWellKnownUrl() + ", authorizationServerMetadata=" + this.getAuthorizationServerMetadata() + ", resourceRetriever=" + this.getResourceRetriever() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientProperties)) {
            return false;
        }
        ClientProperties other = (ClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$tokenEndpointUrl = this.getTokenEndpointUrl();
        URI other$tokenEndpointUrl = other.getTokenEndpointUrl();
        if (this$tokenEndpointUrl == null ? other$tokenEndpointUrl != null : !((Object)this$tokenEndpointUrl).equals(other$tokenEndpointUrl)) {
            return false;
        }
        OAuth2GrantType this$grantType = this.getGrantType();
        OAuth2GrantType other$grantType = other.getGrantType();
        if (this$grantType == null ? other$grantType != null : !((Object)this$grantType).equals(other$grantType)) {
            return false;
        }
        List<String> this$scope = this.getScope();
        List<String> other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
            return false;
        }
        ClientAuthenticationProperties this$authentication = this.getAuthentication();
        ClientAuthenticationProperties other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !((Object)this$authentication).equals(other$authentication)) {
            return false;
        }
        URI this$resourceUrl = this.getResourceUrl();
        URI other$resourceUrl = other.getResourceUrl();
        if (this$resourceUrl == null ? other$resourceUrl != null : !((Object)this$resourceUrl).equals(other$resourceUrl)) {
            return false;
        }
        TokenExchangeProperties this$tokenExchange = this.getTokenExchange();
        TokenExchangeProperties other$tokenExchange = other.getTokenExchange();
        if (this$tokenExchange == null ? other$tokenExchange != null : !((Object)this$tokenExchange).equals(other$tokenExchange)) {
            return false;
        }
        URI this$wellKnownUrl = this.getWellKnownUrl();
        URI other$wellKnownUrl = other.getWellKnownUrl();
        if (this$wellKnownUrl == null ? other$wellKnownUrl != null : !((Object)this$wellKnownUrl).equals(other$wellKnownUrl)) {
            return false;
        }
        AuthorizationServerMetadata this$authorizationServerMetadata = this.getAuthorizationServerMetadata();
        AuthorizationServerMetadata other$authorizationServerMetadata = other.getAuthorizationServerMetadata();
        if (this$authorizationServerMetadata == null ? other$authorizationServerMetadata != null : !this$authorizationServerMetadata.equals(other$authorizationServerMetadata)) {
            return false;
        }
        ResourceRetriever this$resourceRetriever = this.getResourceRetriever();
        ResourceRetriever other$resourceRetriever = other.getResourceRetriever();
        return !(this$resourceRetriever == null ? other$resourceRetriever != null : !this$resourceRetriever.equals(other$resourceRetriever));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $tokenEndpointUrl = this.getTokenEndpointUrl();
        result = result * 59 + ($tokenEndpointUrl == null ? 43 : ((Object)$tokenEndpointUrl).hashCode());
        OAuth2GrantType $grantType = this.getGrantType();
        result = result * 59 + ($grantType == null ? 43 : $grantType.hashCode());
        List<String> $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        ClientAuthenticationProperties $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : ((Object)$authentication).hashCode());
        URI $resourceUrl = this.getResourceUrl();
        result = result * 59 + ($resourceUrl == null ? 43 : ((Object)$resourceUrl).hashCode());
        TokenExchangeProperties $tokenExchange = this.getTokenExchange();
        result = result * 59 + ($tokenExchange == null ? 43 : ((Object)$tokenExchange).hashCode());
        URI $wellKnownUrl = this.getWellKnownUrl();
        result = result * 59 + ($wellKnownUrl == null ? 43 : ((Object)$wellKnownUrl).hashCode());
        AuthorizationServerMetadata $authorizationServerMetadata = this.getAuthorizationServerMetadata();
        result = result * 59 + ($authorizationServerMetadata == null ? 43 : $authorizationServerMetadata.hashCode());
        ResourceRetriever $resourceRetriever = this.getResourceRetriever();
        result = result * 59 + ($resourceRetriever == null ? 43 : $resourceRetriever.hashCode());
        return result;
    }

    public static class ClientPropertiesBuilder {
        private URI tokenEndpointUrl;
        private URI wellKnownUrl;
        private OAuth2GrantType grantType;
        private List<String> scope;
        private ClientAuthenticationProperties authentication;
        private URI resourceUrl;
        private TokenExchangeProperties tokenExchange;

        ClientPropertiesBuilder() {
        }

        public ClientPropertiesBuilder tokenEndpointUrl(URI tokenEndpointUrl) {
            this.tokenEndpointUrl = tokenEndpointUrl;
            return this;
        }

        public ClientPropertiesBuilder wellKnownUrl(URI wellKnownUrl) {
            this.wellKnownUrl = wellKnownUrl;
            return this;
        }

        public ClientPropertiesBuilder grantType(OAuth2GrantType grantType) {
            this.grantType = grantType;
            return this;
        }

        public ClientPropertiesBuilder scope(List<String> scope) {
            this.scope = scope;
            return this;
        }

        public ClientPropertiesBuilder authentication(ClientAuthenticationProperties authentication) {
            this.authentication = authentication;
            return this;
        }

        public ClientPropertiesBuilder resourceUrl(URI resourceUrl) {
            this.resourceUrl = resourceUrl;
            return this;
        }

        public ClientPropertiesBuilder tokenExchange(TokenExchangeProperties tokenExchange) {
            this.tokenExchange = tokenExchange;
            return this;
        }

        public ClientProperties build() {
            return new ClientProperties(this.tokenEndpointUrl, this.wellKnownUrl, this.grantType, this.scope, this.authentication, this.resourceUrl, this.tokenExchange);
        }

        public String toString() {
            return "ClientProperties.ClientPropertiesBuilder(tokenEndpointUrl=" + this.tokenEndpointUrl + ", wellKnownUrl=" + this.wellKnownUrl + ", grantType=" + this.grantType + ", scope=" + this.scope + ", authentication=" + this.authentication + ", resourceUrl=" + this.resourceUrl + ", tokenExchange=" + this.tokenExchange + ")";
        }
    }

    public static class TokenExchangeProperties {
        @NotNull
        private final String audience;
        private final String resource;

        public TokenExchangeProperties(@NotNull String audience, String resource) {
            this.audience = audience;
            this.resource = resource;
            this.validateAfterPropertiesSet();
        }

        private void validateAfterPropertiesSet() {
            Objects.requireNonNull(this.audience, "audience must be set");
        }

        public String subjectTokenType() {
            return "urn:ietf:params:oauth:token-type:jwt";
        }

        public static TokenExchangePropertiesBuilder builder() {
            return new TokenExchangePropertiesBuilder();
        }

        public TokenExchangePropertiesBuilder toBuilder() {
            return new TokenExchangePropertiesBuilder().audience(this.audience).resource(this.resource);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenExchangeProperties)) {
                return false;
            }
            TokenExchangeProperties other = (TokenExchangeProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$audience = this.getAudience();
            String other$audience = other.getAudience();
            if (this$audience == null ? other$audience != null : !this$audience.equals(other$audience)) {
                return false;
            }
            String this$resource = this.getResource();
            String other$resource = other.getResource();
            return !(this$resource == null ? other$resource != null : !this$resource.equals(other$resource));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TokenExchangeProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $audience = this.getAudience();
            result = result * 59 + ($audience == null ? 43 : $audience.hashCode());
            String $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
            return result;
        }

        public String toString() {
            return "ClientProperties.TokenExchangeProperties(audience=" + this.getAudience() + ", resource=" + this.getResource() + ")";
        }

        public String getAudience() {
            return this.audience;
        }

        public String getResource() {
            return this.resource;
        }

        public static class TokenExchangePropertiesBuilder {
            private String audience;
            private String resource;

            TokenExchangePropertiesBuilder() {
            }

            public TokenExchangePropertiesBuilder audience(String audience) {
                this.audience = audience;
                return this;
            }

            public TokenExchangePropertiesBuilder resource(String resource) {
                this.resource = resource;
                return this;
            }

            public TokenExchangeProperties build() {
                return new TokenExchangeProperties(this.audience, this.resource);
            }

            public String toString() {
                return "ClientProperties.TokenExchangeProperties.TokenExchangePropertiesBuilder(audience=" + this.audience + ", resource=" + this.resource + ")";
            }
        }
    }
}

