/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core.oauth2;

import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import no.nav.security.token.support.client.core.ClientAuthenticationProperties;
import no.nav.security.token.support.client.core.ClientProperties;
import no.nav.security.token.support.client.core.OAuth2ClientException;
import no.nav.security.token.support.client.core.OAuth2GrantType;
import no.nav.security.token.support.client.core.auth.ClientAssertion;
import no.nav.security.token.support.client.core.http.OAuth2HttpClient;
import no.nav.security.token.support.client.core.http.OAuth2HttpHeaders;
import no.nav.security.token.support.client.core.http.OAuth2HttpRequest;
import no.nav.security.token.support.client.core.oauth2.AbstractOAuth2GrantRequest;
import no.nav.security.token.support.client.core.oauth2.OAuth2AccessTokenResponse;

abstract class AbstractOAuth2TokenClient<T extends AbstractOAuth2GrantRequest> {
    private static final String CONTENT_TYPE_FORM_URL_ENCODED = "application/x-www-form-urlencoded;charset=UTF-8";
    private static final String CONTENT_TYPE_JSON = "application/json;charset=UTF-8";
    private final OAuth2HttpClient oAuth2HttpClient;

    AbstractOAuth2TokenClient(OAuth2HttpClient oAuth2HttpClient) {
        this.oAuth2HttpClient = oAuth2HttpClient;
    }

    OAuth2AccessTokenResponse getTokenResponse(T grantRequest) {
        ClientProperties clientProperties = Optional.ofNullable(grantRequest).map(AbstractOAuth2GrantRequest::getClientProperties).orElseThrow(() -> new OAuth2ClientException("ClientProperties cannot be null"));
        try {
            Map<String, String> formParameters = this.createDefaultFormParameters(grantRequest);
            formParameters.putAll(this.formParameters(grantRequest));
            OAuth2HttpRequest oAuth2HttpRequest = OAuth2HttpRequest.builder().tokenEndpointUrl(clientProperties.getTokenEndpointUrl()).oAuth2HttpHeaders(OAuth2HttpHeaders.of(this.tokenRequestHeaders(clientProperties))).formParameters(formParameters).build();
            return this.oAuth2HttpClient.post(oAuth2HttpRequest);
        }
        catch (Exception e) {
            if (!(e instanceof OAuth2ClientException)) {
                throw new OAuth2ClientException(String.format("received exception %s when invoking tokenendpoint=%s", e, ((AbstractOAuth2GrantRequest)grantRequest).getClientProperties().getTokenEndpointUrl()), e);
            }
            throw e;
        }
    }

    private Map<String, List<String>> tokenRequestHeaders(ClientProperties clientProperties) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Accept", Collections.singletonList(CONTENT_TYPE_JSON));
        headers.put("Content-Type", Collections.singletonList(CONTENT_TYPE_FORM_URL_ENCODED));
        ClientAuthenticationProperties auth = clientProperties.getAuthentication();
        if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)auth.getClientAuthMethod())) {
            headers.put("Authorization", Collections.singletonList("Basic " + this.basicAuth(auth.getClientId(), auth.getClientSecret())));
        }
        return headers;
    }

    Map<String, String> createDefaultFormParameters(T grantRequest) {
        ClientProperties clientProperties = ((AbstractOAuth2GrantRequest)grantRequest).getClientProperties();
        LinkedHashMap<String, String> formParameters = new LinkedHashMap<String, String>(this.clientAuthenticationFormParameters(grantRequest));
        formParameters.put("grant_type", ((AbstractOAuth2GrantRequest)grantRequest).getGrantType().getValue());
        if (!clientProperties.getGrantType().equals(OAuth2GrantType.TOKEN_EXCHANGE)) {
            formParameters.put("scope", String.join((CharSequence)" ", clientProperties.getScope()));
        }
        return formParameters;
    }

    private Map<String, String> clientAuthenticationFormParameters(T grantRequest) {
        ClientProperties clientProperties = ((AbstractOAuth2GrantRequest)grantRequest).getClientProperties();
        LinkedHashMap<String, String> formParameters = new LinkedHashMap<String, String>();
        ClientAuthenticationProperties auth = clientProperties.getAuthentication();
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.equals((Object)auth.getClientAuthMethod())) {
            formParameters.put("client_id", auth.getClientId());
            formParameters.put("client_secret", auth.getClientSecret());
        } else if (ClientAuthenticationMethod.PRIVATE_KEY_JWT.equals((Object)auth.getClientAuthMethod())) {
            ClientAssertion clientAssertion = new ClientAssertion(clientProperties.getTokenEndpointUrl(), auth);
            formParameters.put("client_id", auth.getClientId());
            formParameters.put("client_assertion_type", clientAssertion.assertionType());
            formParameters.put("client_assertion", clientAssertion.assertion());
        }
        return formParameters;
    }

    private String basicAuth(String username, String password) {
        Charset charset = StandardCharsets.UTF_8;
        CharsetEncoder encoder = charset.newEncoder();
        if (encoder.canEncode(username) && encoder.canEncode(password)) {
            String credentialsString = username + ":" + password;
            byte[] encodedBytes = Base64.getEncoder().encode(credentialsString.getBytes(StandardCharsets.UTF_8));
            return new String(encodedBytes, StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException("Username or password contains characters that cannot be encoded to " + charset.displayName());
    }

    protected abstract Map<String, String> formParameters(T var1);
}

