/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class OAuth2HttpHeaders {
    private final Map<String, List<String>> headers;

    private OAuth2HttpHeaders(Map<String, List<String>> headers) {
        this.headers = Optional.ofNullable(headers).orElse(Map.of());
    }

    public static OAuth2HttpHeaders of(Map<String, List<String>> headers) {
        return new OAuth2HttpHeaders(headers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public String toString() {
        return "OAuth2HttpHeaders(headers=" + this.headers + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2HttpHeaders)) {
            return false;
        }
        OAuth2HttpHeaders other = (OAuth2HttpHeaders)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.headers;
        Map<String, List<String>> other$headers = other.headers;
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuth2HttpHeaders;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, List<String>> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    public static class Builder {
        private final TreeMap<String, List<String>> headersMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);

        public Builder header(String name, String value) {
            this.headersMap.computeIfAbsent(name, k -> new ArrayList(1)).add(value);
            return this;
        }

        public OAuth2HttpHeaders build() {
            return OAuth2HttpHeaders.of(this.headersMap);
        }
    }
}

